#! /bin/awk -f
BEGIN { fcounter = -1; overheads = 1; filescale = 4; }
/^name: min in [0-9]+ runs \(estimated timing overhead is [0-9]+\)$/ {
  ++fcounter;
  name[fcounter] = FILENAME;
  runs[fcounter] = $4 + 0;
  ovh[fcounter] = $10 + 0;
  overheads *= ovh[fcounter];
  next; }
match($1, benchname ":") == 0 { next; }
{ idx = fcounter * filescale; }
/^n/ { idx += 1; }
/^...\.V/ { idx += 2; }
{ min[idx] = $2 + 0; }
END {
  maxscaled = 0;
  for (idx = 0; idx < filescale; idx++)
    for (f = 0; f <= fcounter; f++) {
      i = f * filescale + idx
      scaled[i] = curscaled = min[i]; # * overheads / ovh[f];
      if (curscaled > maxscaled)
	maxscaled = curscaled;
    }

  for (base = 1; base < maxscaled; base *= 10) {
    if (base >= maxscaled / 7) {
      break;
    } else if (2 * base >= maxscaled / 7) {
      base = 2 * base; break;
    } else if (5 * base >= maxscaled / 7) {
      base = 5 * base; break;
    }
  }

  if (maxscaled % base)
    maxscaled += base - maxscaled % base;

  unit = 2 / maxscaled;
  printf "\\setlength{\\unitlength}{%fin}\n", unit;
  hend = 3.2 * maxscaled / 2;
  hu = hend / ((fcounter + 1.5) * 2 + 0.5);
  hhu = hu / 2;
  
  printf "\\begin{picture}(%f,%f)(0,0)\n", hend, maxscaled;
  printf "\\path(%f,0)(%f,0)\n", hhu, hend;
  printf "\\path(%f,0)(%f,%f)\n", hhu, hhu, maxscaled;
  for (x = 0; x <= maxscaled; x += base) {
    printf "\\path(%f,%f)(%f,%f)\n", hhu - hhu / 4, x, hhu + hhu / 4, x;
    printf "\\put(%f,%f){\\makebox(0,0)[rc]{%i}}\n", hhu - 3 * hhu / 8, x, x;
  }
  for (st = 0; st < 2; st++)
    for (f = 0; f <= fcounter; f++) {
      i = f * filescale + st * 2;
      xbase = (1 + f + st * (fcounter + 1.5)) * hu;
      printf "\\path(%f,%f)(%f,%f)(%f,%f)(%f,%f)(%f,%f)\n", xbase, 0, xbase, scaled[i], xbase + hu, scaled[i], xbase + hu, 0, xbase, 0;
      printf "\\path(%f,%f)(%f,%f)(%f,%f)(%f,%f)(%f,%f)\n", xbase, 0, xbase, scaled[i+1], xbase + hu, scaled[i+1], xbase + hu, 0, xbase, 0;
      printf "\\dottedline{%f}(%f,%f)(%f,%f)\n", hu / 16, xbase, ovh[f], xbase + hu, ovh[f];
      if (scaled[i] / scaled[i+1] > 1.3)
        ypt = scaled[i];
      else
        ypt = scaled[i+1];
      printf "\\put(%f,%f){\\makebox(0,0)[ct]{%4.1fx}}\n", xbase + hhu, \
	ypt - hhu / 4, ((scaled[i] - ovh[f]) / (scaled[i+1] - ovh[f]));
      printf "\\put(%f,%f){\\makebox(0,0)[ct]{%4.1fx}}\n", xbase + hhu, \
	ypt - 3.2 * hhu / 4, (scaled[i] / scaled[i+1]);
    }
  printf "\\end{picture}\n"
}
