#ifndef _ts1node_h
#define _ts1node_h

#pragma interface

// $Id: ts1node.h,v 1.1 1998/11/27 20:09:48 oliva Exp $

/* Copyright 1998 Alexandre Oliva <oliva@dcc.unicamp.br>
 *
 * This file is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "basic_node.h"
#include "visit_node.h"
#include "adjlist.h"
#include "arc.h"

/** This is a modified basic_node, that introduces the visiting
    abilities required by Topological Sort algorithms.  */
class ts1node : public visit_node,
		public node<ts1node, adjlist<arc<ts1node> >, basic_node_state_type>
{
 private:
  /** Just a shorthand to refer to the base class.  */
  typedef node<ts1node, adjlist<arc<ts1node> >,
    basic_node_state_type> inherited;

 public:
  /** Just forward the identified to the base class.  */
  ts1node(inherited::node_id_t id) : inherited(id) {}
};    


#endif
