#ifndef _timing_h
#define _timing_h

// $Id: timing.h,v 1.3 1998/11/27 20:09:48 oliva Exp $

/* Copyright 1998 Alexandre Oliva <oliva@dcc.unicamp.br>, Islene Calciolari Garcia <islene@dcc.unicamp.br>
 *
 * This file is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#if TIME_WITH_SYS_TIME
# include <sys/time.h>
# include <time.h>
#else
# if HAVE_SYS_TIME_H
#  include <sys/time.h>
# else
#  include <time.h>
# endif
#endif

#if HAVE_SYS_TIMES_H
# include <sys/times.h>
#endif

#if HAVE_SYS_RESOURCE_H
# include <sys/resource.h>
#endif

#if HAVE_GETHRVTIME
/* We prefer high-resolution virtual time.  */
# define vtime_t hrtime_t
# define getvtime(var) (var)=gethrvtime()
# define diffvtime(var1,var2) (((var1)-(var2))*1e-9)

#elif HAVE_GETRUSAGE
/* If it's not available, rusage user-time will do.  */
# define vtime_t rusage
# define getvtime(var) getrusage(0, &(var))
# define diffvtime(var1, var2) (1.0*((var1).ru_utime.tv_sec - (var2).ru_utime.tv_sec) + 1e-6*((var1).ru_utime.tv_usec - (var2).ru_utime.tv_usec))

#elif HAVE_TIMES
/* For systems that don't provide getrusage, times' user-time will do. */
# define vtime_t tms
# define getvtime(var) times((&var))
# ifndef CLK_TCK
#  define CLK_TCK CLOCKS_PER_SEC
# endif
# define diffvtime(var1,var2) ((((var1).tms_utime) - ((var2).tms_utime)))*1.0/CLK_TCK

#else
/* If everything else fails, real-time is all we have :-( */
# define vtime_t time_t
# define getvtime(var) (var)=time(0)
# define diffvtime(var1,var2) ((var1)-(var2))

#endif

#endif
