#ifndef _distance_h
#define _distance_h

// $Id: distance.h,v 1.1 1998/11/27 13:07:08 oliva Exp $

/* Copyright 1998 Alexandre Oliva <oliva@dcc.unicamp.br>, Islene Calciolari Garcia <islene@dcc.unicamp.br>
 *
 * This file is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#if HAVE_NUMERIC_LIMITS /* not auto-checked; always false */

#include <limits>

template <class T> class distance_limits : std::numeric_limits<T> {
 public:
  static T large() { return max(); }
};

#else

#include <limits.h>

template <class T> class distance_limits;

/** Explicit specialization for integer type.  If any other type is
    used as distance, an explicit specialization like this must be
    provided.  */
template <> class distance_limits<int> {
 public:
  /** Return some large number, that will help us save some time in
      distance comparisons on uninitialized distances.  */
  static int large() { return INT_MAX; }
};

#endif

#endif
