#ifndef _basic_node_h
#define _basic_node_h

// $Id: basic_node.h,v 1.2 1998/11/27 13:07:08 oliva Exp $

/* Copyright 1998 Alexandre Oliva <oliva@dcc.unicamp.br>, Islene Calciolari Garcia <islene@dcc.unicamp.br>
 *
 * This file is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "node.h"
#include "adjlist.h"
#include "arc.h"

/** Implements the basic state machine of a node.  */
class basic_node_state_type {
  /** The `unreached' state means the node was not reached yet, so its
      distance is not meaningful.  `labeled' means the distance of the
      node was recently updated, but it was not scanned for shorter
      paths to children yet.  `scanned' means the arcs leaving the
      node were scanned since its last update. */
  enum { unreached, labeled, scanned } status;

public:
  /** Initializes the status as unreached.  */
  basic_node_state_type() : status(unreached) {}

  /** Returns false if the current state is unreached.  */
  bool is_reached() const { return status != unreached; }

  /** Returns true unless the current state is labeled.  */
  bool is_labeled() const { return status == labeled; }

  /** Enter labeled state.  */
  void mark_labeled() { status = labeled; }

  /** Enter scanned state.  */
  void mark_scanned() { status = scanned; }
};

/** This is the node type used in most algorithms.  This class only
    exists to solve some circularity problems in the template
    definitions.  */
class basic_node :
  public node<basic_node, adjlist<arc<basic_node> >, basic_node_state_type> {
 private:
  /** Just a shorthand to refer to the base class.  */
  typedef node<basic_node, adjlist<arc<basic_node> >,
    basic_node_state_type> inherited;

 public:
  /** Just forward the identified to the base class.  */
  basic_node(inherited::node_id_t id) : inherited(id) {}
};    

#endif
