#ifndef _arc_h
#define _arc_h

// $Id: arc.h,v 1.5 1998/11/27 13:07:07 oliva Exp $

/* Copyright 1998 Alexandre Oliva <oliva@dcc.unicamp.br>, Islene Calciolari Garcia <islene@dcc.unicamp.br>
 *
 * This file is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/** A default arc type.  An acceptable implementation must define the
    nested types node_t and distance_t, as well as operations from()
    and to() (same as tail() and head()), length(), set_length() and a
    constructor that takes the tail, the head and the distance of an
    arc.  */
template <class node_T>
class arc {
 public:
  /** The node type */
  typedef node_T node_t;

  /** The distance type */
  typedef typename node_t::distance_t distance_t;

 private:
  /** The tail and the head of the arc.  They must not be references
      because arc must be assignable, so that it can be stored in a
      container.  */
  node_t *tail_, *head_;

 public:
  /** Return the node that is the tail of the arc.  */
  node_t& from() const { return *tail_; }
  node_t& tail() const { return *tail_; }

  /** Return the node that is the head of the arc.  */
  node_t& to() const { return *head_; }
  node_t& head() const { return *head_; }

 protected:
  /** The length of the arc.  */
  distance_t len;
 public:
  /** Return the length of the arc.  */
  distance_t length() const { return len; }

  /** Modify the length of the arc.  */
  void set_length(distance_t len) { this->len = len; }

 public:
  /** Create an arc given a pair of nodes and the length */
  arc(node_t& from, node_t& to, distance_t length)
    : tail_(&from), head_(&to), len(length) {}
};

#endif
