/* RepositorioDeclaracaoCentralTxt - Decompiled by JODE
 * Visit http://jode.sourceforge.net/
 */
package serpro.ppgd.irpf.txt.gravacaorestauracao;
import java.io.File;
import java.io.IOException;
import java.util.Vector;

import serpro.ppgd.formatosexternos.txt.RegistroTxt;
import serpro.ppgd.formatosexternos.txt.excecao.GeracaoTxtException;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.negocio.util.UtilitariosArquivo;

public class RepositorioDeclaracaoCentralTxt
{
  public static byte FINALIDADE_ENTREGA = 0;
  public static byte FINALIDADE_BACKUP = 1;
  private DocumentoAjusteTXT arquivo;
  private File file;
  private boolean fLido = false;
  private IdentificadorDeclaracao objIdArquivo;
  private ConversorRegistros2ObjetosIRPF conversor2ObjIRPF;
  private ConversorObjetosIRPF2Registros conversor2Registros;
  
  public RepositorioDeclaracaoCentralTxt (String tipoArq, File file) throws GeracaoTxtException
  {
    this.file = file;
    arquivo = new DocumentoAjusteTXT (tipoArq, file.getPath ());
    conversor2ObjIRPF = new ConversorRegistros2ObjetosIRPF ();
    conversor2Registros = new ConversorObjetosIRPF2Registros ();
  }
  
  public IdentificadorDeclaracao recuperarIdDeclaracao () throws Exception
  {
    lerDeclaracao ();
    Vector vetorRegHeader = arquivo.getRegistrosTxt ("IR"); /* REG_HEADER */
    Vector vetorRegIdentificacao = arquivo.getRegistrosTxt ("16"); /* REG_IDENTIFICACAO */
    objIdArquivo = conversor2ObjIRPF.montarIdDeclaracao (vetorRegHeader, vetorRegIdentificacao);
    return objIdArquivo;
  }
  
  public void atualizarNroReciboTransmitida (String nrRecibo) throws Exception
  {
    arquivo.atualizarNrReciboTransmitida (nrRecibo);
    arquivo.setBKPno ();
    arquivo.salvar ();
  }
  
  public String recuperarNroRecibo () throws Exception
  {
    return recuperarRegistroHeader ().fieldByName ("NR_HASH").asString ();
  }
  
  public IdentificadorDeclaracao recuperarIdDeclaracaoAnoAnterior () throws GeracaoTxtException, IOException
  {
    lerDeclaracao ();
    Vector vetorRegHeader = arquivo.getRegistrosTxt ("IR"); /* REG_HEADER */
    Vector vetorRegIdentificacao = arquivo.getRegistrosTxt ("16"); /* REG_IDENTIFICACAO */
    objIdArquivo = conversor2ObjIRPF.montarIdDeclaracaoAnoAnterior (vetorRegHeader, vetorRegIdentificacao);
    return objIdArquivo;
  }
  
  public IdentificadorDeclaracao recuperarIdDeclaracaoNaoPersistido () throws GeracaoTxtException, IOException
  {
    lerDeclaracao ();
    Vector vetorRegistros = arquivo.getRegistrosTxt ("IR"); /* REG_HEADER */
    objIdArquivo = conversor2ObjIRPF.montarIdDeclaracaoNaoPersistido (vetorRegistros);
    return objIdArquivo;
  }
  
  public void recuperarDeclaracao (IdentificadorDeclaracao idDecl) throws GeracaoTxtException
  {
    /* FIXME: Estudar a necessidade e implementar os registros:

       REG_APLICACOES_FINANCEIRAS_EXTERIOR
       REG_ATIVIDADE_RURAL_PROPRIETARIO
       REG_DETALHEPOUPANCA
       REG_DETALHERENDAPLICFINAN
       REG_DETALHETRANSFERENCIAS
       REG_DOACAO
       REG_DOACAO_ECA
       REG_DOACAO_IDOSO
       REG_FINALESPOLIO
       REG_GCAP
       REG_GCAP_ADQUIRENTES
       REG_GCAP_AMPLIACAO_REFORMA
       REG_GCAP_AMPLIACAO_REFORMA_EXT
       REG_GCAP_APURACAO_AMBAS
       REG_GCAP_APURACAO_IMOVEL
       REG_GCAP_APURACAO_MOVEL
       REG_GCAP_BEMIMOVEL
       REG_GCAP_BEMMOVEL
       REG_GCAP_CUSTO_AQUIS_PS
       REG_GCAP_ESPECIE
       REG_GCAP_EXTERIOR
       REG_GCAP_FAIXAS_TRIBUTACAO
       REG_GCAP_PARCELA_IMOVEL
       REG_GCAP_PARCELA_MOVEL
       REG_GCAP_PSOCIETARIA
       REG_GCAP_TOTALIZACAO_MOEDAS_ALIENADAS
       REG_HERDEIROS
       REG_IMPOSTO_PAGO
       REG_INDENIZACOES
       REG_INVENTARIANTE
       REG_IRRF_ANOS_ANTERIORES
       REG_JUROS_CAPITAL_PROPRIO
       REG_LUCROSDIVIDENDOS
       REG_OUTROS_RENDIMENTOS
       REG_PARTICIPACAO_LUCROS_RESULTADOS
       REG_PERCENTUAL_BEM
       REG_RENDAVARANUAL
       REG_RENDAVARTOTAISINVEST
       REG_RENDIMENTOS_TRABALHO_NAO_ASSALARIADO_PF
       REG_RRADEPENDENTE
       REG_RRADEPENDENTE_PENSAO
       REG_RRATITULAR
       REG_RRATITULAR_PENSAO
       REG_SAIDA

    */

    arquivo.validarHeader (idDecl);
    DeclaracaoIRPF objDecl = IRPFFacade.getInstancia ().recuperarDeclaracaoIRPF (idDecl.getCpf ().asString ());
    Vector vetorRegistros = arquivo.getRegistrosTxt ("16"); /* REG_IDENTIFICACAO */
    conversor2ObjIRPF.montarContribuinteIRPF (vetorRegistros, objDecl.getContribuinte ());
    vetorRegistros = arquivo.getRegistrosTxt ("27"); /* REG_BEM */
    conversor2ObjIRPF.montarBem (vetorRegistros, objDecl);
    vetorRegistros = arquivo.getRegistrosTxt ("28"); /* REG_DIVIDA */
    conversor2ObjIRPF.montarDividas (vetorRegistros, objDecl);
    vetorRegistros = arquivo.getRegistrosTxt ("19"); /* REG_COMPLETA */
    conversor2ObjIRPF.montarDeclaracaoCompleta (vetorRegistros, objDecl);
    vetorRegistros = arquivo.getRegistrosTxt ("21"); /* REG_RENDPJ */
    conversor2ObjIRPF.montarRendPJTitularCompleta (vetorRegistros, objDecl);
    vetorRegistros = arquivo.getRegistrosTxt ("32"); /* REG_RENDPJDEPENDENTE */
    conversor2ObjIRPF.montarRendPJDependentesCompleta (vetorRegistros, objDecl); 
    /* FIXME: REG_DETALHEPENSAO */
    vetorRegistros = arquivo.getRegistrosTxt ("22"); /* REG_RENDPF */
    conversor2ObjIRPF.montarRendimentosPF (vetorRegistros, objDecl, false);
    conversor2ObjIRPF.montarRendimentosPF (vetorRegistros, objDecl, true);
    vetorRegistros = arquivo.getRegistrosTxt ("23"); /* REG_RENDISENTOS */
    conversor2ObjIRPF.recuperarRendIsentosNaoTributaveis (vetorRegistros, objDecl, false);
    vetorRegistros = arquivo.getRegistrosTxt ("83"); /* REG_RENDIMENTO_ISENTO_TIPO2 */
    conversor2ObjIRPF.recuperarRendIsentosDetalhe2 (vetorRegistros, objDecl, false);
    vetorRegistros = arquivo.getRegistrosTxt ("84"); /* REG_RENDIMENTO_ISENTO_TIPO_INFORMACAO_3 */
    conversor2ObjIRPF.recuperarRendIsentosDetalhe3 (vetorRegistros, objDecl, false);
    vetorRegistros = arquivo.getRegistrosTxt ("85"); /* REG_RENDIMENTO_ISENTO_TIPO_INFORMACAO_4 */
    conversor2ObjIRPF.recuperarRendIsentosDetalhe4 (vetorRegistros, objDecl, false);
    vetorRegistros = arquivo.getRegistrosTxt ("86"); /* REG_RENDIMENTO_ISENTO_TIPO_INFORMACAO_5 */
    conversor2ObjIRPF.recuperarRendIsentosDetalhe5 (vetorRegistros, objDecl, false);
    vetorRegistros = arquivo.getRegistrosTxt ("87"); /* REG_RENDIMENTO_ISENTO_TIPO_INFORMACAO_6 */
    conversor2ObjIRPF.recuperarRendIsentosDetalhe6 (vetorRegistros, objDecl, false);
    vetorRegistros = arquivo.getRegistrosTxt ("88"); /* REG_RENDIMENTO_EXCLUSIVO_TIPO_INFORMACAO_2 */
    conversor2ObjIRPF.recuperarRendExclusivosDetalhe2 (vetorRegistros, objDecl, false);
    vetorRegistros = arquivo.getRegistrosTxt ("89"); /* REG_RENDIMENTO_EXCLUSIVO_TIPO_INFORMAÇÃO_3 */
    conversor2ObjIRPF.recuperarRendExclusivosDetalhe3 (vetorRegistros, objDecl, false);
    vetorRegistros = arquivo.getRegistrosTxt ("24"); /* REG_RENDEXCLUSIVA */
    conversor2ObjIRPF.recuperarRendTributacaoExclusiva (vetorRegistros, objDecl, false);
    vetorRegistros = arquivo.getRegistrosTxt ("35"); /* REG_ALIMENTANDO */
    conversor2ObjIRPF.montarAlimentandos (vetorRegistros, objDecl);
    vetorRegistros = arquivo.getRegistrosTxt ("25"); /* REG_DEPENDENTE */
    conversor2ObjIRPF.montarDependentes (vetorRegistros, objDecl);
    vetorRegistros = arquivo.getRegistrosTxt ("26"); /* REG_PAGAMENTO */
    conversor2ObjIRPF.montarPagamentos (vetorRegistros, objDecl);
    vetorRegistros = arquivo.getRegistrosTxt ("34"); /* REG_DOACOESCAMPANHA */
    conversor2ObjIRPF.montarDoacoesCampanha (vetorRegistros, objDecl);
    vetorRegistros = arquivo.getRegistrosTxt ("40"); /* REG_RENDAVARMENSAL */
    conversor2ObjIRPF.montarRendaVariavel (vetorRegistros, objDecl);
    vetorRegistros = arquivo.getRegistrosTxt ("42"); /* RENDAVARINVESTMENSAL */
    conversor2ObjIRPF.montarRendaVariavelFII (vetorRegistros, objDecl);
    vetorRegistros = arquivo.getRegistrosTxt ("30"); /* REG_INVENTARIANTE */
    conversor2ObjIRPF.montarInventariante (vetorRegistros, objDecl);
    /* FIXME: REG_PROPRIETARIOUSUFRUTUARIOBEM */
    vetorRegistros = arquivo.getRegistrosTxt ("50"); /* REG_ATIVIDADE_RURAL_ID_IMOVEL */
    conversor2ObjIRPF.montarAtividadeRuralImoveis (vetorRegistros, objDecl);
    vetorRegistros = arquivo.getRegistrosTxt ("54"); /* REG_ATIVIDADE_RURAL_BENS */
    conversor2ObjIRPF.montarAtividadeRuralBens (vetorRegistros, objDecl);
    vetorRegistros = arquivo.getRegistrosTxt ("55"); /* REG_ATIVIDADE_RURAL_DIVIDAS */
    conversor2ObjIRPF.montarAtividadeRuralDividas (vetorRegistros, objDecl);
    vetorRegistros = arquivo.getRegistrosTxt ("53"); /* REG_ATIVIDADE_RURAL_MOV_REBANHO */
    conversor2ObjIRPF.montarAtividadeRuralMovimentacaoRebanho (vetorRegistros, objDecl);
    vetorRegistros = arquivo.getRegistrosTxt ("52"); /* REG_ATIVIDADE_RURAL_APURACAO_RESULTADO */
    conversor2ObjIRPF.montarAtividadeRuralApuracaoResultado (vetorRegistros, objDecl);
    vetorRegistros = arquivo.getRegistrosTxt ("51"); /* REG_ATIVIDADE_RURAL_REC_DESP_BRASIL */
    conversor2ObjIRPF.montarAtividadeRuralReceitasDespesasBrasil (vetorRegistros, objDecl);
    vetorRegistros = arquivo.getRegistrosTxt ("56"); /* REG_ATIVIDADE_RURAL_REC_DESP_EXT */
    conversor2ObjIRPF.montarAtividadeRuralReceitasDespesasExterior (vetorRegistros, objDecl);
    vetorRegistros = arquivo.getRegistrosTxt ("16"); /* REG_IDENTIFICACAO */
    conversor2ObjIRPF.montarContribuinteIRPF (vetorRegistros, objDecl.getContribuinte ());
    conversor2ObjIRPF.montarInformacoesBancarias (vetorRegistros, objDecl);
    conversor2ObjIRPF.montarInformacoesObrigatorias (vetorRegistros, objDecl, false);
    vetorRegistros = arquivo.getRegistrosTxt ("80"); /* REG_RENDPJ_EXIG_TIT */
    conversor2ObjIRPF.montarRendPJTitularComExigibilidade (vetorRegistros, objDecl);
    vetorRegistros = arquivo.getRegistrosTxt ("81"); /* REG_RENDPJ_EXIG_DEPEN */
    conversor2ObjIRPF.montarRendPJDependentesComExigibilidade (vetorRegistros, objDecl);
    objDecl.adicionaObservadoresCalculosLate ();
    IRPFFacade.getInstancia ().salvarDeclaracao (idDecl.getCpf ().asString ());
  }
  
  public void gravarDeclaracao (IdentificadorDeclaracao objIdDecl) throws GeracaoTxtException, IOException
  {
    DeclaracaoIRPF objDecl = IRPFFacade.getInstancia ().recuperarDeclaracaoIRPF (objIdDecl.getCpf ().asString ());
    atualizarDeclaracao (objDecl, FINALIDADE_ENTREGA);
    String hash = arquivo.calcularHash ();
    Vector vRegistros = conversor2Registros.montarRegistroHeader (objDecl);
    arquivo.atualizaHeader (vRegistros, hash);
    vRegistros = conversor2Registros.montarRecibo (objDecl);
    arquivo.incluirRecibo (vRegistros, hash);
    arquivo.salvar ();
    IRPFFacade.getInstancia ().salvarDeclaracao (objIdDecl.getCpf ().asString ());
  }
  
  public void salvarDeclaracao (IdentificadorDeclaracao objIdDecl) throws GeracaoTxtException, IOException
  {
    DeclaracaoIRPF objDecl = IRPFFacade.getInstancia ().recuperarDeclaracaoIRPF (objIdDecl.getCpf ().asString ());
    atualizarDeclaracao (objDecl, FINALIDADE_BACKUP);
    String hash = arquivo.calcularHash ();
    Vector vRegistros = conversor2Registros.montarRegistroHeader (objDecl);
    arquivo.atualizaHeader (vRegistros, hash);
    arquivo.salvar ();
  }
  
  public void atualizarDeclaracao (DeclaracaoIRPF objDecl, byte finalidade) throws GeracaoTxtException
  {
    arquivo.clear ();
    Vector vetorRegistros = conversor2Registros.montarRegistroHeader (objDecl);
    arquivo.setFicha (vetorRegistros);
    vetorRegistros = conversor2Registros.montarRegistroContribuinte (objDecl);
    arquivo.setFicha (vetorRegistros);
    if (objDecl.getIdentificadorDeclaracao ().isCompleta ())
      {
	vetorRegistros = conversor2Registros.montarRegistroDeclaracaoCompleta (objDecl);
	arquivo.setFicha (vetorRegistros);
	vetorRegistros = conversor2Registros.montarFichaResumoCompleta (objDecl);
	arquivo.setFicha (vetorRegistros);
      }
    else
      {
	vetorRegistros = conversor2Registros.montarFichaSimplificada (objDecl);
	arquivo.setFicha (vetorRegistros);
	vetorRegistros = conversor2Registros.montarFichaResumoSimplificada (objDecl);
	arquivo.setFicha (vetorRegistros);
      }
    vetorRegistros = conversor2Registros.montarFichaRendPJ (objDecl);
    arquivo.setFicha (vetorRegistros);
    vetorRegistros = conversor2Registros.montarFichaRendPF (objDecl, false);
    arquivo.setFicha (vetorRegistros);
    vetorRegistros = conversor2Registros.montarFichaRendPF (objDecl, true);
    arquivo.setFicha (vetorRegistros);
    vetorRegistros = conversor2Registros.montarFichaRendIsentos (objDecl);
    arquivo.setFicha (vetorRegistros);
    vetorRegistros = conversor2Registros.montarFichaRendTribExcl (objDecl);
    arquivo.setFicha (vetorRegistros);
    vetorRegistros = conversor2Registros.montarFichaDependentes (objDecl);
    arquivo.setFicha (vetorRegistros);
    vetorRegistros = conversor2Registros.montarFichaPagamentos (objDecl);
    arquivo.setFicha (vetorRegistros);
    vetorRegistros = conversor2Registros.montarFichaBem (objDecl);
    arquivo.setFicha (vetorRegistros);
    vetorRegistros = conversor2Registros.montarFichaDividas (objDecl);
    arquivo.setFicha (vetorRegistros);
    if (objDecl.getIdentificadorDeclaracao ().isEspolio ())
      {
	  vetorRegistros = conversor2Registros.montarFichaInventariante (objDecl);
	  arquivo.setFicha (vetorRegistros);
      }
    vetorRegistros = conversor2Registros.montarFichaRendPJDependente (objDecl);
    arquivo.setFicha (vetorRegistros);
    vetorRegistros = conversor2Registros.montarFichaDoacoesCampanha (objDecl);
    arquivo.setFicha (vetorRegistros);
    vetorRegistros = conversor2Registros.montarFichaAlimentandos (objDecl);
    arquivo.setFicha (vetorRegistros);
    if (objDecl.getIdentificadorDeclaracao ().isEspolio ())
      {
	vetorRegistros = conversor2Registros.montarFichaFinalEspolio (objDecl);
	arquivo.setFicha (vetorRegistros);
      }
    else if (objDecl.getIdentificadorDeclaracao ().isSaida ())
      {
	vetorRegistros = conversor2Registros.montarFichaSaida (objDecl);
	arquivo.setFicha (vetorRegistros);
      }
	
    if (! objDecl.getRendaVariavel ().isVazio ())
      {
	vetorRegistros = conversor2Registros.montarFichaRendaVariavel (objDecl);
	arquivo.setFicha (vetorRegistros);
      }
    if (! objDecl.getRendaVariavel ().isVazio ())
      {
	vetorRegistros = conversor2Registros.montarFichaRendaVariavelAnual (objDecl);
	arquivo.setFicha (vetorRegistros);
      }
    if (! objDecl.getRendaVariavel ().getFundInvest ().isVazio ())
      {
	vetorRegistros = conversor2Registros.montarFichaRendaVariavelFII (objDecl);
	arquivo.setFicha (vetorRegistros);
      }
    if (! objDecl.getRendaVariavel ().getFundInvest ().isVazio ())
      {
	vetorRegistros = conversor2Registros.montarFichaRendaVariavelTotaisFII (objDecl);
	arquivo.setFicha (vetorRegistros);
      }
    vetorRegistros = conversor2Registros.montarFichaRRATitular (objDecl);
    arquivo.setFicha (vetorRegistros);
    vetorRegistros = conversor2Registros.montarFichaRRATitularPensao (objDecl);
    arquivo.setFicha (vetorRegistros);
    vetorRegistros = conversor2Registros.montarFichaRRADependente (objDecl);
    arquivo.setFicha (vetorRegistros);
    vetorRegistros = conversor2Registros.montarFichaRRADependentePensao (objDecl);
    arquivo.setFicha (vetorRegistros);
    vetorRegistros = conversor2Registros.montarFichaAtividadeRuralIdentificacaoImovel (objDecl);
    arquivo.setFicha (vetorRegistros);
    vetorRegistros = conversor2Registros.montarFichaAtividadeRuralReceitasDespesasBrasil (objDecl);
    arquivo.setFicha (vetorRegistros);
    vetorRegistros = conversor2Registros.montarFichaAtividadeRuralApuracaoResultado (objDecl);
    arquivo.setFicha (vetorRegistros);
    vetorRegistros = conversor2Registros.montarFichaAtividadeRuralMovimentacaoRebanho (objDecl);
    arquivo.setFicha (vetorRegistros);
    vetorRegistros = conversor2Registros.montarFichaAtividadeRuralBens (objDecl);
    arquivo.setFicha (vetorRegistros);
    vetorRegistros = conversor2Registros.montarFichaAtividadeRuralDividas (objDecl);
    arquivo.setFicha (vetorRegistros);
    vetorRegistros = conversor2Registros.montarFichaAtividadeRuralReceitasDespesasExterior (objDecl);
    arquivo.setFicha (vetorRegistros);
    if (objDecl.getIdentificadorDeclaracao ().isEspolio ())
      {
	vetorRegistros = conversor2Registros.montarFichaHerdeiros (objDecl);
	arquivo.setFicha (vetorRegistros);
	vetorRegistros = conversor2Registros.montarFichaPercentualBem (objDecl);
	arquivo.setFicha (vetorRegistros);
      }
    vetorRegistros = conversor2Registros.montarFichaRendPJComExigibilidade (objDecl);
    arquivo.setFicha (vetorRegistros);
    vetorRegistros = conversor2Registros.montarFichaRendPJComExigibilidadeDependente (objDecl);
    arquivo.setFicha (vetorRegistros);
    /* FIXME: Ganhos de capital, renda variável, moeda estrangeira, etc.  */
    vetorRegistros = conversor2Registros.montarFichaDetalheRendIsentos (objDecl);
    arquivo.setFicha (vetorRegistros);
    vetorRegistros = conversor2Registros.montarFichaDetalheRendExclusivos (objDecl);
    arquivo.setFicha (vetorRegistros);
    arquivo.incluirTrailler (objDecl.getIdentificadorDeclaracao ().getCpf ().asString ());
  }
  
  public void importarDeclaracaoAnoAnterior (IdentificadorDeclaracao idDecl) throws GeracaoTxtException
  {
    /* FIXME: Implementar os registros:

       REG_ALIMENTANDO

       FIXME: Estudar a necessidade e implementar os registros:

       REG_DETALHERENDRECEBEXT
       REG_DETALHEINCORPRESERVAS
       REG_DETALHEPENSAO
       REG_DETALHEPOUPANCA
       REG_DETALHERENDAPLICFINAN
       REG_DETALHETRANSFERENCIAS
       REG_FINALESPOLIO
       REG_GCAP
       REG_GCAP_ADQUIRENTES
       REG_GCAP_AMPLIACAO_REFORMA
       REG_GCAP_AMPLIACAO_REFORMA_EXT
       REG_GCAP_APURACAO_AMBAS
       REG_GCAP_APURACAO_IMOVEL
       REG_GCAP_APURACAO_MOVEL
       REG_GCAP_BEMIMOVEL
       REG_GCAP_BEMMOVEL
       REG_GCAP_CUSTO_AQUIS_PS
       REG_GCAP_ESPECIE
       REG_GCAP_EXTERIOR
       REG_GCAP_FAIXAS_TRIBUTACAO
       REG_GCAP_PARCELA_IMOVEL
       REG_GCAP_PARCELA_MOVEL
       REG_GCAP_PSOCIETARIA
       REG_HERDEIROS
       REG_IMPOSTO_PAGO
       REG_INDENIZACOES
       REG_IRRF_ANOS_ANTERIORES
       REG_JUROS_CAPITAL_PROPRIO
       REG_LUCROSDIVIDENDOS
       REG_OUTROS_RENDIMENTOS
       REG_PARTICIPACAO_LUCROS_RESULTADOS
       REG_PERCENTUAL_BEM
       REG_SAIDA

    */

    arquivo.validarHeaderAnoAnt (idDecl, getValidaHash ());
    DeclaracaoIRPF objDecl = IRPFFacade.getInstancia ().recuperarDeclaracaoIRPF (idDecl.getCpf ().asString ());
    Vector vetorRegistros = arquivo.getRegistrosTxt ("16"); /* REG_IDENTIFICACAO */
    conversor2ObjIRPF.montarContribuinteIRPFAnoAnterior (vetorRegistros, objDecl.getContribuinte ());
    vetorRegistros = arquivo.getRegistrosTxt ("27"); /* REG_BEM */
    conversor2ObjIRPF.montarBensAnoAnterior (vetorRegistros, objDecl);
    vetorRegistros = arquivo.getRegistrosTxt ("28"); /* REG_DIVIDA */
    conversor2ObjIRPF.montarDividasAnoAnterior (vetorRegistros, objDecl);
    vetorRegistros = arquivo.getRegistrosTxt ("23"); /* REG_RENDISENTOS */
    conversor2ObjIRPF.recuperarRendIsentosNaoTributaveis (vetorRegistros, objDecl, true);
    vetorRegistros = arquivo.getRegistrosTxt ("83"); /* REG_RENDIMENTO_ISENTO_TIPO2 */
    conversor2ObjIRPF.recuperarRendIsentosDetalhe2 (vetorRegistros, objDecl, true);
    vetorRegistros = arquivo.getRegistrosTxt ("84"); /* REG_RENDIMENTO_ISENTO_TIPO_INFORMACAO_3 */
    conversor2ObjIRPF.recuperarRendIsentosDetalhe3 (vetorRegistros, objDecl, true);
    vetorRegistros = arquivo.getRegistrosTxt ("85"); /* REG_RENDIMENTO_ISENTO_TIPO_INFORMACAO_4 */
    conversor2ObjIRPF.recuperarRendIsentosDetalhe4 (vetorRegistros, objDecl, true);
    vetorRegistros = arquivo.getRegistrosTxt ("86"); /* REG_RENDIMENTO_ISENTO_TIPO_INFORMACAO_5 */
    conversor2ObjIRPF.recuperarRendIsentosDetalhe5 (vetorRegistros, objDecl, true);
    vetorRegistros = arquivo.getRegistrosTxt ("87"); /* REG_RENDIMENTO_ISENTO_TIPO_INFORMACAO_6 */
    conversor2ObjIRPF.recuperarRendIsentosDetalhe6 (vetorRegistros, objDecl, true);
    vetorRegistros = arquivo.getRegistrosTxt ("88"); /* REG_RENDIMENTO_EXCLUSIVO_TIPO_INFORMACAO_2 */
    conversor2ObjIRPF.recuperarRendExclusivosDetalhe2 (vetorRegistros, objDecl, true);
    vetorRegistros = arquivo.getRegistrosTxt ("89"); /* REG_RENDIMENTO_EXCLUSIVO_TIPO_INFORMAÇÃO_3 */
    conversor2ObjIRPF.recuperarRendExclusivosDetalhe3 (vetorRegistros, objDecl, true);
    vetorRegistros = arquivo.getRegistrosTxt ("24"); /* REG_RENDEXCLUSIVA */
    conversor2ObjIRPF.recuperarRendTributacaoExclusiva (vetorRegistros, objDecl, true);
    vetorRegistros = arquivo.getRegistrosTxt ("25"); /* REG_DEPENDENTE */
    conversor2ObjIRPF.montarDependentesAnoAnterior (vetorRegistros, objDecl);
    vetorRegistros = arquivo.getRegistrosTxt ("26"); /* REG_PAGAMENTO */
    conversor2ObjIRPF.montarPagamentosAnoAnterior (vetorRegistros, objDecl);
    vetorRegistros = arquivo.getRegistrosTxt ("30"); /* REG_INVENTARIANTE */
    conversor2ObjIRPF.montarInventarianteAnoAnterior (vetorRegistros, objDecl);
    idDecl.getDeclaracaoRetificadora ().clear ();
    idDecl.getNumReciboDecRetif ().clear ();
    objDecl.getIdentificadorDeclaracao ().getEnderecoDiferente ().clear ();
    vetorRegistros = arquivo.getRegistrosTxt ("50"); /* REG_ATIVIDADE_RURAL_ID_IMOVEL */
    conversor2ObjIRPF.montarAtividadeRuralImoveisAnoAnterior (vetorRegistros, objDecl);
    vetorRegistros = arquivo.getRegistrosTxt ("54"); /* REG_ATIVIDADE_RURAL_BENS */
    conversor2ObjIRPF.montarAtividadeRuralBensAnoAnterior (vetorRegistros, objDecl);
    vetorRegistros = arquivo.getRegistrosTxt ("55"); /* REG_ATIVIDADE_RURAL_DIVIDAS */
    conversor2ObjIRPF.montarAtividadeRuralDividasAnoAnterior (vetorRegistros, objDecl);
    vetorRegistros = arquivo.getRegistrosTxt ("53"); /* REG_ATIVIDADE_RURAL_MOV_REBANHO */
    conversor2ObjIRPF.montarAtividadeRuralMovimentacaoRebanhoAnoAnterior (vetorRegistros, objDecl);
    vetorRegistros = arquivo.getRegistrosTxt ("52"); /* REG_ATIVIDADE_RURAL_APURACAO_RESULTADO */
    conversor2ObjIRPF.montarAtividadeRuralApuracaoResultado (vetorRegistros, objDecl);
    vetorRegistros = arquivo.getRegistrosTxt ("51"); /* REG_ATIVIDADE_RURAL_REC_DESP_BRASIL */
    conversor2ObjIRPF.montarAtividadeRuralReceitasDespesasBrasil (vetorRegistros, objDecl);
    vetorRegistros = arquivo.getRegistrosTxt ("56"); /* REG_ATIVIDADE_RURAL_REC_DESP_EXT */
    conversor2ObjIRPF.montarAtividadeRuralReceitasDespesasExterior (vetorRegistros, objDecl);
    vetorRegistros = arquivo.getRegistrosTxt ("16"); /* REG_IDENTIFICACAO */
    conversor2ObjIRPF.montarInformacoesBancarias (vetorRegistros, objDecl);
    conversor2ObjIRPF.montarInformacoesObrigatorias (vetorRegistros, objDecl, true);
    vetorRegistros = arquivo.getRegistrosTxt ("21"); /* REG_RENDPJ */
    conversor2ObjIRPF.montarRendPJTitularAnoAnterior (vetorRegistros, objDecl);
    vetorRegistros = arquivo.getRegistrosTxt ("32"); /* REG_RENDPJDEPENDENTE */
    conversor2ObjIRPF.montarRendPJDependAnoAnterior (vetorRegistros, objDecl);
    vetorRegistros = arquivo.getRegistrosTxt ("80"); /* REG_RENDPJ_EXIG_TIT */
    conversor2ObjIRPF.montarRendPJTitularComExigibilidade (vetorRegistros, objDecl);
    vetorRegistros = arquivo.getRegistrosTxt ("81"); /* REG_RENDPJ_EXIG_DEPEN */
    conversor2ObjIRPF.montarRendPJDependentesComExigibilidade (vetorRegistros, objDecl);
    IRPFFacade.getInstancia ().salvarDeclaracao (idDecl.getCpf ().asString ());
  }
  
  public void validarDeclaracao () throws Exception
  {
    if (objIdArquivo == null)
      objIdArquivo = recuperarIdDeclaracao ();
    arquivo.validarCRC ();
    arquivo.validarHeader (objIdArquivo);
  }
  
  public void validarDeclaracaoNaoPersistido () throws GeracaoTxtException, IOException
  {
    if (objIdArquivo == null)
      objIdArquivo = recuperarIdDeclaracaoNaoPersistido ();
    arquivo.validarCRC ();
    arquivo.validarHeader (objIdArquivo);
  }
  
  public void lerDeclaracao () throws GeracaoTxtException, IOException
  {
    if (arquivo == null)
      arquivo = new DocumentoAjusteTXT ("ARQ_IRPF", file.getPath ());
    if (! fLido)
      arquivo.ler ();
    fLido = true;
  }
  
  public RegistroTxt recuperarRegistroHeader () throws GeracaoTxtException, IOException
  {
    lerDeclaracao ();
    Vector vetorHeader = arquivo.getRegistrosTxt ("IR"); /* REG_HEADER */
    return conversor2ObjIRPF.getRegistroHeader (vetorHeader);
  }
  
  public RegistroTxt recuperarRegistroRecibo () throws GeracaoTxtException, IOException
  {
    lerDeclaracao ();
    Vector vetorRecibo = arquivo.getRegistrosTxt ("DR"); /* REG_RECIBODETALHE */
    return conversor2ObjIRPF.getRegistroRecibo (vetorRecibo);
  }
  
  public RegistroTxt recuperarRegistroComplementoRecibo () throws GeracaoTxtException, IOException
  {
    lerDeclaracao ();
    Vector vetorRecibo = arquivo.getRegistrosTxt ("RC"); /* REG_COMPLRECIBODETALHE */
    return conversor2ObjIRPF.getRegistroRecibo (vetorRecibo);
  }
  
  public RegistroTxt recuperarRegistroComplementoReciboMulta () throws GeracaoTxtException, IOException
  {
    lerDeclaracao ();
    Vector vetorRecibo = arquivo.getRegistrosTxt ("NC"); /* REG_COMPLRECIBOMULTA */
    if (vetorRecibo.isEmpty ())
      return null;
    return conversor2ObjIRPF.getRegistroRecibo (vetorRecibo);
  }
  
  public String getPath ()
  {
    return file.getPath ();
  }
  
  private boolean getValidaHash ()
  {
    if (UtilitariosArquivo.extraiExtensaoAquivo (getPath ()).toUpperCase ().equals (".F2B"))
      return false;
    return true;
  }
  
  public void validarComplementoRecibo (IdentificadorDeclaracao idDecl) throws GeracaoTxtException, IOException
  {
    lerDeclaracao ();
    arquivo.validarCRCAcumulado ();
    arquivo.validarComplRecibo (idDecl);
  }
  
  public DocumentoAjusteTXT getArquivo ()
  {
    return arquivo;
  }

  public ConversorObjetosIRPF2Registros getConversor2Registros ()
  {
    return conversor2Registros;
  }
}
