/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.pagamentos;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.pagamentos.Pagamento;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.NI;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Valor;

public class Pagamentos
extends Colecao {
    public static final String VALOR_PAGO_ALTO = "50.000,00";
    private transient DeclaracaoIRPF objDecl;
    private Valor totalDeducoesInstrucao = new Valor(this, "");
    private Valor totalContribuicaoFAPI = new Valor(this, "");
    private Valor totalDespesasMedicas = new Valor(this, "");
    private Valor totalPensao = new Valor(this, "");
    private Valor totalPensaoCartoral = new Valor(this, "");
    private Valor totalDeducaoIncentivo = new Valor(this, "");

    public Pagamentos(DeclaracaoIRPF declaracaoIRPF) {
        super(Pagamento.class.getName());
        this.objDecl = declaracaoIRPF;
        this.setFicha("Pagamentos e Doa\u00e7\u00f5es Efetuados");
    }

    public void objetoInserido(Object object) {
        ((ObjetoNegocio)object).setFicha(this.getFicha());
    }

    public ObjetoNegocio instanciaNovoObjeto() {
        return new Pagamento(this.objDecl);
    }

    public Valor getTotalDeducoesInstrucao() {
        return this.totalDeducoesInstrucao;
    }

    public Valor getTotalContribuicaoFAPI() {
        return this.totalContribuicaoFAPI;
    }

    public Valor getTotalDespesasMedicas() {
        return this.totalDespesasMedicas;
    }

    public Valor getTotalPensao() {
        return this.totalPensao;
    }

    public Valor getTotalPensaoCartoral() {
        return this.totalPensaoCartoral;
    }

    public Valor getTotalDeducaoIncentivo() {
        return this.totalDeducaoIncentivo;
    }

    public String recuperarCpfMaiorPensaoAlimenticia() {
        Iterator iterator = this.recuperarLista().iterator();
        String string = "";
        Valor valor = null;
        while (iterator.hasNext()) {
            Pagamento pagamento = (Pagamento)iterator.next();
            if (!pagamento.getCodigo().asString().equals("30") && !pagamento.getCodigo().asString().equals("31")) continue;
            if (valor == null) {
                valor = pagamento.getValorPago();
                string = pagamento.getNiBeneficiario().asString().substring(0, 11);
                continue;
            }
            if (!pagamento.getValorPago().comparacao(">", valor)) continue;
            valor = pagamento.getValorPago();
            string = pagamento.getNiBeneficiario().asString().substring(0, 11);
        }
        return string;
    }

    private Object[] OrdenarPagamentos(int n, boolean bl, FiltroDePagamento filtroDePagamento) {
        Object[] objectArray3;
        Object object2;
        Hashtable<String, Object[]> hashtable = new Hashtable<String, Object[]>();
        for (Object object2 : this.recuperarLista()) {
            objectArray3 = filtroDePagamento.seleciona((Pagamento)object2);
            if (objectArray3 == null) continue;
            Object[] objectArray2 = (Object[])hashtable.get(objectArray3.ni);
            if (objectArray2 == null) {
                objectArray2 = objectArray3;
                hashtable.put(objectArray2.ni, objectArray2);
                continue;
            }
            objectArray2.soma((Beneficiario)objectArray3);
        }
        object2 = new String[n];
        block1: for (Object[] objectArray3 : hashtable.values()) {
            int n2 = 0;
            while (n2 < n) {
                if (object2[n2] == null || objectArray3.total.comparacao(">", ((Beneficiario)hashtable.get((Object)object2[n2])).total)) {
                    Object object3 = objectArray3.ni;
                    while (n2 < n) {
                        Object object4 = object2[n2];
                        object2[n2] = object3;
                        object3 = object4;
                        ++n2;
                    }
                    continue block1;
                }
                ++n2;
            }
        }
        if (!bl) {
            return object2;
        }
        objectArray3 = new Beneficiario[n];
        int n3 = 0;
        while (n3 < n && object2[n3] != null) {
            objectArray3[n3] = (Beneficiario)hashtable.get(object2[n3]);
            ++n3;
        }
        return objectArray3;
    }

    public String[] recuperarNiMaioresPagamentosDedutiveis(int n) {
        String[] stringArray = (String[])this.OrdenarPagamentos(n, false, new FiltroDePagamento(this){

            Beneficiario seleciona(Pagamento pagamento) {
                if (pagamento.getCodigo().toString().equals("01") || pagamento.getCodigo().toString().equals("02") || pagamento.getCodigo().toString().equals("09") || pagamento.getCodigo().toString().equals("10") || pagamento.getCodigo().toString().equals("11") || pagamento.getCodigo().toString().equals("12") || pagamento.getCodigo().toString().equals("13") || pagamento.getCodigo().toString().equals("14") || pagamento.getCodigo().toString().equals("21") || pagamento.getCodigo().toString().equals("26") || pagamento.getCodigo().asString().equals("36") || pagamento.getCodigo().asString().equals("38")) {
                    return super.seleciona(pagamento);
                }
                return null;
            }
        });
        return stringArray;
    }

    public String[] recuperarMaioresPagDoa(int n) {
        String[] stringArray = (String[])this.OrdenarPagamentos(n, false, new FiltroDePagamento(this){

            Beneficiario seleciona(Pagamento pagamento) {
                if (pagamento.getCodigo().asString().equals("36") || pagamento.getCodigo().asString().equals("37") || pagamento.getCodigo().asString().equals("38")) {
                    String string = "01" + pagamento.getCodigo().asString() + pagamento.getNiBeneficiario().asString();
                    Beneficiario beneficiario = new Beneficiario(pagamento.getValorPago(), string);
                    return beneficiario;
                }
                return null;
            }
        });
        return stringArray;
    }

    public String recuperarCnpjMaiorPagamentoFunpresp() {
        Iterator iterator = this.recuperarLista().iterator();
        String string = "";
        Valor valor = null;
        while (iterator.hasNext()) {
            Pagamento pagamento = (Pagamento)iterator.next();
            if (!pagamento.getCodigo().asString().equals("37")) continue;
            if (valor == null) {
                valor = pagamento.getValorPago();
                string = pagamento.getNiBeneficiario().asString();
                continue;
            }
            if (!pagamento.getValorPago().comparacao(">", valor)) continue;
            valor = pagamento.getValorPago();
            string = pagamento.getNiBeneficiario().asString();
        }
        return string;
    }

    public String recuperarCNPJMaiorPrevComplementar() {
        Iterator iterator = this.recuperarLista().iterator();
        String string = "";
        Valor valor = null;
        while (iterator.hasNext()) {
            Pagamento pagamento = (Pagamento)iterator.next();
            if (!pagamento.getCodigo().asString().equals("36") && !pagamento.getCodigo().asString().equals("38")) continue;
            if (valor == null) {
                valor = pagamento.getValorPago();
                string = pagamento.getNiBeneficiario().asString().substring(0, 11);
                continue;
            }
            if (!pagamento.getValorPago().comparacao(">", valor)) continue;
            valor = pagamento.getValorPago();
            string = pagamento.getNiBeneficiario().asString().substring(0, 11);
        }
        return string;
    }

    public String recuperarCNPJSegundaMaiorPrevComplementar() {
        Iterator iterator = this.recuperarLista().iterator();
        String string = "";
        Valor valor = null;
        Valor valor2 = null;
        while (iterator.hasNext()) {
            Pagamento pagamento = (Pagamento)iterator.next();
            if (!pagamento.getCodigo().asString().equals("36") && !pagamento.getCodigo().asString().equals("38")) continue;
            if (valor == null) {
                valor = pagamento.getValorPago();
                string = pagamento.getNiBeneficiario().asString().substring(0, 11);
                continue;
            }
            if (pagamento.getValorPago().comparacao(">", valor)) {
                valor2 = valor;
                valor = pagamento.getValorPago();
                string = pagamento.getNiBeneficiario().asString().substring(0, 11);
                continue;
            }
            if (valor2 == null) {
                valor2 = pagamento.getValorPago();
                pagamento.getNiBeneficiario().asString().substring(0, 11);
                continue;
            }
            if (!pagamento.getValorPago().comparacao(">", valor2)) continue;
            valor2 = pagamento.getValorPago();
            pagamento.getNiBeneficiario().asString().substring(0, 11);
        }
        return string;
    }

    public NI recuperarNIMaiorDespMedicas() {
        Object object;
        Object object2;
        class BeneficiarioMedico {
            public Valor total;
            public NI ni;

            BeneficiarioMedico() {
            }
        }
        Hashtable<String, BeneficiarioMedico> hashtable = new Hashtable<String, BeneficiarioMedico>();
        List list = this.recuperarLista();
        int n = 0;
        while (n < this.recuperarLista().size()) {
            object2 = (Pagamento)list.get(n);
            if (((Pagamento)object2).getCodigo().toString().equals("09") || ((Pagamento)object2).getCodigo().toString().equals("10") || ((Pagamento)object2).getCodigo().toString().equals("11") || ((Pagamento)object2).getCodigo().toString().equals("12") || ((Pagamento)object2).getCodigo().toString().equals("13") || ((Pagamento)object2).getCodigo().toString().equals("14") || ((Pagamento)object2).getCodigo().toString().equals("21") || ((Pagamento)object2).getCodigo().toString().equals("26")) {
                String string;
                BeneficiarioMedico beneficiarioMedico;
                object = new Valor();
                if (((Pagamento)object2).getValorPago().comparacao(">=", ((Pagamento)object2).getParcelaNaoDedutivel())) {
                    ((Valor)object).append('+', ((Pagamento)object2).getValorPago());
                    ((Valor)object).append('-', ((Pagamento)object2).getParcelaNaoDedutivel());
                }
                if ((beneficiarioMedico = (BeneficiarioMedico)hashtable.get(string = ((Pagamento)object2).getNiBeneficiario().asString())) == null) {
                    beneficiarioMedico = new BeneficiarioMedico();
                    beneficiarioMedico.total = object;
                    beneficiarioMedico.ni = ((Pagamento)object2).getNiBeneficiario();
                    hashtable.put(string, beneficiarioMedico);
                } else {
                    beneficiarioMedico.total.append('+', (Valor)object);
                }
            }
            ++n;
        }
        Iterator iterator = hashtable.values().iterator();
        object2 = null;
        if (iterator.hasNext()) {
            object2 = (BeneficiarioMedico)iterator.next();
            while (iterator.hasNext()) {
                object = (BeneficiarioMedico)iterator.next();
                if (!((BeneficiarioMedico)object).total.comparacao(">", ((BeneficiarioMedico)object2).total)) continue;
                object2 = object;
            }
        }
        if (object2 == null) {
            return new NI(this, "");
        }
        return ((BeneficiarioMedico)object2).ni;
    }

    public NI recuperarNISegundoMaiorDespMedicas() {
        Object object;
        Object object2;
        Object object3;
        class BeneficiarioMedico {
            public Valor total;
            public NI ni;

            BeneficiarioMedico() {
            }
        }
        Hashtable<Object, BeneficiarioMedico> hashtable = new Hashtable<Object, BeneficiarioMedico>();
        List list = this.recuperarLista();
        int n = 0;
        while (n < this.recuperarLista().size()) {
            object3 = (Pagamento)list.get(n);
            if (((Pagamento)object3).getCodigo().toString().equals("09") || ((Pagamento)object3).getCodigo().toString().equals("10") || ((Pagamento)object3).getCodigo().toString().equals("11") || ((Pagamento)object3).getCodigo().toString().equals("12") || ((Pagamento)object3).getCodigo().toString().equals("13") || ((Pagamento)object3).getCodigo().toString().equals("14") || ((Pagamento)object3).getCodigo().toString().equals("21") || ((Pagamento)object3).getCodigo().toString().equals("26")) {
                BeneficiarioMedico beneficiarioMedico;
                object2 = new Valor();
                if (((Pagamento)object3).getValorPago().comparacao(">=", ((Pagamento)object3).getParcelaNaoDedutivel())) {
                    ((Valor)object2).append('+', ((Pagamento)object3).getValorPago());
                    ((Valor)object2).append('-', ((Pagamento)object3).getParcelaNaoDedutivel());
                }
                if ((beneficiarioMedico = (BeneficiarioMedico)hashtable.get(object = ((Pagamento)object3).getNiBeneficiario().asString())) == null) {
                    beneficiarioMedico = new BeneficiarioMedico();
                    beneficiarioMedico.total = object2;
                    beneficiarioMedico.ni = ((Pagamento)object3).getNiBeneficiario();
                    hashtable.put(object, beneficiarioMedico);
                } else {
                    beneficiarioMedico.total.append('+', (Valor)object2);
                }
            }
            ++n;
        }
        Iterator iterator = hashtable.values().iterator();
        object3 = null;
        object2 = null;
        if (iterator.hasNext()) {
            object3 = (BeneficiarioMedico)iterator.next();
            while (iterator.hasNext()) {
                object = (BeneficiarioMedico)iterator.next();
                if (((BeneficiarioMedico)object).total.comparacao(">", ((BeneficiarioMedico)object3).total)) {
                    object2 = object3;
                    object3 = object;
                    continue;
                }
                if (object2 != null && !((BeneficiarioMedico)object).total.comparacao(">", ((BeneficiarioMedico)object2).total)) continue;
                object2 = object;
            }
        }
        if (object2 == null) {
            return new NI(this, "");
        }
        return ((BeneficiarioMedico)object2).ni;
    }

    public int obterTotalDependentesEnvolvidos() {
        HashSet<String> hashSet = new HashSet<String>();
        this.excluirRegistrosEmBranco();
        for (Pagamento pagamento : this.recuperarLista()) {
            if (!pagamento.ehDependenteBrasil() && !pagamento.ehDependenteExterior()) continue;
            hashSet.add(pagamento.getDependenteOuAlimentando().getConteudoFormatado());
        }
        int n = 0;
        if (!hashSet.isEmpty()) {
            n = hashSet.size();
        }
        return n;
    }

    public int obterTotalAlimentandosEnvolvidos() {
        HashSet<String> hashSet = new HashSet<String>();
        this.excluirRegistrosEmBranco();
        for (Pagamento pagamento : this.recuperarLista()) {
            if (!pagamento.ehAlimentandoBrasil() && !pagamento.ehAlimentandoExterior()) continue;
            hashSet.add(pagamento.getDependenteOuAlimentando().getConteudoFormatado());
        }
        int n = 0;
        if (!hashSet.isEmpty()) {
            n = hashSet.size();
        }
        return n;
    }

    private class Beneficiario {
        public Valor total;
        public String ni;
        private boolean shared = true;

        public Beneficiario(Valor valor, String string) {
            this.total = valor;
            this.ni = string;
        }

        public Beneficiario(Valor valor, NI nI) {
            this.total = valor;
            this.ni = nI.asString();
        }

        public Beneficiario(Pagamento pagamento) {
            this.total = new Valor();
            this.total.append('+', pagamento.getValorPago());
            this.total.append('-', pagamento.getParcelaNaoDedutivel());
            this.ni = pagamento.getNiBeneficiario().asString();
        }

        public void soma(Beneficiario beneficiario) {
            if (this.shared) {
                Valor valor = new Valor();
                valor.append('+', this.total);
                this.total = valor;
                this.shared = false;
            }
            this.total.append('+', beneficiario.total);
        }
    }

    private class FiltroDePagamento {
        private FiltroDePagamento() {
        }

        Beneficiario seleciona(Pagamento pagamento) {
            return new Beneficiario(pagamento);
        }
    }
}

