/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.VariableBinding;

public class FieldBinding
extends VariableBinding {
    public ReferenceBinding declaringClass;

    protected FieldBinding() {
        super(null, null, 0, null);
    }

    public FieldBinding(char[] cArray, TypeBinding typeBinding, int n, ReferenceBinding referenceBinding, Constant constant) {
        super(cArray, typeBinding, n, constant);
        this.declaringClass = referenceBinding;
    }

    public FieldBinding(FieldDeclaration fieldDeclaration, TypeBinding typeBinding, int n, ReferenceBinding referenceBinding) {
        this(fieldDeclaration.name, typeBinding, n, referenceBinding, null);
        fieldDeclaration.binding = this;
    }

    public FieldBinding(FieldBinding fieldBinding, ReferenceBinding referenceBinding) {
        super(fieldBinding.name, fieldBinding.type, fieldBinding.modifiers, fieldBinding.constant());
        this.declaringClass = referenceBinding;
        this.id = fieldBinding.id;
        this.setAnnotations(fieldBinding.getAnnotations());
    }

    public final int kind() {
        return 1;
    }

    public final boolean canBeSeenBy(PackageBinding packageBinding) {
        if (this.isPublic()) {
            return true;
        }
        if (this.isPrivate()) {
            return false;
        }
        return packageBinding == this.declaringClass.getPackage();
    }

    public final boolean canBeSeenBy(TypeBinding typeBinding, InvocationSite invocationSite, Scope scope) {
        if (this.isPublic()) {
            return true;
        }
        SourceTypeBinding sourceTypeBinding = scope.enclosingSourceType();
        if (sourceTypeBinding == this.declaringClass && sourceTypeBinding == typeBinding) {
            return true;
        }
        if (sourceTypeBinding == null) {
            return !this.isPrivate() && scope.getCurrentPackage() == this.declaringClass.fPackage;
        }
        if (this.isProtected()) {
            if (sourceTypeBinding == this.declaringClass) {
                return true;
            }
            if (sourceTypeBinding.fPackage == this.declaringClass.fPackage) {
                return true;
            }
            ReferenceBinding referenceBinding = sourceTypeBinding;
            int n = 0;
            ReferenceBinding referenceBinding2 = (ReferenceBinding)typeBinding.erasure();
            ReferenceBinding referenceBinding3 = (ReferenceBinding)this.declaringClass.erasure();
            do {
                if (referenceBinding.findSuperTypeWithSameErasure(referenceBinding3) != null) {
                    if (invocationSite.isSuperAccess()) {
                        return true;
                    }
                    if (typeBinding instanceof ArrayBinding) {
                        return false;
                    }
                    if (this.isStatic()) {
                        if (n > 0) {
                            invocationSite.setDepth(n);
                        }
                        return true;
                    }
                    if (referenceBinding == referenceBinding2 || referenceBinding2.findSuperTypeWithSameErasure(referenceBinding) != null) {
                        if (n > 0) {
                            invocationSite.setDepth(n);
                        }
                        return true;
                    }
                }
                ++n;
            } while ((referenceBinding = referenceBinding.enclosingType()) != null);
            return false;
        }
        if (this.isPrivate()) {
            if (!(typeBinding == this.declaringClass || typeBinding.isTypeVariable() && ((TypeVariableBinding)typeBinding).isErasureBoundTo(this.declaringClass.erasure()))) {
                return false;
            }
            if (sourceTypeBinding != this.declaringClass) {
                ReferenceBinding referenceBinding = sourceTypeBinding;
                ReferenceBinding referenceBinding4 = referenceBinding.enclosingType();
                while (referenceBinding4 != null) {
                    referenceBinding = referenceBinding4;
                    referenceBinding4 = referenceBinding4.enclosingType();
                }
                ReferenceBinding referenceBinding5 = (ReferenceBinding)this.declaringClass.erasure();
                referenceBinding4 = referenceBinding5.enclosingType();
                while (referenceBinding4 != null) {
                    referenceBinding5 = referenceBinding4;
                    referenceBinding4 = referenceBinding4.enclosingType();
                }
                if (referenceBinding != referenceBinding5) {
                    return false;
                }
            }
            return true;
        }
        PackageBinding packageBinding = this.declaringClass.fPackage;
        if (sourceTypeBinding.fPackage != packageBinding) {
            return false;
        }
        if (typeBinding instanceof ArrayBinding) {
            return false;
        }
        ReferenceBinding referenceBinding = (ReferenceBinding)typeBinding;
        do {
            if (this.declaringClass == referenceBinding) {
                return true;
            }
            PackageBinding packageBinding2 = referenceBinding.fPackage;
            if (packageBinding2 == null || packageBinding2 == packageBinding) continue;
            return false;
        } while ((referenceBinding = referenceBinding.superclass()) != null);
        return false;
    }

    public char[] computeUniqueKey(boolean bl) {
        char[] cArray;
        char[] cArray2 = this.declaringClass == null ? CharOperation.NO_CHAR : this.declaringClass.computeUniqueKey(false);
        int n = cArray2.length;
        int n2 = this.name.length;
        if (this.type == null) {
            char[] cArray3 = new char[1];
            cArray = cArray3;
            cArray3[0] = 86;
        } else {
            cArray = this.type.computeUniqueKey(false);
        }
        char[] cArray4 = cArray;
        int n3 = cArray4.length;
        char[] cArray5 = new char[n + 1 + n2 + 1 + n3];
        int n4 = 0;
        System.arraycopy(cArray2, 0, cArray5, n4, n);
        n4 += n;
        cArray5[n4++] = 46;
        System.arraycopy(this.name, 0, cArray5, n4, n2);
        n4 += n2;
        cArray5[n4++] = 41;
        System.arraycopy(cArray4, 0, cArray5, n4, n3);
        return cArray5;
    }

    public Constant constant() {
        Constant constant = this.constant;
        if (constant == null) {
            if (this.isFinal()) {
                FieldBinding fieldBinding = this.original();
                if (fieldBinding.declaringClass instanceof SourceTypeBinding) {
                    SourceTypeBinding sourceTypeBinding = (SourceTypeBinding)fieldBinding.declaringClass;
                    if (sourceTypeBinding.scope != null) {
                        TypeDeclaration typeDeclaration = sourceTypeBinding.scope.referenceContext;
                        FieldDeclaration fieldDeclaration = typeDeclaration.declarationOf(fieldBinding);
                        fieldDeclaration.resolve(fieldBinding.isStatic() ? typeDeclaration.staticInitializerScope : typeDeclaration.initializerScope);
                        constant = fieldBinding.constant();
                    } else {
                        constant = Constant.NotAConstant;
                    }
                } else {
                    constant = Constant.NotAConstant;
                }
            } else {
                constant = Constant.NotAConstant;
            }
            this.constant = constant;
        }
        return constant;
    }

    public char[] genericSignature() {
        if ((this.modifiers & 0x40000000) == 0) {
            return null;
        }
        return this.type.genericTypeSignature();
    }

    public final int getAccessFlags() {
        return this.modifiers & 0xFFFF;
    }

    public long getAnnotationTagBits() {
        FieldBinding fieldBinding = this.original();
        if ((fieldBinding.tagBits & 0x200000000L) == 0L && fieldBinding.declaringClass instanceof SourceTypeBinding) {
            ClassScope classScope = ((SourceTypeBinding)fieldBinding.declaringClass).scope;
            if (classScope == null) {
                this.tagBits |= 0x200000000L;
                return 0L;
            }
            TypeDeclaration typeDeclaration = classScope.referenceContext;
            FieldDeclaration fieldDeclaration = typeDeclaration.declarationOf(fieldBinding);
            if (fieldDeclaration != null) {
                MethodScope methodScope = this.isStatic() ? typeDeclaration.staticInitializerScope : typeDeclaration.initializerScope;
                FieldBinding fieldBinding2 = methodScope.initializedField;
                int n = methodScope.lastVisibleFieldID;
                try {
                    methodScope.initializedField = fieldBinding;
                    methodScope.lastVisibleFieldID = fieldBinding.id;
                    ASTNode.resolveAnnotations(methodScope, fieldDeclaration.annotations, fieldBinding);
                }
                finally {
                    methodScope.initializedField = fieldBinding2;
                    methodScope.lastVisibleFieldID = n;
                }
            }
        }
        return fieldBinding.tagBits;
    }

    public AnnotationBinding[] getAnnotations() {
        FieldBinding fieldBinding = this.original();
        ReferenceBinding referenceBinding = fieldBinding.declaringClass;
        if (referenceBinding == null) {
            return Binding.NO_ANNOTATIONS;
        }
        return referenceBinding.retrieveAnnotations(fieldBinding);
    }

    public final boolean isDefault() {
        return !this.isPublic() && !this.isProtected() && !this.isPrivate();
    }

    public final boolean isDeprecated() {
        return (this.modifiers & 0x100000) != 0;
    }

    public final boolean isPrivate() {
        return (this.modifiers & 2) != 0;
    }

    public final boolean isUsed() {
        return (this.modifiers & 0x8000000) != 0;
    }

    public final boolean isProtected() {
        return (this.modifiers & 4) != 0;
    }

    public final boolean isPublic() {
        return (this.modifiers & 1) != 0;
    }

    public final boolean isStatic() {
        return (this.modifiers & 8) != 0;
    }

    public final boolean isSynthetic() {
        return (this.modifiers & 0x1000) != 0;
    }

    public final boolean isTransient() {
        return (this.modifiers & 0x80) != 0;
    }

    public final boolean isViewedAsDeprecated() {
        return (this.modifiers & 0x300000) != 0;
    }

    public final boolean isVolatile() {
        return (this.modifiers & 0x40) != 0;
    }

    public FieldBinding original() {
        return this;
    }

    public void setAnnotations(AnnotationBinding[] annotationBindingArray) {
        this.declaringClass.storeAnnotations(this, annotationBindingArray);
    }

    public FieldDeclaration sourceField() {
        SourceTypeBinding sourceTypeBinding;
        try {
            sourceTypeBinding = (SourceTypeBinding)this.declaringClass;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
        FieldDeclaration[] fieldDeclarationArray = sourceTypeBinding.scope.referenceContext.fields;
        if (fieldDeclarationArray != null) {
            int n = fieldDeclarationArray.length;
            while (--n >= 0) {
                if (this != fieldDeclarationArray[n].binding) continue;
                return fieldDeclarationArray[n];
            }
        }
        return null;
    }
}

