/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import java.util.ArrayList;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.codegen.BranchLabel;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;
import org.eclipse.jdt.internal.compiler.problem.ShouldNotImplement;
import org.eclipse.jdt.internal.compiler.util.Messages;

public abstract class Expression
extends Statement {
    public Constant constant;
    public int statementEnd = -1;
    public int implicitConversion;
    public TypeBinding resolvedType;

    public static final boolean isConstantValueRepresentable(Constant constant, int n, int n2) {
        if (n2 == n) {
            return true;
        }
        switch (n2) {
            case 2: {
                switch (n) {
                    case 2: {
                        return true;
                    }
                    case 8: {
                        return constant.doubleValue() == (double)constant.charValue();
                    }
                    case 9: {
                        return constant.floatValue() == (float)constant.charValue();
                    }
                    case 10: {
                        return constant.intValue() == constant.charValue();
                    }
                    case 4: {
                        return constant.shortValue() == constant.charValue();
                    }
                    case 3: {
                        return constant.byteValue() == constant.charValue();
                    }
                    case 7: {
                        return constant.longValue() == (long)constant.charValue();
                    }
                }
                return false;
            }
            case 9: {
                switch (n) {
                    case 2: {
                        return (float)constant.charValue() == constant.floatValue();
                    }
                    case 8: {
                        return constant.doubleValue() == (double)constant.floatValue();
                    }
                    case 9: {
                        return true;
                    }
                    case 10: {
                        return (float)constant.intValue() == constant.floatValue();
                    }
                    case 4: {
                        return (float)constant.shortValue() == constant.floatValue();
                    }
                    case 3: {
                        return (float)constant.byteValue() == constant.floatValue();
                    }
                    case 7: {
                        return (float)constant.longValue() == constant.floatValue();
                    }
                }
                return false;
            }
            case 8: {
                switch (n) {
                    case 2: {
                        return (double)constant.charValue() == constant.doubleValue();
                    }
                    case 8: {
                        return true;
                    }
                    case 9: {
                        return (double)constant.floatValue() == constant.doubleValue();
                    }
                    case 10: {
                        return (double)constant.intValue() == constant.doubleValue();
                    }
                    case 4: {
                        return (double)constant.shortValue() == constant.doubleValue();
                    }
                    case 3: {
                        return (double)constant.byteValue() == constant.doubleValue();
                    }
                    case 7: {
                        return (double)constant.longValue() == constant.doubleValue();
                    }
                }
                return false;
            }
            case 3: {
                switch (n) {
                    case 2: {
                        return constant.charValue() == constant.byteValue();
                    }
                    case 8: {
                        return constant.doubleValue() == (double)constant.byteValue();
                    }
                    case 9: {
                        return constant.floatValue() == (float)constant.byteValue();
                    }
                    case 10: {
                        return constant.intValue() == constant.byteValue();
                    }
                    case 4: {
                        return constant.shortValue() == constant.byteValue();
                    }
                    case 3: {
                        return true;
                    }
                    case 7: {
                        return constant.longValue() == (long)constant.byteValue();
                    }
                }
                return false;
            }
            case 4: {
                switch (n) {
                    case 2: {
                        return constant.charValue() == constant.shortValue();
                    }
                    case 8: {
                        return constant.doubleValue() == (double)constant.shortValue();
                    }
                    case 9: {
                        return constant.floatValue() == (float)constant.shortValue();
                    }
                    case 10: {
                        return constant.intValue() == constant.shortValue();
                    }
                    case 4: {
                        return true;
                    }
                    case 3: {
                        return constant.byteValue() == constant.shortValue();
                    }
                    case 7: {
                        return constant.longValue() == (long)constant.shortValue();
                    }
                }
                return false;
            }
            case 10: {
                switch (n) {
                    case 2: {
                        return constant.charValue() == constant.intValue();
                    }
                    case 8: {
                        return constant.doubleValue() == (double)constant.intValue();
                    }
                    case 9: {
                        return constant.floatValue() == (float)constant.intValue();
                    }
                    case 10: {
                        return true;
                    }
                    case 4: {
                        return constant.shortValue() == constant.intValue();
                    }
                    case 3: {
                        return constant.byteValue() == constant.intValue();
                    }
                    case 7: {
                        return constant.longValue() == (long)constant.intValue();
                    }
                }
                return false;
            }
            case 7: {
                switch (n) {
                    case 2: {
                        return (long)constant.charValue() == constant.longValue();
                    }
                    case 8: {
                        return constant.doubleValue() == (double)constant.longValue();
                    }
                    case 9: {
                        return constant.floatValue() == (float)constant.longValue();
                    }
                    case 10: {
                        return (long)constant.intValue() == constant.longValue();
                    }
                    case 4: {
                        return (long)constant.shortValue() == constant.longValue();
                    }
                    case 3: {
                        return (long)constant.byteValue() == constant.longValue();
                    }
                    case 7: {
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        return flowInfo;
    }

    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo, boolean bl) {
        return this.analyseCode(blockScope, flowContext, flowInfo);
    }

    public final boolean checkCastTypesCompatibility(Scope scope, TypeBinding typeBinding, TypeBinding typeBinding2, Expression expression) {
        boolean bl;
        if (typeBinding == null || typeBinding2 == null) {
            return true;
        }
        boolean bl2 = bl = scope.compilerOptions().sourceLevel >= 0x310000L;
        if (typeBinding.isBaseType()) {
            if (typeBinding2.isBaseType()) {
                if (typeBinding2 == typeBinding) {
                    if (expression != null) {
                        this.constant = expression.constant;
                    }
                    this.tagAsUnnecessaryCast(scope, typeBinding);
                    return true;
                }
                boolean bl3 = false;
                if (typeBinding2.isCompatibleWith(typeBinding) || (bl3 = BaseTypeBinding.isNarrowing(typeBinding.id, typeBinding2.id))) {
                    if (expression != null) {
                        expression.implicitConversion = (typeBinding.id << 4) + typeBinding2.id;
                        if (expression.constant != Constant.NotAConstant) {
                            this.constant = expression.constant.castTo(expression.implicitConversion);
                        }
                    }
                    if (!bl3) {
                        this.tagAsUnnecessaryCast(scope, typeBinding);
                    }
                    return true;
                }
            } else if (bl && scope.environment().computeBoxingType(typeBinding2).isCompatibleWith(typeBinding)) {
                this.tagAsUnnecessaryCast(scope, typeBinding);
                return true;
            }
            return false;
        }
        if (bl && typeBinding2.isBaseType() && scope.environment().computeBoxingType(typeBinding2).isCompatibleWith(typeBinding)) {
            this.tagAsUnnecessaryCast(scope, typeBinding);
            return true;
        }
        switch (typeBinding2.kind()) {
            case 132: {
                if (typeBinding2 == TypeBinding.NULL) {
                    this.tagAsUnnecessaryCast(scope, typeBinding);
                    return true;
                }
                return false;
            }
            case 68: {
                if (typeBinding == typeBinding2) {
                    this.tagAsUnnecessaryCast(scope, typeBinding);
                    return true;
                }
                switch (typeBinding.kind()) {
                    case 68: {
                        TypeBinding typeBinding3 = ((ArrayBinding)typeBinding).elementsType();
                        TypeBinding typeBinding4 = ((ArrayBinding)typeBinding2).elementsType();
                        if (typeBinding4.isBaseType() || typeBinding3.isBaseType()) {
                            if (typeBinding3 == typeBinding4) {
                                this.tagAsNeedCheckCast();
                                return true;
                            }
                            return false;
                        }
                        return this.checkCastTypesCompatibility(scope, typeBinding3, typeBinding4, expression);
                    }
                    case 4100: {
                        TypeBinding typeBinding5 = typeBinding2.findSuperTypeWithSameErasure(typeBinding);
                        if (typeBinding5 == null) {
                            this.checkUnsafeCast(scope, typeBinding, typeBinding2, typeBinding5, true);
                        }
                        return this.checkCastTypesCompatibility(scope, ((TypeVariableBinding)typeBinding).upperBound(), typeBinding2, expression);
                    }
                }
                switch (typeBinding.id) {
                    case 36: 
                    case 37: {
                        this.tagAsNeedCheckCast();
                        return true;
                    }
                    case 1: {
                        this.tagAsUnnecessaryCast(scope, typeBinding);
                        return true;
                    }
                }
                return false;
            }
            case 4100: {
                TypeBinding typeBinding6 = typeBinding2.findSuperTypeWithSameErasure(typeBinding);
                if (typeBinding6 != null) {
                    return this.checkUnsafeCast(scope, typeBinding, typeBinding2, typeBinding6, false);
                }
                return this.checkCastTypesCompatibility(scope, typeBinding, ((TypeVariableBinding)typeBinding2).upperBound(), expression);
            }
            case 516: {
                TypeBinding typeBinding7 = typeBinding2.findSuperTypeWithSameErasure(typeBinding);
                if (typeBinding7 != null) {
                    return this.checkUnsafeCast(scope, typeBinding, typeBinding2, typeBinding7, false);
                }
                return this.checkCastTypesCompatibility(scope, typeBinding, ((WildcardBinding)typeBinding2).bound, expression);
            }
        }
        if (typeBinding2.isInterface()) {
            TypeBinding typeBinding8;
            switch (typeBinding.kind()) {
                case 68: {
                    switch (typeBinding2.id) {
                        case 36: 
                        case 37: {
                            this.tagAsNeedCheckCast();
                            return true;
                        }
                    }
                    return false;
                }
                case 4100: {
                    TypeBinding typeBinding9 = typeBinding2.findSuperTypeWithSameErasure(typeBinding);
                    if (typeBinding9 == null) {
                        this.checkUnsafeCast(scope, typeBinding, typeBinding2, typeBinding9, true);
                    }
                    return this.checkCastTypesCompatibility(scope, ((TypeVariableBinding)typeBinding).upperBound(), typeBinding2, expression);
                }
            }
            if (typeBinding.isInterface()) {
                ReferenceBinding referenceBinding = (ReferenceBinding)typeBinding2;
                TypeBinding typeBinding10 = referenceBinding.findSuperTypeWithSameErasure(typeBinding);
                if (typeBinding10 != null) {
                    return this.checkUnsafeCast(scope, typeBinding, referenceBinding, typeBinding10, false);
                }
                this.tagAsNeedCheckCast();
                typeBinding10 = typeBinding.findSuperTypeWithSameErasure(referenceBinding);
                if (typeBinding10 != null) {
                    return this.checkUnsafeCast(scope, typeBinding, referenceBinding, typeBinding10, true);
                }
                if (bl) {
                    if (referenceBinding.hasIncompatibleSuperType((ReferenceBinding)typeBinding)) {
                        return false;
                    }
                } else {
                    MethodBinding[] methodBindingArray = this.getAllInheritedMethods((ReferenceBinding)typeBinding);
                    MethodBinding[] methodBindingArray2 = this.getAllInheritedMethods((ReferenceBinding)typeBinding2);
                    int n = methodBindingArray2.length;
                    int n2 = 0;
                    int n3 = methodBindingArray.length;
                    while (n2 < n3) {
                        int n4 = 0;
                        while (n4 < n) {
                            if (methodBindingArray[n2].returnType != methodBindingArray2[n4].returnType && CharOperation.equals(methodBindingArray[n2].selector, methodBindingArray2[n4].selector) && methodBindingArray[n2].areParametersEqual(methodBindingArray2[n4])) {
                                return false;
                            }
                            ++n4;
                        }
                        ++n2;
                    }
                }
                return true;
            }
            if (typeBinding.id == 1) {
                this.tagAsUnnecessaryCast(scope, typeBinding);
                return true;
            }
            if (((ReferenceBinding)typeBinding).isFinal() && (typeBinding8 = typeBinding.findSuperTypeWithSameErasure(typeBinding2)) == null) {
                return false;
            }
            if (bl && ((ReferenceBinding)typeBinding).hasIncompatibleSuperType((ReferenceBinding)typeBinding2)) {
                return false;
            }
            this.tagAsNeedCheckCast();
            return true;
        }
        switch (typeBinding.kind()) {
            case 68: {
                if (typeBinding2.id == 1) {
                    this.checkUnsafeCast(scope, typeBinding, typeBinding2, typeBinding2, true);
                    this.tagAsNeedCheckCast();
                    return true;
                }
                return false;
            }
            case 4100: {
                TypeBinding typeBinding11 = typeBinding2.findSuperTypeWithSameErasure(typeBinding);
                if (typeBinding11 == null) {
                    this.checkUnsafeCast(scope, typeBinding, typeBinding2, typeBinding11, true);
                }
                return this.checkCastTypesCompatibility(scope, ((TypeVariableBinding)typeBinding).upperBound(), typeBinding2, expression);
            }
        }
        if (typeBinding.isInterface()) {
            ReferenceBinding referenceBinding = (ReferenceBinding)typeBinding2;
            TypeBinding typeBinding12 = referenceBinding.findSuperTypeWithSameErasure(typeBinding);
            if (referenceBinding.isFinal()) {
                if (typeBinding12 == null) {
                    return false;
                }
                return this.checkUnsafeCast(scope, typeBinding, typeBinding2, typeBinding12, false);
            }
            if (typeBinding12 != null) {
                return this.checkUnsafeCast(scope, typeBinding, typeBinding2, typeBinding12, false);
            }
            this.tagAsNeedCheckCast();
            typeBinding12 = typeBinding.findSuperTypeWithSameErasure(typeBinding2);
            if (typeBinding12 != null) {
                return this.checkUnsafeCast(scope, typeBinding, typeBinding2, typeBinding12, true);
            }
            return !bl || !referenceBinding.hasIncompatibleSuperType((ReferenceBinding)typeBinding);
        }
        TypeBinding typeBinding13 = typeBinding2.findSuperTypeWithSameErasure(typeBinding);
        if (typeBinding13 != null) {
            if (expression != null && typeBinding.id == 11) {
                this.constant = expression.constant;
            }
            return this.checkUnsafeCast(scope, typeBinding, typeBinding2, typeBinding13, false);
        }
        typeBinding13 = typeBinding.findSuperTypeWithSameErasure(typeBinding2);
        if (typeBinding13 != null) {
            this.tagAsNeedCheckCast();
            return this.checkUnsafeCast(scope, typeBinding, typeBinding2, typeBinding13, true);
        }
        return false;
    }

    public void checkNPE(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        LocalVariableBinding localVariableBinding = this.localVariableBinding();
        if (localVariableBinding != null && (localVariableBinding.type.tagBits & 2L) == 0L) {
            if ((this.bits & 0x20000) == 0) {
                flowContext.recordUsingNullReference(blockScope, localVariableBinding, this, 22, flowInfo);
            }
            flowInfo.markAsComparedEqualToNonNull(localVariableBinding);
            if (flowContext.initsOnFinally != null) {
                flowContext.initsOnFinally.markAsComparedEqualToNonNull(localVariableBinding);
            }
        }
    }

    public boolean checkUnsafeCast(Scope scope, TypeBinding typeBinding, TypeBinding typeBinding2, TypeBinding typeBinding3, boolean bl) {
        if (typeBinding3 == typeBinding) {
            if (!bl) {
                this.tagAsUnnecessaryCast(scope, typeBinding);
            }
            return true;
        }
        if (typeBinding3 != null && (typeBinding.isBoundParameterizedType() || typeBinding2.isBoundParameterizedType()) && typeBinding3.isProvablyDistinctFrom(bl ? typeBinding2 : typeBinding, 0)) {
            return false;
        }
        if (!bl) {
            this.tagAsUnnecessaryCast(scope, typeBinding);
        }
        return true;
    }

    public void computeConversion(Scope scope, TypeBinding typeBinding, TypeBinding typeBinding2) {
        int n;
        if (typeBinding == null || typeBinding2 == null) {
            return;
        }
        if (this.implicitConversion != 0) {
            return;
        }
        if (typeBinding != TypeBinding.NULL && typeBinding.isBaseType()) {
            if (!typeBinding2.isBaseType()) {
                TypeBinding typeBinding3 = scope.environment().computeBoxingType(typeBinding2);
                this.implicitConversion = 1024;
                scope.problemReporter().autoboxing(this, typeBinding2, typeBinding);
                typeBinding2 = typeBinding3;
            }
        } else {
            if (typeBinding2 != TypeBinding.NULL && typeBinding2.isBaseType()) {
                TypeBinding typeBinding4 = scope.environment().computeBoxingType(typeBinding);
                if (typeBinding4 == typeBinding) {
                    typeBinding4 = typeBinding2;
                }
                this.implicitConversion = 0x200 | (typeBinding4.id << 4) + typeBinding2.id;
                scope.problemReporter().autoboxing(this, typeBinding2, scope.environment().computeBoxingType(typeBinding4));
                return;
            }
            if (this.constant != Constant.NotAConstant && this.constant.typeID() != 11) {
                this.implicitConversion = 512;
                return;
            }
        }
        if ((n = typeBinding2.id) == Integer.MAX_VALUE) {
            n = typeBinding2.erasure().id == 11 ? 11 : 1;
        }
        int n2 = typeBinding.id;
        switch (n2) {
            case 2: 
            case 3: 
            case 4: {
                this.implicitConversion |= 160 + n;
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                this.implicitConversion |= (n2 << 4) + n;
            }
        }
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream) {
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        this.generateCode(blockScope, codeStream, false);
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream, boolean bl) {
        if (this.constant == Constant.NotAConstant) {
            throw new ShouldNotImplement(Messages.ast_missingCode);
        }
        int n = codeStream.position;
        codeStream.generateConstant(this.constant, this.implicitConversion);
        codeStream.recordPositionsFrom(n, this.sourceStart);
    }

    public void generateOptimizedBoolean(BlockScope blockScope, CodeStream codeStream, BranchLabel branchLabel, BranchLabel branchLabel2, boolean bl) {
        Constant constant = this.optimizedBooleanConstant();
        this.generateCode(blockScope, codeStream, bl && constant == Constant.NotAConstant);
        if (constant != Constant.NotAConstant && constant.typeID() == 5) {
            int n = codeStream.position;
            if (constant.booleanValue()) {
                if (bl && branchLabel2 == null && branchLabel != null) {
                    codeStream.goto_(branchLabel);
                }
            } else if (bl && branchLabel2 != null && branchLabel == null) {
                codeStream.goto_(branchLabel2);
            }
            codeStream.recordPositionsFrom(n, this.sourceStart);
            return;
        }
        int n = codeStream.position;
        if (bl) {
            if (branchLabel2 == null) {
                if (branchLabel != null) {
                    codeStream.ifne(branchLabel);
                }
            } else if (branchLabel == null) {
                codeStream.ifeq(branchLabel2);
            }
        }
        codeStream.updateLastRecordedEndPC(blockScope, n);
    }

    public void generateOptimizedStringConcatenation(BlockScope blockScope, CodeStream codeStream, int n) {
        if (n == 11 && this.constant != Constant.NotAConstant && this.constant.stringValue().length() == 0) {
            return;
        }
        this.generateCode(blockScope, codeStream, true);
        codeStream.invokeStringConcatenationAppendForType(n);
    }

    public void generateOptimizedStringConcatenationCreation(BlockScope blockScope, CodeStream codeStream, int n) {
        codeStream.newStringContatenation();
        codeStream.dup();
        switch (n) {
            case 0: 
            case 1: {
                codeStream.invokeStringConcatenationDefaultConstructor();
                this.generateCode(blockScope, codeStream, true);
                codeStream.invokeStringConcatenationAppendForType(1);
                return;
            }
            case 11: 
            case 12: {
                if (this.constant != Constant.NotAConstant) {
                    String string = this.constant.stringValue();
                    if (string.length() == 0) {
                        codeStream.invokeStringConcatenationDefaultConstructor();
                        return;
                    }
                    codeStream.ldc(string);
                    break;
                }
                this.generateCode(blockScope, codeStream, true);
                codeStream.invokeStringValueOf(1);
                break;
            }
            default: {
                this.generateCode(blockScope, codeStream, true);
                codeStream.invokeStringValueOf(n);
            }
        }
        codeStream.invokeStringConcatenationStringConstructor();
    }

    private MethodBinding[] getAllInheritedMethods(ReferenceBinding referenceBinding) {
        ArrayList arrayList = new ArrayList();
        this.getAllInheritedMethods0(referenceBinding, arrayList);
        return arrayList.toArray(new MethodBinding[arrayList.size()]);
    }

    private void getAllInheritedMethods0(ReferenceBinding referenceBinding, ArrayList arrayList) {
        if (!referenceBinding.isInterface()) {
            return;
        }
        MethodBinding[] methodBindingArray = referenceBinding.methods();
        int n = 0;
        int n2 = methodBindingArray.length;
        while (n < n2) {
            arrayList.add(methodBindingArray[n]);
            ++n;
        }
        ReferenceBinding[] referenceBindingArray = referenceBinding.superInterfaces();
        n2 = 0;
        int n3 = referenceBindingArray.length;
        while (n2 < n3) {
            this.getAllInheritedMethods0(referenceBindingArray[n2], arrayList);
            ++n2;
        }
    }

    public boolean isCompactableOperation() {
        return false;
    }

    public boolean isConstantValueOfTypeAssignableToType(TypeBinding typeBinding, TypeBinding typeBinding2) {
        if (this.constant == Constant.NotAConstant) {
            return false;
        }
        if (typeBinding == typeBinding2) {
            return true;
        }
        if (typeBinding.isBaseType() && typeBinding2.isBaseType() && (typeBinding == TypeBinding.INT || BaseTypeBinding.isWidening(10, typeBinding.id)) && BaseTypeBinding.isNarrowing(typeBinding2.id, 10)) {
            return Expression.isConstantValueRepresentable(this.constant, typeBinding.id, typeBinding2.id);
        }
        return false;
    }

    public boolean isTypeReference() {
        return false;
    }

    public LocalVariableBinding localVariableBinding() {
        return null;
    }

    public void markAsNonNull() {
        this.bits |= 0x20000;
    }

    public int nullStatus(FlowInfo flowInfo) {
        if (this.constant != null && this.constant != Constant.NotAConstant) {
            return -1;
        }
        LocalVariableBinding localVariableBinding = this.localVariableBinding();
        if (localVariableBinding != null) {
            if (flowInfo.isDefinitelyNull(localVariableBinding)) {
                return 1;
            }
            if (flowInfo.isDefinitelyNonNull(localVariableBinding)) {
                return -1;
            }
            return 0;
        }
        return -1;
    }

    public Constant optimizedBooleanConstant() {
        return this.constant;
    }

    public TypeBinding postConversionType(Scope scope) {
        TypeBinding typeBinding = this.resolvedType;
        int n = (this.implicitConversion & 0xFF) >> 4;
        switch (n) {
            case 5: {
                typeBinding = TypeBinding.BOOLEAN;
                break;
            }
            case 3: {
                typeBinding = TypeBinding.BYTE;
                break;
            }
            case 4: {
                typeBinding = TypeBinding.SHORT;
                break;
            }
            case 2: {
                typeBinding = TypeBinding.CHAR;
                break;
            }
            case 10: {
                typeBinding = TypeBinding.INT;
                break;
            }
            case 9: {
                typeBinding = TypeBinding.FLOAT;
                break;
            }
            case 7: {
                typeBinding = TypeBinding.LONG;
                break;
            }
            case 8: {
                typeBinding = TypeBinding.DOUBLE;
            }
        }
        if ((this.implicitConversion & 0x200) != 0) {
            typeBinding = scope.environment().computeBoxingType(typeBinding);
        }
        return typeBinding;
    }

    public StringBuffer print(int n, StringBuffer stringBuffer) {
        Expression.printIndent(n, stringBuffer);
        return this.printExpression(n, stringBuffer);
    }

    public abstract StringBuffer printExpression(int var1, StringBuffer var2);

    public StringBuffer printStatement(int n, StringBuffer stringBuffer) {
        return this.print(n, stringBuffer).append(";");
    }

    public void resolve(BlockScope blockScope) {
        this.resolveType(blockScope);
    }

    public TypeBinding resolveType(BlockScope blockScope) {
        return null;
    }

    public TypeBinding resolveType(ClassScope classScope) {
        return null;
    }

    public TypeBinding resolveTypeExpecting(BlockScope blockScope, TypeBinding typeBinding) {
        this.setExpectedType(typeBinding);
        TypeBinding typeBinding2 = this.resolveType(blockScope);
        if (typeBinding2 == null) {
            return null;
        }
        if (typeBinding2 == typeBinding) {
            return typeBinding2;
        }
        if (!typeBinding2.isCompatibleWith(typeBinding)) {
            if (blockScope.isBoxingCompatibleWith(typeBinding2, typeBinding)) {
                this.computeConversion(blockScope, typeBinding, typeBinding2);
            } else {
                blockScope.problemReporter().typeMismatchError(typeBinding2, typeBinding, this);
                return null;
            }
        }
        return typeBinding2;
    }

    public Object reusableJSRTarget() {
        if (this.constant != Constant.NotAConstant) {
            return this.constant;
        }
        return null;
    }

    public void setExpectedType(TypeBinding typeBinding) {
    }

    public void tagAsNeedCheckCast() {
    }

    public void tagAsUnnecessaryCast(Scope scope, TypeBinding typeBinding) {
    }

    public Expression toTypeReference() {
        return this;
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
    }

    public void traverse(ASTVisitor aSTVisitor, ClassScope classScope) {
    }

    public void traverse(ASTVisitor aSTVisitor, CompilationUnitScope compilationUnitScope) {
    }
}

