package serpro.ppgd.irpf;
import java.util.List;

import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.bens.Bem;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.NI;
import serpro.ppgd.negocio.CPF;
import serpro.ppgd.negocio.Inteiro;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Valor;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorDefault;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorCPF;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNI;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNaoNulo;

public class ItemQuadroOutrosRendimentos extends ObjetoNegocio
{
  private CPF cpfBenefic = new CPF (this, "CPF");
  private Alfa especificacao = new Alfa (this, "Descrição do rendimento", 60);
  private Valor valor = new Valor (this, "Valor do recebimento");
  private Alfa nomeFonte = new Alfa (this, "Nome da fonte pagadora", 60);
  private NI cnpjoucpfdaFonte = new NI (this, "CNPJ da Empresa ou CPF da Fonte");
  private Inteiro indiceDoBem = new Inteiro (this, "Chave/índice do bem; o primeiro é 1");
  private transient DeclaracaoIRPF objDecl;

  public ItemQuadroOutrosRendimentos (final DeclaracaoIRPF objDecl)
  {
    this.objDecl = objDecl;
    getCpfBenefic ().setConteudo (objDecl.getIdentificadorDeclaracao ().getCpf ().asString ());
    // getCnpjEmpresa ().addValidador (new ValidadorNaoNulo ((byte) 3));
    getCnpjEmpresa ().addValidador (new ValidadorNI ((byte) 3));
    // getEspecificacao ().addValidador (new ValidadorNaoNulo ((byte) 3));
    getValor ().addValidador (new ValidadorNaoNulo ((byte) 3));
    getCpfBenefic ().addValidador (new ValidadorCPF ((byte) 3));
    getCpfBenefic ().addValidador (new ValidadorDefault ((byte) 3)
      {
	public RetornoValidacao validarImplementado ()
	{
	  if (isMissingBenefic ())
	    return new RetornoValidacao (tab.msg ("cpf_branco"));
	  /* FIXME: Há algum totalizador que não separe rendimentos do
	     titular dos dependentes?  */
	  if (!isTitular () && !isDependente ())
	    return new RetornoValidacao (tab.msg ("rend_outros_cpf"));
	  return null;
	}
      });
    getIndiceDoBem ().addValidador (new ValidadorDefault ((byte) 3)
      {
	public RetornoValidacao validarImplementado ()
	{
	  int id = getIndiceDoBem ().asInteger ();
	  if (id == 0)
	    return null;

	  String desc = getNomeFonte ().asString ();
	  if (desc.length () == 0)
	    return null;

	  if (id < 0
	      || id > objDecl.getBens ().recuperarLista ().size ())
	    return new RetornoValidacao (tab.msg ("rend_bem_inexiste"));

	  Bem bem = (Bem) objDecl.getBens ().recuperarLista ().get (id - 1);
	  if (bem.getDiscriminacao ().asString ().indexOf (desc) < 0)
	    return new RetornoValidacao (tab.msg ("rend_bem_indice_suspeito"));

	  return null;
	}
      });
  }

  public CPF getCpfBenefic ()
  {
    return cpfBenefic;
  }

  public Alfa getEspecificacao ()
  {
    return especificacao;
  }

  public Valor getValor ()
  {
    return valor;
  }

  public Alfa getNomeFonte ()
  {
    return nomeFonte;
  }

  public NI getCnpjEmpresa ()
  {
    return cnpjoucpfdaFonte;
  }

  public Inteiro getIndiceDoBem ()
  {
    return indiceDoBem;
  }

  public boolean isMissingBenefic (final String cpf)
  {
    return cpf.equals ("") || cpf.equals ("   .   .   -  ");
  }

  public boolean isMissingBenefic ()
  {
    String cpf = getCpfBenefic ().asString ();
    return isMissingBenefic (cpf);
  }

  public boolean isTitular ()
  {
    String cpf = getCpfBenefic ().asString ();
    return (isMissingBenefic (cpf) ||
	    cpf.equals (objDecl.getIdentificadorDeclaracao ().getCpf ().asString ()));
  }

  public boolean isDependente ()
  {
    return (!isTitular ()
	    && (objDecl.getDependentes ().getDependenteByCPF (getCpfBenefic ())
		!= null));
  }

  protected List recuperarListaCamposPendencia ()
  {
    List retorno = super.recuperarListaCamposPendencia ();
    retorno.add (getCnpjEmpresa ());
    retorno.add (getEspecificacao ());
    retorno.add (getValor ());
    retorno.add (getCpfBenefic ());
    retorno.add (getIndiceDoBem ());
    return retorno;
  }
}
