/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.bens;

import java.util.List;
import java.util.Vector;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.tabelas.CadastroTabelasIRPF;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.CEP;
import serpro.ppgd.negocio.CPF;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Inteiro;
import serpro.ppgd.negocio.NI;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Pendencia;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorDefault;
import serpro.ppgd.negocio.Valor;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNI;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNaoNulo;

public class Bem
extends ObjetoNegocio {
    public static final String NOME_CAMPO_VALOR_ANTERIOR = "Situa\u00e7\u00e3o em 31/12/" + ConstantesGlobais.EXERCICIO_ANTERIOR;
    public static final String NOME_CAMPO_VALOR_ATUAL = "Situa\u00e7\u00e3o em 31/12/" + ConstantesGlobais.EXERCICIO;
    private Inteiro AChava = new Inteiro(this, "Chave/\u00edndice (calculada)");
    private Codigo codGrupo = new Codigo(this, "Grupo", CadastroTabelasIRPF.recuperarGrupoBens());
    private Codigo codigo = new Codigo(this, "C\u00f3digo", CadastroTabelasIRPF.recuperarTipoBens());
    private Codigo pais = new Codigo(this, "Localiza\u00e7\u00e3o(Pa\u00eds)", CadastroTabelasIRPF.recuperarPaises());
    private Alfa discriminacao = new Alfa(this, "Discrimina\u00e7\u00e3o", 510);
    private Valor valorExercicioAnterior = new Valor(this, NOME_CAMPO_VALOR_ANTERIOR);
    private Valor valorExercicioAtual = new Valor(this, NOME_CAMPO_VALOR_ATUAL);
    private Alfa logradouro = new Alfa(this, "Logradouro", 40);
    private Alfa numero = new Alfa(this, "N\u00famero", 6);
    private Alfa complemento = new Alfa(this, "N\u00famero", 40);
    private Alfa bairro = new Alfa(this, "Bairro", 40);
    private Codigo uf = new Codigo(this, "UF", CadastroTabelasIRPF.recuperarUFs(1));
    private Codigo municipio = new Codigo(this, "Munic\u00edpio", new Vector());
    private Alfa nomeMunicipio = new Alfa(this, "Munic\u00edpio", 40);
    private Alfa cidade = new Alfa(this, "Cidade", 40);
    private CEP cep = new CEP(this, "CEP");
    private Alfa registrado = new Alfa(this, "Registrado", 1);
    private Alfa matricula = new Alfa(this, "Matr\u00edcula", 40);
    private Valor areaTotal = new Valor(this, "\u00c1rea Total");
    private Alfa unidade = new Alfa(this, "Unidade da \u00c1rea", 1);
    private Alfa nomeCartorio = new Alfa(this, "Nome do Cart\u00f3rio", 60);
    private Data dataAquisicao = new Data(this, "Data de aquisi\u00e7\u00e3o");
    private Alfa IPTU = new Alfa(this, "N\u00famero do IPTU", 30);
    private Alfa Renavan = new Alfa(this, "N\u00famero do RENAVAN", 30);
    private Alfa RegAviaCivil = new Alfa(this, "N\u00famero do Registro na Avia\u00e7\u00e3o Civil", 30);
    private Alfa RegCapPortos = new Alfa(this, "N\u00famero do Registro na Capitania de Portos", 30);
    private Codigo banco = new Codigo(this, "Banco", CadastroTabelasIRPF.recuperarBancos());
    private Alfa agencia = new Alfa(this, "N\u00famero da Ag\u00eancia Banc\u00e1ria", 4);
    private Alfa conta = new Alfa(this, "N\u00famero da Conta Banc\u00e1ria", 20);
    private Alfa contaDV = new Alfa(this, "D\u00edgito Verificador da Conta Banc\u00e1ria", 2);
    private NI CPFCNPJ = new NI(this, "CPF ou CNPJ do Benefici\u00e1rio");
    private CPF CPFTitDep = new CPF(this, "CPF do Titular ou do Dependente ao qual o registro se refere");
    private Alfa CIB = new Alfa(this, "CIB do Im\u00f3vel Rural", 8);
    private Alfa CEI_CNO = new Alfa(this, "CEI/CNO da Constru\u00e7\u00e3o", 12);
    private static final int[] grupo_requer_TD = new int[]{3, 4, 5, 6, 7};
    private static final int[] grupoComCodigo_requer_TD = new int[]{9905, 9906, 9907, 9999};
    public static final String BRASIL = "0";
    public static final String EXTERIOR = "1";

    public static int mapeiaCodigo21para22(int n) {
        switch (n) {
            case 1: {
                return 101;
            }
            case 2: {
                return 102;
            }
            case 3: {
                return 103;
            }
            case 11: {
                return 111;
            }
            case 12: {
                return 112;
            }
            case 13: {
                return 113;
            }
            case 14: {
                return 114;
            }
            case 15: {
                return 115;
            }
            case 16: {
                return 116;
            }
            case 17: {
                return 117;
            }
            case 18: {
                return 118;
            }
            case 19: {
                return 199;
            }
            case 21: {
                return 201;
            }
            case 22: {
                return 202;
            }
            case 23: {
                return 203;
            }
            case 24: {
                return 204;
            }
            case 25: {
                return 205;
            }
            case 26: {
                return 299;
            }
            case 29: {
                return 299;
            }
            case 31: {
                return 301;
            }
            case 32: {
                return 302;
            }
            case 39: {
                return 399;
            }
            case 41: {
                return 401;
            }
            case 45: {
                return 402;
            }
            case 46: {
                return 405;
            }
            case 47: {
                return 404;
            }
            case 49: {
                return 499;
            }
            case 51: {
                return 501;
            }
            case 52: {
                return 502;
            }
            case 53: {
                return 699;
            }
            case 54: {
                return 699;
            }
            case 59: {
                return 599;
            }
            case 61: {
                return 601;
            }
            case 62: {
                return 601;
            }
            case 63: {
                return 610;
            }
            case 64: {
                return 611;
            }
            case 69: {
                return 699;
            }
            case 71: {
                return 701;
            }
            case 72: {
                return 701;
            }
            case 73: {
                return 703;
            }
            case 74: {
                return 705;
            }
            case 79: {
                return 799;
            }
            case 80: {
                return 699;
            }
            case 91: {
                return 9901;
            }
            case 92: {
                return 9902;
            }
            case 93: {
                return 9903;
            }
            case 94: {
                return 9904;
            }
            case 95: {
                return 9905;
            }
            case 96: {
                return 9999;
            }
            case 99: {
                return 9999;
            }
        }
        return 9999;
    }

    public int codigoComGrupo() {
        return this.codGrupo.asInteger() * 100 + this.codigo.asInteger();
    }

    public Bem(final DeclaracaoIRPF declaracaoIRPF) {
        final IdentificadorDeclaracao identificadorDeclaracao = declaracaoIRPF.getIdentificadorDeclaracao();
        this.getCodGrupo().setColunaFiltro(1);
        this.getCodigo().setColunaFiltro(1);
        this.getPais().setColunaFiltro(1);
        this.getCodGrupo().addValidador(new ValidadorNaoNulo(3, this.tab.msg("bem_codigo")));
        this.getCodigo().addValidador(new ValidadorNaoNulo(3, this.tab.msg("bem_codigo")));
        this.getDiscriminacao().addValidador(new ValidadorNaoNulo(3, this.tab.msg("bem_discriminacao")));
        this.getPais().addValidador(new ValidadorNaoNulo(3, this.tab.msg("bem_pais_branco")));
        this.getCPFCNPJ().addValidador(new ValidadorNI(3));
        this.getCPFTitDep().addValidador(new ValidadorDefault(3){

            private boolean requerTD(int n) {
                int n2;
                int n3 = n / 100;
                int[] nArray = grupo_requer_TD;
                int n4 = 0;
                int n5 = nArray.length - 1;
                while (n4 <= n5) {
                    n2 = (n4 + n5) / 2;
                    int n6 = nArray[n2];
                    if (n6 == n3) {
                        return true;
                    }
                    if (n6 < n3) {
                        n4 = n2 + 1;
                        continue;
                    }
                    n5 = n2 - 1;
                }
                int[] nArray2 = grupoComCodigo_requer_TD;
                int n7 = 0;
                n4 = nArray2.length - 1;
                while (n7 <= n4) {
                    n5 = (n7 + n4) / 2;
                    n2 = nArray2[n5];
                    if (n2 == n) {
                        return true;
                    }
                    if (n2 < n) {
                        n7 = n5 + 1;
                        continue;
                    }
                    n4 = n5 - 1;
                }
                return false;
            }

            public RetornoValidacao validarImplementado() {
                CPF cPF = Bem.this.getCPFTitDep();
                boolean bl = this.requerTD(Bem.this.codigoComGrupo());
                if (cPF.asString().trim().length() > 0) {
                    if (!bl) {
                        return new RetornoValidacao(tab.msg("bem_dispensa_td"), 3);
                    }
                    if (identificadorDeclaracao.getCpf().asString().equals(cPF.asString())) {
                        return null;
                    }
                    if (declaracaoIRPF.getDependentes().getDependenteByCPF(cPF) == null) {
                        return new RetornoValidacao(tab.msg("bem_dependente_sem_ficha"), 3);
                    }
                } else if (bl) {
                    return new RetornoValidacao(tab.msg("bem_requer_td"), 3);
                }
                return null;
            }
        });
    }

    public boolean isVazio() {
        for (Informacao informacao : this.recuperarCamposInformacao()) {
            if (informacao.isVazio() || informacao.getNomeCampo().equals("Localiza\u00e7\u00e3o(Pa\u00eds)")) continue;
            return false;
        }
        return true;
    }

    public Inteiro getChave() {
        return this.AChava;
    }

    public Codigo getCodGrupo() {
        return this.codGrupo;
    }

    public Codigo getCodigo() {
        return this.codigo;
    }

    public Alfa getDiscriminacao() {
        return this.discriminacao;
    }

    public Codigo getPais() {
        return this.pais;
    }

    public Valor getValorExercicioAnterior() {
        return this.valorExercicioAnterior;
    }

    public Valor getValorExercicioAtual() {
        return this.valorExercicioAtual;
    }

    public Alfa getLogradouro() {
        return this.logradouro;
    }

    public Alfa getNumero() {
        return this.numero;
    }

    public Alfa getComplemento() {
        return this.complemento;
    }

    public Alfa getBairro() {
        return this.bairro;
    }

    public Codigo getUf() {
        return this.uf;
    }

    public Codigo getMunicipio() {
        return this.municipio;
    }

    public Alfa getNomeMunicipio() {
        return this.nomeMunicipio;
    }

    public Alfa getCidade() {
        return this.cidade;
    }

    public CEP getCep() {
        return this.cep;
    }

    public Alfa getRegistrado() {
        return this.registrado;
    }

    public Alfa getMatricula() {
        return this.matricula;
    }

    public Valor getAreaTotal() {
        return this.areaTotal;
    }

    public Alfa getUnidade() {
        return this.unidade;
    }

    public Alfa getNomeCartorio() {
        return this.nomeCartorio;
    }

    public Data getDataAquisicao() {
        return this.dataAquisicao;
    }

    public Alfa getIPTU() {
        return this.IPTU;
    }

    public Alfa getRenavan() {
        return this.Renavan;
    }

    public Alfa getRegAviaCivil() {
        return this.RegAviaCivil;
    }

    public Alfa getRegCapPortos() {
        return this.RegCapPortos;
    }

    public Codigo getBanco() {
        return this.banco;
    }

    public Alfa getAgencia() {
        return this.agencia;
    }

    public Alfa getConta() {
        return this.conta;
    }

    public Alfa getContaDV() {
        return this.contaDV;
    }

    public NI getCPFCNPJ() {
        return this.CPFCNPJ;
    }

    public CPF getCPFTitDep() {
        return this.CPFTitDep;
    }

    public Alfa getCIB() {
        return this.CIB;
    }

    public Alfa getCEI_CNO() {
        return this.CEI_CNO;
    }

    protected List recuperarListaCamposPendencia() {
        List list = super.recuperarListaCamposPendencia();
        list.add(this.codGrupo);
        list.add(this.codigo);
        list.add(this.pais);
        list.add(this.discriminacao);
        list.add(this.valorExercicioAtual);
        list.add(this.valorExercicioAnterior);
        list.add(this.CPFCNPJ);
        list.add(this.CPFTitDep);
        return list;
    }

    public List verificarPendencias(int n) {
        List list = super.verificarPendencias(n);
        if (this.getValorExercicioAtual().isVazio() && this.getValorExercicioAnterior().isVazio()) {
            Pendencia pendencia = new Pendencia(2, this.getValorExercicioAnterior(), this.getValorExercicioAnterior().getNomeCampo(), this.tab.msg("bem_valor_nao_informado"), n);
            list.add(pendencia);
        }
        return list;
    }
}

