/* RendIsentos - Decompiled by JODE
 * Visit http://jode.sourceforge.net/
 */
package serpro.ppgd.irpf.rendIsentos;
import java.util.Iterator;
import java.util.List;

import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.ColecaoItemQuadroOutrosRendimentos;
import serpro.ppgd.irpf.ItemQuadroOutrosRendimentos;
import serpro.ppgd.irpf.calculos.CalculosRendIsentos;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorDefault;
import serpro.ppgd.negocio.ValidadorImpeditivoDefault;
import serpro.ppgd.negocio.Valor;

public class RendIsentos extends ObjetoNegocio
{
  /* Não encontrado em lib/resources/aliquotas.xml a partir do
     IRPF2021.  */
  public static final String LIMITE_ISENCAO_APOSENTADORIA = "24.751,74";
  private ColecaoItemQuadroOutrosRendimentos bolsaEstudosQuadroAuxiliar; // 01
  private ColecaoItemQuadroOutrosRendimentos residenciaPronatecQuadroAuxiliar; // 02
  private Valor capitalApolices = new Valor (); // 03
  private Valor totalIndenizacoes = new Valor (); // 04
  private ColecaoItemQuadroOutrosRendimentos/*NI*/ indenizacoesQuadroAuxiliar;
  private Valor bensPequenoValorInformado = new Valor (this, ""); // 05i
  private Valor bensPequenoValorTransportado = new Valor (this, ""); // 05t
  private Valor unicoImovelInformado = new Valor (this, ""); // 06i
  private Valor unicoImovelTransportado = new Valor (this, ""); // 06t
  private Valor outrosBensImoveisInformado = new Valor (this, ""); // 07i
  private Valor outrosBensImoveisTransportado = new Valor (this, ""); // 07t
  private Valor moedaEstrangeiraEspecieInformado = new Valor (this, ""); // 08i
  private Valor moedaEstrangeiraEspecieTransportado = new Valor (this, ""); // 08t
  private Valor totalLucroAlienacaoInformado = new Valor ();
  private Valor totalLucroAlienacaoTransportado = new Valor ();
  private Valor totalLucroAlienacao = new Valor (); // 05..08
  private ColecaoItemQuadroOutrosRendimentos lucroRecebidoQuadroAuxiliar; // 09
  private ColecaoItemQuadroOutrosRendimentos parcIsentaAposentadoriaQuadroAuxiliar; // 10
  private ColecaoItemQuadroOutrosRendimentos/*NI*/ pensaoQuadroAuxiliar; // 11 FIXME: 13,IRRF,IRRF13,Prev
  private ColecaoItemQuadroOutrosRendimentos poupancaQuadroAuxiliar; // 12
  private ColecaoItemQuadroOutrosRendimentos rendSocioQuadroAuxiliar; // 13
  private ColecaoItemQuadroOutrosRendimentos/*NI*/ transferenciasQuadroAuxiliar; // 14
  private Valor parcIsentaAtivRural = new Valor (); // 15
  private ColecaoItemQuadroOutrosRendimentos/*NI*/ IRPFAntCompJudQuadroAuxiliar; // 16
  private ColecaoItemQuadroOutrosRendimentos rendAssalMoedaEstrangQuadroAuxiliar; // 17
  private ColecaoItemQuadroOutrosRendimentos incorpReservasCapitalQuadroAuxiliar; // 18
  private ColecaoItemQuadroOutrosRendimentos meacaoDissolucaoQuadroAuxiliar; // 19
  private ColecaoItemQuadroOutrosRendimentos/*NIopt*/ ganhosLiqAcoesQuadroAuxiliar; // 20
  private ColecaoItemQuadroOutrosRendimentos/*NIopt*/ ganhosCapOuroQuadroAuxiliar; // 21
  private Valor recuperacaoPrejuizosBolsaValores = new Valor (); // 22
  private Valor transporteCargas = new Valor (); // 23
  private Valor transportePassageiros = new Valor (); // 24
  private Valor restitIRPFAnt = new Valor (); // 25
  private ColecaoItemQuadroOutrosRendimentos/*NINomOpt*/ outrosQuadroAuxiliar; // 26
  private Valor total = new Valor ();
  private Valor totalTitular = new Valor ();
  private Valor totalDependentes = new Valor ();

  public RendIsentos (final DeclaracaoIRPF objDecl)
  {
    bolsaEstudosQuadroAuxiliar = new ColecaoItemQuadroOutrosRendimentos
      (objDecl, "Bolsas de Estudos");
    residenciaPronatecQuadroAuxiliar = new ColecaoItemQuadroOutrosRendimentos
      (objDecl, "Bolsas de residência médica ou Pronatec");
    indenizacoesQuadroAuxiliar = new ColecaoItemQuadroOutrosRendimentos
      (objDecl, "Indenizações trabalhistas");
    lucroRecebidoQuadroAuxiliar = new ColecaoItemQuadroOutrosRendimentos
      (objDecl, "Lucros e Dividendos");
    parcIsentaAposentadoriaQuadroAuxiliar = new ColecaoItemQuadroOutrosRendimentos
      (objDecl, "Parcela isenta da aposentadoria");
    pensaoQuadroAuxiliar = new ColecaoItemQuadroOutrosRendimentos
      (objDecl, "Pensão, aposentadoria");
    poupancaQuadroAuxiliar = new ColecaoItemQuadroOutrosRendimentos
      (objDecl, "Cadernetas de Poupança e Letras Hipotecárias");
    rendSocioQuadroAuxiliar = new ColecaoItemQuadroOutrosRendimentos
      (objDecl, "Sócio ou titular de empresa simples");
    transferenciasQuadroAuxiliar = new ColecaoItemQuadroOutrosRendimentos
      (objDecl, "Doaçoes e heranças");
    IRPFAntCompJudQuadroAuxiliar = new ColecaoItemQuadroOutrosRendimentos
      (objDecl, "Imposto de anos anteriores compensado judicialmente");
    rendAssalMoedaEstrangQuadroAuxiliar = new ColecaoItemQuadroOutrosRendimentos
      (objDecl, "75% do rendimento assalariado em moeda estrangeira");
    incorpReservasCapitalQuadroAuxiliar = new ColecaoItemQuadroOutrosRendimentos
      (objDecl, "Incorporação de reservas de capital / bonificações em ações");
    meacaoDissolucaoQuadroAuxiliar = new ColecaoItemQuadroOutrosRendimentos
      (objDecl, "Transferência patrimonial por meação e divórcio");
    ganhosLiqAcoesQuadroAuxiliar = new ColecaoItemQuadroOutrosRendimentos
      (objDecl, "Ganhos líquidos de ações");
    ganhosCapOuroQuadroAuxiliar = new ColecaoItemQuadroOutrosRendimentos
      (objDecl, "Ganhos líquidos em operações com ouro");
    outrosQuadroAuxiliar = new ColecaoItemQuadroOutrosRendimentos
      (objDecl, "Outros rendimentos isentos");
    getTotal ().setReadOnly (true);
    getTotalTitular ().setReadOnly (true);
    getTotalDependentes ().setReadOnly (true);
    getParcIsentaAtivRural ().setReadOnly (true);
    getLucroRecebido ().setReadOnly (true);
    getBensPequenoValorTransportado ().setHabilitado (false);
    getUnicoImovelTransportado ().setHabilitado (false);
    getOutrosBensImoveisTransportado ().setHabilitado (false);
    getMoedaEstrangeiraEspecieTransportado ().setHabilitado (false);
    getTotalInformado ().setHabilitado (false);
    getTotalTransportado ().setHabilitado (false);
    getParcIsentaAposentadoria ().addValidador (new ValidadorImpeditivoDefault (tab.msg ("rendisentos_aposentadoria_limite", new String[] { LIMITE_ISENCAO_APOSENTADORIA }))
    {
      public RetornoValidacao validarImplementado ()
      {
	Valor proxConteudo = new Valor ((String) getProximoConteudo ());
	if (proxConteudo.comparacao (">", LIMITE_ISENCAO_APOSENTADORIA))
	  {
	    setTipoExibicao (0);
	    setSeveridade ((byte) 5);
	    return new RetornoValidacao (tab.msg ("rendisentos_aposentadoria_limite", new String[] { LIMITE_ISENCAO_APOSENTADORIA }));
	  }
	return null;
      }

      public void acaoOk ()
      {
	/* empty */
      }

      public void acaoCancelar ()
      {
	/* empty */
      }

      public String getTituloPopup ()
      {
	return getParcIsentaAposentadoria ().getNomeCampo ();
      }
    });
    getLucroRecebido ().addValidador (new ValidadorDefault ((byte) 2)
    {
      public RetornoValidacao validarImplementado ()
      {
	Iterator it = lucroRecebidoQuadroAuxiliar.recuperarLista ().iterator ();
	while (it.hasNext ())
	  {
	    ItemQuadroOutrosRendimentos item = (ItemQuadroOutrosRendimentos) it.next ();
	    if (item.getNomeFonte ().isVazio ())
	      return new RetornoValidacao (tab.msg ("nome_fonte_pagadora_ausente"), (byte) 2);
	  }
	return null;
      }
    });
    setFicha ("Rendimentos Isentos e N\u00e3o-Tribut\u00e1veis");
  }

  public void addObservador (CalculosRendIsentos calculosRendIsentos)
  {
    bolsaEstudosQuadroAuxiliar.getTotais ().addObservador (calculosRendIsentos);
    residenciaPronatecQuadroAuxiliar.getTotais ().addObservador (calculosRendIsentos);
    capitalApolices.addObservador (calculosRendIsentos);
    indenizacoesQuadroAuxiliar.getTotais ().addObservador (calculosRendIsentos);
    bensPequenoValorInformado.addObservador (calculosRendIsentos);
    bensPequenoValorTransportado.addObservador (calculosRendIsentos);
    unicoImovelInformado.addObservador (calculosRendIsentos);
    unicoImovelTransportado.addObservador (calculosRendIsentos);
    outrosBensImoveisInformado.addObservador (calculosRendIsentos);
    outrosBensImoveisTransportado.addObservador (calculosRendIsentos);
    moedaEstrangeiraEspecieInformado.addObservador (calculosRendIsentos);
    moedaEstrangeiraEspecieTransportado.addObservador (calculosRendIsentos);
    totalLucroAlienacao.addObservador (calculosRendIsentos);
    lucroRecebidoQuadroAuxiliar.getTotais ().addObservador (calculosRendIsentos);
    parcIsentaAtivRural.addObservador (calculosRendIsentos);
    parcIsentaAposentadoriaQuadroAuxiliar.getTotais ().addObservador (calculosRendIsentos);
    pensaoQuadroAuxiliar.getTotais ().addObservador (calculosRendIsentos);
    poupancaQuadroAuxiliar.getTotais ().addObservador (calculosRendIsentos);
    rendSocioQuadroAuxiliar.getTotais ().addObservador (calculosRendIsentos);
    transferenciasQuadroAuxiliar.getTotais ().addObservador (calculosRendIsentos);
    parcIsentaAtivRural.addObservador (calculosRendIsentos);
    IRPFAntCompJudQuadroAuxiliar.getTotais ().addObservador (calculosRendIsentos);
    rendAssalMoedaEstrangQuadroAuxiliar.getTotais ().addObservador (calculosRendIsentos);
    incorpReservasCapitalQuadroAuxiliar.getTotais ().addObservador (calculosRendIsentos);
    meacaoDissolucaoQuadroAuxiliar.getTotais ().addObservador (calculosRendIsentos);
    ganhosLiqAcoesQuadroAuxiliar.getTotais ().addObservador (calculosRendIsentos);
    ganhosCapOuroQuadroAuxiliar.getTotais ().addObservador (calculosRendIsentos);
    recuperacaoPrejuizosBolsaValores.addObservador (calculosRendIsentos);
    transporteCargas.addObservador (calculosRendIsentos);
    transportePassageiros.addObservador (calculosRendIsentos);
    restitIRPFAnt.addObservador (calculosRendIsentos);
    outrosQuadroAuxiliar.getTotais ().addObservador (calculosRendIsentos);
  }

  public ColecaoItemQuadroOutrosRendimentos getBolsaEstudosQuadroAuxiliar ()
  {
    return bolsaEstudosQuadroAuxiliar;
  }

  public Valor getBolsaEstudos ()
  {
    return getBolsaEstudosQuadroAuxiliar ().getTotais ();
  }

  public ColecaoItemQuadroOutrosRendimentos getResidenciaPronatecQuadroAuxiliar ()
  {
    return residenciaPronatecQuadroAuxiliar;
  }

  public Valor getResidenciaPronatec ()
  {
    return getResidenciaPronatecQuadroAuxiliar ().getTotais ();
  }

  public Valor getCapitalApolices ()
  {
    return capitalApolices;
  }

  public ColecaoItemQuadroOutrosRendimentos/*NI*/ getIndenizacoesQuadroAuxiliar ()
  {
    return indenizacoesQuadroAuxiliar;
  }

  public Valor getIndenizacoes ()
  {
    return getIndenizacoesQuadroAuxiliar ().getTotais ();
  }

  public Valor getBensPequenoValorInformado ()
  {
    return bensPequenoValorInformado;
  }

  public Valor getBensPequenoValorTransportado ()
  {
    return bensPequenoValorTransportado;
  }

  public Valor getUnicoImovelInformado ()
  {
    return unicoImovelInformado;
  }

  public Valor getUnicoImovelTransportado ()
  {
    return unicoImovelTransportado;
  }

  public Valor getOutrosBensImoveisInformado ()
  {
    return outrosBensImoveisInformado;
  }

  public Valor getOutrosBensImoveisTransportado ()
  {
    return outrosBensImoveisTransportado;
  }

  public Valor getMoedaEstrangeiraEspecieInformado ()
  {
    return moedaEstrangeiraEspecieInformado;
  }

  public Valor getMoedaEstrangeiraEspecieTransportado ()
  {
    return moedaEstrangeiraEspecieTransportado;
  }

  public Valor getTotalInformado ()
  {
    return totalLucroAlienacaoInformado;
  }

  public Valor getTotalTransportado ()
  {
    return totalLucroAlienacaoTransportado;
  }

  public Valor getLucroAlienacao ()
  {
    return totalLucroAlienacao;
  }

  public ColecaoItemQuadroOutrosRendimentos getLucroRecebidoQuadroAuxiliar ()
  {
    return lucroRecebidoQuadroAuxiliar;
  }

  public Valor getLucroRecebido ()
  {
    return getLucroRecebidoQuadroAuxiliar ().getTotais ();
  }

  public ColecaoItemQuadroOutrosRendimentos getParcIsentaAposentadoriaQuadroAuxiliar ()
  {
    return parcIsentaAposentadoriaQuadroAuxiliar;
  }

  public Valor getParcIsentaAposentadoria ()
  {
    return getParcIsentaAposentadoriaQuadroAuxiliar ().getTotais ();
  }

  public ColecaoItemQuadroOutrosRendimentos/*NI*/ getPensaoQuadroAuxiliar ()
  {
    return pensaoQuadroAuxiliar;
  }

  public Valor getPensao ()
  {
    return getPensaoQuadroAuxiliar ().getTotais ();
  }

  public ColecaoItemQuadroOutrosRendimentos getPoupancaQuadroAuxiliar ()
  {
    return poupancaQuadroAuxiliar;
  }

  public Valor getPoupanca ()
  {
    return getPoupancaQuadroAuxiliar ().getTotais ();
  }

  public ColecaoItemQuadroOutrosRendimentos getRendSocioQuadroAuxiliar ()
  {
    return rendSocioQuadroAuxiliar;
  }

  public Valor getRendSocio ()
  {
    return getRendSocioQuadroAuxiliar ().getTotais ();
  }

  public ColecaoItemQuadroOutrosRendimentos/*NI*/ getTransferenciasQuadroAuxiliar ()
  {
    return transferenciasQuadroAuxiliar;
  }

  public Valor getTransferencias ()
  {
    return getTransferenciasQuadroAuxiliar ().getTotais ();
  }

  public Valor getParcIsentaAtivRural ()
  {
    return parcIsentaAtivRural;
  }

  public ColecaoItemQuadroOutrosRendimentos/*NI*/ getIRPFAntCompJudQuadroAuxiliar ()
  {
    return IRPFAntCompJudQuadroAuxiliar;
  }

  public Valor getIRPFAntCompJud ()
  {
    return getIRPFAntCompJudQuadroAuxiliar ().getTotais ();
  }

  public ColecaoItemQuadroOutrosRendimentos getRendAssalMoedaEstrangQuadroAuxiliar ()
  {
    return rendAssalMoedaEstrangQuadroAuxiliar;
  }

  public Valor getRendAssalMoedaEstrang ()
  {
    return getRendAssalMoedaEstrangQuadroAuxiliar ().getTotais ();
  }

  public ColecaoItemQuadroOutrosRendimentos getIncorpReservasCapitalQuadroAuxiliar ()
  {
    return incorpReservasCapitalQuadroAuxiliar;
  }

  public Valor getIncorpReservasCapital ()
  {
    return getIncorpReservasCapitalQuadroAuxiliar ().getTotais ();
  }

  public ColecaoItemQuadroOutrosRendimentos getMeacaoDissolucaoQuadroAuxiliar ()
  {
    return meacaoDissolucaoQuadroAuxiliar;
  }

  public Valor getMeacaoDissolucao ()
  {
    return getMeacaoDissolucaoQuadroAuxiliar ().getTotais ();
  }

  public ColecaoItemQuadroOutrosRendimentos/*NIopt*/ getGanhosLiqAcoesQuadroAuxiliar ()
  {
    return ganhosLiqAcoesQuadroAuxiliar;
  }

  public Valor getGanhosLiqAcoes ()
  {
    return getGanhosLiqAcoesQuadroAuxiliar ().getTotais ();
  }

  public ColecaoItemQuadroOutrosRendimentos/*NIopt*/ getGanhosCapOuroQuadroAuxiliar ()
  {
    return ganhosCapOuroQuadroAuxiliar;
  }

  public Valor getGanhosCapOuro ()
  {
    return getGanhosCapOuroQuadroAuxiliar ().getTotais ();
  }

  public Valor getRecuperacaoPrejuizosBolsaValores ()
  {
    return recuperacaoPrejuizosBolsaValores;
  }

  public Valor getTransporteCargas ()
  {
    return transporteCargas;
  }

  public Valor getTransportePassageiros ()
  {
    return transportePassageiros;
  }

  public Valor getRestitIRPFAnt ()
  {
    return restitIRPFAnt;
  }

  public ColecaoItemQuadroOutrosRendimentos/*NINomOpt*/ getOutrosQuadroAuxiliar ()
  {
    return outrosQuadroAuxiliar;
  }

  public Valor getOutros ()
  {
    return getOutrosQuadroAuxiliar ().getTotais ();
  }

  public Valor getTotal ()
  {
    return total;
  }

  public Valor getTotalTitular ()
  {
    return totalTitular;
  }

  public Valor getTotalDependentes ()
  {
    return totalDependentes;
  }

  protected List recuperarListaCamposPendencia ()
  {
    List lista = super.recuperarListaCamposPendencia ();
    lista.add (getLucroRecebido ());
    return lista;
  }

  public Valor recuperarTotalTitularExcetoAtividadeRuraleGC ()
  {
    return getTotalTitular ()
      .operacao ('-', recuperarSubTotalRendIsentoTransportado ())
      .operacao ('-', getTotalInformado ());
  }

  public Valor recuperarSubTotalRendIsentoTransportado ()
  {
    Valor result = new Valor ();
    result.append ('+', getParcIsentaAtivRural ());
    result.append ('+', getTotalTransportado ());
    return result;
  }

  public Valor recuperarTotalLucrosDividendosTit ()
  {
    return getLucroRecebidoQuadroAuxiliar ().getTotaisTitular ();
  }

  public Valor recuperarTotalLucrosDividendosDep ()
  {
    return getLucroRecebidoQuadroAuxiliar ().getTotaisDependentes ();
  }
}
