/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.negocio.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Properties;
import serpro.ppgd.negocio.util.FabricaUtilitarios;
import serpro.ppgd.negocio.util.LogPPGD;

public class UtilitariosArquivo {
    public static Properties loadProperties(String string, Class clazz) {
        InputStream inputStream = clazz.getResourceAsStream(string);
        Properties properties = new Properties();
        try {
            if (inputStream != null) {
                properties.load(inputStream);
                LogPPGD.debug("Propriedades carregadas do arquivo: " + string);
            } else {
                LogPPGD.aviso("Nao foi poss\u00edvel localizar o arquivo: " + string);
            }
        }
        catch (IOException iOException) {
            LogPPGD.aviso("N\u00e3o foi poss\u00edvel carregar arquivo: " + string);
            LogPPGD.erro("Erro ao carregar arquivo.");
            iOException.printStackTrace();
        }
        return properties;
    }

    public static InputStream getResource(String string, Class clazz) {
        InputStream inputStream = clazz.getResourceAsStream(string);
        if (inputStream == null) {
            LogPPGD.aviso("Retornando um stream NULO para o arquivo: " + string);
        }
        return inputStream;
    }

    public static void copiaArquivoDoJar(String string, String string2, Class clazz) {
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(UtilitariosArquivo.getResource(string, clazz));
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            int n = ((InputStream)bufferedInputStream).read();
            while (n != -1) {
                ((OutputStream)bufferedOutputStream).write(n);
                n = ((InputStream)bufferedInputStream).read();
            }
            ((OutputStream)bufferedOutputStream).flush();
            ((OutputStream)bufferedOutputStream).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            LogPPGD.erro("Arquivo de saida n\u00e3o encontrado.");
        }
        catch (IOException iOException) {
            LogPPGD.erro("Erro na escrita do arquivo.");
        }
    }

    public static String extraiNomeArquivo(String string) {
        return new File(string).getName();
    }

    public static String extraiPath(String string) {
        int n;
        if (string.startsWith("file:")) {
            string = string.substring(5);
        }
        if ((n = string.indexOf(33)) != -1) {
            string = string.substring(0, n);
        }
        return string.substring(0, string.lastIndexOf(UtilitariosArquivo.extraiNomeArquivo(string)));
    }

    public static String extraiNomeAquivoSemExtensao(String string) {
        return string.substring(0, string.lastIndexOf("."));
    }

    public static String extraiExtensaoAquivo(String string) {
        return string.substring(string.lastIndexOf(".", string.length()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copiaArquivo(String string, String string2) {
        try {
            File file = null;
            file = new File(string);
            int n = (int)file.length();
            char[] cArray = new char[n];
            File file2 = new File(string2);
            if (!file2.exists()) {
                file2.mkdirs();
            }
            if (file.getParent().equals(file2.getPath())) {
                return;
            }
            FileWriter fileWriter = null;
            FileReader fileReader = null;
            BufferedReader bufferedReader = null;
            BufferedWriter bufferedWriter = null;
            try {
                string2 = string2 + "/" + file.getName();
                fileReader = new FileReader(string);
                fileWriter = new FileWriter(string2);
                bufferedReader = new BufferedReader(fileReader);
                bufferedWriter = new BufferedWriter(fileWriter);
                while (bufferedReader.read(cArray, 0, n) != -1) {
                    bufferedWriter.write(cArray, 0, n);
                }
            }
            finally {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static boolean ehDisquete(File file) {
        return file.getPath().toUpperCase().indexOf("A:") != -1;
    }

    public static void apagaDiretorio(File file) throws IOException {
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isDirectory()) {
                UtilitariosArquivo.apagaDiretorio(fileArray[i]);
                continue;
            }
            fileArray[i].delete();
        }
        file.delete();
    }

    public static File getRECCorrespondente(File file) {
        File file2 = null;
        String string = file.getPath();
        int n = string.lastIndexOf(File.separator);
        String string2 = string.substring(0, string.length() - 4) + ".REC";
        String string3 = string.substring(0, 11);
        File file3 = new File(string2);
        if (!file3.exists()) {
            string2 = string.substring(0, n + 1);
            string2 = string2 + string3.substring(0, 8);
            string2 = string2 + ".REC";
            file3 = new File(string2);
        }
        if (file3.exists()) {
            file2 = file3;
        }
        return file2;
    }

    public static File getDisquete() {
        File[] fileArray = File.listRoots();
        for (int i = 0; i < fileArray.length; ++i) {
            if (!UtilitariosArquivo.ehDisquete(fileArray[i])) continue;
            return fileArray[i];
        }
        return null;
    }

    public static void apagaDisquete() {
        try {
            File[] fileArray = UtilitariosArquivo.getDisquete().listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].isDirectory()) {
                    UtilitariosArquivo.apagaDiretorio(fileArray[i]);
                    continue;
                }
                fileArray[i].delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static URL localizaArquivoEmClasspath(String string) {
        return UtilitariosArquivo.class.getResource(string);
    }

    public static String getPathAplicacao() {
        String string;
        URL uRL = FabricaUtilitarios.class.getResource("/aplicacao.properties");
        if (uRL == null) {
            string = System.getProperty("user.dir");
        } else {
            URI uRI = null;
            try {
                uRI = new URI(uRL.getFile());
            }
            catch (URISyntaxException uRISyntaxException) {
                string = System.getProperty("user.dir");
            }
            String string2 = uRI.getPath();
            if (string2 == null) {
                string2 = uRL.getPath();
            }
            string = UtilitariosArquivo.extraiPath(string2);
        }
        return string;
    }

    public static String getPathDados() {
        String string = FabricaUtilitarios.getProperties().getProperty("aplicacao.diretorio.dados");
        if (string.charAt(string.length() - 1) != '/') {
            string = string + "/";
        }
        string = string + "aplicacao/dados";
        return string;
    }

    public static String getPathImpressao() {
        return UtilitariosArquivo.getPathAplicacao() + "impressao";
    }

    public static String getPathGravadas() {
        return UtilitariosArquivo.getPathAplicacao() + "gravadas";
    }

    public static String getPathTransmitidas() {
        return UtilitariosArquivo.getPathAplicacao() + "transmitidas";
    }

    public static String getPathLib() {
        return UtilitariosArquivo.getPathAplicacao() + "lib";
    }

    public static void main(String[] stringArray) {
        UtilitariosArquivo.apagaDisquete();
    }
}

