/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.negocio;

import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.util.LogPPGD;

public class Inteiro
extends Informacao {
    public static final String PROP_LIMITE_MIN_MAX = "LIMITES";
    private int conteudoInteiro = 0;
    private int limiteMinimo = -1;
    private int limiteMaximo = -1;

    public Inteiro() {
        this(null, "");
    }

    public Inteiro(String string) {
        this(null, string);
    }

    public Inteiro(ObjetoNegocio objetoNegocio, String string) {
        super(objetoNegocio, string);
    }

    public int getLimiteMaximo() {
        return this.limiteMaximo;
    }

    public void setLimiteMaximo(int n) {
        this.limiteMaximo = n;
        this.getObservadores().firePropertyChange(PROP_LIMITE_MIN_MAX, false, true);
    }

    public int getLimiteMinimo() {
        return this.limiteMinimo;
    }

    public void setLimiteMinimo(int n) {
        this.limiteMinimo = n;
        this.getObservadores().firePropertyChange(PROP_LIMITE_MIN_MAX, false, true);
    }

    public void setConteudo(int n) {
        LogPPGD.debug("Atribui\u00e7\u00e3o: " + this.getNomeCampo() + " = " + String.valueOf(n));
        String string = this.asString();
        this.clearRetornosValidacoes();
        this.conteudoInteiro = n;
        this.disparaObservadores(string);
    }

    @Override
    public void setConteudo(String string) {
        if (string.trim().equals("")) {
            this.setConteudo(0);
        } else {
            int n = 0;
            try {
                n = Integer.parseInt(string);
            }
            catch (Exception exception) {
                n = 0;
            }
            this.setConteudo(n);
        }
    }

    @Override
    public String getConteudoFormatado() {
        return this.asString();
    }

    @Override
    public boolean isVazio() {
        return this.asInteger() == 0;
    }

    @Override
    public int compareTo(Object object) {
        Inteiro inteiro = (Inteiro)object;
        if (this.conteudoInteiro < inteiro.asInteger()) {
            return -1;
        }
        if (this.conteudoInteiro == inteiro.asInteger()) {
            return 0;
        }
        return 1;
    }

    @Override
    public String asString() {
        return String.valueOf(this.conteudoInteiro);
    }

    public int asInteger() {
        return this.conteudoInteiro;
    }

    public static void main(String[] stringArray) {
        System.out.println(new Inteiro().conteudoInteiro);
    }

    @Override
    public void clear() {
        this.setConteudo(0);
    }

    public int getConteudoInteiro() {
        return this.conteudoInteiro;
    }

    public void setConteudoInteiro(int n) {
        this.conteudoInteiro = n;
    }
}

