/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.rendpjexigibilidade;

import java.util.List;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.NI;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Pendencia;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.Valor;
import serpro.ppgd.negocio.util.Validador;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNaoNulo;

public class RendPJComExigibilidadeTitular
extends ObjetoNegocio {
    public static final String NOME_NI_FONTE_PAGADORA = "NI da Fonte Pagadora";
    protected transient IdentificadorDeclaracao identificadorDeclaracao = null;
    protected Alfa nomeFontePagadora = new Alfa(this, "Nome da Fonte Pagadora");
    protected NI NIFontePagadora = new NI(this, "NI da Fonte Pagadora");
    protected Valor rendExigSuspensa = new Valor(this, "Rend. com Exigibilidade Suspensa");
    protected Valor depositoJudicial = new Valor(this, "Dep\u00f3sito Judicial");

    public RendPJComExigibilidadeTitular(IdentificadorDeclaracao identificadorDeclaracao) {
        this.identificadorDeclaracao = identificadorDeclaracao;
        this.addValidadores();
    }

    public void addValidadores() {
        ValidadorNaoNulo validadorNaoNulo = new ValidadorNaoNulo(3){

            @Override
            public RetornoValidacao validarImplementado() {
                RetornoValidacao retornoValidacao = Validador.validarNI(RendPJComExigibilidadeTitular.this.getNIFontePagadora().asString());
                if (retornoValidacao == null && RendPJComExigibilidadeTitular.this.getNomeFontePagadora().isVazio()) {
                    this.setSeveridade((byte)2);
                    return new RetornoValidacao(tab.msg("nome_fonte_pagadora_ausente"), 2);
                }
                if (retornoValidacao != null && RendPJComExigibilidadeTitular.this.getNomeFontePagadora().isVazio()) {
                    this.setSeveridade((byte)3);
                    return new RetornoValidacao(tab.msg("nome_fonte_pagadora"), 3);
                }
                return null;
            }
        };
        this.getNomeFontePagadora().addValidador(validadorNaoNulo);
        ValidadorNaoNulo validadorNaoNulo2 = new ValidadorNaoNulo(3){

            @Override
            public RetornoValidacao validarImplementado() {
                RetornoValidacao retornoValidacao = Validador.validarNI(RendPJComExigibilidadeTitular.this.getNIFontePagadora().asString());
                if (RendPJComExigibilidadeTitular.this.getNIFontePagadora().asString().equals(RendPJComExigibilidadeTitular.this.identificadorDeclaracao.getCpf().asString())) {
                    this.setSeveridade((byte)3);
                    return new RetornoValidacao(tab.msg("ni_fonte_pagadora_igual_declarante"), 3);
                }
                return null;
            }
        };
        this.getNIFontePagadora().addValidador(validadorNaoNulo2);
    }

    public void addObservador(Observador observador) {
        this.rendExigSuspensa.addObservador(observador);
        this.depositoJudicial.addObservador(observador);
        this.NIFontePagadora.addObservador(observador);
    }

    public void removeObservador(Observador observador) {
        this.rendExigSuspensa.removeObservador(observador);
        this.depositoJudicial.removeObservador(observador);
        this.NIFontePagadora.removeObservador(observador);
    }

    public Valor getDepositoJudicial() {
        return this.depositoJudicial;
    }

    public NI getNIFontePagadora() {
        return this.NIFontePagadora;
    }

    public Alfa getNomeFontePagadora() {
        return this.nomeFontePagadora;
    }

    public Valor getRendExigSuspensa() {
        return this.rendExigSuspensa;
    }

    public Pendencia verificaValores(int n) {
        Pendencia pendencia = null;
        if (this.getDepositoJudicial().isVazio() && this.getRendExigSuspensa().isVazio()) {
            pendencia = new Pendencia(2, this.getRendExigSuspensa(), "Valores RendPJ", this.tab.msg("rendpj_faltam_valores"), n);
        }
        return pendencia;
    }

    @Override
    public List verificarPendencias(int n) {
        List list = super.verificarPendencias(n);
        Pendencia pendencia = this.verificaValores(n);
        if (pendencia != null) {
            list.add(pendencia);
        }
        return list;
    }

    @Override
    protected List recuperarListaCamposPendencia() {
        List list = this.recuperarCamposInformacao();
        return list;
    }

    @Override
    public boolean isVazio() {
        for (Informacao informacao : this.recuperarCamposInformacao()) {
            if (informacao.isVazio()) continue;
            return false;
        }
        return true;
    }
}

