/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.calculos;

import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.rendpjexigibilidade.ColecaoRendPJComExigibilidadeTitular;
import serpro.ppgd.irpf.rendpjexigibilidade.RendPJComExigibilidadeTitular;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Valor;

public class CalculosRendPJComExigibilidadeTitular
extends Observador {
    private ColecaoRendPJComExigibilidadeTitular colecaoRendPJ = null;
    private DeclaracaoIRPF declaracaoIRPF;

    public CalculosRendPJComExigibilidadeTitular(ColecaoRendPJComExigibilidadeTitular colecaoRendPJComExigibilidadeTitular, DeclaracaoIRPF declaracaoIRPF) {
        this.colecaoRendPJ = colecaoRendPJComExigibilidadeTitular;
        this.declaracaoIRPF = declaracaoIRPF;
    }

    @Override
    public void notifica(Object object, String string, Object object2, Object object3) {
        if (string != null) {
            if (string.equals("ObjetoInserido")) {
                RendPJComExigibilidadeTitular rendPJComExigibilidadeTitular = (RendPJComExigibilidadeTitular)object3;
                rendPJComExigibilidadeTitular.addObservador(this);
                this.calculaTotaisRendExigSuspensa();
                this.calculaTotaisDepositoJudicial();
            } else if (string.equals("ObjetoRemovido")) {
                RendPJComExigibilidadeTitular rendPJComExigibilidadeTitular = (RendPJComExigibilidadeTitular)object3;
                rendPJComExigibilidadeTitular.removeObservador(this);
                this.calculaTotaisRendExigSuspensa();
                this.calculaTotaisDepositoJudicial();
            } else if (string.equals("Rend. com Exigibilidade Suspensa")) {
                this.calculaTotaisRendExigSuspensa();
            } else if (string.equals("Dep\u00f3sito Judicial")) {
                this.calculaTotaisDepositoJudicial();
            }
        }
    }

    private void calculaTotaisDepositoJudicial() {
        Valor valor = new Valor();
        for (RendPJComExigibilidadeTitular rendPJComExigibilidadeTitular : this.colecaoRendPJ.recuperarLista()) {
            valor.append('+', rendPJComExigibilidadeTitular.getDepositoJudicial());
        }
        this.colecaoRendPJ.getTotaisDepositoJudicial().setConteudo(valor);
    }

    private void calculaTotaisRendExigSuspensa() {
        Valor valor = new Valor();
        for (RendPJComExigibilidadeTitular rendPJComExigibilidadeTitular : this.colecaoRendPJ.recuperarLista()) {
            valor.append('+', rendPJComExigibilidadeTitular.getRendExigSuspensa());
        }
        this.colecaoRendPJ.getTotaisRendRecebidoPJ().setConteudo(valor);
    }
}

