/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.gui;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import serpro.ppgd.gui.BlinkBorder;
import serpro.ppgd.gui.ConstantesGlobaisGUI;
import serpro.ppgd.gui.EditCampo;
import serpro.ppgd.gui.editors.PPGDCheckBox;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ItemOpcao;
import serpro.ppgd.negocio.Opcao;
import serpro.ppgd.negocio.ValidadorImpeditivoDefault;
import serpro.ppgd.negocio.util.LogPPGD;

public class EditOpcao
extends EditCampo {
    private static Opcao vazio = new Opcao();
    private Box box;
    private int orientacaoTexto = 0;
    private static final Color DEFAULT_FOREGROUND = new JCheckBox().getForeground();
    private static final Color DISABLED_FOREGROUND = ConstantesGlobaisGUI.COR_CINZA_CLARO;
    private boolean bloqueiaItemListener = false;
    private Map opcoes;
    private LinkedList listaOrdenada = new LinkedList();
    private BlinkBorder borda;

    public EditOpcao() {
        super(vazio);
    }

    public EditOpcao(Informacao informacao, int n) {
        super(informacao, n);
    }

    public EditOpcao(Informacao informacao) {
        super(informacao);
    }

    public void setFont(Font font) {
        for (JCheckBox jCheckBox : this.opcoes.values()) {
            jCheckBox.setFont(font);
        }
    }

    public void setForeground(Color color) {
        for (JCheckBox jCheckBox : this.opcoes.values()) {
            jCheckBox.setForeground(color);
        }
    }

    public void setFont(String string, Color color) {
        if (this.opcoes.containsKey(string)) {
            JCheckBox jCheckBox = (JCheckBox)this.opcoes.get(string);
            jCheckBox.setForeground(color);
        }
    }

    public void setFont(String string, Font font) {
        if (this.opcoes.containsKey(string)) {
            JCheckBox jCheckBox = (JCheckBox)this.opcoes.get(string);
            jCheckBox.setFont(font);
        }
    }

    public void addListener(String string, EventListener eventListener) {
        if (this.opcoes.containsKey(string)) {
            JCheckBox jCheckBox = (JCheckBox)this.opcoes.get(string);
            this.adicionaListener(jCheckBox, eventListener);
        }
    }

    private void adicionaListener(JCheckBox jCheckBox, EventListener eventListener) {
        if (eventListener instanceof ActionListener) {
            jCheckBox.addActionListener((ActionListener)eventListener);
        } else if (eventListener instanceof ItemListener) {
            jCheckBox.addItemListener((ItemListener)eventListener);
        } else if (eventListener instanceof KeyListener) {
            jCheckBox.addKeyListener((KeyListener)eventListener);
        } else if (eventListener instanceof FocusListener) {
            jCheckBox.addFocusListener((FocusListener)eventListener);
        } else if (eventListener instanceof MouseListener) {
            jCheckBox.addMouseListener((MouseListener)eventListener);
        } else if (eventListener instanceof MouseMotionListener) {
            jCheckBox.addMouseMotionListener((MouseMotionListener)eventListener);
        }
    }

    public void addListener(EventListener eventListener) {
        for (JCheckBox jCheckBox : this.opcoes.values()) {
            this.adicionaListener(jCheckBox, eventListener);
        }
    }

    public void addValidador(ValidadorImpeditivoDefault validadorImpeditivoDefault, String string) {
    }

    public int getOrientacaoTexto() {
        return this.orientacaoTexto;
    }

    public void setOrientacaoTexto(int n) {
        this.orientacaoTexto = n;
        this.box = new Box(n);
        this.setInformacao(this.getInformacao());
    }

    public void setOpcaoHabilitada(String string, boolean bl) {
        if (this.opcoes.containsKey(string)) {
            JCheckBox jCheckBox = (JCheckBox)this.opcoes.get(string);
            jCheckBox.setEnabled(bl);
            if (!bl) {
                jCheckBox.setForeground(DISABLED_FOREGROUND);
            } else {
                jCheckBox.setForeground(DEFAULT_FOREGROUND);
            }
        }
    }

    @Override
    public void setInformacao(Informacao informacao) {
        Object object2;
        this.opcoes = new Hashtable();
        this.listaOrdenada = new LinkedList();
        if (this.box == null) {
            this.box = new Box(this.getOrientacaoTexto());
        } else {
            this.box.removeAll();
        }
        Opcao opcao = (Opcao)informacao;
        for (Object object2 : opcao.getListaOrdenada()) {
            PPGDCheckBox pPGDCheckBox = new PPGDCheckBox(((ItemOpcao)object2).getCodigo(), ((ItemOpcao)object2).getDescricao(), ((ItemOpcao)object2).isSelecionado());
            pPGDCheckBox.setInformacao(informacao);
            pPGDCheckBox.setVisible(true);
            pPGDCheckBox.setSelected(((ItemOpcao)object2).isSelecionado());
            this.opcoes.put(pPGDCheckBox.getName(), pPGDCheckBox);
            this.listaOrdenada.addLast(pPGDCheckBox);
            pPGDCheckBox.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    if (focusEvent.getOppositeComponent() != null) {
                        EditOpcao.this.setIdentificacaoFoco(false);
                        EditOpcao.this.chamaValidacao();
                    }
                }
            });
            pPGDCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    JCheckBox jCheckBox = (JCheckBox)itemEvent.getSource();
                    String string = jCheckBox.getName().trim();
                    ((Opcao)EditOpcao.this.getInformacao()).atualizaListaValidadoresImpeditivos(string);
                    if (EditOpcao.this.getInformacao().getListaValidadoresImpeditivos().isEmpty() || EditOpcao.this.verificaValidacoesImpeditivas(string)) {
                        if (itemEvent.getStateChange() == 1 && !EditOpcao.this.isBloqueiaItemListener()) {
                            ((Opcao)EditOpcao.this.getInformacao()).addSelectedItem(string);
                        }
                        if (itemEvent.getStateChange() == 2 && !EditOpcao.this.isBloqueiaItemListener()) {
                            ((Opcao)EditOpcao.this.getInformacao()).delSelectedItem(string);
                        }
                        EditOpcao.this.chamaValidacao();
                    }
                }
            });
            if (this.getOrientacaoTexto() == 0) {
                this.box.add(new JLabel(" "));
            }
            this.box.add(pPGDCheckBox);
        }
        this.setObservadorAtivo(false);
        object2 = new PropertyChangeEvent(this, null, null, this.getInformacao().asString());
        this.implementacaoPropertyChange((PropertyChangeEvent)object2);
        this.setObservadorAtivo(true);
        this.box.validate();
    }

    @Override
    public JComponent getComponenteEditor() {
        return this.box;
    }

    @Override
    public void setIdentificacaoFoco(boolean bl) {
        if (this.getComponenteEditor().getBorder() != null) {
            if (bl) {
                this.borda = new BlinkBorder(this.getComponenteEditor());
                this.borda.start();
            } else if (this.borda != null) {
                this.borda.parar();
                this.borda = null;
            }
        } else {
            super.setIdentificacaoFoco(bl);
        }
    }

    @Override
    public void implementacaoPropertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.setObservadorAtivo(false);
        if (propertyChangeEvent == null) {
            LogPPGD.debug("Evento nulo no metodo implementacaoPropertyChange da classe " + this.getClass());
        }
        if ((propertyChangeEvent.getPropertyName() == null || !propertyChangeEvent.getPropertyName().equals("ReadOnly")) && propertyChangeEvent.getNewValue() instanceof String) {
            String string = (String)propertyChangeEvent.getNewValue();
            if (string == null) {
                string = "";
            }
            String string2 = ((Opcao)this.getInformacao()).getDescricaoOpcoes();
            for (JCheckBox jCheckBox : this.opcoes.values()) {
                if (string2.indexOf(jCheckBox.getText().trim()) > -1) {
                    this.setBloqueiaItemListener(true);
                    jCheckBox.setSelected(true);
                    this.setBloqueiaItemListener(false);
                    continue;
                }
                this.setBloqueiaItemListener(true);
                jCheckBox.setSelected(false);
                this.setBloqueiaItemListener(false);
            }
        }
        this.setObservadorAtivo(true);
    }

    @Override
    protected void readOnlyPropertyChange(boolean bl) {
        for (JCheckBox jCheckBox : this.opcoes.values()) {
            jCheckBox.setEnabled(!bl);
        }
    }

    @Override
    protected void habilitadoPropertyChange(boolean bl) {
        for (JCheckBox jCheckBox : this.opcoes.values()) {
            jCheckBox.setEnabled(bl);
            jCheckBox.setForeground(ConstantesGlobaisGUI.COR_CINZA_CLARO);
        }
        this.labelCampo.setEnabled(bl);
    }

    @Override
    public JComponent getComponenteFoco() {
        int n = this.opcoes.values().size();
        int n2 = 0;
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                if (!((JCheckBox)this.opcoes.values().toArray()[i]).isEnabled()) continue;
                n2 = i;
                break;
            }
            return (JCheckBox)this.opcoes.values().toArray()[n2];
        }
        return null;
    }

    public Map getOpcoes() {
        return this.opcoes;
    }

    public void setOpcoes(Map map) {
        this.opcoes = map;
    }

    public LinkedList getListaRadiosOrdenada() {
        return this.listaOrdenada;
    }

    public boolean isBloqueiaItemListener() {
        return this.bloqueiaItemListener;
    }

    public void setBloqueiaItemListener(boolean bl) {
        this.bloqueiaItemListener = bl;
    }

    @Override
    public void setPerdeFocoComEnter(boolean bl) {
    }
}

