/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.gui;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import serpro.ppgd.gui.EditMascara;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.NI;
import serpro.ppgd.negocio.util.UtilitariosString;

public class EditNI
extends EditMascara
implements FocusListener {
    private static String maskara = "**************";
    private static String maskaraCPF = "***.***.***-**";
    private static String maskaraCNPJ = "**.***.***/****-**";
    private static String caracteresValidos = "0123456789 ";

    public EditNI() {
        this(new NI(null, "NI"));
    }

    public EditNI(Informacao informacao) {
        this.aplicaMascaraCorrespondente(informacao);
        this.setAssociaInformacao(informacao);
        this.setCaracteresValidos(caracteresValidos);
        this.getComponenteEditor().addFocusListener(this);
    }

    public void setarMascaraCPF() {
        this.getInformacao().setConteudo(this.getInformacao().asString().trim());
        this.setMascara(maskaraCPF);
        this.setCaracteresValidos(caracteresValidos);
    }

    public void setarMascaraCNPJ() {
        this.setMascara(maskaraCNPJ);
        this.setCaracteresValidos(caracteresValidos);
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.aplicaMascaraCorrespondente(this.getInformacao());
    }

    private void aplicaMascaraCorrespondente(Informacao informacao) {
        if (informacao.asString().length() == 11) {
            this.setarMascaraCPF();
        } else if (informacao.asString().length() == 14) {
            this.setarMascaraCNPJ();
        } else {
            this.setMascara(maskara);
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        String string = UtilitariosString.retiraMascara(this.componente.getText());
        this.setMascara(maskara);
        this.setCaracteresValidos(caracteresValidos);
        this.componente.setText(string);
    }
}

