/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import serpro.ppgd.gui.CustomComboBox;
import serpro.ppgd.gui.EditCampo;
import serpro.ppgd.gui.KeySelectionCustomizado;
import serpro.ppgd.gui.MyCustomRenderer;
import serpro.ppgd.gui.editors.PPGDComboBox;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.ElementoTabela;
import serpro.ppgd.negocio.Informacao;

public class EditCodigo
extends EditCampo
implements ActionListener {
    private static Codigo vazio = new Codigo("C\u00f3digo");
    JComboBox combo;
    Dimension[] tamCols;
    boolean[] colsVisiveisExpandidas;
    boolean[] colsVisiveis;
    private Border bordaColunas = BorderFactory.createMatteBorder(0, 0, 1, 1, Color.GRAY);
    private Border bordaVazia = BorderFactory.createEmptyBorder();
    private KeySelectionCustomizado keySelectionCustomizado;

    public EditCodigo() {
        super(vazio);
        this.aplicaItens(((Codigo)this.campo).getColecaoElementoTabela());
        this.inicio();
    }

    public EditCodigo(Informacao informacao) {
        super(informacao);
        this.inicio();
    }

    public EditCodigo(Informacao informacao, Dimension[] dimensionArray, String string) {
        super(informacao, dimensionArray, string);
        this.inicio();
    }

    @Override
    protected boolean continuaValidacaoImpeditiva(Object object) {
        return object == null || !object.equals(((Codigo)this.getInformacao()).getElementoTabela());
    }

    @Override
    protected void desfazModificacao() {
        int n = ((Codigo)this.getInformacao()).getIndiceElementoTabela();
        this.combo.setSelectedIndex(n);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EditCodigo.this.combo.grabFocus();
            }
        });
    }

    private void inicio() {
        this.setInformacao(this.getInformacao());
        this.combo.setKeySelectionManager(this.keySelectionCustomizado);
        this.combo.addActionListener(this);
        this.combo.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (focusEvent.getOppositeComponent() != null && EditCodigo.this.isFocusLostAtivo()) {
                    EditCodigo.this.setIdentificacaoFoco(false);
                    if (!EditCodigo.this.getInformacao().getListaValidadoresImpeditivos().isEmpty()) {
                        ElementoTabela elementoTabela = ((Codigo)EditCodigo.this.getInformacao()).getElementoTabela(EditCodigo.this.combo.getSelectedIndex());
                        if (!EditCodigo.this.verificaValidacoesImpeditivas(elementoTabela)) {
                            return;
                        }
                        EditCodigo.this.setaCampo();
                    }
                    EditCodigo.this.chamaValidacao();
                }
            }
        });
        this.getInformacao().getObservadores().addPropertyChangeListener("ComboReiniciado", this);
    }

    private void initColsVisiveis() {
        this.colsVisiveis = new boolean[30];
        this.colsVisiveisExpandidas = new boolean[30];
        for (int i = 0; i < this.colsVisiveis.length; ++i) {
            this.colsVisiveisExpandidas[i] = false;
            this.colsVisiveis[i] = false;
        }
        this.exibeColunaNaoExpandida(1);
        this.exibeColunaExpandida(1);
    }

    public void exibeColunaNaoExpandida(int n) {
        this.colsVisiveis[n] = true;
    }

    public void escondeColunaNaoExpandida(int n) {
        this.colsVisiveis[n] = false;
    }

    public void exibeColunaExpandida(int n) {
        this.colsVisiveisExpandidas[n] = true;
    }

    public void escondeColunaExpandida(int n) {
        this.colsVisiveisExpandidas[n] = false;
    }

    private void aplicaItens(List list) {
        if (this.combo == null) {
            this.combo = new CustomComboBox(this);
        }
        if (this.colsVisiveis == null || this.colsVisiveisExpandidas == null) {
            this.initColsVisiveis();
        }
        this.combo.setRenderer(new MyCustomRenderer(this));
        if (list != null) {
            this.calculaTamanhoMaxCols();
            this.combo.setModel(new DefaultComboBoxModel<Object>(list.toArray()));
            this.combo.setSelectedItem(((Codigo)this.campo).getElementoTabela());
        }
    }

    @Override
    public void setInformacao(Informacao informacao) {
        if (informacao != null) {
            this.campo = informacao;
            this.aplicaItens(((Codigo)informacao).getColecaoElementoTabela());
            ((PPGDComboBox)this.combo).setInformacao(informacao);
            if (this.keySelectionCustomizado == null) {
                this.keySelectionCustomizado = new KeySelectionCustomizado(((Codigo)informacao).getColunaFiltro());
            } else {
                this.keySelectionCustomizado.setColunaFiltro(((Codigo)informacao).getColunaFiltro());
            }
        }
    }

    @Override
    public void implementacaoPropertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName() != null && propertyChangeEvent.getPropertyName().equals("ComboReiniciado")) {
            this.setInformacao(this.getInformacao());
        }
        if (propertyChangeEvent.getPropertyName() != null && propertyChangeEvent.getPropertyName().equals(this.getInformacao().getNomeCampo())) {
            this.combo.setSelectedIndex(((Codigo)this.getInformacao()).getIndiceElementoTabela());
        }
    }

    @Override
    public JComponent getComponenteEditor() {
        return this.combo;
    }

    @Override
    public JComponent getComponenteFoco() {
        return this.combo;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.getInformacao().getListaValidadoresImpeditivos().isEmpty()) {
            this.setaCampo();
        }
    }

    public void setaCampo() {
        ElementoTabela elementoTabela = (ElementoTabela)this.combo.getSelectedItem();
        if (elementoTabela != null) {
            this.campo.setConteudo(elementoTabela.getConteudo(0));
        }
    }

    private void calculaTamanhoMaxCols() {
        Dimension dimension;
        int n;
        ElementoTabela elementoTabela;
        Iterator iterator = ((Codigo)this.campo).getColecaoElementoTabela().iterator();
        if (iterator.hasNext()) {
            elementoTabela = (ElementoTabela)iterator.next();
            this.tamCols = new Dimension[elementoTabela.size()];
            for (n = 0; n < this.tamCols.length; ++n) {
                dimension = new JLabel(elementoTabela.getConteudo(n)).getPreferredSize();
                if (this.tamCols[n] != null && this.tamCols[n].width >= dimension.width) continue;
                this.tamCols[n] = dimension;
                this.tamCols[n].width += 5;
            }
        }
        while (iterator.hasNext()) {
            elementoTabela = (ElementoTabela)iterator.next();
            for (n = 0; n < this.tamCols.length; ++n) {
                dimension = new JLabel(elementoTabela.getConteudo(n)).getPreferredSize();
                if (this.tamCols[n] != null && this.tamCols[n].width >= dimension.width) continue;
                this.tamCols[n] = dimension;
                this.tamCols[n].width += 5;
            }
        }
    }

    @Override
    protected void readOnlyPropertyChange(boolean bl) {
        this.combo.setEnabled(!bl);
    }

    @Override
    protected void habilitadoPropertyChange(boolean bl) {
        this.combo.setEnabled(bl);
        this.labelCampo.setEnabled(bl);
    }

    public void setMaximoCaracteresNaColuna(int n, int n2) {
        String string = "";
        for (int i = 0; i < n2; ++i) {
            string = string + " ";
        }
        this.tamCols[n] = new JLabel(string).getPreferredSize();
    }

    public Border getBordaColunas() {
        Border border = null;
        int n = 0;
        for (int i = 0; i < this.colsVisiveis.length; ++i) {
            if (!this.colsVisiveis[i]) continue;
            ++n;
        }
        border = n > 1 ? this.bordaColunas : this.bordaVazia;
        return border;
    }

    public void setBordaColunas(Border border) {
        this.bordaColunas = border;
    }

    @Override
    public void setPerdeFocoComEnter(boolean bl) {
        this.isPerdeFocoComEnter = bl;
        if (this.isPerdeFocoComEnter()) {
            this.aplicaTransfereFocoEnter();
        } else {
            this.removeTransfereFocoEnter();
        }
    }
}

