/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import serpro.ppgd.gui.EditCampo;
import serpro.ppgd.gui.editors.PPGDTextField;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Informacao;

public class EditAlfa
extends EditCampo {
    private static Alfa vazio = new Alfa("EditAlfa");
    private JTextField componente;

    public EditAlfa() {
        super(vazio);
    }

    public EditAlfa(Informacao informacao, int n) {
        super(informacao, n);
    }

    @Override
    public void setInformacao(Informacao informacao) {
        if (this.componente == null) {
            this.componente = new PPGDTextField();
            this.componente.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    if (focusEvent.getOppositeComponent() != null) {
                        EditAlfa.this.setIdentificacaoFoco(false);
                        if (EditAlfa.this.getInformacao().getListaValidadoresImpeditivos().isEmpty() || EditAlfa.this.verificaValidacoesImpeditivas(EditAlfa.this.componente.getText())) {
                            EditAlfa.this.setarCampo();
                        }
                    }
                }

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    if (EditAlfa.this.isSelecionaTextoOnFocusGained()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                EditAlfa.this.componente.selectAll();
                            }
                        });
                    }
                }
            });
            this.componente.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    EditAlfa.this.setarCampo();
                }
            });
            this.componente.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent keyEvent) {
                    int n;
                    boolean bl;
                    char c = keyEvent.getKeyChar();
                    boolean bl2 = bl = c != '\t' && c != '\n' && c != '\b' && c != '\u007f' && c != '%' && c != '\'';
                    if (c == '\'') {
                        bl = true;
                    }
                    if ((n = EditAlfa.this.componente.getText().length()) >= EditAlfa.this.d[0].width && bl && EditAlfa.this.componente.getSelectedText() == null) {
                        keyEvent.setKeyChar('\uffff');
                        keyEvent.consume();
                        UIManager.getLookAndFeel().provideErrorFeedback(EditAlfa.this.componente);
                    }
                }
            });
        }
        ((PPGDTextField)this.componente).setInformacao(informacao);
        this.setTamanho(((Alfa)informacao).getMaximoCaracteres());
        this.implementacaoPropertyChange(null);
    }

    public void setarCampo() {
        String string = this.componente.getText();
        if (string.length() > this.d[0].width) {
            string = string.substring(0, this.d[0].width);
        }
        this.getInformacao().setConteudo(string);
        this.chamaValidacao();
    }

    @Override
    public JComponent getComponenteEditor() {
        return this.componente;
    }

    @Override
    public void implementacaoPropertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.componente.setText(this.getInformacao().getConteudoFormatado());
        this.componente.setCaretPosition(0);
    }

    @Override
    protected void readOnlyPropertyChange(boolean bl) {
        if (bl) {
            this.componente.setEditable(false);
        } else {
            this.componente.setEditable(true);
        }
    }

    @Override
    protected void habilitadoPropertyChange(boolean bl) {
        this.componente.setEnabled(bl);
        this.labelCampo.setEnabled(bl);
    }

    @Override
    public JComponent getComponenteFoco() {
        return this.componente;
    }

    @Override
    public void setPerdeFocoComEnter(boolean bl) {
        this.isPerdeFocoComEnter = bl;
        if (this.isPerdeFocoComEnter()) {
            this.aplicaTransfereFocoEnter();
        } else {
            this.removeTransfereFocoEnter();
        }
    }
}

