/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data;

import org.jfree.data.DefaultKeyedValues;
import org.jfree.data.KeyedValues;
import org.jfree.data.Values2D;

public abstract class DataUtilities {
    public static double calculateColumnTotal(Values2D values2D, int n) {
        double d = 0.0;
        int n2 = values2D.getRowCount();
        for (int i = 0; i < n2; ++i) {
            Number number = values2D.getValue(i, n);
            if (number == null) continue;
            d += number.doubleValue();
        }
        return d;
    }

    public static double calculateRowTotal(Values2D values2D, int n) {
        double d = 0.0;
        int n2 = values2D.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            Number number = values2D.getValue(n, i);
            if (number == null) continue;
            d += number.doubleValue();
        }
        return d;
    }

    public static Number[] createNumberArray(double[] dArray) {
        if (dArray == null) {
            throw new IllegalArgumentException("Null 'data' argument.");
        }
        Number[] numberArray = new Number[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            numberArray[i] = new Double(dArray[i]);
        }
        return numberArray;
    }

    public static Number[][] createNumberArray2D(double[][] dArray) {
        if (dArray == null) {
            throw new IllegalArgumentException("Null 'data' argument.");
        }
        int n = dArray.length;
        Number[][] numberArray = new Number[n][];
        for (int i = 0; i < n; ++i) {
            numberArray[i] = DataUtilities.createNumberArray(dArray[i]);
        }
        return numberArray;
    }

    public static KeyedValues getCumulativePercentages(KeyedValues keyedValues) {
        if (keyedValues == null) {
            throw new IllegalArgumentException("Null 'data' argument.");
        }
        DefaultKeyedValues defaultKeyedValues = new DefaultKeyedValues();
        double d = 0.0;
        for (int i = 0; i < keyedValues.getItemCount(); ++i) {
            Number number = keyedValues.getValue(i);
            if (number == null) continue;
            d += number.doubleValue();
        }
        double d2 = 0.0;
        for (int i = 0; i < keyedValues.getItemCount(); ++i) {
            Number number = keyedValues.getValue(i);
            if (number != null) {
                d2 += number.doubleValue();
            }
            defaultKeyedValues.addValue(keyedValues.getKey(i), new Double(d2 / d));
        }
        return defaultKeyedValues;
    }
}

