/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.awt.Color;
import java.awt.Paint;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.jfree.chart.axis.ValueTick;

public abstract class ColorPalette
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -9029901853079622051L;
    protected double minZ = -1.0;
    protected double maxZ = -1.0;
    protected int[] r;
    protected int[] g;
    protected int[] b;
    protected double[] tickValues = null;
    protected boolean logscale = false;
    protected boolean inverse = false;
    protected String paletteName = null;
    protected boolean stepped = false;
    protected static final double log10 = Math.log(10.0);

    public Paint getColor(double d) {
        int n = (int)(253.0 * (d - this.minZ) / (this.maxZ - this.minZ)) + 2;
        return new Color(this.r[n], this.g[n], this.b[n]);
    }

    public Color getColor(int n) {
        return new Color(this.r[n], this.g[n], this.b[n]);
    }

    public Color getColorLinear(double d) {
        int n = 0;
        if (this.stepped) {
            int n2 = Arrays.binarySearch(this.tickValues, d);
            if (n2 < 0) {
                n2 = -1 * n2 - 2;
            }
            d = n2 < 0 ? this.minZ : this.tickValues[n2];
        }
        n = (int)(253.0 * (d - this.minZ) / (this.maxZ - this.minZ)) + 2;
        n = Math.min(n, 255);
        n = Math.max(n, 2);
        return this.getColor(n);
    }

    public Color getColorLog(double d) {
        int n = 0;
        double d2 = this.minZ;
        double d3 = this.maxZ;
        if (this.minZ <= 0.0) {
            this.maxZ = d3 - d2 + 1.0;
            this.minZ = 1.0;
            d = d - d2 + 1.0;
        }
        double d4 = Math.log(this.minZ) / log10;
        double d5 = Math.log(this.maxZ) / log10;
        d = Math.log(d) / log10;
        if (this.stepped) {
            int n2 = this.tickValues.length;
            int n3 = 256 / (n2 - 1);
            n = n3 * (int)((double)n2 * (d - d4) / (d5 - d4)) + 2;
        } else {
            n = (int)(253.0 * (d - d4) / (d5 - d4)) + 2;
        }
        n = Math.min(n, 255);
        n = Math.max(n, 2);
        this.minZ = d2;
        this.maxZ = d3;
        return this.getColor(n);
    }

    public double getMaxZ() {
        return this.maxZ;
    }

    public double getMinZ() {
        return this.minZ;
    }

    public Paint getPaint(double d) {
        if (this.isLogscale()) {
            return this.getColorLog(d);
        }
        return this.getColorLinear(d);
    }

    public String getPaletteName() {
        return this.paletteName;
    }

    public double[] getTickValues() {
        return this.tickValues;
    }

    public abstract void initialize();

    public void invertPalette() {
        int n;
        int[] nArray = new int[256];
        int[] nArray2 = new int[256];
        int[] nArray3 = new int[256];
        for (n = 0; n < 256; ++n) {
            nArray[n] = this.r[n];
            nArray2[n] = this.g[n];
            nArray3[n] = this.b[n];
        }
        for (n = 2; n < 256; ++n) {
            this.r[n] = nArray[257 - n];
            this.g[n] = nArray2[257 - n];
            this.b[n] = nArray3[257 - n];
        }
    }

    public boolean isInverse() {
        return this.inverse;
    }

    public boolean isLogscale() {
        return this.logscale;
    }

    public boolean isStepped() {
        return this.stepped;
    }

    public void setInverse(boolean bl) {
        this.inverse = bl;
        this.initialize();
        if (bl) {
            this.invertPalette();
        }
    }

    public void setLogscale(boolean bl) {
        this.logscale = bl;
    }

    public void setMaxZ(double d) {
        this.maxZ = d;
    }

    public void setMinZ(double d) {
        this.minZ = d;
    }

    public void setPaletteName(String string) {
        this.paletteName = string;
    }

    public void setStepped(boolean bl) {
        this.stepped = bl;
    }

    public void setTickValues(double[] dArray) {
        this.tickValues = dArray;
    }

    public void setTickValues(List list) {
        this.tickValues = new double[list.size()];
        for (int i = 0; i < this.tickValues.length; ++i) {
            this.tickValues[i] = ((ValueTick)list.get(i)).getValue();
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ColorPalette)) {
            return false;
        }
        ColorPalette colorPalette = (ColorPalette)object;
        if (this.inverse != colorPalette.inverse) {
            return false;
        }
        if (this.logscale != colorPalette.logscale) {
            return false;
        }
        if (this.maxZ != colorPalette.maxZ) {
            return false;
        }
        if (this.minZ != colorPalette.minZ) {
            return false;
        }
        if (this.stepped != colorPalette.stepped) {
            return false;
        }
        if (!Arrays.equals(this.b, colorPalette.b)) {
            return false;
        }
        if (!Arrays.equals(this.g, colorPalette.g)) {
            return false;
        }
        if (this.paletteName != null ? !this.paletteName.equals(colorPalette.paletteName) : colorPalette.paletteName != null) {
            return false;
        }
        if (!Arrays.equals(this.r, colorPalette.r)) {
            return false;
        }
        return Arrays.equals(this.tickValues, colorPalette.tickValues);
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.minZ);
        int n = (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.maxZ);
        n = 29 * n + (int)(l ^ l >>> 32);
        n = 29 * n + (this.logscale ? 1 : 0);
        n = 29 * n + (this.inverse ? 1 : 0);
        n = 29 * n + (this.paletteName != null ? this.paletteName.hashCode() : 0);
        n = 29 * n + (this.stepped ? 1 : 0);
        return n;
    }

    public Object clone() throws CloneNotSupportedException {
        ColorPalette colorPalette = (ColorPalette)super.clone();
        return colorPalette;
    }
}

