/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.layout;

import java.awt.Container;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;
import org.jdesktop.layout.LayoutStyle;

class MetalLayoutStyle
extends LayoutStyle {
    private boolean isOcean = false;

    public MetalLayoutStyle() {
        try {
            Method method = MetalLookAndFeel.class.getMethod("getCurrentTheme", null);
            this.isOcean = ((MetalTheme)method.invoke(null, (Object[])null)).getName() == "Ocean";
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    @Override
    public int getPreferredGap(JComponent jComponent, JComponent jComponent2, int n, int n2, Container container) {
        int n3;
        super.getPreferredGap(jComponent, jComponent2, n, n2, container);
        if (n == 3) {
            if (n2 == 3 || n2 == 7) {
                int n4 = this.getButtonChildIndent(jComponent, n2);
                if (n4 != 0) {
                    return n4;
                }
                return 12;
            }
            n = 0;
        }
        String string = jComponent.getUIClassID();
        String string2 = jComponent2.getUIClassID();
        if (n == 0) {
            if (string == "ToggleButtonUI" && string2 == "ToggleButtonUI") {
                ButtonModel buttonModel = ((JToggleButton)jComponent).getModel();
                ButtonModel buttonModel2 = ((JToggleButton)jComponent2).getModel();
                if (buttonModel instanceof DefaultButtonModel && buttonModel2 instanceof DefaultButtonModel && ((DefaultButtonModel)buttonModel).getGroup() == ((DefaultButtonModel)buttonModel2).getGroup() && ((DefaultButtonModel)buttonModel).getGroup() != null) {
                    return 2;
                }
                if (this.isOcean) {
                    return 6;
                }
                return 5;
            }
            n3 = 6;
        } else {
            n3 = 12;
        }
        if ((n2 == 3 || n2 == 7) && (string == "LabelUI" && string2 != "LabelUI" || string != "LabelUI" && string2 == "LabelUI")) {
            return this.getCBRBPadding(jComponent, jComponent2, n2, n3 + 6);
        }
        return this.getCBRBPadding(jComponent, jComponent2, n2, n3);
    }

    @Override
    int getCBRBPadding(JComponent jComponent, JComponent jComponent2, int n, int n2) {
        if ((n2 = super.getCBRBPadding(jComponent, jComponent2, n, n2)) > 0) {
            int n3 = this.getButtonAdjustment(jComponent, n);
            if (n3 == 0) {
                n3 = this.getButtonAdjustment(jComponent2, this.flipDirection(n));
            }
            n2 -= n3;
        }
        if (n2 < 0) {
            return 0;
        }
        return n2;
    }

    private int getButtonAdjustment(JComponent jComponent, int n) {
        String string = jComponent.getUIClassID();
        if (string == "ButtonUI" || string == "ToggleButtonUI" ? !this.isOcean && (n == 3 || n == 5) : n == 5 && (string == "RadioButtonUI" || !this.isOcean && string == "CheckBoxUI")) {
            return 1;
        }
        return 0;
    }

    @Override
    public int getContainerGap(JComponent jComponent, int n, Container container) {
        super.getContainerGap(jComponent, n, container);
        return this.getCBRBPadding(jComponent, n, 12 - this.getButtonAdjustment(jComponent, n));
    }
}

