/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.parser;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.Block;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ExplicitConstructorCall;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MemberValuePair;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.SuperReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.parser.RecoveredBlock;
import org.eclipse.jdt.internal.compiler.parser.RecoveredElement;
import org.eclipse.jdt.internal.compiler.parser.RecoveredType;
import org.eclipse.jdt.internal.compiler.parser.TerminalTokens;

public class RecoveredMethod
extends RecoveredElement
implements TerminalTokens {
    public AbstractMethodDeclaration methodDeclaration;
    public RecoveredType[] localTypes;
    public int localTypeCount;
    public RecoveredBlock methodBody;
    public boolean discardBody = true;

    public RecoveredMethod(AbstractMethodDeclaration abstractMethodDeclaration, RecoveredElement recoveredElement, int n, Parser parser) {
        super(recoveredElement, n, parser);
        this.methodDeclaration = abstractMethodDeclaration;
        boolean bl = this.foundOpeningBrace = !this.bodyStartsAtHeaderEnd();
        if (this.foundOpeningBrace) {
            ++this.bracketBalance;
        }
    }

    @Override
    public RecoveredElement add(Block block, int n) {
        if (this.methodDeclaration.declarationSourceEnd > 0 && block.sourceStart > this.methodDeclaration.declarationSourceEnd) {
            if (this.parent == null) {
                return this;
            }
            return this.parent.add(block, n);
        }
        if (!this.foundOpeningBrace) {
            this.foundOpeningBrace = true;
            ++this.bracketBalance;
        }
        this.methodBody = new RecoveredBlock(block, (RecoveredElement)this, n);
        if (block.sourceEnd == 0) {
            return this.methodBody;
        }
        return this;
    }

    @Override
    public RecoveredElement add(FieldDeclaration fieldDeclaration, int n) {
        char[][] cArray;
        if ((fieldDeclaration.modifiers & 0xFFFFFFEF) != 0 || fieldDeclaration.type == null || (cArray = fieldDeclaration.type.getTypeName()).length == 1 && CharOperation.equals(cArray[0], TypeBinding.VOID.sourceName())) {
            if (this.parent == null) {
                return this;
            }
            this.updateSourceEndIfNecessary(this.previousAvailableLineEnd(fieldDeclaration.declarationSourceStart - 1));
            return this.parent.add(fieldDeclaration, n);
        }
        if (this.methodDeclaration.declarationSourceEnd > 0 && fieldDeclaration.declarationSourceStart > this.methodDeclaration.declarationSourceEnd) {
            if (this.parent == null) {
                return this;
            }
            return this.parent.add(fieldDeclaration, n);
        }
        if (!this.foundOpeningBrace) {
            this.foundOpeningBrace = true;
            ++this.bracketBalance;
        }
        return this;
    }

    @Override
    public RecoveredElement add(LocalDeclaration localDeclaration, int n) {
        if (this.methodDeclaration.declarationSourceEnd != 0 && localDeclaration.declarationSourceStart > this.methodDeclaration.declarationSourceEnd) {
            if (this.parent == null) {
                return this;
            }
            return this.parent.add(localDeclaration, n);
        }
        if (this.methodBody == null) {
            Block block = new Block(0);
            block.sourceStart = this.methodDeclaration.bodyStart;
            RecoveredElement recoveredElement = this.add(block, 1);
            if (this.bracketBalance > 0) {
                for (int i = 0; i < this.bracketBalance - 1; ++i) {
                    recoveredElement = recoveredElement.add(new Block(0), 1);
                }
                this.bracketBalance = 1;
            }
            return recoveredElement.add(localDeclaration, n);
        }
        return this.methodBody.add(localDeclaration, n, true);
    }

    @Override
    public RecoveredElement add(Statement statement, int n) {
        if (this.methodDeclaration.declarationSourceEnd != 0 && statement.sourceStart > this.methodDeclaration.declarationSourceEnd) {
            if (this.parent == null) {
                return this;
            }
            return this.parent.add(statement, n);
        }
        if (this.methodBody == null) {
            Block block = new Block(0);
            block.sourceStart = this.methodDeclaration.bodyStart;
            RecoveredElement recoveredElement = this.add(block, 1);
            if (this.bracketBalance > 0) {
                for (int i = 0; i < this.bracketBalance - 1; ++i) {
                    recoveredElement = recoveredElement.add(new Block(0), 1);
                }
                this.bracketBalance = 1;
            }
            return recoveredElement.add(statement, n);
        }
        return this.methodBody.add(statement, n, true);
    }

    @Override
    public RecoveredElement add(TypeDeclaration typeDeclaration, int n) {
        if (this.methodDeclaration.declarationSourceEnd != 0 && typeDeclaration.declarationSourceStart > this.methodDeclaration.declarationSourceEnd) {
            if (this.parent == null) {
                return this;
            }
            return this.parent.add(typeDeclaration, n);
        }
        if ((typeDeclaration.bits & 0x100) != 0 || this.parser().methodRecoveryActivated || this.parser().statementRecoveryActivated) {
            if (this.methodBody == null) {
                Block block = new Block(0);
                block.sourceStart = this.methodDeclaration.bodyStart;
                this.add(block, 1);
            }
            return this.methodBody.add(typeDeclaration, n, true);
        }
        switch (TypeDeclaration.kind(typeDeclaration.modifiers)) {
            case 2: 
            case 4: {
                this.updateSourceEndIfNecessary(this.previousAvailableLineEnd(typeDeclaration.declarationSourceStart - 1));
                if (this.parent == null) {
                    return this;
                }
                return this.parent.add(typeDeclaration, n);
            }
        }
        if (this.localTypes == null) {
            this.localTypes = new RecoveredType[5];
            this.localTypeCount = 0;
        } else if (this.localTypeCount == this.localTypes.length) {
            this.localTypes = new RecoveredType[2 * this.localTypeCount];
            System.arraycopy(this.localTypes, 0, this.localTypes, 0, this.localTypeCount);
        }
        RecoveredType recoveredType = new RecoveredType(typeDeclaration, (RecoveredElement)this, n);
        this.localTypes[this.localTypeCount++] = recoveredType;
        if (!this.foundOpeningBrace) {
            this.foundOpeningBrace = true;
            ++this.bracketBalance;
        }
        return recoveredType;
    }

    public boolean bodyStartsAtHeaderEnd() {
        return this.methodDeclaration.bodyStart == this.methodDeclaration.sourceEnd + 1;
    }

    @Override
    public ASTNode parseTree() {
        return this.methodDeclaration;
    }

    @Override
    public int sourceEnd() {
        return this.methodDeclaration.declarationSourceEnd;
    }

    @Override
    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer(this.tabString(n));
        stringBuffer.append("Recovered method:\n");
        this.methodDeclaration.print(n + 1, stringBuffer);
        if (this.localTypes != null) {
            for (int i = 0; i < this.localTypeCount; ++i) {
                stringBuffer.append("\n");
                stringBuffer.append(this.localTypes[i].toString(n + 1));
            }
        }
        if (this.methodBody != null) {
            stringBuffer.append("\n");
            stringBuffer.append(this.methodBody.toString(n + 1));
        }
        return stringBuffer.toString();
    }

    @Override
    public void updateBodyStart(int n) {
        this.foundOpeningBrace = true;
        this.methodDeclaration.bodyStart = n;
    }

    public AbstractMethodDeclaration updatedMethodDeclaration() {
        Block block;
        if (this.methodBody != null && (block = this.methodBody.updatedBlock()) != null) {
            this.methodDeclaration.statements = block.statements;
            if (this.methodDeclaration.isConstructor()) {
                ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)this.methodDeclaration;
                if (this.methodDeclaration.statements != null && this.methodDeclaration.statements[0] instanceof ExplicitConstructorCall) {
                    constructorDeclaration.constructorCall = (ExplicitConstructorCall)this.methodDeclaration.statements[0];
                    int n = this.methodDeclaration.statements.length;
                    this.methodDeclaration.statements = new Statement[n - 1];
                    System.arraycopy(this.methodDeclaration.statements, 1, this.methodDeclaration.statements, 0, n - 1);
                }
                if (constructorDeclaration.constructorCall == null) {
                    constructorDeclaration.constructorCall = SuperReference.implicitSuperConstructorCall();
                }
            }
        }
        if (this.localTypeCount > 0) {
            this.methodDeclaration.bits |= 2;
        }
        return this.methodDeclaration;
    }

    @Override
    public void updateFromParserState() {
        if (this.bodyStartsAtHeaderEnd() && this.parent != null) {
            Parser parser = this.parser();
            if (parser.listLength > 0 && parser.astLengthPtr > 0) {
                if (this.methodDeclaration.sourceEnd == parser.rParenPos) {
                    boolean bl;
                    int n = parser.astLengthStack[parser.astLengthPtr];
                    int n2 = parser.astPtr - n;
                    boolean bl2 = bl = n2 >= 0;
                    if (bl) {
                        if (!(parser.astStack[n2] instanceof AbstractMethodDeclaration)) {
                            bl = false;
                        }
                        int n3 = n + 1;
                        for (int i = 1; i < n3; ++i) {
                            if (parser.astStack[n2 + i] instanceof TypeReference) continue;
                            bl = false;
                        }
                    }
                    if (bl) {
                        parser.consumeMethodHeaderThrowsClause();
                    } else {
                        parser.listLength = 0;
                    }
                } else {
                    if (parser.currentToken == 28 || parser.currentToken == 27) {
                        int n = parser.astLengthPtr;
                        parser.astLengthStack[n] = parser.astLengthStack[n] - 1;
                        --parser.astPtr;
                        --parser.listLength;
                        parser.currentToken = 0;
                    }
                    int n = parser.astLengthStack[parser.astLengthPtr];
                    int n4 = parser.astPtr - n + 1;
                    boolean bl = parser.rParenPos < parser.lParenPos;
                    MemberValuePair[] memberValuePairArray = null;
                    if (n > 0 && parser.astStack[parser.astPtr] instanceof MemberValuePair) {
                        memberValuePairArray = new MemberValuePair[n];
                        System.arraycopy(parser.astStack, n4, memberValuePairArray, 0, n);
                        --parser.astLengthPtr;
                        parser.astPtr -= n;
                        n = parser.astLengthStack[parser.astLengthPtr];
                        n4 = parser.astPtr - n + 1;
                        bl = true;
                    }
                    for (int i = 0; i < n; ++i) {
                        ASTNode aSTNode = parser.astStack[n4 + i];
                        if (aSTNode instanceof Argument) {
                            Argument argument = (Argument)aSTNode;
                            char[][] cArray = argument.type.getTypeName();
                            if ((argument.modifiers & 0xFFFFFFEF) != 0 || cArray.length == 1 && CharOperation.equals(cArray[0], TypeBinding.VOID.sourceName())) {
                                parser.astLengthStack[parser.astLengthPtr] = i;
                                parser.astPtr = n4 + i - 1;
                                parser.listLength = i;
                                parser.currentToken = 0;
                                break;
                            }
                            if (!bl) continue;
                            parser.rParenPos = argument.sourceEnd + 1;
                            continue;
                        }
                        parser.astLengthStack[parser.astLengthPtr] = i;
                        parser.astPtr = n4 + i - 1;
                        parser.listLength = i;
                        parser.currentToken = 0;
                        break;
                    }
                    if (parser.listLength > 0 && parser.astLengthPtr > 0) {
                        boolean bl3;
                        int n5 = parser.astLengthStack[parser.astLengthPtr];
                        int n6 = parser.astPtr - n5;
                        boolean bl4 = bl3 = n6 >= 0;
                        if (bl3) {
                            if (!(parser.astStack[n6] instanceof AbstractMethodDeclaration)) {
                                bl3 = false;
                            }
                            int n7 = n5 + 1;
                            for (int i = 1; i < n7; ++i) {
                                if (parser.astStack[n6 + i] instanceof Argument) continue;
                                bl3 = false;
                            }
                        }
                        if (bl3) {
                            parser.consumeMethodHeaderRightParen();
                            if (parser.currentElement == this) {
                                this.methodDeclaration.sourceEnd = this.methodDeclaration.arguments[this.methodDeclaration.arguments.length - 1].sourceEnd;
                                parser.lastCheckPoint = this.methodDeclaration.bodyStart = this.methodDeclaration.sourceEnd + 1;
                            }
                        }
                    }
                    if (memberValuePairArray != null) {
                        System.arraycopy(memberValuePairArray, 0, parser.astStack, parser.astPtr + 1, memberValuePairArray.length);
                        parser.astPtr += memberValuePairArray.length;
                        parser.astLengthStack[++parser.astLengthPtr] = memberValuePairArray.length;
                    }
                }
            }
        }
    }

    @Override
    public RecoveredElement updateOnClosingBrace(int n, int n2) {
        if (this.methodDeclaration.isAnnotationMethod()) {
            this.updateSourceEndIfNecessary(n, n2);
            if (!this.foundOpeningBrace && this.parent != null) {
                return this.parent.updateOnClosingBrace(n, n2);
            }
            return this;
        }
        return super.updateOnClosingBrace(n, n2);
    }

    @Override
    public RecoveredElement updateOnOpeningBrace(int n, int n2) {
        if (this.bracketBalance == 0) {
            switch (this.parser().lastIgnoredToken) {
                case -1: 
                case 105: {
                    break;
                }
                default: {
                    this.foundOpeningBrace = true;
                    this.bracketBalance = 1;
                }
            }
        }
        return super.updateOnOpeningBrace(n, n2);
    }

    @Override
    public void updateParseTree() {
        this.updatedMethodDeclaration();
    }

    @Override
    public void updateSourceEndIfNecessary(int n, int n2) {
        if (this.methodDeclaration.declarationSourceEnd == 0) {
            if (this.parser().rBraceSuccessorStart >= n2) {
                this.methodDeclaration.declarationSourceEnd = this.parser().rBraceEnd;
                this.methodDeclaration.bodyEnd = this.parser().rBraceStart;
            } else {
                this.methodDeclaration.declarationSourceEnd = n2;
                this.methodDeclaration.bodyEnd = n - 1;
            }
        }
    }

    void attach(TypeParameter[] typeParameterArray, int n) {
        if (this.methodDeclaration.modifiers != 0) {
            return;
        }
        int n2 = typeParameterArray[typeParameterArray.length - 1].sourceEnd;
        Parser parser = this.parser();
        if (parser.scanner.getLineNumber(this.methodDeclaration.declarationSourceStart) != parser.scanner.getLineNumber(n2)) {
            return;
        }
        if (parser.modifiersSourceStart > n2 && parser.modifiersSourceStart < this.methodDeclaration.declarationSourceStart) {
            return;
        }
        if (this.methodDeclaration instanceof MethodDeclaration) {
            ((MethodDeclaration)this.methodDeclaration).typeParameters = typeParameterArray;
            this.methodDeclaration.declarationSourceStart = n;
        } else if (this.methodDeclaration instanceof ConstructorDeclaration) {
            ((ConstructorDeclaration)this.methodDeclaration).typeParameters = typeParameterArray;
            this.methodDeclaration.declarationSourceStart = n;
        }
    }
}

