/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.RawTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.Substitution;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;

public class ParameterizedGenericMethodBinding
extends ParameterizedMethodBinding
implements Substitution {
    public TypeBinding[] typeArguments;
    private LookupEnvironment environment;
    public boolean inferredReturnType;
    public boolean wasInferred;
    public boolean isRaw;
    private MethodBinding tiebreakMethod;
    public boolean isUnchecked;

    public static MethodBinding computeCompatibleMethod(MethodBinding methodBinding, TypeBinding[] typeBindingArray, Scope scope, InvocationSite invocationSite) {
        Object object;
        int n;
        ParameterizedGenericMethodBinding parameterizedGenericMethodBinding;
        TypeVariableBinding[] typeVariableBindingArray = methodBinding.typeVariables;
        TypeBinding[] typeBindingArray2 = invocationSite.genericTypeArguments();
        if (typeBindingArray2 != null) {
            if (typeBindingArray2.length != typeVariableBindingArray.length) {
                return new ProblemMethodBinding(methodBinding, methodBinding.selector, typeBindingArray2, 11);
            }
            parameterizedGenericMethodBinding = scope.environment().createParameterizedGenericMethod(methodBinding, typeBindingArray2);
        } else {
            TypeBinding[] typeBindingArray3 = methodBinding.parameters;
            n = typeVariableBindingArray.length;
            object = new HashMap<TypeVariableBinding, TypeBinding[][]>(n);
            for (int i = 0; i < n; ++i) {
                object.put(typeVariableBindingArray[i], new TypeBinding[3][]);
            }
            typeBindingArray2 = new TypeBinding[n];
            parameterizedGenericMethodBinding = ParameterizedGenericMethodBinding.inferFromArgumentTypes(scope, methodBinding, typeBindingArray, typeBindingArray3, object, typeBindingArray2);
            if (parameterizedGenericMethodBinding == null) {
                return null;
            }
            if (ParameterizedGenericMethodBinding.hasUnresolvedTypeArgument(typeBindingArray2)) {
                TypeBinding typeBinding = null;
                if (parameterizedGenericMethodBinding.returnType != TypeBinding.VOID) {
                    if (invocationSite instanceof MessageSend) {
                        MessageSend messageSend = (MessageSend)invocationSite;
                        typeBinding = messageSend.expectedType;
                    }
                    if (typeBinding == null) {
                        typeBinding = scope.getJavaLangObject();
                    }
                }
                if ((parameterizedGenericMethodBinding = parameterizedGenericMethodBinding.inferFromExpectedType(scope, typeBinding, (Map)object, typeBindingArray2)) == null) {
                    return null;
                }
            }
        }
        if (!parameterizedGenericMethodBinding.isRaw) {
            n = typeVariableBindingArray.length;
            for (int i = 0; i < n; ++i) {
                object = typeVariableBindingArray[i];
                TypeBinding typeBinding = parameterizedGenericMethodBinding.typeArguments[i];
                switch (((TypeVariableBinding)object).boundCheck(parameterizedGenericMethodBinding, typeBinding)) {
                    case 2: {
                        int n2 = typeBindingArray.length;
                        TypeBinding[] typeBindingArray4 = new TypeBinding[n2 + 2];
                        System.arraycopy(typeBindingArray, 0, typeBindingArray4, 0, n2);
                        typeBindingArray4[n2] = typeBinding;
                        typeBindingArray4[n2 + 1] = object;
                        return new ProblemMethodBinding(parameterizedGenericMethodBinding, methodBinding.selector, typeBindingArray4, 10);
                    }
                    case 1: {
                        parameterizedGenericMethodBinding.isUnchecked = true;
                    }
                }
            }
        }
        return parameterizedGenericMethodBinding;
    }

    private static boolean hasUnresolvedTypeArgument(TypeBinding[] typeBindingArray) {
        int n = typeBindingArray.length;
        for (int i = 0; i < n; ++i) {
            if (typeBindingArray[i] != null) continue;
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private static ParameterizedGenericMethodBinding inferFromArgumentTypes(Scope var0, MethodBinding var1_1, TypeBinding[] var2_2, TypeBinding[] var3_3, Map var4_4, TypeBinding[] var5_5) {
        block13: {
            block12: {
                block15: {
                    block14: {
                        if (!var1_1.isVarargs()) break block12;
                        var6_6 = var3_3.length;
                        var7_8 = var6_6 - 1;
                        var8_9 = var2_2.length;
                        for (var9_11 = 0; var9_11 < var7_8; ++var9_11) {
                            var3_3[var9_11].collectSubstitutes(var0, var2_2[var9_11], var4_4, 1);
                            if (var4_4.get(TypeBinding.VOID) == null) continue;
                            return null;
                        }
                        if (var7_8 >= var8_9) break block13;
                        var9_12 = var3_3[var7_8];
                        var10_13 = var2_2[var7_8];
                        if (var6_6 != var8_9) break block14;
                        if (var10_13 == TypeBinding.NULL) break block15;
                        switch (var10_13.dimensions()) {
                            case 0: {
                                ** break;
                            }
                            case 1: {
                                if (var10_13.leafComponentType().isBaseType()) ** break;
                                break block15;
                            }
                            default: {
                                break block15;
                            }
                        }
                    }
                    var9_12 = ((ArrayBinding)var9_12).elementsType();
                }
                for (var11_14 = var7_8; var11_14 < var8_9; ++var11_14) {
                    var9_12.collectSubstitutes(var0, var2_2[var11_14], var4_4, 1);
                    if (var4_4.get(TypeBinding.VOID) == null) continue;
                    return null;
                }
                break block13;
            }
            var6_6 = var3_3.length;
            for (var7_8 = 0; var7_8 < var6_6; ++var7_8) {
                var3_3[var7_8].collectSubstitutes(var0, var2_2[var7_8], var4_4, 1);
                if (var4_4.get(TypeBinding.VOID) == null) continue;
                return null;
            }
        }
        var6_7 = var1_1.typeVariables;
        var7_8 = var6_7.length;
        if ((var5_5 = ParameterizedGenericMethodBinding.resolveSubstituteConstraints(var0, var6_7, var5_5, false, var4_4)) == null) {
            return null;
        }
        if (var5_5.length == 0) {
            return var0.environment().createParameterizedGenericMethod(var1_1, (RawTypeBinding)null);
        }
        var8_10 = var5_5;
        for (var9_11 = 0; var9_11 < var7_8; ++var9_11) {
            if (var5_5[var9_11] == null) {
                if (var8_10 == var5_5) {
                    var8_10 = new TypeBinding[var7_8];
                    System.arraycopy(var5_5, 0, var8_10, 0, var9_11);
                }
                var8_10[var9_11] = var6_7[var9_11];
                continue;
            }
            if (var8_10 == var5_5) continue;
            var8_10[var9_11] = var5_5[var9_11];
        }
        return var0.environment().createParameterizedGenericMethod(var1_1, var8_10);
    }

    private static TypeBinding[] resolveSubstituteConstraints(Scope scope, TypeVariableBinding[] typeVariableBindingArray, TypeBinding[] typeBindingArray, boolean bl, Map map) {
        TypeBinding[][] typeBindingArray2;
        TypeBinding[] typeBindingArray3;
        TypeBinding typeBinding;
        TypeVariableBinding typeVariableBinding;
        int n;
        if (map.isEmpty()) {
            return Binding.NO_TYPES;
        }
        int n2 = typeVariableBindingArray.length;
        block0: for (n = 0; n < n2; ++n) {
            typeVariableBinding = typeVariableBindingArray[n];
            typeBinding = typeBindingArray[n];
            if (typeBinding != null || (typeBindingArray3 = (typeBindingArray2 = (TypeBinding[][])map.get(typeVariableBinding))[0]) == null) continue;
            int n3 = typeBindingArray3.length;
            for (int i = 0; i < n3; ++i) {
                TypeBinding typeBinding2 = typeBindingArray3[i];
                if (typeBinding2 == null) continue;
                if (typeBinding2 == typeVariableBinding) {
                    for (int j = i + 1; j < n3; ++j) {
                        typeBinding2 = typeBindingArray3[j];
                        if (typeBinding2 == typeVariableBinding || typeBinding2 == null) continue;
                        typeBindingArray[n] = typeBinding2;
                        continue block0;
                    }
                    typeBindingArray[n] = typeVariableBinding;
                    continue block0;
                }
                typeBindingArray[n] = typeBinding2;
                continue block0;
            }
        }
        if (ParameterizedGenericMethodBinding.hasUnresolvedTypeArgument(typeBindingArray)) {
            for (n = 0; n < n2; ++n) {
                typeVariableBinding = typeVariableBindingArray[n];
                typeBinding = typeBindingArray[n];
                if (typeBinding != null || (typeBindingArray3 = (typeBindingArray2 = (TypeBinding[][])map.get(typeVariableBinding))[2]) == null) continue;
                TypeBinding typeBinding3 = scope.lowerUpperBound(typeBindingArray3);
                if (typeBinding3 == null) {
                    return null;
                }
                if (typeBinding3 == TypeBinding.VOID) continue;
                typeBindingArray[n] = typeBinding3;
            }
        }
        if (bl && ParameterizedGenericMethodBinding.hasUnresolvedTypeArgument(typeBindingArray)) {
            for (n = 0; n < n2; ++n) {
                typeVariableBinding = typeVariableBindingArray[n];
                typeBinding = typeBindingArray[n];
                if (typeBinding != null || (typeBindingArray3 = (typeBindingArray2 = (TypeBinding[][])map.get(typeVariableBinding))[1]) == null) continue;
                TypeBinding[] typeBindingArray4 = Scope.greaterLowerBound(typeBindingArray3);
                TypeBinding typeBinding4 = null;
                if (typeBindingArray4 != null) {
                    typeBinding4 = typeBindingArray4[0];
                }
                if (typeBinding4 == null) continue;
                typeBindingArray[n] = typeBinding4;
            }
        }
        return typeBindingArray;
    }

    public ParameterizedGenericMethodBinding(MethodBinding methodBinding, RawTypeBinding rawTypeBinding, LookupEnvironment lookupEnvironment) {
        int n;
        TypeVariableBinding[] typeVariableBindingArray = methodBinding.typeVariables;
        int n2 = typeVariableBindingArray.length;
        TypeBinding[] typeBindingArray = new TypeBinding[n2];
        for (n = 0; n < n2; ++n) {
            typeBindingArray[n] = lookupEnvironment.convertToRawType(typeVariableBindingArray[n].erasure());
        }
        this.isRaw = true;
        this.tagBits = methodBinding.tagBits;
        this.isUnchecked = false;
        this.environment = lookupEnvironment;
        this.modifiers = methodBinding.modifiers;
        this.selector = methodBinding.selector;
        this.declaringClass = rawTypeBinding == null ? methodBinding.declaringClass : rawTypeBinding;
        this.typeVariables = Binding.NO_TYPE_VARIABLES;
        this.typeArguments = typeBindingArray;
        this.originalMethod = methodBinding;
        n = rawTypeBinding == null || methodBinding.isStatic() ? 1 : 0;
        this.parameters = Scope.substitute((Substitution)this, n != 0 ? methodBinding.parameters : Scope.substitute((Substitution)rawTypeBinding, methodBinding.parameters));
        this.thrownExceptions = Scope.substitute((Substitution)this, n != 0 ? methodBinding.thrownExceptions : Scope.substitute((Substitution)rawTypeBinding, methodBinding.thrownExceptions));
        this.returnType = Scope.substitute((Substitution)this, n != 0 ? methodBinding.returnType : Scope.substitute((Substitution)rawTypeBinding, methodBinding.returnType));
        this.wasInferred = false;
    }

    public ParameterizedGenericMethodBinding(MethodBinding methodBinding, TypeBinding[] typeBindingArray, LookupEnvironment lookupEnvironment) {
        this.environment = lookupEnvironment;
        this.modifiers = methodBinding.modifiers;
        this.selector = methodBinding.selector;
        this.declaringClass = methodBinding.declaringClass;
        this.typeVariables = Binding.NO_TYPE_VARIABLES;
        this.typeArguments = typeBindingArray;
        this.isRaw = false;
        this.tagBits = methodBinding.tagBits;
        this.isUnchecked = false;
        this.originalMethod = methodBinding;
        this.parameters = Scope.substitute((Substitution)this, methodBinding.parameters);
        this.thrownExceptions = Scope.substitute((Substitution)this, methodBinding.thrownExceptions);
        this.returnType = Scope.substitute((Substitution)this, methodBinding.returnType);
        this.wasInferred = true;
    }

    @Override
    public char[] computeUniqueKey(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.originalMethod.computeUniqueKey(false));
        stringBuffer.append('%');
        stringBuffer.append('<');
        if (!this.isRaw) {
            for (TypeBinding typeBinding : this.typeArguments) {
                stringBuffer.append(typeBinding.computeUniqueKey(false));
            }
        }
        stringBuffer.append('>');
        int n = stringBuffer.length();
        char[] cArray = new char[n];
        stringBuffer.getChars(0, n, cArray, 0);
        return cArray;
    }

    @Override
    public LookupEnvironment environment() {
        return this.environment;
    }

    @Override
    public boolean hasSubstitutedParameters() {
        if (this.wasInferred) {
            return this.originalMethod.hasSubstitutedParameters();
        }
        return super.hasSubstitutedParameters();
    }

    @Override
    public boolean hasSubstitutedReturnType() {
        if (this.inferredReturnType) {
            return this.originalMethod.hasSubstitutedReturnType();
        }
        return super.hasSubstitutedReturnType();
    }

    private ParameterizedGenericMethodBinding inferFromExpectedType(Scope scope, TypeBinding typeBinding, Map map, TypeBinding[] typeBindingArray) {
        TypeBinding typeBinding2;
        int n;
        TypeVariableBinding[] typeVariableBindingArray = this.originalMethod.typeVariables;
        int n2 = typeVariableBindingArray.length;
        if (typeBinding != null) {
            this.returnType.collectSubstitutes(scope, typeBinding, map, 2);
            if (map.get(TypeBinding.VOID) != null) {
                return null;
            }
        }
        for (n = 0; n < n2; ++n) {
            boolean bl;
            TypeBinding typeBinding3 = this.typeArguments[n];
            typeBinding2 = typeVariableBindingArray[n];
            boolean bl2 = bl = typeBinding3 != typeBinding2;
            if (typeBinding2.firstBound == typeBinding2.superclass) {
                TypeBinding typeBinding4 = Scope.substitute((Substitution)this, typeBinding2.superclass);
                typeBinding3.collectSubstitutes(scope, typeBinding4, map, 2);
                if (map.get(TypeBinding.VOID) != null) {
                    return null;
                }
                if (bl) {
                    typeBinding4.collectSubstitutes(scope, typeBinding3, map, 1);
                    if (map.get(TypeBinding.VOID) != null) {
                        return null;
                    }
                }
            }
            int n3 = typeBinding2.superInterfaces.length;
            for (int i = 0; i < n3; ++i) {
                TypeBinding typeBinding5 = Scope.substitute((Substitution)this, typeBinding2.superInterfaces[i]);
                typeBinding3.collectSubstitutes(scope, typeBinding5, map, 2);
                if (map.get(TypeBinding.VOID) != null) {
                    return null;
                }
                if (!bl) continue;
                typeBinding5.collectSubstitutes(scope, typeBinding3, map, 1);
                if (map.get(TypeBinding.VOID) == null) continue;
                return null;
            }
        }
        if ((typeBindingArray = ParameterizedGenericMethodBinding.resolveSubstituteConstraints(scope, typeVariableBindingArray, typeBindingArray, true, map)) == null) {
            return null;
        }
        if (typeBindingArray.length == 0) {
            this.isRaw = true;
            this.isUnchecked = false;
            for (n = 0; n < n2; ++n) {
                this.typeArguments[n] = typeVariableBindingArray[n].upperBound();
            }
        } else {
            for (n = 0; n < n2; ++n) {
                typeBinding2 = typeBindingArray[n];
                this.typeArguments[n] = typeBinding2 != null ? typeBindingArray[n] : typeVariableBindingArray[n].upperBound();
            }
        }
        this.typeArguments = Scope.substitute((Substitution)this, this.typeArguments);
        TypeBinding typeBinding6 = this.returnType;
        this.returnType = Scope.substitute((Substitution)this, this.returnType);
        this.inferredReturnType = this.returnType != typeBinding6;
        this.parameters = Scope.substitute((Substitution)this, this.parameters);
        this.thrownExceptions = Scope.substitute((Substitution)this, this.thrownExceptions);
        return this;
    }

    @Override
    public boolean isRawSubstitution() {
        return this.isRaw;
    }

    @Override
    public TypeBinding substitute(TypeVariableBinding typeVariableBinding) {
        TypeVariableBinding[] typeVariableBindingArray = this.originalMethod.typeVariables;
        int n = typeVariableBindingArray.length;
        if (typeVariableBinding.rank < n && typeVariableBindingArray[typeVariableBinding.rank] == typeVariableBinding) {
            return this.typeArguments[typeVariableBinding.rank];
        }
        if (!this.isStatic() && this.declaringClass instanceof Substitution) {
            return ((Substitution)((Object)this.declaringClass)).substitute(typeVariableBinding);
        }
        return typeVariableBinding;
    }

    @Override
    public MethodBinding tiebreakMethod() {
        if (this.tiebreakMethod == null) {
            TypeVariableBinding[] typeVariableBindingArray = this.originalMethod.typeVariables;
            int n = typeVariableBindingArray.length;
            TypeBinding[] typeBindingArray = new TypeBinding[n];
            for (int i = 0; i < n; ++i) {
                typeBindingArray[i] = this.environment.convertToRawType(typeVariableBindingArray[i].upperBound());
            }
            this.tiebreakMethod = this.environment.createParameterizedGenericMethod(this.originalMethod, typeBindingArray);
        }
        return this.tiebreakMethod;
    }
}

