/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.codegen.ConstantPool;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationHolder;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticArgumentBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;

public class MethodBinding
extends Binding
implements TypeConstants {
    public int modifiers;
    public char[] selector;
    public TypeBinding returnType;
    public TypeBinding[] parameters;
    public ReferenceBinding[] thrownExceptions;
    public ReferenceBinding declaringClass;
    public TypeVariableBinding[] typeVariables = Binding.NO_TYPE_VARIABLES;
    char[] signature;
    public long tagBits;

    protected MethodBinding() {
    }

    public MethodBinding(int n, char[] cArray, TypeBinding typeBinding, TypeBinding[] typeBindingArray, ReferenceBinding[] referenceBindingArray, ReferenceBinding referenceBinding) {
        this.modifiers = n;
        this.selector = cArray;
        this.returnType = typeBinding;
        this.parameters = typeBindingArray == null || typeBindingArray.length == 0 ? Binding.NO_PARAMETERS : typeBindingArray;
        this.thrownExceptions = referenceBindingArray == null || referenceBindingArray.length == 0 ? Binding.NO_EXCEPTIONS : referenceBindingArray;
        this.declaringClass = referenceBinding;
        if (this.declaringClass != null && this.declaringClass.isStrictfp() && !this.isNative() && !this.isAbstract()) {
            this.modifiers |= 0x800;
        }
    }

    public MethodBinding(int n, TypeBinding[] typeBindingArray, ReferenceBinding[] referenceBindingArray, ReferenceBinding referenceBinding) {
        this(n, TypeConstants.INIT, TypeBinding.VOID, typeBindingArray, referenceBindingArray, referenceBinding);
    }

    public MethodBinding(MethodBinding methodBinding, ReferenceBinding referenceBinding) {
        this.modifiers = methodBinding.modifiers;
        this.selector = methodBinding.selector;
        this.returnType = methodBinding.returnType;
        this.parameters = methodBinding.parameters;
        this.thrownExceptions = methodBinding.thrownExceptions;
        this.declaringClass = referenceBinding;
        referenceBinding.storeAnnotationHolder(this, methodBinding.declaringClass.retrieveAnnotationHolder(methodBinding, true));
    }

    public final boolean areParameterErasuresEqual(MethodBinding methodBinding) {
        TypeBinding[] typeBindingArray = methodBinding.parameters;
        if (this.parameters == typeBindingArray) {
            return true;
        }
        int n = this.parameters.length;
        if (n != typeBindingArray.length) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (this.parameters[i] == typeBindingArray[i] || this.parameters[i].erasure() == typeBindingArray[i].erasure()) continue;
            return false;
        }
        return true;
    }

    public final boolean areParametersEqual(MethodBinding methodBinding) {
        TypeBinding[] typeBindingArray = methodBinding.parameters;
        if (this.parameters == typeBindingArray) {
            return true;
        }
        int n = this.parameters.length;
        if (n != typeBindingArray.length) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (this.parameters[i] == typeBindingArray[i]) continue;
            return false;
        }
        return true;
    }

    public final boolean areParametersCompatibleWith(TypeBinding[] typeBindingArray) {
        int n;
        int n2 = this.parameters.length;
        int n3 = n = typeBindingArray.length;
        if (this.isVarargs()) {
            TypeBinding typeBinding;
            n3 = n2 - 1;
            if (n2 == n) {
                typeBinding = this.parameters[n3];
                TypeBinding typeBinding2 = typeBindingArray[n3];
                if (typeBinding != typeBinding2 && !typeBinding2.isCompatibleWith(typeBinding)) {
                    return false;
                }
            } else if (n2 < n) {
                typeBinding = ((ArrayBinding)this.parameters[n3]).elementsType();
                for (int i = n3; i < n; ++i) {
                    if (typeBinding == typeBindingArray[i] || typeBindingArray[i].isCompatibleWith(typeBinding)) continue;
                    return false;
                }
            } else if (n3 != n) {
                return false;
            }
        }
        for (int i = 0; i < n3; ++i) {
            if (this.parameters[i] == typeBindingArray[i] || typeBindingArray[i].isCompatibleWith(this.parameters[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int kind() {
        return 8;
    }

    public final boolean canBeSeenBy(PackageBinding packageBinding) {
        if (this.isPublic()) {
            return true;
        }
        if (this.isPrivate()) {
            return false;
        }
        return packageBinding == this.declaringClass.getPackage();
    }

    public final boolean areTypeVariableErasuresEqual(MethodBinding methodBinding) {
        TypeVariableBinding[] typeVariableBindingArray = methodBinding.typeVariables;
        if (this.typeVariables == typeVariableBindingArray) {
            return true;
        }
        int n = this.typeVariables.length;
        if (n != typeVariableBindingArray.length) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (this.typeVariables[i] == typeVariableBindingArray[i] || this.typeVariables[i].erasure() == typeVariableBindingArray[i].erasure()) continue;
            return false;
        }
        return true;
    }

    public final boolean canBeSeenBy(InvocationSite invocationSite, Scope scope) {
        if (this.isPublic()) {
            return true;
        }
        SourceTypeBinding sourceTypeBinding = scope.enclosingSourceType();
        if (sourceTypeBinding == this.declaringClass) {
            return true;
        }
        if (this.isProtected()) {
            if (sourceTypeBinding.fPackage == this.declaringClass.fPackage) {
                return true;
            }
            return invocationSite.isSuperAccess();
        }
        if (this.isPrivate()) {
            ReferenceBinding referenceBinding;
            ReferenceBinding referenceBinding2 = sourceTypeBinding;
            for (referenceBinding = referenceBinding2.enclosingType(); referenceBinding != null; referenceBinding = referenceBinding.enclosingType()) {
                referenceBinding2 = referenceBinding;
            }
            ReferenceBinding referenceBinding3 = (ReferenceBinding)this.declaringClass.erasure();
            for (referenceBinding = referenceBinding3.enclosingType(); referenceBinding != null; referenceBinding = referenceBinding.enclosingType()) {
                referenceBinding3 = referenceBinding;
            }
            return referenceBinding2 == referenceBinding3;
        }
        return sourceTypeBinding.fPackage == this.declaringClass.fPackage;
    }

    public final boolean canBeSeenBy(TypeBinding typeBinding, InvocationSite invocationSite, Scope scope) {
        if (this.isPublic()) {
            return true;
        }
        SourceTypeBinding sourceTypeBinding = scope.enclosingSourceType();
        if (sourceTypeBinding == this.declaringClass && sourceTypeBinding == typeBinding) {
            return true;
        }
        if (sourceTypeBinding == null) {
            return !this.isPrivate() && scope.getCurrentPackage() == this.declaringClass.fPackage;
        }
        if (this.isProtected()) {
            if (sourceTypeBinding == this.declaringClass) {
                return true;
            }
            if (sourceTypeBinding.fPackage == this.declaringClass.fPackage) {
                return true;
            }
            ReferenceBinding referenceBinding = sourceTypeBinding;
            TypeBinding typeBinding2 = typeBinding.erasure();
            ReferenceBinding referenceBinding2 = (ReferenceBinding)this.declaringClass.erasure();
            int n = 0;
            do {
                if (referenceBinding.findSuperTypeWithSameErasure(referenceBinding2) != null) {
                    if (invocationSite.isSuperAccess()) {
                        return true;
                    }
                    if (typeBinding instanceof ArrayBinding) {
                        return false;
                    }
                    if (this.isStatic()) {
                        if (n > 0) {
                            invocationSite.setDepth(n);
                        }
                        return true;
                    }
                    if (referenceBinding == typeBinding2 || typeBinding2.findSuperTypeWithSameErasure(referenceBinding) != null) {
                        if (n > 0) {
                            invocationSite.setDepth(n);
                        }
                        return true;
                    }
                }
                ++n;
            } while ((referenceBinding = referenceBinding.enclosingType()) != null);
            return false;
        }
        if (this.isPrivate()) {
            if (!(typeBinding == this.declaringClass || typeBinding.isTypeVariable() && ((TypeVariableBinding)typeBinding).isErasureBoundTo(this.declaringClass.erasure()))) {
                return false;
            }
            if (sourceTypeBinding != this.declaringClass) {
                ReferenceBinding referenceBinding;
                ReferenceBinding referenceBinding3 = sourceTypeBinding;
                for (referenceBinding = referenceBinding3.enclosingType(); referenceBinding != null; referenceBinding = referenceBinding.enclosingType()) {
                    referenceBinding3 = referenceBinding;
                }
                ReferenceBinding referenceBinding4 = (ReferenceBinding)this.declaringClass.erasure();
                for (referenceBinding = referenceBinding4.enclosingType(); referenceBinding != null; referenceBinding = referenceBinding.enclosingType()) {
                    referenceBinding4 = referenceBinding;
                }
                if (referenceBinding3 != referenceBinding4) {
                    return false;
                }
            }
            return true;
        }
        PackageBinding packageBinding = this.declaringClass.fPackage;
        if (sourceTypeBinding.fPackage != packageBinding) {
            return false;
        }
        if (typeBinding instanceof ArrayBinding) {
            return false;
        }
        ReferenceBinding referenceBinding = (ReferenceBinding)typeBinding;
        do {
            if (this.declaringClass == referenceBinding) {
                return true;
            }
            PackageBinding packageBinding2 = referenceBinding.fPackage;
            if (packageBinding2 == null || packageBinding2 == packageBinding) continue;
            return false;
        } while ((referenceBinding = referenceBinding.superclass()) != null);
        return false;
    }

    MethodBinding computeSubstitutedMethod(MethodBinding methodBinding, LookupEnvironment lookupEnvironment) {
        TypeBinding[] typeBindingArray = this.typeVariables;
        TypeVariableBinding[] typeVariableBindingArray = methodBinding.typeVariables;
        if (typeBindingArray.length != typeVariableBindingArray.length) {
            return null;
        }
        int n = typeBindingArray.length;
        while (--n >= 0) {
            if (typeBindingArray[n].isInterchangeableWith(lookupEnvironment, typeVariableBindingArray[n])) continue;
            return null;
        }
        return lookupEnvironment.createParameterizedGenericMethod(methodBinding, typeBindingArray);
    }

    @Override
    public char[] computeUniqueKey(boolean bl) {
        char[] cArray = this.declaringClass.computeUniqueKey(false);
        int n = cArray.length;
        int n2 = this.selector == TypeConstants.INIT ? 0 : this.selector.length;
        char[] cArray2 = this.genericSignature();
        if (cArray2 == null) {
            cArray2 = this.signature();
        }
        int n3 = cArray2.length;
        char[] cArray3 = new char[n + 1 + n2 + n3];
        int n4 = 0;
        System.arraycopy(cArray, 0, cArray3, n4, n);
        n4 = n;
        cArray3[n4++] = 46;
        System.arraycopy(this.selector, 0, cArray3, n4, n2);
        System.arraycopy(cArray2, 0, cArray3, n4 += n2, n3);
        return cArray3;
    }

    public TypeBinding constantPoolDeclaringClass() {
        return this.declaringClass;
    }

    public final char[] constantPoolName() {
        return this.selector;
    }

    public char[] genericSignature() {
        int n;
        int n2;
        int n3;
        if ((this.modifiers & 0x40000000) == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(10);
        if (this.typeVariables != Binding.NO_TYPE_VARIABLES) {
            stringBuffer.append('<');
            n3 = this.typeVariables.length;
            for (n2 = 0; n2 < n3; ++n2) {
                stringBuffer.append(this.typeVariables[n2].genericSignature());
            }
            stringBuffer.append('>');
        }
        stringBuffer.append('(');
        n3 = this.parameters.length;
        for (n2 = 0; n2 < n3; ++n2) {
            stringBuffer.append(this.parameters[n2].genericTypeSignature());
        }
        stringBuffer.append(')');
        if (this.returnType != null) {
            stringBuffer.append(this.returnType.genericTypeSignature());
        }
        n2 = 0;
        n3 = this.thrownExceptions.length;
        for (n = 0; n < n3; ++n) {
            if ((this.thrownExceptions[n].modifiers & 0x40000000) == 0) continue;
            n2 = 1;
            break;
        }
        if (n2 != 0) {
            for (n = 0; n < n3; ++n) {
                stringBuffer.append('^');
                stringBuffer.append(this.thrownExceptions[n].genericTypeSignature());
            }
        }
        n = stringBuffer.length();
        char[] cArray = new char[n];
        stringBuffer.getChars(0, n, cArray, 0);
        return cArray;
    }

    public AnnotationBinding[] getAnnotations() {
        MethodBinding methodBinding = this.original();
        return methodBinding.declaringClass.retrieveAnnotations(methodBinding);
    }

    public AnnotationBinding[] getParameterAnnotations(int n) {
        MethodBinding methodBinding = this.original();
        AnnotationHolder annotationHolder = methodBinding.declaringClass.retrieveAnnotationHolder(methodBinding, true);
        return annotationHolder == null ? Binding.NO_ANNOTATIONS : annotationHolder.getParameterAnnotations(n);
    }

    public final int getAccessFlags() {
        return this.modifiers & 0xFFFF;
    }

    @Override
    public long getAnnotationTagBits() {
        TypeDeclaration typeDeclaration;
        AbstractMethodDeclaration abstractMethodDeclaration;
        ClassScope classScope;
        MethodBinding methodBinding = this.original();
        if ((methodBinding.tagBits & 0x200000000L) == 0L && methodBinding.declaringClass instanceof SourceTypeBinding && (classScope = ((SourceTypeBinding)methodBinding.declaringClass).scope) != null && (abstractMethodDeclaration = (typeDeclaration = classScope.referenceContext).declarationOf(methodBinding)) != null) {
            ASTNode.resolveAnnotations(abstractMethodDeclaration.scope, abstractMethodDeclaration.annotations, methodBinding);
        }
        return methodBinding.tagBits;
    }

    public Object getDefaultValue() {
        Object object;
        MethodBinding methodBinding = this.original();
        if ((methodBinding.tagBits & 0x4000000000000L) == 0L) {
            if (methodBinding.declaringClass instanceof SourceTypeBinding) {
                AbstractMethodDeclaration abstractMethodDeclaration;
                object = (SourceTypeBinding)methodBinding.declaringClass;
                if (((SourceTypeBinding)object).scope != null && (abstractMethodDeclaration = methodBinding.sourceMethod()) != null) {
                    abstractMethodDeclaration.resolve(((SourceTypeBinding)object).scope);
                }
            }
            methodBinding.tagBits |= 0x4000000000000L;
        }
        return (object = methodBinding.declaringClass.retrieveAnnotationHolder(methodBinding, true)) == null ? null : ((AnnotationHolder)object).getDefaultValue();
    }

    public TypeVariableBinding getTypeVariable(char[] cArray) {
        int n = this.typeVariables.length;
        while (--n >= 0) {
            if (!CharOperation.equals(this.typeVariables[n].sourceName, cArray)) continue;
            return this.typeVariables[n];
        }
        return null;
    }

    public boolean hasSubstitutedParameters() {
        return false;
    }

    public boolean hasSubstitutedReturnType() {
        return false;
    }

    public final boolean isAbstract() {
        return (this.modifiers & 0x400) != 0;
    }

    public final boolean isBridge() {
        return (this.modifiers & 0x40) != 0;
    }

    public final boolean isConstructor() {
        return this.selector == TypeConstants.INIT;
    }

    public final boolean isDefault() {
        return !this.isPublic() && !this.isProtected() && !this.isPrivate();
    }

    public final boolean isDefaultAbstract() {
        return (this.modifiers & 0x80000) != 0;
    }

    public final boolean isDeprecated() {
        return (this.modifiers & 0x100000) != 0;
    }

    public final boolean isFinal() {
        return (this.modifiers & 0x10) != 0;
    }

    public final boolean isImplementing() {
        return (this.modifiers & 0x20000000) != 0;
    }

    public final boolean isNative() {
        return (this.modifiers & 0x100) != 0;
    }

    public final boolean isOverriding() {
        return (this.modifiers & 0x10000000) != 0;
    }

    public final boolean isMain() {
        TypeBinding typeBinding;
        return this.selector.length == 4 && CharOperation.equals(this.selector, MAIN) && (this.modifiers & 9) != 0 && TypeBinding.VOID == this.returnType && this.parameters.length == 1 && (typeBinding = this.parameters[0]).dimensions() == 1 && typeBinding.leafComponentType().id == 11;
    }

    public final boolean isPrivate() {
        return (this.modifiers & 2) != 0;
    }

    public final boolean isUsed() {
        return (this.modifiers & 0x8000000) != 0;
    }

    public final boolean isProtected() {
        return (this.modifiers & 4) != 0;
    }

    public final boolean isPublic() {
        return (this.modifiers & 1) != 0;
    }

    public final boolean isStatic() {
        return (this.modifiers & 8) != 0;
    }

    public final boolean isStrictfp() {
        return (this.modifiers & 0x800) != 0;
    }

    public final boolean isSynchronized() {
        return (this.modifiers & 0x20) != 0;
    }

    public final boolean isSynthetic() {
        return (this.modifiers & 0x1000) != 0;
    }

    public final boolean isVarargs() {
        return (this.modifiers & 0x80) != 0;
    }

    public final boolean isViewedAsDeprecated() {
        return (this.modifiers & 0x300000) != 0;
    }

    public MethodBinding original() {
        return this;
    }

    @Override
    public char[] readableName() {
        StringBuffer stringBuffer = new StringBuffer(this.parameters.length + 20);
        if (this.isConstructor()) {
            stringBuffer.append(this.declaringClass.sourceName());
        } else {
            stringBuffer.append(this.selector);
        }
        stringBuffer.append('(');
        if (this.parameters != Binding.NO_PARAMETERS) {
            int n = this.parameters.length;
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.parameters[i].sourceName());
            }
        }
        stringBuffer.append(')');
        return stringBuffer.toString().toCharArray();
    }

    public void setAnnotations(AnnotationBinding[] annotationBindingArray) {
        this.declaringClass.storeAnnotations(this, annotationBindingArray);
    }

    public void setAnnotations(AnnotationBinding[] annotationBindingArray, AnnotationBinding[][] annotationBindingArray2, Object object) {
        this.declaringClass.storeAnnotationHolder(this, AnnotationHolder.storeAnnotations(annotationBindingArray, annotationBindingArray2, object));
    }

    public void setDefaultValue(Object object) {
        MethodBinding methodBinding = this.original();
        methodBinding.tagBits |= 0x4000000000000L;
        AnnotationHolder annotationHolder = this.declaringClass.retrieveAnnotationHolder(this, false);
        if (annotationHolder == null) {
            this.setAnnotations(null, null, object);
        } else {
            this.setAnnotations(annotationHolder.getAnnotations(), annotationHolder.getParameterAnnotations(), object);
        }
    }

    public void setParameterAnnotations(AnnotationBinding[][] annotationBindingArray) {
        AnnotationHolder annotationHolder = this.declaringClass.retrieveAnnotationHolder(this, false);
        if (annotationHolder == null) {
            this.setAnnotations(null, annotationBindingArray, null);
        } else {
            this.setAnnotations(annotationHolder.getAnnotations(), annotationBindingArray, annotationHolder.getDefaultValue());
        }
    }

    @Override
    public char[] shortReadableName() {
        int n;
        StringBuffer stringBuffer = new StringBuffer(this.parameters.length + 20);
        if (this.isConstructor()) {
            stringBuffer.append(this.declaringClass.shortReadableName());
        } else {
            stringBuffer.append(this.selector);
        }
        stringBuffer.append('(');
        if (this.parameters != Binding.NO_PARAMETERS) {
            int n2 = this.parameters.length;
            for (n = 0; n < n2; ++n) {
                if (n > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.parameters[n].shortReadableName());
            }
        }
        stringBuffer.append(')');
        n = stringBuffer.length();
        char[] cArray = new char[n];
        stringBuffer.getChars(0, n, cArray, 0);
        return cArray;
    }

    protected final void setSelector(char[] cArray) {
        this.selector = cArray;
        this.signature = null;
    }

    public final char[] signature() {
        int n;
        int n2;
        Binding[] bindingArray;
        boolean bl;
        if (this.signature != null) {
            return this.signature;
        }
        StringBuffer stringBuffer = new StringBuffer(this.parameters.length + 20);
        stringBuffer.append('(');
        TypeBinding[] typeBindingArray = this.parameters;
        boolean bl2 = this.isConstructor();
        if (bl2 && this.declaringClass.isEnum()) {
            stringBuffer.append(ConstantPool.JavaLangStringSignature);
            stringBuffer.append(TypeBinding.INT.signature());
        }
        boolean bl3 = bl = bl2 && this.declaringClass.isNestedType();
        if (bl) {
            bindingArray = this.declaringClass.syntheticEnclosingInstanceTypes();
            if (bindingArray != null) {
                n2 = bindingArray.length;
                for (n = 0; n < n2; ++n) {
                    stringBuffer.append(((ReferenceBinding)bindingArray[n]).signature());
                }
            }
            if (this instanceof SyntheticMethodBinding) {
                typeBindingArray = ((SyntheticMethodBinding)this).targetMethod.parameters;
            }
        }
        if (typeBindingArray != Binding.NO_PARAMETERS) {
            for (int i = 0; i < typeBindingArray.length; ++i) {
                stringBuffer.append(typeBindingArray[i].signature());
            }
        }
        if (bl) {
            bindingArray = this.declaringClass.syntheticOuterLocalVariables();
            n = bindingArray == null ? 0 : bindingArray.length;
            for (n2 = 0; n2 < n; ++n2) {
                stringBuffer.append(((SyntheticArgumentBinding)bindingArray[n2]).type.signature());
            }
            int n3 = this.parameters.length;
            for (n2 = typeBindingArray.length; n2 < n3; ++n2) {
                stringBuffer.append(this.parameters[n2].signature());
            }
        }
        stringBuffer.append(')');
        if (this.returnType != null) {
            stringBuffer.append(this.returnType.signature());
        }
        int n4 = stringBuffer.length();
        this.signature = new char[n4];
        stringBuffer.getChars(0, n4, this.signature, 0);
        return this.signature;
    }

    public final int sourceEnd() {
        AbstractMethodDeclaration abstractMethodDeclaration = this.sourceMethod();
        if (abstractMethodDeclaration == null) {
            if (this.declaringClass instanceof SourceTypeBinding) {
                return ((SourceTypeBinding)this.declaringClass).sourceEnd();
            }
            return 0;
        }
        return abstractMethodDeclaration.sourceEnd;
    }

    public AbstractMethodDeclaration sourceMethod() {
        SourceTypeBinding sourceTypeBinding;
        try {
            sourceTypeBinding = (SourceTypeBinding)this.declaringClass;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
        AbstractMethodDeclaration[] abstractMethodDeclarationArray = sourceTypeBinding.scope.referenceContext.methods;
        int n = abstractMethodDeclarationArray.length;
        while (--n >= 0) {
            if (this != abstractMethodDeclarationArray[n].binding) continue;
            return abstractMethodDeclarationArray[n];
        }
        return null;
    }

    public final int sourceStart() {
        AbstractMethodDeclaration abstractMethodDeclaration = this.sourceMethod();
        if (abstractMethodDeclaration == null) {
            if (this.declaringClass instanceof SourceTypeBinding) {
                return ((SourceTypeBinding)this.declaringClass).sourceStart();
            }
            return 0;
        }
        return abstractMethodDeclaration.sourceStart;
    }

    public String toString() {
        int n;
        int n2;
        String string = this.returnType != null ? this.returnType.debugName() : "NULL TYPE";
        string = string + " ";
        string = string + (this.selector != null ? new String(this.selector) : "UNNAMED METHOD");
        string = string + "(";
        if (this.parameters != null) {
            if (this.parameters != Binding.NO_PARAMETERS) {
                n2 = this.parameters.length;
                for (n = 0; n < n2; ++n) {
                    if (n > 0) {
                        string = string + ", ";
                    }
                    string = string + (this.parameters[n] != null ? this.parameters[n].debugName() : "NULL TYPE");
                }
            }
        } else {
            string = string + "NULL PARAMETERS";
        }
        string = string + ") ";
        if (this.thrownExceptions != null) {
            if (this.thrownExceptions != Binding.NO_EXCEPTIONS) {
                string = string + "throws ";
                n2 = this.thrownExceptions.length;
                for (n = 0; n < n2; ++n) {
                    if (n > 0) {
                        string = string + ", ";
                    }
                    string = string + (this.thrownExceptions[n] != null ? this.thrownExceptions[n].debugName() : "NULL TYPE");
                }
            }
        } else {
            string = string + "NULL THROWN EXCEPTIONS";
        }
        return string;
    }

    public MethodBinding tiebreakMethod() {
        return this;
    }

    public TypeVariableBinding[] typeVariables() {
        return this.typeVariables;
    }
}

