/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.CaseStatement;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.NestedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemFieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticArgumentBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.VariableBinding;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;

public class BlockScope
extends Scope {
    public LocalVariableBinding[] locals;
    public int localIndex;
    public int startIndex;
    public int offset;
    public int maxOffset;
    public BlockScope[] shiftScopes;
    public Scope[] subscopes = new Scope[1];
    public int subscopeCount = 0;
    public CaseStatement enclosingCase;
    public static final VariableBinding[] EmulationPathToImplicitThis = new VariableBinding[0];
    public static final VariableBinding[] NoEnclosingInstanceInConstructorCall = new VariableBinding[0];
    public static final VariableBinding[] NoEnclosingInstanceInStaticContext = new VariableBinding[0];

    public BlockScope(BlockScope blockScope) {
        this(blockScope, true);
    }

    public BlockScope(BlockScope blockScope, boolean bl) {
        this(1, blockScope);
        this.locals = new LocalVariableBinding[5];
        if (bl) {
            blockScope.addSubscope(this);
        }
        this.startIndex = blockScope.localIndex;
    }

    public BlockScope(BlockScope blockScope, int n) {
        this(1, blockScope);
        this.locals = new LocalVariableBinding[n];
        blockScope.addSubscope(this);
        this.startIndex = blockScope.localIndex;
    }

    protected BlockScope(int n, Scope scope) {
        super(n, scope);
    }

    public final void addAnonymousType(TypeDeclaration typeDeclaration, ReferenceBinding referenceBinding) {
        ClassScope classScope = new ClassScope(this, typeDeclaration);
        classScope.buildAnonymousTypeBinding(this.enclosingSourceType(), referenceBinding);
    }

    public final void addLocalType(TypeDeclaration typeDeclaration) {
        ReferenceBinding referenceBinding = this.enclosingSourceType();
        do {
            if (!CharOperation.equals(referenceBinding.sourceName, typeDeclaration.name)) continue;
            this.problemReporter().hidingEnclosingType(typeDeclaration);
            return;
        } while ((referenceBinding = referenceBinding.enclosingType()) != null);
        Scope scope = this;
        do {
            if (scope.findLocalType(typeDeclaration.name) == null) continue;
            this.problemReporter().duplicateNestedType(typeDeclaration);
            return;
        } while ((scope = scope.parent) instanceof BlockScope);
        ClassScope classScope = new ClassScope(this, typeDeclaration);
        this.addSubscope(classScope);
        classScope.buildLocalTypeBinding(this.enclosingSourceType());
    }

    public final void addLocalVariable(LocalVariableBinding localVariableBinding) {
        this.checkAndSetModifiersForVariable(localVariableBinding);
        if (this.localIndex == this.locals.length) {
            this.locals = new LocalVariableBinding[this.localIndex * 2];
            System.arraycopy(this.locals, 0, this.locals, 0, this.localIndex);
        }
        this.locals[this.localIndex++] = localVariableBinding;
        localVariableBinding.declaringScope = this;
        localVariableBinding.id = this.outerMostMethodScope().analysisIndex++;
    }

    public void addSubscope(Scope scope) {
        if (this.subscopeCount == this.subscopes.length) {
            this.subscopes = new Scope[this.subscopeCount * 2];
            System.arraycopy(this.subscopes, 0, this.subscopes, 0, this.subscopeCount);
        }
        this.subscopes[this.subscopeCount++] = scope;
    }

    public final boolean allowBlankFinalFieldAssignment(FieldBinding fieldBinding) {
        if (this.enclosingReceiverType() != fieldBinding.declaringClass) {
            return false;
        }
        MethodScope methodScope = this.methodScope();
        if (methodScope.isStatic != fieldBinding.isStatic()) {
            return false;
        }
        return methodScope.isInsideInitializer() || ((AbstractMethodDeclaration)methodScope.referenceContext).isInitializationMethod();
    }

    String basicToString(int n) {
        String string = "\n";
        int n2 = n;
        while (--n2 >= 0) {
            string = string + "\t";
        }
        String string2 = string + "--- Block Scope ---";
        string = string + "\t";
        string2 = string2 + string + "locals:";
        for (int i = 0; i < this.localIndex; ++i) {
            string2 = string2 + string + "\t" + this.locals[i].toString();
        }
        string2 = string2 + string + "startIndex = " + this.startIndex;
        return string2;
    }

    private void checkAndSetModifiersForVariable(LocalVariableBinding localVariableBinding) {
        int n;
        int n2;
        int n3 = localVariableBinding.modifiers;
        if ((n3 & 0x400000) != 0 && localVariableBinding.declaration != null) {
            this.problemReporter().duplicateModifierForVariable(localVariableBinding.declaration, this instanceof MethodScope);
        }
        if (((n2 = n3 & 0xFFFF) & (n = -17)) != 0 && localVariableBinding.declaration != null) {
            this.problemReporter().illegalModifierForVariable(localVariableBinding.declaration, this instanceof MethodScope);
        }
        localVariableBinding.modifiers = n3;
    }

    void computeLocalVariablePositions(int n, int n2, CodeStream codeStream) {
        boolean bl;
        this.offset = n2;
        this.maxOffset = n2;
        int n3 = this.localIndex;
        boolean bl2 = n < n3;
        int n4 = 0;
        int n5 = this.subscopeCount;
        boolean bl3 = bl = n5 > 0;
        while (bl2 || bl) {
            int n6;
            Object object;
            if (bl && (!bl2 || this.subscopes[n4].startIndex() <= n)) {
                if (this.subscopes[n4] instanceof BlockScope) {
                    object = (BlockScope)this.subscopes[n4];
                    n6 = ((BlockScope)object).shiftScopes == null ? this.offset : ((BlockScope)object).maxShiftedOffset();
                    ((BlockScope)object).computeLocalVariablePositions(0, n6, codeStream);
                    if (((BlockScope)object).maxOffset > this.maxOffset) {
                        this.maxOffset = ((BlockScope)object).maxOffset;
                    }
                }
                bl = ++n4 < n5;
                continue;
            }
            object = this.locals[n];
            int n7 = n6 = ((LocalVariableBinding)object).useFlag == 1 && ((VariableBinding)object).constant() == Constant.NotAConstant ? 1 : 0;
            if (((LocalVariableBinding)object).useFlag == 0 && ((LocalVariableBinding)object).declaration != null && (((LocalVariableBinding)object).declaration.bits & 0x40000000) != 0 && !(((LocalVariableBinding)object).declaration instanceof Argument)) {
                this.problemReporter().unusedLocalVariable(((LocalVariableBinding)object).declaration);
            }
            if (n6 == 0 && ((LocalVariableBinding)object).declaration != null && this.compilerOptions().preserveAllLocalVariables) {
                n6 = 1;
                ((LocalVariableBinding)object).useFlag = 1;
            }
            if (n6 != 0) {
                if (((LocalVariableBinding)object).declaration != null) {
                    codeStream.record((LocalVariableBinding)object);
                }
                ((LocalVariableBinding)object).resolvedPosition = this.offset++;
                if (((LocalVariableBinding)object).type == TypeBinding.LONG || ((LocalVariableBinding)object).type == TypeBinding.DOUBLE) {
                    this.offset += 2;
                }
                if (this.offset > 65535) {
                    this.problemReporter().noMoreAvailableSpaceForLocal((LocalVariableBinding)object, ((LocalVariableBinding)object).declaration == null ? (ASTNode)((Object)this.methodScope().referenceContext) : ((LocalVariableBinding)object).declaration);
                }
            } else {
                ((LocalVariableBinding)object).resolvedPosition = -1;
            }
            bl2 = ++n < n3;
        }
        if (this.offset > this.maxOffset) {
            this.maxOffset = this.offset;
        }
    }

    public void emulateOuterAccess(LocalVariableBinding localVariableBinding) {
        BlockScope blockScope = localVariableBinding.declaringScope;
        if (blockScope == null) {
            return;
        }
        MethodScope methodScope = this.methodScope();
        if (blockScope.methodScope() != methodScope) {
            NestedTypeBinding nestedTypeBinding = (NestedTypeBinding)this.enclosingSourceType();
            if (!nestedTypeBinding.isLocalType()) {
                return;
            }
            if (!methodScope.isInsideInitializerOrConstructor()) {
                nestedTypeBinding.addSyntheticArgumentAndField(localVariableBinding);
            } else {
                nestedTypeBinding.addSyntheticArgument(localVariableBinding);
            }
        }
    }

    public final ReferenceBinding findLocalType(char[] cArray) {
        long l = this.compilerOptions().complianceLevel;
        int n = this.subscopeCount;
        for (int i = 0; i < n; ++i) {
            if (!(this.subscopes[i] instanceof ClassScope)) continue;
            LocalTypeBinding localTypeBinding = (LocalTypeBinding)((ClassScope)this.subscopes[i]).referenceContext.binding;
            if (l >= 0x300000L && localTypeBinding.enclosingCase != null && !this.isInsideCase(localTypeBinding.enclosingCase) || !CharOperation.equals(localTypeBinding.sourceName(), cArray)) continue;
            return localTypeBinding;
        }
        return null;
    }

    public LocalDeclaration[] findLocalVariableDeclarations(int n) {
        boolean bl;
        int n2 = 0;
        int n3 = this.localIndex;
        boolean bl2 = n3 > 0;
        LocalDeclaration[] localDeclarationArray = null;
        int n4 = 0;
        int n5 = 0;
        int n6 = this.subscopeCount;
        boolean bl3 = bl = n6 > 0;
        while (bl2 || bl) {
            LocalDeclaration localDeclaration;
            Object object;
            if (bl && (!bl2 || this.subscopes[n5].startIndex() <= n2)) {
                object = this.subscopes[n5];
                if (((Scope)object).kind == 1 && (localDeclarationArray = ((BlockScope)object).findLocalVariableDeclarations(n)) != null) {
                    return localDeclarationArray;
                }
                bl = ++n5 < n6;
                continue;
            }
            object = this.locals[n2];
            if (object != null && (localDeclaration = ((LocalVariableBinding)object).declaration) != null) {
                if (localDeclaration.declarationSourceStart <= n) {
                    if (n <= localDeclaration.declarationSourceEnd) {
                        if (localDeclarationArray == null) {
                            localDeclarationArray = new LocalDeclaration[n3];
                        }
                        localDeclarationArray[n4++] = localDeclaration;
                    }
                } else {
                    return localDeclarationArray;
                }
            }
            if ((bl2 = ++n2 < n3) || localDeclarationArray == null) continue;
            return localDeclarationArray;
        }
        return null;
    }

    @Override
    public LocalVariableBinding findVariable(char[] cArray) {
        int n = cArray.length;
        for (int i = this.localIndex - 1; i >= 0; --i) {
            LocalVariableBinding localVariableBinding = this.locals[i];
            char[] cArray2 = localVariableBinding.name;
            if (localVariableBinding.name.length != n || !CharOperation.equals(cArray2, cArray)) continue;
            return localVariableBinding;
        }
        return null;
    }

    public Binding getBinding(char[][] cArray, int n, InvocationSite invocationSite, boolean bl) {
        Binding binding;
        int n2;
        int n3;
        Binding binding2;
        block16: {
            binding2 = this.getBinding(cArray[0], n | 4 | 0x10, invocationSite, bl);
            invocationSite.setFieldIndex(1);
            if (binding2 instanceof VariableBinding) {
                return binding2;
            }
            CompilationUnitScope compilationUnitScope = this.compilationUnitScope();
            compilationUnitScope.recordQualifiedReference(cArray);
            if (!binding2.isValidBinding()) {
                return binding2;
            }
            n3 = cArray.length;
            n2 = 1;
            if (binding2 instanceof PackageBinding) {
                binding = (PackageBinding)binding2;
                while (n2 < n3) {
                    compilationUnitScope.recordReference(((PackageBinding)binding).compoundName, cArray[n2]);
                    binding2 = ((PackageBinding)binding).getTypeOrPackage(cArray[n2++]);
                    invocationSite.setFieldIndex(n2);
                    if (binding2 == null) {
                        if (n2 == n3) {
                            return new ProblemReferenceBinding(CharOperation.subarray(cArray, 0, n2), null, 1);
                        }
                        return new ProblemBinding(CharOperation.subarray(cArray, 0, n2), 1);
                    }
                    if (binding2 instanceof ReferenceBinding) {
                        if (!binding2.isValidBinding()) {
                            return new ProblemReferenceBinding(CharOperation.subarray(cArray, 0, n2), null, binding2.problemId());
                        }
                        if (!((ReferenceBinding)binding2).canBeSeenBy(this)) {
                            return new ProblemReferenceBinding(CharOperation.subarray(cArray, 0, n2), (ReferenceBinding)binding2, 2);
                        }
                        break block16;
                    }
                    binding = (PackageBinding)binding2;
                }
                return new ProblemReferenceBinding(CharOperation.subarray(cArray, 0, n2), null, 1);
            }
        }
        binding2 = this.environment().convertToRawType((ReferenceBinding)binding2);
        while (n2 < n3) {
            binding = (ReferenceBinding)binding2;
            char[] cArray2 = cArray[n2++];
            invocationSite.setFieldIndex(n2);
            invocationSite.setActualReceiverType((ReferenceBinding)binding);
            if ((n & 1) != 0 && (binding2 = this.findField((TypeBinding)binding, cArray2, invocationSite, true)) != null) {
                if (binding2.isValidBinding()) break;
                return new ProblemFieldBinding(((ProblemFieldBinding)binding2).closestMatch, ((ProblemFieldBinding)binding2).declaringClass, CharOperation.concatWith(CharOperation.subarray(cArray, 0, n2), '.'), binding2.problemId());
            }
            binding2 = this.findMemberType(cArray2, (ReferenceBinding)binding);
            if (binding2 == null) {
                if ((n & 1) != 0) {
                    return new ProblemBinding(CharOperation.subarray(cArray, 0, n2), (ReferenceBinding)binding, 1);
                }
                return new ProblemReferenceBinding(CharOperation.subarray(cArray, 0, n2), (ReferenceBinding)binding, 1);
            }
            if (binding2.isValidBinding()) continue;
            return new ProblemReferenceBinding(CharOperation.subarray(cArray, 0, n2), null, binding2.problemId());
        }
        if ((n & 1) != 0 && binding2 instanceof FieldBinding) {
            binding = (FieldBinding)binding2;
            if (!((FieldBinding)binding).isStatic()) {
                return new ProblemFieldBinding((FieldBinding)binding, ((FieldBinding)binding).declaringClass, CharOperation.concatWith(CharOperation.subarray(cArray, 0, n2), '.'), 7);
            }
            return binding2;
        }
        if ((n & 4) != 0 && binding2 instanceof ReferenceBinding) {
            return binding2;
        }
        return new ProblemBinding(CharOperation.subarray(cArray, 0, n2), 1);
    }

    public final Binding getBinding(char[][] cArray, InvocationSite invocationSite) {
        Object object;
        Binding binding;
        Binding binding2;
        int n;
        int n2;
        block17: {
            block16: {
                n2 = 0;
                n = cArray.length;
                if (!(binding2 = this.getBinding(cArray[n2++], 23, invocationSite, true)).isValidBinding()) {
                    return binding2;
                }
                if (binding2 instanceof PackageBinding) {
                    while (n2 < n) {
                        binding = (PackageBinding)binding2;
                        if ((binding2 = ((PackageBinding)binding).getTypeOrPackage(cArray[n2++])) == null) {
                            if (n2 == n) {
                                return new ProblemReferenceBinding(CharOperation.subarray(cArray, 0, n2), null, 1);
                            }
                            return new ProblemBinding(CharOperation.subarray(cArray, 0, n2), 1);
                        }
                        if (!(binding2 instanceof ReferenceBinding)) continue;
                        if (!binding2.isValidBinding()) {
                            return new ProblemReferenceBinding(CharOperation.subarray(cArray, 0, n2), null, binding2.problemId());
                        }
                        if (!((ReferenceBinding)binding2).canBeSeenBy(this)) {
                            return new ProblemReferenceBinding(CharOperation.subarray(cArray, 0, n2), (ReferenceBinding)binding2, 2);
                        }
                        break block16;
                    }
                    return binding2;
                }
            }
            if (binding2 instanceof ReferenceBinding) {
                while (n2 < n) {
                    binding = (ReferenceBinding)binding2;
                    if ((binding2 = this.findField((TypeBinding)binding, (char[])(object = (Object)cArray[n2++]), invocationSite, true)) != null) {
                        if (!binding2.isValidBinding()) {
                            return new ProblemFieldBinding((FieldBinding)binding2, ((FieldBinding)binding2).declaringClass, CharOperation.concatWith(CharOperation.subarray(cArray, 0, n2), '.'), binding2.problemId());
                        }
                        if (!((FieldBinding)binding2).isStatic()) {
                            return new ProblemFieldBinding((FieldBinding)binding2, ((FieldBinding)binding2).declaringClass, CharOperation.concatWith(CharOperation.subarray(cArray, 0, n2), '.'), 7);
                        }
                        break block17;
                    }
                    binding2 = this.findMemberType((char[])object, (ReferenceBinding)binding);
                    if (binding2 == null) {
                        return new ProblemBinding(CharOperation.subarray(cArray, 0, n2), (ReferenceBinding)binding, 1);
                    }
                    if (binding2.isValidBinding()) continue;
                    return new ProblemReferenceBinding(CharOperation.subarray(cArray, 0, n2), null, binding2.problemId());
                }
                return binding2;
            }
        }
        binding = (VariableBinding)binding2;
        while (n2 < n) {
            object = ((VariableBinding)binding).type;
            if (object == null) {
                return new ProblemFieldBinding(null, null, CharOperation.concatWith(CharOperation.subarray(cArray, 0, n2), '.'), 1);
            }
            if ((binding = this.findField((TypeBinding)object, cArray[n2++], invocationSite, true)) == null) {
                return new ProblemFieldBinding(null, null, CharOperation.concatWith(CharOperation.subarray(cArray, 0, n2), '.'), 1);
            }
            if (binding.isValidBinding()) continue;
            return binding;
        }
        return binding;
    }

    public VariableBinding[] getEmulationPath(LocalVariableBinding localVariableBinding) {
        VariableBinding variableBinding;
        MethodScope methodScope = this.methodScope();
        SourceTypeBinding sourceTypeBinding = methodScope.enclosingSourceType();
        BlockScope blockScope = localVariableBinding.declaringScope;
        if (blockScope == null || methodScope == blockScope.methodScope()) {
            return new VariableBinding[]{localVariableBinding};
        }
        if (methodScope.isInsideInitializerOrConstructor() && sourceTypeBinding.isNestedType() && (variableBinding = ((NestedTypeBinding)sourceTypeBinding).getSyntheticArgument(localVariableBinding)) != null) {
            return new VariableBinding[]{variableBinding};
        }
        if (!methodScope.isStatic && (variableBinding = sourceTypeBinding.getSyntheticField(localVariableBinding)) != null) {
            return new VariableBinding[]{variableBinding};
        }
        return null;
    }

    public Object[] getEmulationPath(ReferenceBinding referenceBinding, boolean bl, boolean bl2) {
        FieldBinding fieldBinding;
        Object[] objectArray;
        Binding binding;
        Binding binding2;
        MethodScope methodScope = this.methodScope();
        SourceTypeBinding sourceTypeBinding = methodScope.enclosingSourceType();
        if (!(methodScope.isStatic || methodScope.isConstructorCall || sourceTypeBinding != referenceBinding && (bl || sourceTypeBinding.findSuperTypeWithSameErasure(referenceBinding) == null))) {
            return EmulationPathToImplicitThis;
        }
        if (!sourceTypeBinding.isNestedType() || sourceTypeBinding.isStatic()) {
            if (methodScope.isConstructorCall) {
                return NoEnclosingInstanceInConstructorCall;
            }
            if (methodScope.isStatic) {
                return NoEnclosingInstanceInStaticContext;
            }
            return null;
        }
        boolean bl3 = methodScope.isInsideInitializerOrConstructor();
        if (bl3 && (binding2 = ((NestedTypeBinding)sourceTypeBinding).getSyntheticArgument(referenceBinding, bl)) != null) {
            if (bl2 && methodScope.isConstructorCall && (sourceTypeBinding == referenceBinding || !bl && sourceTypeBinding.findSuperTypeWithSameErasure(referenceBinding) != null)) {
                return NoEnclosingInstanceInConstructorCall;
            }
            return new Object[]{binding2};
        }
        if (methodScope.isStatic) {
            return NoEnclosingInstanceInStaticContext;
        }
        if (sourceTypeBinding.isAnonymousType() && ((TypeBinding)(binding2 = sourceTypeBinding.enclosingType())).isNestedType() && (binding = (objectArray = (Object[])binding2).getSyntheticArgument(objectArray.enclosingType(), bl)) != null && (fieldBinding = sourceTypeBinding.getSyntheticField((LocalVariableBinding)binding)) != null && (fieldBinding.type == referenceBinding || !bl && ((ReferenceBinding)fieldBinding.type).findSuperTypeWithSameErasure(referenceBinding) != null)) {
            return new Object[]{fieldBinding};
        }
        binding2 = sourceTypeBinding.getSyntheticField(referenceBinding, bl);
        if (binding2 != null) {
            if (methodScope.isConstructorCall) {
                return NoEnclosingInstanceInConstructorCall;
            }
            return new Object[]{binding2};
        }
        objectArray = new Object[2];
        binding = sourceTypeBinding.enclosingType();
        if (bl3) {
            objectArray[0] = ((NestedTypeBinding)sourceTypeBinding).getSyntheticArgument((ReferenceBinding)binding, bl);
        } else {
            if (methodScope.isConstructorCall) {
                return NoEnclosingInstanceInConstructorCall;
            }
            objectArray[0] = sourceTypeBinding.getSyntheticField((ReferenceBinding)binding, bl);
        }
        if (objectArray[0] != null) {
            ReferenceBinding referenceBinding2;
            int n = 1;
            while ((referenceBinding2 = ((TypeBinding)binding).enclosingType()) != null && binding != referenceBinding && (bl || ((TypeBinding)binding).findSuperTypeWithSameErasure(referenceBinding) == null)) {
                if (methodScope != null) {
                    if ((methodScope = methodScope.enclosingMethodScope()) != null && methodScope.isConstructorCall) {
                        return NoEnclosingInstanceInConstructorCall;
                    }
                    if (methodScope != null && methodScope.isStatic) {
                        return NoEnclosingInstanceInStaticContext;
                    }
                }
                if ((binding2 = ((NestedTypeBinding)binding).getSyntheticField(referenceBinding2, bl)) == null) break;
                if (n == objectArray.length) {
                    Object[] objectArray2 = objectArray;
                    objectArray = new Object[n + 1];
                    System.arraycopy(objectArray2, 0, objectArray, 0, n);
                }
                objectArray[n++] = ((SourceTypeBinding)((FieldBinding)binding2).declaringClass).addSyntheticMethod((FieldBinding)binding2, true);
                binding = referenceBinding2;
            }
            if (binding == referenceBinding || !bl && ((TypeBinding)binding).findSuperTypeWithSameErasure(referenceBinding) != null) {
                return objectArray;
            }
        }
        return null;
    }

    public final boolean isDuplicateLocalVariable(char[] cArray) {
        BlockScope blockScope = this;
        while (true) {
            for (int i = 0; i < this.localIndex; ++i) {
                if (!CharOperation.equals(cArray, blockScope.locals[i].name)) continue;
                return true;
            }
            if (blockScope.kind != 1) {
                return false;
            }
            blockScope = (BlockScope)blockScope.parent;
        }
    }

    public int maxShiftedOffset() {
        int n = -1;
        if (this.shiftScopes != null) {
            int n2 = this.shiftScopes.length;
            for (int i = 0; i < n2; ++i) {
                int n3 = this.shiftScopes[i].maxOffset;
                if (n3 <= n) continue;
                n = n3;
            }
        }
        return n;
    }

    @Override
    public ProblemReporter problemReporter() {
        return this.outerMostMethodScope().problemReporter();
    }

    public void propagateInnerEmulation(ReferenceBinding referenceBinding, boolean bl) {
        SyntheticArgumentBinding[] syntheticArgumentBindingArray = referenceBinding.syntheticOuterLocalVariables();
        if (syntheticArgumentBindingArray != null) {
            for (SyntheticArgumentBinding syntheticArgumentBinding : syntheticArgumentBindingArray) {
                if (bl && syntheticArgumentBinding.type == referenceBinding.enclosingType()) continue;
                this.emulateOuterAccess(syntheticArgumentBinding.actualOuterLocalVariable);
            }
        }
    }

    public TypeDeclaration referenceType() {
        return this.methodScope().referenceType();
    }

    public int scopeIndex() {
        if (this instanceof MethodScope) {
            return -1;
        }
        BlockScope blockScope = (BlockScope)this.parent;
        Scope[] scopeArray = blockScope.subscopes;
        int n = blockScope.subscopeCount;
        for (int i = 0; i < n; ++i) {
            if (scopeArray[i] != this) continue;
            return i;
        }
        return -1;
    }

    @Override
    int startIndex() {
        return this.startIndex;
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int n) {
        String string = this.basicToString(n);
        for (int i = 0; i < this.subscopeCount; ++i) {
            if (!(this.subscopes[i] instanceof BlockScope)) continue;
            string = string + ((BlockScope)this.subscopes[i]).toString(n + 1) + "\n";
        }
        return string;
    }
}

