/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.batch;

import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.batch.ClasspathLocation;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.parser.ScannerHelper;

public class ClasspathDirectory
extends ClasspathLocation {
    private char[] normalizedPath;
    private String path;
    private Hashtable directoryCache;
    private String[] missingPackageHolder = new String[1];
    private int mode;
    private String encoding;

    ClasspathDirectory(File file, String string, int n, AccessRuleSet accessRuleSet) {
        super(accessRuleSet);
        this.mode = n;
        this.path = file.getAbsolutePath();
        if (!this.path.endsWith(File.separator)) {
            this.path = this.path + File.separator;
        }
        this.directoryCache = new Hashtable(11);
        this.encoding = string;
    }

    String[] directoryList(String string) {
        String[] stringArray = (String[])this.directoryCache.get(string);
        if (stringArray == this.missingPackageHolder) {
            return null;
        }
        if (stringArray != null) {
            return stringArray;
        }
        File file = new File(this.path + string);
        if (file != null && file.isDirectory()) {
            String string2;
            String string3;
            int n = string.length();
            int n2 = string.lastIndexOf(File.separatorChar);
            while (--n > n2 && !ScannerHelper.isUpperCase(string.charAt(n))) {
            }
            if (n <= n2 || !(n2 != -1 ? !this.doesFileExist(string3 = string.substring(n2 + 1), string2 = string.substring(0, n2)) : !this.doesFileExist(string, ""))) {
                stringArray = file.list();
                if (stringArray == null) {
                    stringArray = new String[]{};
                }
                this.directoryCache.put(string, stringArray);
                return stringArray;
            }
        }
        this.directoryCache.put(string, this.missingPackageHolder);
        return null;
    }

    boolean doesFileExist(String string, String string2) {
        String[] stringArray = this.directoryList(string2);
        if (stringArray == null) {
            return false;
        }
        int n = stringArray.length;
        while (--n >= 0) {
            if (!string.equals(stringArray[n])) continue;
            return true;
        }
        return false;
    }

    @Override
    public NameEnvironmentAnswer findClass(char[] cArray, String string, String string2) {
        Object object;
        boolean bl;
        if (!this.isPackage(string)) {
            return null;
        }
        String string3 = new String(cArray);
        boolean bl2 = (this.mode & 2) != 0 && this.doesFileExist(string3 + ".class", string);
        boolean bl3 = bl = (this.mode & 1) != 0 && this.doesFileExist(string3 + ".java", string);
        if (bl) {
            object = this.path + string2.substring(0, string2.length() - 6) + ".java";
            if (!bl2) {
                return new NameEnvironmentAnswer(new CompilationUnit(null, (String)object, this.encoding), this.fetchAccessRestriction(string2));
            }
            String string4 = this.path + string2;
            long l = new File(string4).lastModified();
            long l2 = new File((String)object).lastModified();
            if (l2 > l) {
                return new NameEnvironmentAnswer(new CompilationUnit(null, (String)object, this.encoding), this.fetchAccessRestriction(string2));
            }
        }
        if (bl2) {
            try {
                object = ClassFileReader.read(this.path + string2);
                if (object != null) {
                    return new NameEnvironmentAnswer((IBinaryType)object, this.fetchAccessRestriction(string2));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public void initialize() throws IOException {
    }

    @Override
    public boolean isPackage(String string) {
        return this.directoryList(string) != null;
    }

    @Override
    public void reset() {
        this.directoryCache = new Hashtable(11);
    }

    public String toString() {
        return "ClasspathDirectory " + this.path;
    }

    @Override
    public char[] normalizedPath() {
        if (this.normalizedPath == null) {
            this.normalizedPath = this.path.toCharArray();
            if (File.separatorChar == '\\') {
                CharOperation.replace(this.normalizedPath, '\\', '/');
            }
        }
        return this.normalizedPath;
    }

    @Override
    public String getPath() {
        return this.path;
    }
}

