/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Block;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.SubRoutineStatement;
import org.eclipse.jdt.internal.compiler.codegen.BranchLabel;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.InsideSubRoutineFlowContext;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class SynchronizedStatement
extends SubRoutineStatement {
    public Expression expression;
    public Block block;
    public BlockScope scope;
    boolean blockExit;
    public LocalVariableBinding synchroVariable;
    static final char[] SecretLocalDeclarationName = " syncValue".toCharArray();
    int preSynchronizedInitStateIndex = -1;
    int mergedSynchronizedInitStateIndex = -1;

    public SynchronizedStatement(Expression expression, Block block, int n, int n2) {
        this.expression = expression;
        this.block = block;
        this.sourceEnd = n2;
        this.sourceStart = n;
    }

    @Override
    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        this.preSynchronizedInitStateIndex = blockScope.methodScope().recordInitializationStates(flowInfo);
        this.synchroVariable.useFlag = 1;
        flowInfo = this.block.analyseCode(this.scope, new InsideSubRoutineFlowContext(flowContext, this), this.expression.analyseCode(this.scope, flowContext, flowInfo));
        this.mergedSynchronizedInitStateIndex = blockScope.methodScope().recordInitializationStates(flowInfo);
        this.blockExit = (flowInfo.tagBits & 1) != 0;
        return flowInfo;
    }

    @Override
    public boolean isSubRoutineEscaping() {
        return false;
    }

    @Override
    public void generateCode(BlockScope blockScope, CodeStream codeStream) {
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        this.anyExceptionLabel = null;
        int n = codeStream.position;
        this.expression.generateCode(this.scope, codeStream, true);
        if (this.block.isEmptyBlock()) {
            if (this.synchroVariable.type == TypeBinding.LONG || this.synchroVariable.type == TypeBinding.DOUBLE) {
                codeStream.dup2();
            } else {
                codeStream.dup();
            }
            codeStream.monitorenter();
            codeStream.monitorexit();
            if (this.scope != blockScope) {
                codeStream.exitUserScope(this.scope);
            }
        } else {
            codeStream.store(this.synchroVariable, true);
            codeStream.monitorenter();
            this.enterAnyExceptionHandler(codeStream);
            this.block.generateCode(this.scope, codeStream);
            if (this.scope != blockScope) {
                codeStream.exitUserScope(this.scope, this.synchroVariable);
            }
            BranchLabel branchLabel = new BranchLabel(codeStream);
            if (!this.blockExit) {
                codeStream.load(this.synchroVariable);
                codeStream.monitorexit();
                this.exitAnyExceptionHandler();
                codeStream.goto_(branchLabel);
                this.enterAnyExceptionHandler(codeStream);
            }
            codeStream.pushOnStack(this.scope.getJavaLangThrowable());
            if (this.preSynchronizedInitStateIndex != -1) {
                codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.preSynchronizedInitStateIndex);
            }
            this.placeAllAnyExceptionHandler();
            codeStream.load(this.synchroVariable);
            codeStream.monitorexit();
            this.exitAnyExceptionHandler();
            codeStream.athrow();
            if (this.mergedSynchronizedInitStateIndex != -1) {
                codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.mergedSynchronizedInitStateIndex);
                codeStream.addDefinitelyAssignedVariables(blockScope, this.mergedSynchronizedInitStateIndex);
            }
            if (this.scope != blockScope) {
                codeStream.removeVariable(this.synchroVariable);
            }
            if (!this.blockExit) {
                branchLabel.place();
            }
        }
        codeStream.recordPositionsFrom(n, this.sourceStart);
    }

    @Override
    public boolean generateSubRoutineInvocation(BlockScope blockScope, CodeStream codeStream, Object object) {
        codeStream.load(this.synchroVariable);
        codeStream.monitorexit();
        this.exitAnyExceptionHandler();
        return false;
    }

    @Override
    public void resolve(BlockScope blockScope) {
        this.scope = new BlockScope(blockScope);
        TypeBinding typeBinding = this.expression.resolveType(this.scope);
        if (typeBinding == null) {
            return;
        }
        switch (typeBinding.id) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                this.scope.problemReporter().invalidTypeToSynchronize(this.expression, typeBinding);
                break;
            }
            case 6: {
                this.scope.problemReporter().illegalVoidExpression(this.expression);
                break;
            }
            case 12: {
                this.scope.problemReporter().invalidNullToSynchronize(this.expression);
            }
        }
        this.synchroVariable = new LocalVariableBinding(SecretLocalDeclarationName, typeBinding, 0, false);
        this.scope.addLocalVariable(this.synchroVariable);
        this.synchroVariable.setConstant(Constant.NotAConstant);
        this.expression.computeConversion(this.scope, typeBinding, typeBinding);
        this.block.resolveUsing(this.scope);
    }

    @Override
    public StringBuffer printStatement(int n, StringBuffer stringBuffer) {
        SynchronizedStatement.printIndent(n, stringBuffer);
        stringBuffer.append("synchronized (");
        this.expression.printExpression(0, stringBuffer).append(')');
        stringBuffer.append('\n');
        return this.block.printStatement(n + 1, stringBuffer);
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            this.expression.traverse(aSTVisitor, this.scope);
            this.block.traverse(aSTVisitor, this.scope);
        }
        aSTVisitor.endVisit(this, blockScope);
    }
}

