/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.CaseStatement;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.codegen.BranchLabel;
import org.eclipse.jdt.internal.compiler.codegen.CaseLabel;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.SwitchFlowContext;
import org.eclipse.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class SwitchStatement
extends Statement {
    public Expression expression;
    public Statement[] statements;
    public BlockScope scope;
    public int explicitDeclarations;
    public BranchLabel breakLabel;
    public CaseStatement[] cases;
    public CaseStatement defaultCase;
    public int blockStart;
    public int caseCount;
    int[] constants;
    public static final int CASE = 0;
    public static final int FALLTHROUGH = 1;
    public static final int ESCAPING = 2;
    public SyntheticMethodBinding synthetic;
    int preSwitchInitStateIndex = -1;
    int mergedInitStateIndex = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        try {
            flowInfo = this.expression.analyseCode(blockScope, flowContext, flowInfo);
            this.breakLabel = new BranchLabel();
            SwitchFlowContext switchFlowContext = new SwitchFlowContext(flowContext, this, this.breakLabel);
            FlowInfo flowInfo2 = FlowInfo.DEAD_END;
            this.preSwitchInitStateIndex = blockScope.methodScope().recordInitializationStates(flowInfo);
            int n = 0;
            if (this.statements != null) {
                boolean bl = false;
                int n2 = 0;
                for (Statement statement : this.statements) {
                    if (n < this.caseCount && statement == this.cases[n]) {
                        this.scope.enclosingCase = this.cases[n];
                        ++n;
                        if (n2 == 1 && (statement.bits & 0x20000000) == 0) {
                            this.scope.problemReporter().possibleFallThroughCase(this.scope.enclosingCase);
                        }
                        flowInfo2 = ((FlowInfo)flowInfo2).mergedWith(flowInfo.unconditionalInits());
                        bl = false;
                        n2 = 0;
                    } else if (statement == this.defaultCase) {
                        this.scope.enclosingCase = this.defaultCase;
                        if (n2 == 1 && (statement.bits & 0x20000000) == 0) {
                            this.scope.problemReporter().possibleFallThroughCase(this.scope.enclosingCase);
                        }
                        flowInfo2 = ((FlowInfo)flowInfo2).mergedWith(flowInfo.unconditionalInits());
                        bl = false;
                        n2 = 0;
                    } else {
                        n2 = 1;
                    }
                    if (!statement.complainIfUnreachable(flowInfo2, this.scope, bl)) {
                        if ((flowInfo2 = statement.analyseCode(this.scope, switchFlowContext, flowInfo2)) != FlowInfo.DEAD_END) continue;
                        n2 = 2;
                        continue;
                    }
                    bl = true;
                }
            }
            TypeBinding typeBinding = this.expression.resolvedType;
            if (this.caseCount > 0 && typeBinding.isEnum()) {
                SourceTypeBinding sourceTypeBinding = this.scope.classScope().referenceContext.binding;
                this.synthetic = sourceTypeBinding.addSyntheticMethodForSwitchEnum(typeBinding);
            }
            if (this.defaultCase == null) {
                flowInfo.addPotentialInitializationsFrom(((FlowInfo)flowInfo2).mergedWith(switchFlowContext.initsOnBreak));
                this.mergedInitStateIndex = blockScope.methodScope().recordInitializationStates(flowInfo);
                FlowInfo flowInfo3 = flowInfo;
                return flowInfo3;
            }
            UnconditionalFlowInfo unconditionalFlowInfo = ((FlowInfo)flowInfo2).mergedWith(switchFlowContext.initsOnBreak);
            this.mergedInitStateIndex = blockScope.methodScope().recordInitializationStates(unconditionalFlowInfo);
            UnconditionalFlowInfo unconditionalFlowInfo2 = unconditionalFlowInfo;
            return unconditionalFlowInfo2;
        }
        finally {
            if (this.scope != null) {
                this.scope.enclosingCase = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generateCode(BlockScope blockScope, CodeStream codeStream) {
        try {
            TypeBinding typeBinding;
            if ((this.bits & Integer.MIN_VALUE) == 0) {
                return;
            }
            int n = codeStream.position;
            this.breakLabel.initialize(codeStream);
            CaseLabel[] caseLabelArray = new CaseLabel[this.caseCount];
            boolean bl = this.caseCount != 0;
            for (int i = 0; i < this.caseCount; ++i) {
                this.cases[i].targetLabel = caseLabelArray[i] = new CaseLabel(codeStream);
                caseLabelArray[i].tagBits |= 2;
            }
            CaseLabel caseLabel = new CaseLabel(codeStream);
            if (bl) {
                caseLabel.tagBits |= 2;
            }
            if (this.defaultCase != null) {
                this.defaultCase.targetLabel = caseLabel;
            }
            if ((typeBinding = this.expression.resolvedType).isEnum()) {
                if (bl) {
                    codeStream.invokestatic(this.synthetic);
                    this.expression.generateCode(blockScope, codeStream, true);
                    codeStream.invokeEnumOrdinal(typeBinding.constantPoolName());
                    codeStream.iaload();
                } else {
                    this.expression.generateCode(blockScope, codeStream, false);
                }
            } else {
                this.expression.generateCode(blockScope, codeStream, bl);
            }
            if (bl) {
                int[] nArray = new int[this.caseCount];
                for (int i = 0; i < this.caseCount; ++i) {
                    nArray[i] = i;
                }
                int[] nArray2 = new int[this.caseCount];
                System.arraycopy(this.constants, 0, nArray2, 0, this.caseCount);
                CodeStream.sort(nArray2, 0, this.caseCount - 1, nArray);
                int n2 = nArray2[this.caseCount - 1];
                int n3 = nArray2[0];
                if ((long)((double)this.caseCount * 2.5) > (long)n2 - (long)n3) {
                    if (n2 > 0x7FFF0000 && blockScope.compilerOptions().complianceLevel < 0x300000L) {
                        codeStream.lookupswitch(caseLabel, this.constants, nArray, caseLabelArray);
                    } else {
                        codeStream.tableswitch(caseLabel, n3, n2, this.constants, nArray, caseLabelArray);
                    }
                } else {
                    codeStream.lookupswitch(caseLabel, this.constants, nArray, caseLabelArray);
                }
                codeStream.updateLastRecordedEndPC(this.scope, codeStream.position);
            }
            int n4 = 0;
            if (this.statements != null) {
                for (Statement statement : this.statements) {
                    if (n4 < this.caseCount && statement == this.cases[n4]) {
                        this.scope.enclosingCase = this.cases[n4];
                        if (this.preSwitchInitStateIndex != -1) {
                            codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.preSwitchInitStateIndex);
                        }
                        ++n4;
                    } else if (statement == this.defaultCase) {
                        this.scope.enclosingCase = this.defaultCase;
                        if (this.preSwitchInitStateIndex != -1) {
                            codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.preSwitchInitStateIndex);
                        }
                    }
                    statement.generateCode(this.scope, codeStream);
                }
            }
            if (this.mergedInitStateIndex != -1) {
                codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.mergedInitStateIndex);
                codeStream.addDefinitelyAssignedVariables(blockScope, this.mergedInitStateIndex);
            }
            if (this.scope != blockScope) {
                codeStream.exitUserScope(this.scope);
            }
            this.breakLabel.place();
            if (this.defaultCase == null) {
                caseLabel.place();
            }
            codeStream.recordPositionsFrom(n, this.sourceStart);
        }
        finally {
            if (this.scope != null) {
                this.scope.enclosingCase = null;
            }
        }
    }

    @Override
    public StringBuffer printStatement(int n, StringBuffer stringBuffer) {
        SwitchStatement.printIndent(n, stringBuffer).append("switch (");
        this.expression.printExpression(0, stringBuffer).append(") {");
        if (this.statements != null) {
            for (int i = 0; i < this.statements.length; ++i) {
                stringBuffer.append('\n');
                if (this.statements[i] instanceof CaseStatement) {
                    this.statements[i].printStatement(n, stringBuffer);
                    continue;
                }
                this.statements[i].printStatement(n + 2, stringBuffer);
            }
        }
        stringBuffer.append("\n");
        return SwitchStatement.printIndent(n, stringBuffer).append('}');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void resolve(BlockScope var1_1) {
        try {
            block21: {
                block22: {
                    var2_2 = false;
                    var3_3 = this.expression.resolveType(var1_1);
                    if (var3_3 == null) break block21;
                    this.expression.computeConversion(var1_1, var3_3, var3_3);
                    if (!var3_3.isBaseType()) break block22;
                    if (!this.expression.isConstantValueOfTypeAssignableToType(var3_3, TypeBinding.INT) && !var3_3.isCompatibleWith(TypeBinding.INT)) ** GOTO lbl-1000
                    break block21;
                }
                if (var3_3.isEnum()) {
                    var2_2 = true;
                } else if (var1_1.isBoxingCompatibleWith(var3_3, TypeBinding.INT)) {
                    this.expression.computeConversion(var1_1, TypeBinding.INT, var3_3);
                } else lbl-1000:
                // 2 sources

                {
                    var1_1.problemReporter().incorrectSwitchType(this.expression, var3_3);
                    var3_3 = null;
                }
            }
            if (this.statements != null) {
                this.scope = new BlockScope(var1_1);
                var4_4 = this.statements.length;
                this.cases = new CaseStatement[var4_4];
                this.constants = new int[var4_4];
                var5_5 = null;
                var6_6 = 0;
                var7_7 = 0;
                for (var8_8 = 0; var8_8 < var4_4; ++var8_8) {
                    var10_12 = this.statements[var8_8];
                    var9_10 = var10_12.resolveCase(this.scope, var3_3, this);
                    if (var9_10 == Constant.NotAConstant) continue;
                    var11_13 = var9_10.intValue();
                    for (var12_14 = 0; var12_14 < var7_7; ++var12_14) {
                        if (this.constants[var12_14] != var11_13) continue;
                        var13_15 = (CaseStatement)var10_12;
                        if (var5_5 == null) {
                            this.scope.problemReporter().duplicateCase(this.cases[var12_14]);
                            this.scope.problemReporter().duplicateCase(var13_15);
                            var5_5 = new CaseStatement[var4_4];
                            var5_5[var6_6++] = this.cases[var12_14];
                            var5_5[var6_6++] = var13_15;
                            continue;
                        }
                        var14_16 = false;
                        for (var15_17 = 2; var15_17 < var6_6; ++var15_17) {
                            if (var5_5[var15_17] != var10_12) continue;
                            var14_16 = true;
                            break;
                        }
                        if (var14_16) continue;
                        this.scope.problemReporter().duplicateCase(var13_15);
                        var5_5[var6_6++] = var13_15;
                    }
                    this.constants[var7_7++] = var11_13;
                }
                if (var4_4 != var7_7) {
                    this.constants = new int[var7_7];
                    System.arraycopy(this.constants, 0, this.constants, 0, var7_7);
                }
            } else if ((this.bits & 8) != 0) {
                var1_1.problemReporter().undocumentedEmptyBlock(this.blockStart, this.sourceEnd);
            }
            if (var2_2 && this.defaultCase == null && var1_1.compilerOptions().getSeverity(0x20000000000L) != -1) {
                v0 = var4_4 = this.constants == null ? 0 : this.constants.length;
                if (var4_4 == this.caseCount && this.caseCount != ((ReferenceBinding)var3_3).enumConstantCount()) {
                    block6: for (FieldBinding var8_9 : ((ReferenceBinding)var3_3.erasure()).fields()) {
                        if ((var8_9.modifiers & 16384) == 0) continue;
                        for (var9_11 = 0; var9_11 < this.caseCount; ++var9_11) {
                            if (var8_9.id + 1 == this.constants[var9_11]) continue block6;
                        }
                        var1_1.problemReporter().missingEnumConstantCase(this, var8_9);
                    }
                }
            }
        }
        finally {
            if (this.scope != null) {
                this.scope.enclosingCase = null;
            }
        }
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            this.expression.traverse(aSTVisitor, this.scope);
            if (this.statements != null) {
                int n = this.statements.length;
                for (int i = 0; i < n; ++i) {
                    this.statements[i].traverse(aSTVisitor, this.scope);
                }
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    @Override
    public void branchChainTo(BranchLabel branchLabel) {
        if (this.breakLabel.forwardReferenceCount > 0) {
            branchLabel.appendForwardReferencesFrom(this.breakLabel);
        }
    }
}

