/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.Javadoc;
import org.eclipse.jdt.internal.compiler.ast.StringLiteral;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.ImportBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.parser.NLSTag;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilationUnit;
import org.eclipse.jdt.internal.compiler.problem.AbortMethod;
import org.eclipse.jdt.internal.compiler.problem.AbortType;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.compiler.problem.ProblemSeverities;

public class CompilationUnitDeclaration
extends ASTNode
implements ProblemSeverities,
ReferenceContext {
    private static final Comparator STRING_LITERAL_COMPARATOR = new Comparator(){

        public int compare(Object object, Object object2) {
            StringLiteral stringLiteral = (StringLiteral)object;
            StringLiteral stringLiteral2 = (StringLiteral)object2;
            return stringLiteral.sourceStart - stringLiteral2.sourceStart;
        }
    };
    private static final int STRING_LITERALS_INCREMENT = 10;
    public ImportReference currentPackage;
    public ImportReference[] imports;
    public TypeDeclaration[] types;
    public int[][] comments;
    public boolean ignoreFurtherInvestigation = false;
    public boolean ignoreMethodBodies = false;
    public CompilationUnitScope scope;
    public ProblemReporter problemReporter;
    public CompilationResult compilationResult;
    public LocalTypeBinding[] localTypes;
    public int localTypeCount = 0;
    public boolean isPropagatingInnerClassEmulation;
    public Javadoc javadoc;
    public NLSTag[] nlsTags;
    private StringLiteral[] stringLiterals;
    private int stringLiteralsPtr;

    public CompilationUnitDeclaration(ProblemReporter problemReporter, CompilationResult compilationResult, int n) {
        this.problemReporter = problemReporter;
        this.compilationResult = compilationResult;
        this.sourceStart = 0;
        this.sourceEnd = n - 1;
    }

    @Override
    public void abort(int n, CategorizedProblem categorizedProblem) {
        switch (n) {
            case 8: {
                throw new AbortType(this.compilationResult, categorizedProblem);
            }
            case 16: {
                throw new AbortMethod(this.compilationResult, categorizedProblem);
            }
        }
        throw new AbortCompilationUnit(this.compilationResult, categorizedProblem);
    }

    public void analyseCode() {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        try {
            if (this.types != null) {
                int n = this.types.length;
                for (int i = 0; i < n; ++i) {
                    this.types[i].analyseCode(this.scope);
                }
            }
            this.propagateInnerEmulationForAllLocalTypes();
        }
        catch (AbortCompilationUnit abortCompilationUnit) {
            this.ignoreFurtherInvestigation = true;
            return;
        }
    }

    public void cleanUp() {
        if (this.types != null) {
            int n;
            int n2 = this.types.length;
            for (n = 0; n < n2; ++n) {
                this.cleanUp(this.types[n]);
            }
            n2 = this.localTypeCount;
            for (n = 0; n < n2; ++n) {
                LocalTypeBinding localTypeBinding = this.localTypes[n];
                localTypeBinding.scope = null;
                localTypeBinding.enclosingCase = null;
            }
        }
        this.compilationResult.recoveryScannerData = null;
        for (ClassFile classFile : this.compilationResult.getClassFiles()) {
            classFile.referenceBinding = null;
            classFile.innerClassesBindings = null;
        }
    }

    private void cleanUp(TypeDeclaration typeDeclaration) {
        if (typeDeclaration.memberTypes != null) {
            int n = typeDeclaration.memberTypes.length;
            for (int i = 0; i < n; ++i) {
                this.cleanUp(typeDeclaration.memberTypes[i]);
            }
        }
        if (typeDeclaration.binding != null && typeDeclaration.binding.isAnnotationType()) {
            this.compilationResult.hasAnnotations = true;
        }
        if (typeDeclaration.binding != null) {
            typeDeclaration.binding.scope = null;
        }
    }

    public void checkUnusedImports() {
        if (this.scope.imports != null) {
            for (ImportBinding importBinding : this.scope.imports) {
                ImportReference importReference = importBinding.reference;
                if (importReference == null || importReference.used) continue;
                this.scope.problemReporter().unusedImport(importReference);
            }
        }
    }

    @Override
    public CompilationResult compilationResult() {
        return this.compilationResult;
    }

    public TypeDeclaration declarationOfType(char[][] cArray) {
        for (int i = 0; i < this.types.length; ++i) {
            TypeDeclaration typeDeclaration = this.types[i].declarationOfType(cArray);
            if (typeDeclaration == null) continue;
            return typeDeclaration;
        }
        return null;
    }

    public void generateCode() {
        if (this.ignoreFurtherInvestigation) {
            if (this.types != null) {
                int n = this.types.length;
                for (int i = 0; i < n; ++i) {
                    this.types[i].ignoreFurtherInvestigation = true;
                    this.types[i].generateCode(this.scope);
                }
            }
            return;
        }
        if (this.isPackageInfo() && this.types != null && this.currentPackage.annotations != null) {
            this.types[0].annotations = this.currentPackage.annotations;
        }
        try {
            if (this.types != null) {
                int n = this.types.length;
                for (int i = 0; i < n; ++i) {
                    this.types[i].generateCode(this.scope);
                }
            }
        }
        catch (AbortCompilationUnit abortCompilationUnit) {
            // empty catch block
        }
    }

    public char[] getFileName() {
        return this.compilationResult.getFileName();
    }

    public char[] getMainTypeName() {
        if (this.compilationResult.compilationUnit == null) {
            int n;
            char[] cArray = this.compilationResult.getFileName();
            int n2 = CharOperation.lastIndexOf('/', cArray) + 1;
            if (n2 == 0 || n2 < CharOperation.lastIndexOf('\\', cArray)) {
                n2 = CharOperation.lastIndexOf('\\', cArray) + 1;
            }
            if ((n = CharOperation.lastIndexOf('.', cArray)) == -1) {
                n = cArray.length;
            }
            return CharOperation.subarray(cArray, n2, n);
        }
        return this.compilationResult.compilationUnit.getMainTypeName();
    }

    public boolean isEmpty() {
        return this.currentPackage == null && this.imports == null && this.types == null;
    }

    public boolean isPackageInfo() {
        return CharOperation.equals(this.getMainTypeName(), TypeConstants.PACKAGE_INFO_NAME) && this.currentPackage != null && (this.currentPackage.annotations != null || this.javadoc != null);
    }

    @Override
    public boolean hasErrors() {
        return this.ignoreFurtherInvestigation;
    }

    @Override
    public StringBuffer print(int n, StringBuffer stringBuffer) {
        int n2;
        if (this.currentPackage != null) {
            CompilationUnitDeclaration.printIndent(n, stringBuffer).append("package ");
            this.currentPackage.print(0, stringBuffer, false).append(";\n");
        }
        if (this.imports != null) {
            for (n2 = 0; n2 < this.imports.length; ++n2) {
                CompilationUnitDeclaration.printIndent(n, stringBuffer).append("import ");
                this.imports[n2].print(0, stringBuffer).append(";\n");
            }
        }
        if (this.types != null) {
            for (n2 = 0; n2 < this.types.length; ++n2) {
                this.types[n2].print(n, stringBuffer).append("\n");
            }
        }
        return stringBuffer;
    }

    public void propagateInnerEmulationForAllLocalTypes() {
        this.isPropagatingInnerClassEmulation = true;
        int n = this.localTypeCount;
        for (int i = 0; i < n; ++i) {
            LocalTypeBinding localTypeBinding = this.localTypes[i];
            if ((localTypeBinding.scope.referenceType().bits & Integer.MIN_VALUE) == 0) continue;
            localTypeBinding.updateInnerEmulationDependents();
        }
    }

    public void recordStringLiteral(StringLiteral stringLiteral) {
        if (this.stringLiterals == null) {
            this.stringLiterals = new StringLiteral[10];
            this.stringLiteralsPtr = 0;
        } else {
            int n = this.stringLiterals.length;
            if (this.stringLiteralsPtr == n) {
                this.stringLiterals = new StringLiteral[n + 10];
                System.arraycopy(this.stringLiterals, 0, this.stringLiterals, 0, n);
            }
        }
        this.stringLiterals[this.stringLiteralsPtr++] = stringLiteral;
    }

    public void record(LocalTypeBinding localTypeBinding) {
        if (this.localTypeCount == 0) {
            this.localTypes = new LocalTypeBinding[5];
        } else if (this.localTypeCount == this.localTypes.length) {
            this.localTypes = new LocalTypeBinding[this.localTypeCount * 2];
            System.arraycopy(this.localTypes, 0, this.localTypes, 0, this.localTypeCount);
        }
        this.localTypes[this.localTypeCount++] = localTypeBinding;
    }

    public void resolve() {
        int n = 0;
        boolean bl = this.isPackageInfo();
        if (this.types != null && bl) {
            TypeDeclaration typeDeclaration = this.types[0];
            typeDeclaration.javadoc = new Javadoc(typeDeclaration.declarationSourceStart, typeDeclaration.declarationSourceStart);
            typeDeclaration.resolve(this.scope);
            if (this.currentPackage.annotations != null) {
                CompilationUnitDeclaration.resolveAnnotations(typeDeclaration.staticInitializerScope, this.currentPackage.annotations, this.scope.fPackage);
            }
            if (this.javadoc != null) {
                this.javadoc.resolve(typeDeclaration.staticInitializerScope);
            }
            n = 1;
        }
        if (this.currentPackage != null && this.currentPackage.annotations != null && !bl) {
            this.scope.problemReporter().invalidFileNameForPackageAnnotations(this.currentPackage.annotations[0]);
        }
        try {
            if (this.types != null) {
                int n2 = this.types.length;
                for (int i = n; i < n2; ++i) {
                    this.types[i].resolve(this.scope);
                }
            }
            if (!this.compilationResult.hasErrors()) {
                this.checkUnusedImports();
            }
            this.reportNLSProblems();
        }
        catch (AbortCompilationUnit abortCompilationUnit) {
            this.ignoreFurtherInvestigation = true;
            return;
        }
    }

    private void reportNLSProblems() {
        block20: {
            int n;
            int n2;
            block21: {
                if (this.nlsTags == null && this.stringLiterals == null) break block20;
                n2 = this.stringLiteralsPtr;
                int n3 = n = this.nlsTags == null ? 0 : this.nlsTags.length;
                if (n2 != 0) break block21;
                if (n == 0) break block20;
                for (int i = 0; i < n; ++i) {
                    NLSTag nLSTag = this.nlsTags[i];
                    if (nLSTag == null) continue;
                    this.scope.problemReporter().unnecessaryNLSTags(nLSTag.start, nLSTag.end);
                }
                break block20;
            }
            if (n == 0) {
                if (this.stringLiterals.length != n2) {
                    this.stringLiterals = new StringLiteral[n2];
                    System.arraycopy(this.stringLiterals, 0, this.stringLiterals, 0, n2);
                }
                Arrays.sort(this.stringLiterals, STRING_LITERAL_COMPARATOR);
                for (int i = 0; i < n2; ++i) {
                    this.scope.problemReporter().nonExternalizedStringLiteral(this.stringLiterals[i]);
                }
            } else {
                int n4;
                if (this.stringLiterals.length != n2) {
                    this.stringLiterals = new StringLiteral[n2];
                    System.arraycopy(this.stringLiterals, 0, this.stringLiterals, 0, n2);
                }
                Arrays.sort(this.stringLiterals, STRING_LITERAL_COMPARATOR);
                int n5 = 1;
                int n6 = -1;
                StringLiteral stringLiteral = null;
                int n7 = 0;
                block2: for (n4 = 0; n4 < n2; ++n4) {
                    stringLiteral = this.stringLiterals[n4];
                    int n8 = stringLiteral.lineNumber;
                    if (n6 != n8) {
                        n5 = 1;
                        n6 = n8;
                    } else {
                        ++n5;
                    }
                    if (n7 >= n) break;
                    while (n7 < n) {
                        NLSTag nLSTag = this.nlsTags[n7];
                        if (nLSTag != null) {
                            int n9 = nLSTag.lineNumber;
                            if (n8 < n9) {
                                this.scope.problemReporter().nonExternalizedStringLiteral(stringLiteral);
                                continue block2;
                            }
                            if (n8 == n9) {
                                if (nLSTag.index == n5) {
                                    this.nlsTags[n7] = null;
                                    ++n7;
                                    continue block2;
                                }
                                for (int i = n7 + 1; i < n; ++i) {
                                    NLSTag nLSTag2 = this.nlsTags[i];
                                    if (nLSTag2 == null) continue;
                                    int n10 = nLSTag2.lineNumber;
                                    if (n8 == n10) {
                                        if (nLSTag2.index != n5) continue;
                                        this.nlsTags[i] = null;
                                        continue block2;
                                    }
                                    this.scope.problemReporter().nonExternalizedStringLiteral(stringLiteral);
                                    continue block2;
                                }
                                this.scope.problemReporter().nonExternalizedStringLiteral(stringLiteral);
                                continue block2;
                            }
                            this.scope.problemReporter().unnecessaryNLSTags(nLSTag.start, nLSTag.end);
                        }
                        ++n7;
                    }
                    break block2;
                }
                while (n4 < n2) {
                    this.scope.problemReporter().nonExternalizedStringLiteral(this.stringLiterals[n4]);
                    ++n4;
                }
                if (n7 < n) {
                    while (n7 < n) {
                        NLSTag nLSTag = this.nlsTags[n7];
                        if (nLSTag != null) {
                            this.scope.problemReporter().unnecessaryNLSTags(nLSTag.start, nLSTag.end);
                        }
                        ++n7;
                    }
                }
            }
        }
    }

    @Override
    public void tagAsHavingErrors() {
        this.ignoreFurtherInvestigation = true;
    }

    public void traverse(ASTVisitor aSTVisitor, CompilationUnitScope compilationUnitScope) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        try {
            if (aSTVisitor.visit(this, this.scope)) {
                int n;
                int n2;
                if (this.currentPackage != null) {
                    this.currentPackage.traverse(aSTVisitor, this.scope);
                }
                if (this.imports != null) {
                    n2 = this.imports.length;
                    for (n = 0; n < n2; ++n) {
                        this.imports[n].traverse(aSTVisitor, this.scope);
                    }
                }
                if (this.types != null) {
                    n2 = this.types.length;
                    for (n = 0; n < n2; ++n) {
                        this.types[n].traverse(aSTVisitor, this.scope);
                    }
                }
            }
            aSTVisitor.endVisit(this, this.scope);
        }
        catch (AbortCompilationUnit abortCompilationUnit) {
            // empty catch block
        }
    }
}

