/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.eclipse.jdt.internal.compiler.ast.OperatorExpression;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedGenericMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class CastExpression
extends Expression {
    public Expression expression;
    public Expression type;
    public TypeBinding expectedType;

    public CastExpression(Expression expression, Expression expression2) {
        this.expression = expression;
        this.type = expression2;
        expression2.bits |= 0x40000000;
    }

    @Override
    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        return this.expression.analyseCode(blockScope, flowContext, flowInfo).unconditionalInits();
    }

    public static void checkNeedForAssignedCast(BlockScope blockScope, TypeBinding typeBinding, CastExpression castExpression) {
        if (blockScope.compilerOptions().getSeverity(0x4000000L) == -1) {
            return;
        }
        TypeBinding typeBinding2 = castExpression.expression.resolvedType;
        if (typeBinding2 == null || castExpression.resolvedType.isBaseType()) {
            return;
        }
        if (typeBinding2.isCompatibleWith(typeBinding)) {
            blockScope.problemReporter().unnecessaryCast(castExpression);
        }
    }

    public static void checkNeedForEnclosingInstanceCast(BlockScope blockScope, Expression expression, TypeBinding typeBinding, TypeBinding typeBinding2) {
        if (blockScope.compilerOptions().getSeverity(0x4000000L) == -1) {
            return;
        }
        TypeBinding typeBinding3 = ((CastExpression)expression).expression.resolvedType;
        if (typeBinding3 == null) {
            return;
        }
        if (typeBinding3 == typeBinding) {
            blockScope.problemReporter().unnecessaryCast((CastExpression)expression);
        } else {
            if (typeBinding3 == TypeBinding.NULL) {
                return;
            }
            TypeBinding typeBinding4 = typeBinding3;
            if (typeBinding3.isBaseType() || typeBinding3.isArrayType()) {
                return;
            }
            if (typeBinding2 == blockScope.getMemberType(typeBinding2.sourceName(), (ReferenceBinding)typeBinding4)) {
                blockScope.problemReporter().unnecessaryCast((CastExpression)expression);
            }
        }
    }

    public static void checkNeedForArgumentCast(BlockScope blockScope, int n, int n2, Expression expression, int n3) {
        if (blockScope.compilerOptions().getSeverity(0x4000000L) == -1) {
            return;
        }
        int n4 = n3;
        if ((expression.bits & 0x4000) == 0 && expression.resolvedType.isBaseType()) {
            return;
        }
        TypeBinding typeBinding = ((CastExpression)expression).expression.resolvedType;
        if (typeBinding == null) {
            return;
        }
        n4 = typeBinding.id;
        if (n4 == n3) {
            blockScope.problemReporter().unnecessaryCast((CastExpression)expression);
            return;
        }
        if (n4 == 12) {
            n4 = n3;
            return;
        }
    }

    public static void checkNeedForArgumentCasts(BlockScope blockScope, Expression expression, TypeBinding typeBinding, MethodBinding methodBinding, Expression[] expressionArray, TypeBinding[] typeBindingArray, InvocationSite invocationSite) {
        if (blockScope.compilerOptions().getSeverity(0x4000000L) == -1) {
            return;
        }
        int n = typeBindingArray.length;
        TypeBinding[] typeBindingArray2 = typeBindingArray;
        for (int i = 0; i < n; ++i) {
            Expression expression2 = expressionArray[i];
            if (!(expression2 instanceof CastExpression) || (expression2.bits & 0x4000) == 0 && expression2.resolvedType.isBaseType()) continue;
            TypeBinding typeBinding2 = ((CastExpression)expression2).expression.resolvedType;
            if (typeBinding2 == null) {
                return;
            }
            if (typeBinding2 == typeBindingArray[i]) {
                blockScope.problemReporter().unnecessaryCast((CastExpression)expression2);
                continue;
            }
            if (typeBinding2 == TypeBinding.NULL || (expression2.implicitConversion & 0x200) != 0) continue;
            if (typeBindingArray2 == typeBindingArray) {
                TypeBinding[] typeBindingArray3 = typeBindingArray2;
                typeBindingArray2 = new TypeBinding[n];
                System.arraycopy(typeBindingArray3, 0, typeBindingArray2, 0, n);
            }
            typeBindingArray2[i] = typeBinding2;
        }
        if (typeBindingArray2 != typeBindingArray) {
            CastExpression.checkAlternateBinding(blockScope, expression, typeBinding, methodBinding, expressionArray, typeBindingArray, typeBindingArray2, invocationSite);
        }
    }

    public static void checkNeedForArgumentCasts(BlockScope blockScope, int n, int n2, Expression expression, int n3, boolean bl, Expression expression2, int n4, boolean bl2) {
        if (blockScope.compilerOptions().getSeverity(0x4000000L) == -1) {
            return;
        }
        int n5 = n3;
        if (bl) {
            if ((expression.bits & 0x4000) == 0 && expression.resolvedType.isBaseType()) {
                bl = false;
            } else {
                TypeBinding typeBinding = ((CastExpression)expression).expression.resolvedType;
                if (typeBinding == null) {
                    return;
                }
                n5 = typeBinding.id;
                if (n5 == n3) {
                    blockScope.problemReporter().unnecessaryCast((CastExpression)expression);
                    bl = false;
                } else if (n5 == 12) {
                    n5 = n3;
                    bl = false;
                }
            }
        }
        int n6 = n4;
        if (bl2) {
            if ((expression2.bits & 0x4000) == 0 && expression2.resolvedType.isBaseType()) {
                bl2 = false;
            } else {
                TypeBinding typeBinding = ((CastExpression)expression2).expression.resolvedType;
                if (typeBinding == null) {
                    return;
                }
                n6 = typeBinding.id;
                if (n6 == n4) {
                    blockScope.problemReporter().unnecessaryCast((CastExpression)expression2);
                    bl2 = false;
                } else if (n6 == 12) {
                    n6 = n4;
                    bl2 = false;
                }
            }
        }
        if (bl || bl2) {
            int n7;
            if (n5 > 15 || n6 > 15) {
                if (n5 == 11) {
                    n6 = 1;
                } else if (n6 == 11) {
                    n5 = 1;
                } else {
                    return;
                }
            }
            if ((n2 & 0xF0F0F) == ((n7 = OperatorExpression.OperatorSignatures[n][(n5 << 4) + n6]) & 0xF0F0F)) {
                if (bl) {
                    blockScope.problemReporter().unnecessaryCast((CastExpression)expression);
                }
                if (bl2) {
                    blockScope.problemReporter().unnecessaryCast((CastExpression)expression2);
                }
            }
        }
    }

    private static void checkAlternateBinding(BlockScope blockScope, Expression expression, TypeBinding typeBinding, MethodBinding methodBinding, Expression[] expressionArray, TypeBinding[] typeBindingArray, TypeBinding[] typeBindingArray2, final InvocationSite invocationSite) {
        MethodBinding methodBinding2;
        InvocationSite invocationSite2 = new InvocationSite(){

            @Override
            public TypeBinding[] genericTypeArguments() {
                return null;
            }

            @Override
            public boolean isSuperAccess() {
                return invocationSite.isSuperAccess();
            }

            @Override
            public boolean isTypeAccess() {
                return invocationSite.isTypeAccess();
            }

            @Override
            public void setActualReceiverType(ReferenceBinding referenceBinding) {
            }

            @Override
            public void setDepth(int n) {
            }

            @Override
            public void setFieldIndex(int n) {
            }

            @Override
            public int sourceStart() {
                return 0;
            }

            @Override
            public int sourceEnd() {
                return 0;
            }
        };
        if (methodBinding.isConstructor()) {
            methodBinding2 = blockScope.getConstructor((ReferenceBinding)typeBinding, typeBindingArray2, invocationSite2);
        } else {
            MethodBinding methodBinding3 = methodBinding2 = expression.isImplicitThis() ? blockScope.getImplicitMethod(methodBinding.selector, typeBindingArray2, invocationSite2) : blockScope.getMethod(typeBinding, methodBinding.selector, typeBindingArray2, invocationSite2);
        }
        if (methodBinding2 == methodBinding) {
            int n;
            int n2 = typeBindingArray.length;
            if (methodBinding.isVarargs() && (n = methodBinding.parameters.length) == n2) {
                int n3 = n - 1;
                ArrayBinding arrayBinding = (ArrayBinding)methodBinding.parameters[n3];
                TypeBinding typeBinding2 = typeBindingArray2[n3];
                if (arrayBinding.dimensions != typeBinding2.dimensions()) {
                    return;
                }
                if (typeBinding2.isCompatibleWith(arrayBinding.elementsType()) && typeBinding2.isCompatibleWith(arrayBinding)) {
                    return;
                }
            }
            for (n = 0; n < n2; ++n) {
                if (typeBindingArray[n] == typeBindingArray2[n]) continue;
                blockScope.problemReporter().unnecessaryCast((CastExpression)expressionArray[n]);
            }
        }
    }

    @Override
    public boolean checkUnsafeCast(Scope scope, TypeBinding typeBinding, TypeBinding typeBinding2, TypeBinding typeBinding3, boolean bl) {
        boolean bl2;
        if (typeBinding3 == typeBinding) {
            if (!bl && typeBinding3 == this.resolvedType.leafComponentType()) {
                this.tagAsUnnecessaryCast(scope, typeBinding);
            }
            return true;
        }
        if (typeBinding3 != null && ((bl2 = typeBinding.isBoundParameterizedType()) || typeBinding2.isBoundParameterizedType())) {
            if (typeBinding3.isProvablyDistinctFrom(bl ? typeBinding2 : typeBinding, 0)) {
                return false;
            }
            if (bl2 && (bl ? !typeBinding2.isEquivalentTo(typeBinding3) : !typeBinding3.isEquivalentTo(typeBinding))) {
                this.bits |= 0x80;
                return true;
            }
            if ((typeBinding.tagBits & 0x40000000L) == 0L && (!typeBinding3.isParameterizedType() || typeBinding2.isRawType())) {
                this.bits |= 0x80;
                return true;
            }
        } else if (bl) {
            TypeBinding typeBinding4 = typeBinding.leafComponentType();
            if (typeBinding2.id == 1 && typeBinding.isArrayType() && typeBinding4.isBoundParameterizedType()) {
                this.bits |= 0x80;
                return true;
            }
            if (typeBinding4.isTypeVariable()) {
                this.bits |= 0x80;
                return true;
            }
        }
        if (!bl && typeBinding3 == this.resolvedType.leafComponentType()) {
            this.tagAsUnnecessaryCast(scope, typeBinding);
        }
        return true;
    }

    @Override
    public void generateCode(BlockScope blockScope, CodeStream codeStream, boolean bl) {
        boolean bl2;
        int n = codeStream.position;
        boolean bl3 = bl2 = (this.bits & 0x40) != 0;
        if (this.constant != Constant.NotAConstant) {
            if (bl || bl2) {
                codeStream.generateConstant(this.constant, this.implicitConversion);
                if (bl2) {
                    codeStream.checkcast(this.resolvedType);
                }
                if (!bl) {
                    codeStream.pop();
                }
            }
            codeStream.recordPositionsFrom(n, this.sourceStart);
            return;
        }
        this.expression.generateCode(blockScope, codeStream, bl || bl2);
        if (bl2 && this.expression.postConversionType(blockScope) != this.resolvedType) {
            codeStream.checkcast(this.resolvedType);
        }
        if (bl) {
            codeStream.generateImplicitConversion(this.implicitConversion);
        } else if (bl2) {
            codeStream.pop();
        }
        codeStream.recordPositionsFrom(n, this.sourceStart);
    }

    public Expression innermostCastedExpression() {
        Expression expression = this.expression;
        while (expression instanceof CastExpression) {
            expression = ((CastExpression)expression).expression;
        }
        return expression;
    }

    @Override
    public LocalVariableBinding localVariableBinding() {
        return this.expression.localVariableBinding();
    }

    @Override
    public int nullStatus(FlowInfo flowInfo) {
        return this.expression.nullStatus(flowInfo);
    }

    @Override
    public Constant optimizedBooleanConstant() {
        switch (this.resolvedType.id) {
            case 5: 
            case 33: {
                return this.expression.optimizedBooleanConstant();
            }
        }
        return Constant.NotAConstant;
    }

    @Override
    public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
        stringBuffer.append('(');
        this.type.print(0, stringBuffer).append(") ");
        return this.expression.printExpression(0, stringBuffer);
    }

    @Override
    public TypeBinding resolveType(BlockScope blockScope) {
        this.constant = Constant.NotAConstant;
        this.implicitConversion = 0;
        if (this.type instanceof TypeReference || this.type instanceof NameReference && (this.type.bits & 0x1FE00000) >> 21 == 0) {
            TypeBinding typeBinding = this.resolvedType = this.type.resolveType(blockScope);
            TypeBinding typeBinding2 = this.expression.resolveType(blockScope);
            if (typeBinding != null) {
                if (typeBinding2 != null) {
                    boolean bl = this.checkCastTypesCompatibility(blockScope, typeBinding, typeBinding2, this.expression);
                    if (bl) {
                        this.expression.computeConversion(blockScope, typeBinding, typeBinding2);
                        if ((this.bits & 0x80) != 0) {
                            blockScope.problemReporter().unsafeCast(this, blockScope);
                        } else if ((this.bits & 0x4020) == 16384 && !this.isIndirectlyUsed()) {
                            blockScope.problemReporter().unnecessaryCast(this);
                        }
                    } else {
                        blockScope.problemReporter().typeCastError(this, typeBinding, typeBinding2);
                        this.bits |= 0x20;
                    }
                }
                this.resolvedType = typeBinding.capture(blockScope, this.sourceEnd);
            }
            return this.resolvedType;
        }
        TypeBinding typeBinding = this.expression.resolveType(blockScope);
        if (typeBinding == null) {
            return null;
        }
        blockScope.problemReporter().invalidTypeReference(this.type);
        return null;
    }

    @Override
    public void setExpectedType(TypeBinding typeBinding) {
        this.expectedType = typeBinding;
    }

    private boolean isIndirectlyUsed() {
        MethodBinding methodBinding;
        if (this.expression instanceof MessageSend && (methodBinding = ((MessageSend)this.expression).binding) instanceof ParameterizedGenericMethodBinding && ((ParameterizedGenericMethodBinding)methodBinding).inferredReturnType) {
            if (this.expectedType == null) {
                return true;
            }
            if (this.resolvedType != this.expectedType) {
                return true;
            }
        }
        return this.expectedType != null && this.resolvedType.isBaseType() && !this.resolvedType.isCompatibleWith(this.expectedType);
    }

    @Override
    public void tagAsNeedCheckCast() {
        this.bits |= 0x40;
    }

    @Override
    public void tagAsUnnecessaryCast(Scope scope, TypeBinding typeBinding) {
        if (this.expression.resolvedType == null) {
            return;
        }
        this.bits |= 0x4000;
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            this.type.traverse(aSTVisitor, blockScope);
            this.expression.traverse(aSTVisitor, blockScope);
        }
        aSTVisitor.endVisit(this, blockScope);
    }
}

