/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.digester;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.Rule;
import org.apache.commons.digester.Rules;
import org.apache.commons.logging.Log;
import org.xml.sax.Attributes;

public class SetNestedPropertiesRule
extends Rule {
    private Log log = null;
    private boolean trimData = true;
    private boolean allowUnknownChildElements = false;
    private HashMap elementNames = new HashMap();

    public SetNestedPropertiesRule() {
    }

    public SetNestedPropertiesRule(String string, String string2) {
        this.elementNames.put(string, string2);
    }

    public SetNestedPropertiesRule(String[] stringArray, String[] stringArray2) {
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string = null;
            if (i < stringArray2.length) {
                string = stringArray2[i];
            }
            this.elementNames.put(stringArray[i], string);
        }
    }

    @Override
    public void setDigester(Digester digester) {
        super.setDigester(digester);
        this.log = digester.getLogger();
    }

    public void setTrimData(boolean bl) {
        this.trimData = bl;
    }

    public boolean getTrimData() {
        return this.trimData;
    }

    public void setAllowUnknownChildElements(boolean bl) {
        this.allowUnknownChildElements = bl;
    }

    public boolean getAllowUnknownChildElements() {
        return this.allowUnknownChildElements;
    }

    @Override
    public void begin(String string, String string2, Attributes attributes) throws Exception {
        Rules rules = this.digester.getRules();
        AnyChildRule anyChildRule = new AnyChildRule();
        anyChildRule.setDigester(this.digester);
        AnyChildRules anyChildRules = new AnyChildRules(anyChildRule);
        anyChildRules.init(this.digester.getMatch() + "/", rules);
        this.digester.setRules(anyChildRules);
    }

    @Override
    public void body(String string) throws Exception {
        AnyChildRules anyChildRules = (AnyChildRules)this.digester.getRules();
        this.digester.setRules(anyChildRules.getOldRules());
    }

    public void addAlias(String string, String string2) {
        this.elementNames.put(string, string2);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("SetNestedPropertiesRule[");
        stringBuffer.append("allowUnknownChildElements=");
        stringBuffer.append(this.allowUnknownChildElements);
        stringBuffer.append(", trimData=");
        stringBuffer.append(this.trimData);
        stringBuffer.append(", elementNames=");
        stringBuffer.append(this.elementNames);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private class AnyChildRule
    extends Rule {
        private String currChildNamespaceURI = null;
        private String currChildElementName = null;

        private AnyChildRule() {
        }

        @Override
        public void begin(String string, String string2, Attributes attributes) throws Exception {
            this.currChildNamespaceURI = string;
            this.currChildElementName = string2;
        }

        @Override
        public void body(String string) throws Exception {
            Object object;
            String string2 = this.currChildElementName;
            if (SetNestedPropertiesRule.this.elementNames.containsKey(this.currChildElementName) && (string2 = (String)SetNestedPropertiesRule.this.elementNames.get(this.currChildElementName)) == null) {
                return;
            }
            boolean bl = SetNestedPropertiesRule.this.log.isDebugEnabled();
            if (bl) {
                SetNestedPropertiesRule.this.log.debug("[SetNestedPropertiesRule]{" + this.digester.match + "} Setting property '" + string2 + "' to '" + string + "'");
            }
            Object object2 = this.digester.peek();
            if (bl) {
                if (object2 != null) {
                    SetNestedPropertiesRule.this.log.debug("[SetNestedPropertiesRule]{" + this.digester.match + "} Set " + object2.getClass().getName() + " properties");
                } else {
                    SetNestedPropertiesRule.this.log.debug("[SetPropertiesRule]{" + this.digester.match + "} Set NULL properties");
                }
            }
            if (SetNestedPropertiesRule.this.trimData) {
                string = string.trim();
            }
            if (!SetNestedPropertiesRule.this.allowUnknownChildElements && (object2 instanceof DynaBean ? (object = ((DynaBean)object2).getDynaClass().getDynaProperty(string2)) == null : (object = PropertyUtils.getPropertyDescriptor(object2, string2)) == null)) {
                throw new NoSuchMethodException("Bean has no property named " + string2);
            }
            try {
                BeanUtils.setProperty(object2, string2, string);
            }
            catch (NullPointerException nullPointerException) {
                SetNestedPropertiesRule.this.log.error("NullPointerException: top=" + object2 + ",propName=" + string2 + ",value=" + string + "!");
                throw nullPointerException;
            }
        }

        @Override
        public void end(String string, String string2) throws Exception {
            this.currChildElementName = null;
        }
    }

    private class AnyChildRules
    implements Rules {
        private String matchPrefix = null;
        private Rules decoratedRules = null;
        private ArrayList rules = new ArrayList(1);
        private AnyChildRule rule;

        public AnyChildRules(AnyChildRule anyChildRule) {
            this.rule = anyChildRule;
            this.rules.add(anyChildRule);
        }

        @Override
        public Digester getDigester() {
            return null;
        }

        @Override
        public void setDigester(Digester digester) {
        }

        @Override
        public String getNamespaceURI() {
            return null;
        }

        @Override
        public void setNamespaceURI(String string) {
        }

        @Override
        public void add(String string, Rule rule) {
        }

        @Override
        public void clear() {
        }

        @Override
        public List match(String string) {
            return this.match(null, string);
        }

        @Override
        public List match(String string, String string2) {
            List list = this.decoratedRules.match(string, string2);
            if (string2.startsWith(this.matchPrefix) && string2.indexOf(47, this.matchPrefix.length()) == -1) {
                if (list == null || list.size() == 0) {
                    return this.rules;
                }
                LinkedList<AnyChildRule> linkedList = new LinkedList<AnyChildRule>(list);
                linkedList.addLast(this.rule);
                return linkedList;
            }
            return list;
        }

        @Override
        public List rules() {
            SetNestedPropertiesRule.this.log.debug("AnyChildRules.rules invoked.");
            return this.decoratedRules.rules();
        }

        public void init(String string, Rules rules) {
            this.matchPrefix = string;
            this.decoratedRules = rules;
        }

        public Rules getOldRules() {
            return this.decoratedRules;
        }
    }
}

