/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.xml;

import java.awt.Color;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import net.sf.jasperreports.charts.JRAreaPlot;
import net.sf.jasperreports.charts.JRBar3DPlot;
import net.sf.jasperreports.charts.JRBarPlot;
import net.sf.jasperreports.charts.JRBubblePlot;
import net.sf.jasperreports.charts.JRCandlestickPlot;
import net.sf.jasperreports.charts.JRCategoryDataset;
import net.sf.jasperreports.charts.JRCategorySeries;
import net.sf.jasperreports.charts.JRChartAxis;
import net.sf.jasperreports.charts.JRDataRange;
import net.sf.jasperreports.charts.JRHighLowDataset;
import net.sf.jasperreports.charts.JRHighLowPlot;
import net.sf.jasperreports.charts.JRLinePlot;
import net.sf.jasperreports.charts.JRMeterPlot;
import net.sf.jasperreports.charts.JRMultiAxisPlot;
import net.sf.jasperreports.charts.JRPie3DPlot;
import net.sf.jasperreports.charts.JRPieDataset;
import net.sf.jasperreports.charts.JRScatterPlot;
import net.sf.jasperreports.charts.JRThermometerPlot;
import net.sf.jasperreports.charts.JRTimePeriodDataset;
import net.sf.jasperreports.charts.JRTimePeriodSeries;
import net.sf.jasperreports.charts.JRTimeSeries;
import net.sf.jasperreports.charts.JRTimeSeriesDataset;
import net.sf.jasperreports.charts.JRTimeSeriesPlot;
import net.sf.jasperreports.charts.JRValueDataset;
import net.sf.jasperreports.charts.JRValueDisplay;
import net.sf.jasperreports.charts.JRXyDataset;
import net.sf.jasperreports.charts.JRXySeries;
import net.sf.jasperreports.charts.JRXyzDataset;
import net.sf.jasperreports.charts.JRXyzSeries;
import net.sf.jasperreports.charts.util.JRMeterInterval;
import net.sf.jasperreports.crosstabs.JRCellContents;
import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.crosstabs.JRCrosstabBucket;
import net.sf.jasperreports.crosstabs.JRCrosstabCell;
import net.sf.jasperreports.crosstabs.JRCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabDataset;
import net.sf.jasperreports.crosstabs.JRCrosstabMeasure;
import net.sf.jasperreports.crosstabs.JRCrosstabParameter;
import net.sf.jasperreports.crosstabs.JRCrosstabRowGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRChartDataset;
import net.sf.jasperreports.engine.JRChartPlot;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRConditionalStyle;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRDatasetParameter;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementDataset;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JREllipse;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRFrame;
import net.sf.jasperreports.engine.JRGraphicElement;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRHyperlink;
import net.sf.jasperreports.engine.JRHyperlinkParameter;
import net.sf.jasperreports.engine.JRImage;
import net.sf.jasperreports.engine.JRLine;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRQuery;
import net.sf.jasperreports.engine.JRRectangle;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JRReportFont;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRSortField;
import net.sf.jasperreports.engine.JRStaticText;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRSubreport;
import net.sf.jasperreports.engine.JRSubreportParameter;
import net.sf.jasperreports.engine.JRSubreportReturnValue;
import net.sf.jasperreports.engine.JRTextElement;
import net.sf.jasperreports.engine.JRTextField;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.util.JRXmlWriteHelper;
import net.sf.jasperreports.engine.xml.JRXmlConstants;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.time.Day;

public class JRXmlWriter {
    private JRReport report = null;
    private String encoding = null;
    private JRXmlWriteHelper writer;
    private Map fontsMap = new HashMap();
    private Map stylesMap = new HashMap();

    protected JRXmlWriter(JRReport jRReport, String string) {
        this.report = jRReport;
        this.encoding = string;
    }

    public static String writeReport(JRReport jRReport, String string) {
        JRXmlWriter jRXmlWriter = new JRXmlWriter(jRReport, string);
        StringWriter stringWriter = new StringWriter();
        try {
            jRXmlWriter.writeReport(stringWriter);
        }
        catch (IOException iOException) {
            throw new JRRuntimeException("Error writing report design.", iOException);
        }
        return stringWriter.toString();
    }

    public static void writeReport(JRReport jRReport, String string, String string2) throws JRException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(string);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, string2);
            JRXmlWriter jRXmlWriter = new JRXmlWriter(jRReport, string2);
            jRXmlWriter.writeReport(outputStreamWriter);
        }
        catch (IOException iOException) {
            throw new JRException("Error writing to file : " + string, iOException);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void writeReport(JRReport jRReport, OutputStream outputStream, String string) throws JRException {
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, string);
            JRXmlWriter jRXmlWriter = new JRXmlWriter(jRReport, string);
            jRXmlWriter.writeReport(outputStreamWriter);
        }
        catch (Exception exception) {
            throw new JRException("Error writing to OutputStream : " + jRReport.getName(), exception);
        }
    }

    protected void writeReport(Writer writer) throws IOException {
        JRDataset[] jRDatasetArray;
        JRStyle[] jRStyleArray;
        JRReportFont[] jRReportFontArray;
        this.writer = new JRXmlWriteHelper(writer);
        this.writer.writeProlog(this.encoding);
        this.writer.writePublicDoctype("jasperReport", "-//JasperReports//DTD Report Design//EN", "http://jasperreports.sourceforge.net/dtds/jasperreport.dtd");
        this.writer.startElement("jasperReport");
        this.writer.addAttribute("name", this.report.getName());
        this.writer.addAttribute("language", this.report.getLanguage(), "java");
        this.writer.addAttribute("columnCount", this.report.getColumnCount(), 1);
        this.writer.addAttribute("printOrder", this.report.getPrintOrder(), JRXmlConstants.getPrintOrderMap(), (byte)1);
        this.writer.addAttribute("pageWidth", this.report.getPageWidth());
        this.writer.addAttribute("pageHeight", this.report.getPageHeight());
        this.writer.addAttribute("orientation", this.report.getOrientation(), JRXmlConstants.getOrientationMap(), (byte)1);
        this.writer.addAttribute("whenNoDataType", this.report.getWhenNoDataType(), JRXmlConstants.getWhenNoDataTypeMap(), (byte)1);
        this.writer.addAttribute("columnWidth", this.report.getColumnWidth());
        this.writer.addAttribute("columnSpacing", this.report.getColumnSpacing(), 0);
        this.writer.addAttribute("leftMargin", this.report.getLeftMargin());
        this.writer.addAttribute("rightMargin", this.report.getRightMargin());
        this.writer.addAttribute("topMargin", this.report.getTopMargin());
        this.writer.addAttribute("bottomMargin", this.report.getBottomMargin());
        this.writer.addAttribute("isTitleNewPage", this.report.isTitleNewPage(), false);
        this.writer.addAttribute("isSummaryNewPage", this.report.isSummaryNewPage(), false);
        this.writer.addAttribute("isFloatColumnFooter", this.report.isFloatColumnFooter(), false);
        this.writer.addAttribute("scriptletClass", this.report.getScriptletClass());
        this.writer.addAttribute("formatFactoryClass", this.report.getFormatFactoryClass());
        this.writer.addAttribute("resourceBundle", this.report.getResourceBundle());
        this.writer.addAttribute("whenResourceMissingType", this.report.getWhenResourceMissingType(), JRXmlConstants.getWhenResourceMissingTypeMap(), (byte)1);
        this.writer.addAttribute("isIgnorePagination", this.report.isIgnorePagination(), false);
        this.writeProperties(this.report.getPropertiesMap());
        String[] stringArray = this.report.getImports();
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                if (string == null) continue;
                this.writer.startElement("import");
                this.writer.addEncodedAttribute("value", string);
                this.writer.closeElement();
            }
        }
        if ((jRReportFontArray = this.report.getFonts()) != null && jRReportFontArray.length > 0) {
            for (int i = 0; i < jRReportFontArray.length; ++i) {
                this.fontsMap.put(jRReportFontArray[i].getName(), jRReportFontArray[i]);
                this.writeReportFont(jRReportFontArray[i]);
            }
        }
        if ((jRStyleArray = this.report.getStyles()) != null && jRStyleArray.length > 0) {
            for (int i = 0; i < jRStyleArray.length; ++i) {
                this.stylesMap.put(jRStyleArray[i].getName(), jRStyleArray[i]);
                this.writeStyle(jRStyleArray[i]);
            }
        }
        if ((jRDatasetArray = this.report.getDatasets()) != null && jRDatasetArray.length > 0) {
            for (int i = 0; i < jRDatasetArray.length; ++i) {
                this.writeDataset(jRDatasetArray[i]);
            }
        }
        this.writeDatasetContents(this.report.getMainDataset());
        if (this.report.getBackground() != null) {
            this.writer.startElement("background");
            this.writeBand(this.report.getBackground());
            this.writer.closeElement();
        }
        if (this.report.getTitle() != null) {
            this.writer.startElement("title");
            this.writeBand(this.report.getTitle());
            this.writer.closeElement();
        }
        if (this.report.getPageHeader() != null) {
            this.writer.startElement("pageHeader");
            this.writeBand(this.report.getPageHeader());
            this.writer.closeElement();
        }
        if (this.report.getColumnHeader() != null) {
            this.writer.startElement("columnHeader");
            this.writeBand(this.report.getColumnHeader());
            this.writer.closeElement();
        }
        if (this.report.getDetail() != null) {
            this.writer.startElement("detail");
            this.writeBand(this.report.getDetail());
            this.writer.closeElement();
        }
        if (this.report.getColumnFooter() != null) {
            this.writer.startElement("columnFooter");
            this.writeBand(this.report.getColumnFooter());
            this.writer.closeElement();
        }
        if (this.report.getPageFooter() != null) {
            this.writer.startElement("pageFooter");
            this.writeBand(this.report.getPageFooter());
            this.writer.closeElement();
        }
        if (this.report.getLastPageFooter() != null) {
            this.writer.startElement("lastPageFooter");
            this.writeBand(this.report.getLastPageFooter());
            this.writer.closeElement();
        }
        if (this.report.getSummary() != null) {
            this.writer.startElement("summary");
            this.writeBand(this.report.getSummary());
            this.writer.closeElement();
        }
        this.writer.closeElement();
        writer.flush();
    }

    private void writeProperties(JRPropertiesMap jRPropertiesMap) throws IOException {
        String[] stringArray = jRPropertiesMap.getPropertyNames();
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = jRPropertiesMap.getProperty(stringArray[i]);
                if (string == null) continue;
                this.writer.startElement("property");
                this.writer.addAttribute("name", stringArray[i]);
                this.writer.addEncodedAttribute("value", string);
                this.writer.closeElement();
            }
        }
    }

    private void writeReportFont(JRReportFont jRReportFont) throws IOException {
        this.writer.startElement("reportFont");
        this.writer.addAttribute("name", jRReportFont.getName());
        this.writer.addAttribute("isDefault", jRReportFont.isDefault());
        this.writer.addAttribute("fontName", jRReportFont.getFontName());
        this.writer.addAttribute("size", jRReportFont.getFontSize());
        this.writer.addAttribute("isBold", jRReportFont.isBold());
        this.writer.addAttribute("isItalic", jRReportFont.isItalic());
        this.writer.addAttribute("isUnderline", jRReportFont.isUnderline());
        this.writer.addAttribute("isStrikeThrough", jRReportFont.isStrikeThrough());
        this.writer.addAttribute("pdfFontName", jRReportFont.getPdfFontName());
        this.writer.addAttribute("pdfEncoding", jRReportFont.getPdfEncoding());
        this.writer.addAttribute("isPdfEmbedded", jRReportFont.isPdfEmbedded());
        this.writer.closeElement();
    }

    private void writeStyle(JRStyle jRStyle) throws IOException {
        JRConditionalStyle[] jRConditionalStyleArray;
        this.writer.startElement("style");
        this.writer.addAttribute("name", jRStyle.getName());
        this.writer.addAttribute("isDefault", jRStyle.isDefault());
        if (jRStyle.getStyle() != null) {
            jRConditionalStyleArray = (JRConditionalStyle[])this.stylesMap.get(jRStyle.getStyle().getName());
            if (jRConditionalStyleArray != null) {
                this.writer.addAttribute("style", jRStyle.getStyle().getName());
            } else {
                throw new JRRuntimeException("Referenced report style not found : " + jRStyle.getStyle().getName());
            }
        }
        this.writer.addAttribute("mode", jRStyle.getOwnMode(), JRXmlConstants.getModeMap());
        this.writer.addAttribute("forecolor", jRStyle.getOwnForecolor());
        this.writer.addAttribute("backcolor", jRStyle.getOwnBackcolor());
        this.writer.addAttribute("pen", jRStyle.getOwnPen(), JRXmlConstants.getPenMap());
        this.writer.addAttribute("fill", jRStyle.getOwnFill(), JRXmlConstants.getFillMap());
        this.writer.addAttribute("radius", jRStyle.getOwnRadius());
        this.writer.addAttribute("scaleImage", jRStyle.getOwnScaleImage(), JRXmlConstants.getScaleImageMap());
        this.writer.addAttribute("hAlign", jRStyle.getOwnHorizontalAlignment(), JRXmlConstants.getHorizontalAlignMap());
        this.writer.addAttribute("vAlign", jRStyle.getOwnVerticalAlignment(), JRXmlConstants.getVerticalAlignMap());
        this.writer.addAttribute("rotation", jRStyle.getOwnRotation(), JRXmlConstants.getRotationMap());
        this.writer.addAttribute("lineSpacing", jRStyle.getOwnLineSpacing(), JRXmlConstants.getLineSpacingMap());
        this.writer.addAttribute("isStyledText", jRStyle.isOwnStyledText());
        this.writer.addAttribute("pattern", jRStyle.getOwnPattern());
        this.writer.addAttribute("isBlankWhenNull", jRStyle.isOwnBlankWhenNull());
        this.writer.addAttribute("border", jRStyle.getOwnBorder(), JRXmlConstants.getPenMap());
        this.writer.addAttribute("borderColor", jRStyle.getOwnBorderColor());
        this.writer.addAttribute("padding", jRStyle.getOwnPadding());
        this.writer.addAttribute("topBorder", jRStyle.getOwnTopBorder(), JRXmlConstants.getPenMap());
        this.writer.addAttribute("topBorderColor", jRStyle.getOwnTopBorderColor());
        this.writer.addAttribute("topPadding", jRStyle.getOwnTopPadding());
        this.writer.addAttribute("leftBorder", jRStyle.getOwnLeftBorder(), JRXmlConstants.getPenMap());
        this.writer.addAttribute("leftBorderColor", jRStyle.getOwnLeftBorderColor());
        this.writer.addAttribute("leftPadding", jRStyle.getOwnLeftPadding());
        this.writer.addAttribute("bottomBorder", jRStyle.getOwnBottomBorder(), JRXmlConstants.getPenMap());
        this.writer.addAttribute("bottomBorderColor", jRStyle.getOwnBottomBorderColor());
        this.writer.addAttribute("bottomPadding", jRStyle.getOwnBottomPadding());
        this.writer.addAttribute("rightBorder", jRStyle.getOwnRightBorder(), JRXmlConstants.getPenMap());
        this.writer.addAttribute("rightBorderColor", jRStyle.getOwnRightBorderColor());
        this.writer.addAttribute("rightPadding", jRStyle.getOwnRightPadding());
        this.writer.addAttribute("fontName", jRStyle.getOwnFontName());
        this.writer.addAttribute("fontSize", jRStyle.getOwnFontSize());
        this.writer.addAttribute("isBold", jRStyle.isOwnBold());
        this.writer.addAttribute("isItalic", jRStyle.isOwnItalic());
        this.writer.addAttribute("isUnderline", jRStyle.isOwnUnderline());
        this.writer.addAttribute("isStrikeThrough", jRStyle.isOwnStrikeThrough());
        this.writer.addAttribute("pdfFontName", jRStyle.getOwnPdfFontName());
        this.writer.addAttribute("pdfEncoding", jRStyle.getOwnPdfEncoding());
        this.writer.addAttribute("isPdfEmbedded", jRStyle.isOwnPdfEmbedded());
        jRConditionalStyleArray = jRStyle.getConditionalStyles();
        if (!(jRStyle instanceof JRConditionalStyle) && jRConditionalStyleArray != null) {
            for (int i = 0; i < jRConditionalStyleArray.length; ++i) {
                this.writeConditionalStyle(jRConditionalStyleArray[i]);
            }
        }
        this.writer.closeElement();
    }

    private void writeConditionalStyle(JRConditionalStyle jRConditionalStyle) throws IOException {
        this.writer.startElement("conditionalStyle");
        this.writer.writeExpression("conditionExpression", jRConditionalStyle.getConditionExpression(), false);
        this.writeStyle(jRConditionalStyle);
        this.writer.closeElement();
    }

    private void writeParameter(JRParameter jRParameter) throws IOException {
        this.writer.startElement("parameter");
        this.writer.addAttribute("name", jRParameter.getName());
        this.writer.addAttribute("class", jRParameter.getValueClassName());
        this.writer.addAttribute("isForPrompting", jRParameter.isForPrompting(), true);
        this.writer.writeCDATAElement("parameterDescription", jRParameter.getDescription());
        this.writer.writeExpression("defaultValueExpression", jRParameter.getDefaultValueExpression(), false);
        this.writer.closeElement();
    }

    private void writeQuery(JRQuery jRQuery) throws IOException {
        this.writer.startElement("queryString");
        this.writer.addAttribute("language", jRQuery.getLanguage(), "sql");
        this.writer.writeCDATA(jRQuery.getText());
        this.writer.closeElement();
    }

    private void writeField(JRField jRField) throws IOException {
        this.writer.startElement("field");
        this.writer.addAttribute("name", jRField.getName());
        this.writer.addAttribute("class", jRField.getValueClassName());
        this.writer.writeCDATAElement("fieldDescription", jRField.getDescription());
        this.writer.closeElement();
    }

    private void writeSortField(JRSortField jRSortField) throws IOException {
        this.writer.startElement("sortField");
        this.writer.addAttribute("name", jRSortField.getName());
        this.writer.addAttribute("order", jRSortField.getOrder(), JRXmlConstants.getSortOrderMap(), (byte)0);
        this.writer.closeElement();
    }

    private void writeVariable(JRVariable jRVariable) throws IOException {
        this.writer.startElement("variable");
        this.writer.addAttribute("name", jRVariable.getName());
        this.writer.addAttribute("class", jRVariable.getValueClassName());
        this.writer.addAttribute("resetType", jRVariable.getResetType(), JRXmlConstants.getResetTypeMap(), (byte)1);
        if (jRVariable.getResetGroup() != null) {
            this.writer.addAttribute("resetGroup", jRVariable.getResetGroup().getName());
        }
        this.writer.addAttribute("incrementType", jRVariable.getIncrementType(), JRXmlConstants.getResetTypeMap(), (byte)5);
        if (jRVariable.getIncrementGroup() != null) {
            this.writer.addAttribute("incrementGroup", jRVariable.getIncrementGroup().getName());
        }
        this.writer.addAttribute("calculation", jRVariable.getCalculation(), JRXmlConstants.getCalculationMap(), (byte)0);
        this.writer.addAttribute("incrementerFactoryClass", jRVariable.getIncrementerFactoryClassName());
        this.writer.writeExpression("variableExpression", jRVariable.getExpression(), false);
        this.writer.writeExpression("initialValueExpression", jRVariable.getInitialValueExpression(), false);
        this.writer.closeElement();
    }

    private void writeGroup(JRGroup jRGroup) throws IOException {
        this.writer.startElement("group");
        this.writer.addAttribute("name", jRGroup.getName());
        this.writer.addAttribute("isStartNewColumn", jRGroup.isStartNewColumn(), false);
        this.writer.addAttribute("isStartNewPage", jRGroup.isStartNewPage(), false);
        this.writer.addAttribute("isResetPageNumber", jRGroup.isResetPageNumber(), false);
        this.writer.addAttribute("isReprintHeaderOnEachPage", jRGroup.isReprintHeaderOnEachPage(), false);
        this.writer.addAttributePositive("minHeightToStartNewPage", jRGroup.getMinHeightToStartNewPage());
        this.writer.writeExpression("groupExpression", jRGroup.getExpression(), false);
        if (jRGroup.getGroupHeader() != null) {
            this.writer.startElement("groupHeader");
            this.writeBand(jRGroup.getGroupHeader());
            this.writer.closeElement();
        }
        if (jRGroup.getGroupFooter() != null) {
            this.writer.startElement("groupFooter");
            this.writeBand(jRGroup.getGroupFooter());
            this.writer.closeElement();
        }
        this.writer.closeElement();
    }

    private void writeBand(JRBand jRBand) throws IOException {
        this.writer.startElement("band");
        this.writer.addAttributePositive("height", jRBand.getHeight());
        this.writer.addAttribute("isSplitAllowed", jRBand.isSplitAllowed(), true);
        this.writer.writeExpression("printWhenExpression", jRBand.getPrintWhenExpression(), false);
        List list = jRBand.getChildren();
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                ((JRChild)list.get(i)).writeXml(this);
            }
        }
        this.writer.closeElement();
    }

    public void writeElementGroup(JRElementGroup jRElementGroup) throws IOException {
        this.writer.startElement("elementGroup");
        List list = jRElementGroup.getChildren();
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                JRChild jRChild = (JRChild)list.get(i);
                jRChild.writeXml(this);
            }
        }
        this.writer.closeElement();
    }

    public void writeLine(JRLine jRLine) throws IOException {
        this.writer.startElement("line");
        this.writer.addAttribute("direction", jRLine.getDirection(), JRXmlConstants.getDirectionMap(), (byte)1);
        this.writeReportElement(jRLine);
        this.writeGraphicElement(jRLine);
        this.writer.closeElement();
    }

    private void writeReportElement(JRElement jRElement) throws IOException {
        this.writer.startElement("reportElement");
        this.writer.addAttribute("key", jRElement.getKey());
        JRStyle jRStyle = jRElement.getStyle();
        if (jRStyle != null) {
            this.writer.addAttribute("style", jRStyle.getName());
        }
        this.writer.addAttribute("positionType", jRElement.getPositionType(), JRXmlConstants.getPositionTypeMap(), (byte)2);
        this.writer.addAttribute("stretchType", jRElement.getStretchType(), JRXmlConstants.getStretchTypeMap(), (byte)0);
        this.writer.addAttribute("isPrintRepeatedValues", jRElement.isPrintRepeatedValues(), true);
        this.writer.addAttribute("mode", jRElement.getOwnMode(), JRXmlConstants.getModeMap());
        this.writer.addAttribute("x", jRElement.getX());
        this.writer.addAttribute("y", jRElement.getY());
        this.writer.addAttribute("width", jRElement.getWidth());
        this.writer.addAttribute("height", jRElement.getHeight());
        this.writer.addAttribute("isRemoveLineWhenBlank", jRElement.isRemoveLineWhenBlank(), false);
        this.writer.addAttribute("isPrintInFirstWholeBand", jRElement.isPrintInFirstWholeBand(), false);
        this.writer.addAttribute("isPrintWhenDetailOverflows", jRElement.isPrintWhenDetailOverflows(), false);
        if (jRElement.getPrintWhenGroupChanges() != null) {
            this.writer.addAttribute("printWhenGroupChanges", jRElement.getPrintWhenGroupChanges().getName());
        }
        this.writer.addAttribute("forecolor", jRElement.getOwnForecolor());
        this.writer.addAttribute("backcolor", jRElement.getOwnBackcolor());
        this.writer.writeExpression("printWhenExpression", jRElement.getPrintWhenExpression(), false);
        this.writer.closeElement();
    }

    private void writeGraphicElement(JRGraphicElement jRGraphicElement) throws IOException {
        this.writer.startElement("graphicElement");
        this.writer.addAttribute("pen", jRGraphicElement.getOwnPen(), JRXmlConstants.getPenMap());
        this.writer.addAttribute("fill", jRGraphicElement.getOwnFill(), JRXmlConstants.getFillMap());
        this.writer.closeElement();
    }

    public void writeRectangle(JRRectangle jRRectangle) throws IOException {
        this.writer.startElement("rectangle");
        this.writer.addAttribute("radius", jRRectangle.getOwnRadius());
        this.writeReportElement(jRRectangle);
        this.writeGraphicElement(jRRectangle);
        this.writer.closeElement();
    }

    public void writeEllipse(JREllipse jREllipse) throws IOException {
        this.writer.startElement("ellipse");
        this.writeReportElement(jREllipse);
        this.writeGraphicElement(jREllipse);
        this.writer.closeElement();
    }

    public void writeImage(JRImage jRImage) throws IOException {
        this.writer.startElement("image");
        this.writer.addAttribute("scaleImage", jRImage.getOwnScaleImage(), JRXmlConstants.getScaleImageMap());
        this.writer.addAttribute("hAlign", jRImage.getOwnHorizontalAlignment(), JRXmlConstants.getHorizontalAlignMap());
        this.writer.addAttribute("vAlign", jRImage.getOwnVerticalAlignment(), JRXmlConstants.getVerticalAlignMap());
        this.writer.addAttribute("isUsingCache", jRImage.isOwnUsingCache());
        this.writer.addAttribute("isLazy", jRImage.isLazy(), false);
        this.writer.addAttribute("onErrorType", jRImage.getOnErrorType(), JRXmlConstants.getOnErrorTypeMap(), (byte)1);
        this.writer.addAttribute("evaluationTime", jRImage.getEvaluationTime(), JRXmlConstants.getEvaluationTimeMap(), (byte)1);
        if (jRImage.getEvaluationGroup() != null) {
            this.writer.addAttribute("evaluationGroup", jRImage.getEvaluationGroup().getName());
        }
        this.writer.addAttribute("hyperlinkType", jRImage.getLinkType());
        this.writer.addAttribute("hyperlinkTarget", jRImage.getHyperlinkTarget(), JRXmlConstants.getHyperlinkTargetMap(), (byte)1);
        this.writer.addAttribute("bookmarkLevel", jRImage.getBookmarkLevel(), 0);
        this.writeReportElement(jRImage);
        this.writeBox(jRImage);
        this.writeGraphicElement(jRImage);
        this.writer.writeExpression("imageExpression", jRImage.getExpression(), true);
        this.writer.writeExpression("anchorNameExpression", jRImage.getAnchorNameExpression(), false);
        this.writer.writeExpression("hyperlinkReferenceExpression", jRImage.getHyperlinkReferenceExpression(), false);
        this.writer.writeExpression("hyperlinkAnchorExpression", jRImage.getHyperlinkAnchorExpression(), false);
        this.writer.writeExpression("hyperlinkPageExpression", jRImage.getHyperlinkPageExpression(), false);
        this.writer.writeExpression("hyperlinkTooltipExpression", jRImage.getHyperlinkTooltipExpression(), false);
        this.writeHyperlinkParameters(jRImage.getHyperlinkParameters());
        this.writer.closeElement();
    }

    private void writeBox(JRBox jRBox) throws IOException {
        if (jRBox != null) {
            this.writer.startElement("box");
            this.writer.addAttribute("border", jRBox.getOwnBorder(), JRXmlConstants.getPenMap());
            this.writer.addAttribute("borderColor", jRBox.getOwnBorderColor());
            this.writer.addAttribute("padding", jRBox.getOwnPadding());
            this.writer.addAttribute("topBorder", jRBox.getOwnTopBorder(), JRXmlConstants.getPenMap());
            this.writer.addAttribute("topBorderColor", jRBox.getOwnTopBorderColor());
            this.writer.addAttribute("topPadding", jRBox.getOwnTopPadding());
            this.writer.addAttribute("leftBorder", jRBox.getOwnLeftBorder(), JRXmlConstants.getPenMap());
            this.writer.addAttribute("leftBorderColor", jRBox.getOwnLeftBorderColor());
            this.writer.addAttribute("leftPadding", jRBox.getOwnLeftPadding());
            this.writer.addAttribute("bottomBorder", jRBox.getOwnBottomBorder(), JRXmlConstants.getPenMap());
            this.writer.addAttribute("bottomBorderColor", jRBox.getOwnBottomBorderColor());
            this.writer.addAttribute("bottomPadding", jRBox.getOwnBottomPadding());
            this.writer.addAttribute("rightBorder", jRBox.getOwnRightBorder(), JRXmlConstants.getPenMap());
            this.writer.addAttribute("rightBorderColor", jRBox.getOwnRightBorderColor());
            this.writer.addAttribute("rightPadding", jRBox.getOwnRightPadding());
            this.writer.closeElement(true);
        }
    }

    public void writeStaticText(JRStaticText jRStaticText) throws IOException {
        this.writer.startElement("staticText");
        this.writeReportElement(jRStaticText);
        this.writeBox(jRStaticText);
        this.writeTextElement(jRStaticText);
        this.writer.writeCDATAElement("text", jRStaticText.getText());
        this.writer.closeElement();
    }

    private void writeTextElement(JRTextElement jRTextElement) throws IOException {
        this.writer.startElement("textElement");
        this.writer.addAttribute("textAlignment", jRTextElement.getOwnHorizontalAlignment(), JRXmlConstants.getHorizontalAlignMap());
        this.writer.addAttribute("verticalAlignment", jRTextElement.getOwnVerticalAlignment(), JRXmlConstants.getVerticalAlignMap());
        this.writer.addAttribute("rotation", jRTextElement.getOwnRotation(), JRXmlConstants.getRotationMap());
        this.writer.addAttribute("lineSpacing", jRTextElement.getOwnLineSpacing(), JRXmlConstants.getLineSpacingMap());
        this.writer.addAttribute("isStyledText", jRTextElement.isOwnStyledText());
        this.writeFont(jRTextElement);
        this.writer.closeElement();
    }

    private void writeFont(JRFont jRFont) throws IOException {
        if (jRFont != null) {
            this.writer.startElement("font");
            if (jRFont.getReportFont() != null) {
                JRFont jRFont2 = (JRFont)this.fontsMap.get(jRFont.getReportFont().getName());
                if (jRFont2 != null) {
                    this.writer.addAttribute("reportFont", jRFont.getReportFont().getName());
                } else {
                    throw new JRRuntimeException("Referenced report font not found : " + jRFont.getReportFont().getName());
                }
            }
            this.writer.addAttribute("fontName", jRFont.getOwnFontName());
            this.writer.addAttribute("size", jRFont.getOwnFontSize());
            this.writer.addAttribute("isBold", jRFont.isOwnBold());
            this.writer.addAttribute("isItalic", jRFont.isOwnItalic());
            this.writer.addAttribute("isUnderline", jRFont.isOwnUnderline());
            this.writer.addAttribute("isStrikeThrough", jRFont.isOwnStrikeThrough());
            this.writer.addAttribute("pdfFontName", jRFont.getOwnPdfFontName());
            this.writer.addAttribute("pdfEncoding", jRFont.getOwnPdfEncoding());
            this.writer.addAttribute("isPdfEmbedded", jRFont.isOwnPdfEmbedded());
            this.writer.closeElement(true);
        }
    }

    public void writeTextField(JRTextField jRTextField) throws IOException {
        this.writer.startElement("textField");
        this.writer.addAttribute("isStretchWithOverflow", jRTextField.isStretchWithOverflow(), false);
        this.writer.addAttribute("evaluationTime", jRTextField.getEvaluationTime(), JRXmlConstants.getEvaluationTimeMap(), (byte)1);
        if (jRTextField.getEvaluationGroup() != null) {
            this.writer.addAttribute("evaluationGroup", jRTextField.getEvaluationGroup().getName());
        }
        this.writer.addAttribute("pattern", jRTextField.getOwnPattern());
        this.writer.addAttribute("isBlankWhenNull", jRTextField.isOwnBlankWhenNull());
        this.writer.addAttribute("hyperlinkType", jRTextField.getLinkType());
        this.writer.addAttribute("hyperlinkTarget", jRTextField.getHyperlinkTarget(), JRXmlConstants.getHyperlinkTargetMap(), (byte)1);
        this.writer.addAttribute("bookmarkLevel", jRTextField.getBookmarkLevel(), 0);
        this.writeReportElement(jRTextField);
        this.writeBox(jRTextField);
        this.writeTextElement(jRTextField);
        this.writer.writeExpression("textFieldExpression", jRTextField.getExpression(), true);
        this.writer.writeExpression("anchorNameExpression", jRTextField.getAnchorNameExpression(), false);
        this.writer.writeExpression("hyperlinkReferenceExpression", jRTextField.getHyperlinkReferenceExpression(), false);
        this.writer.writeExpression("hyperlinkAnchorExpression", jRTextField.getHyperlinkAnchorExpression(), false);
        this.writer.writeExpression("hyperlinkPageExpression", jRTextField.getHyperlinkPageExpression(), false);
        this.writer.writeExpression("hyperlinkTooltipExpression", jRTextField.getHyperlinkTooltipExpression(), false);
        this.writeHyperlinkParameters(jRTextField.getHyperlinkParameters());
        this.writer.closeElement();
    }

    public void writeSubreport(JRSubreport jRSubreport) throws IOException {
        this.writer.startElement("subreport");
        this.writer.addAttribute("isUsingCache", jRSubreport.isOwnUsingCache());
        this.writeReportElement(jRSubreport);
        this.writer.writeExpression("parametersMapExpression", jRSubreport.getParametersMapExpression(), false);
        JRSubreportParameter[] jRSubreportParameterArray = jRSubreport.getParameters();
        if (jRSubreportParameterArray != null && jRSubreportParameterArray.length > 0) {
            for (int i = 0; i < jRSubreportParameterArray.length; ++i) {
                this.writeSubreportParameter(jRSubreportParameterArray[i]);
            }
        }
        this.writer.writeExpression("connectionExpression", jRSubreport.getConnectionExpression(), false);
        this.writer.writeExpression("dataSourceExpression", jRSubreport.getDataSourceExpression(), false);
        JRSubreportReturnValue[] jRSubreportReturnValueArray = jRSubreport.getReturnValues();
        if (jRSubreportReturnValueArray != null && jRSubreportReturnValueArray.length > 0) {
            for (int i = 0; i < jRSubreportReturnValueArray.length; ++i) {
                this.writeSubreportReturnValue(jRSubreportReturnValueArray[i]);
            }
        }
        this.writer.writeExpression("subreportExpression", jRSubreport.getExpression(), true);
        this.writer.closeElement();
    }

    private void writeSubreportParameter(JRSubreportParameter jRSubreportParameter) throws IOException {
        this.writer.startElement("subreportParameter");
        this.writer.addAttribute("name", jRSubreportParameter.getName());
        this.writer.writeExpression("subreportParameterExpression", jRSubreportParameter.getExpression(), false);
        this.writer.closeElement();
    }

    private void writeDatasetParameter(JRDatasetParameter jRDatasetParameter) throws IOException {
        this.writer.startElement("datasetParameter");
        this.writer.addAttribute("name", jRDatasetParameter.getName());
        this.writer.writeExpression("datasetParameterExpression", jRDatasetParameter.getExpression(), false);
        this.writer.closeElement();
    }

    private void writeChart(JRChart jRChart) throws IOException {
        this.writer.startElement("chart");
        this.writer.addAttribute("isShowLegend", jRChart.isShowLegend(), true);
        this.writer.addAttribute("evaluationTime", jRChart.getEvaluationTime(), JRXmlConstants.getEvaluationTimeMap(), (byte)1);
        if (jRChart.getEvaluationTime() == 5) {
            this.writer.addAttribute("evaluationGroup", jRChart.getEvaluationGroup().getName());
        }
        this.writer.addAttribute("hyperlinkType", jRChart.getLinkType());
        this.writer.addAttribute("hyperlinkTarget", jRChart.getHyperlinkTarget(), JRXmlConstants.getHyperlinkTargetMap(), (byte)1);
        this.writer.addAttribute("bookmarkLevel", jRChart.getBookmarkLevel(), 0);
        this.writer.addAttribute("customizerClass", jRChart.getCustomizerClass());
        this.writeReportElement(jRChart);
        this.writeBox(jRChart);
        this.writer.startElement("chartTitle");
        this.writer.addAttribute("position", jRChart.getTitlePosition(), JRXmlConstants.getChartTitlePositionMap(), (byte)1);
        this.writer.addAttribute("color", jRChart.getTitleColor(), Color.black);
        this.writeFont(jRChart.getTitleFont());
        if (jRChart.getTitleExpression() != null) {
            this.writer.writeExpression("titleExpression", jRChart.getTitleExpression(), false);
        }
        this.writer.closeElement();
        this.writer.startElement("chartSubtitle");
        this.writer.addAttribute("color", jRChart.getSubtitleColor());
        this.writeFont(jRChart.getSubtitleFont());
        if (jRChart.getSubtitleExpression() != null) {
            this.writer.writeExpression("subtitleExpression", jRChart.getSubtitleExpression(), false);
        }
        this.writer.closeElement();
        this.writer.startElement("chartLegend");
        if (jRChart.getLegendColor() != null) {
            this.writer.addAttribute("textColor", jRChart.getLegendColor());
        }
        if (jRChart.getLegendBackgroundColor() != null) {
            this.writer.addAttribute("backgroundColor", jRChart.getLegendBackgroundColor());
        }
        this.writeFont(jRChart.getLegendFont());
        this.writer.closeElement();
        this.writer.writeExpression("anchorNameExpression", jRChart.getAnchorNameExpression(), false);
        this.writer.writeExpression("hyperlinkReferenceExpression", jRChart.getHyperlinkReferenceExpression(), false);
        this.writer.writeExpression("hyperlinkAnchorExpression", jRChart.getHyperlinkAnchorExpression(), false);
        this.writer.writeExpression("hyperlinkPageExpression", jRChart.getHyperlinkPageExpression(), false);
        this.writer.writeExpression("hyperlinkTooltipExpression", jRChart.getHyperlinkTooltipExpression(), false);
        this.writeHyperlinkParameters(jRChart.getHyperlinkParameters());
        this.writer.closeElement();
    }

    private void writeElementDataset(JRElementDataset jRElementDataset) throws IOException {
        this.writer.startElement("dataset");
        this.writer.addAttribute("resetType", jRElementDataset.getResetType(), JRXmlConstants.getResetTypeMap(), (byte)1);
        if (jRElementDataset.getResetType() == 4) {
            this.writer.addAttribute("resetGroup", jRElementDataset.getResetGroup().getName());
        }
        this.writer.addAttribute("incrementType", jRElementDataset.getIncrementType(), JRXmlConstants.getResetTypeMap(), (byte)5);
        if (jRElementDataset.getIncrementType() == 4) {
            this.writer.addAttribute("incrementGroup", jRElementDataset.getIncrementGroup().getName());
        }
        this.writer.writeExpression("incrementWhenExpression", jRElementDataset.getIncrementWhenExpression(), false);
        JRDatasetRun jRDatasetRun = jRElementDataset.getDatasetRun();
        if (jRDatasetRun != null) {
            this.writeDatasetRun(jRDatasetRun);
        }
        this.writer.closeElement(true);
    }

    private void writeCategoryDataSet(JRCategoryDataset jRCategoryDataset) throws IOException {
        this.writer.startElement("categoryDataset");
        this.writeElementDataset(jRCategoryDataset);
        JRCategorySeries[] jRCategorySeriesArray = jRCategoryDataset.getSeries();
        if (jRCategorySeriesArray != null && jRCategorySeriesArray.length > 0) {
            for (int i = 0; i < jRCategorySeriesArray.length; ++i) {
                this.writeCategorySeries(jRCategorySeriesArray[i]);
            }
        }
        this.writer.closeElement();
    }

    private void writeTimeSeriesDataset(JRTimeSeriesDataset jRTimeSeriesDataset) throws IOException {
        this.writer.startElement("timeSeriesDataset");
        if (jRTimeSeriesDataset.getTimePeriod() != null && !Day.class.getName().equals(jRTimeSeriesDataset.getTimePeriod().getName())) {
            this.writer.addAttribute("timePeriod", JRXmlConstants.getTimePeriodName(jRTimeSeriesDataset.getTimePeriod()));
        }
        this.writeElementDataset(jRTimeSeriesDataset);
        JRTimeSeries[] jRTimeSeriesArray = jRTimeSeriesDataset.getSeries();
        if (jRTimeSeriesArray != null && jRTimeSeriesArray.length > 0) {
            for (int i = 0; i < jRTimeSeriesArray.length; ++i) {
                this.writeTimeSeries(jRTimeSeriesArray[i]);
            }
        }
        this.writer.closeElement();
    }

    private void writeTimePeriodDataset(JRTimePeriodDataset jRTimePeriodDataset) throws IOException {
        this.writer.startElement("timePeriodDataset");
        this.writeElementDataset(jRTimePeriodDataset);
        JRTimePeriodSeries[] jRTimePeriodSeriesArray = jRTimePeriodDataset.getSeries();
        if (jRTimePeriodSeriesArray != null && jRTimePeriodSeriesArray.length > 0) {
            for (int i = 0; i < jRTimePeriodSeriesArray.length; ++i) {
                this.writeTimePeriodSeries(jRTimePeriodSeriesArray[i]);
            }
        }
        this.writer.closeElement();
    }

    private void writeCategorySeries(JRCategorySeries jRCategorySeries) throws IOException {
        this.writer.startElement("categorySeries");
        this.writer.writeExpression("seriesExpression", jRCategorySeries.getSeriesExpression(), false);
        this.writer.writeExpression("categoryExpression", jRCategorySeries.getCategoryExpression(), false);
        this.writer.writeExpression("valueExpression", jRCategorySeries.getValueExpression(), false);
        this.writer.writeExpression("labelExpression", jRCategorySeries.getLabelExpression(), false);
        this.writeHyperlink("itemHyperlink", jRCategorySeries.getItemHyperlink());
        this.writer.closeElement();
    }

    private void writeXyzDataset(JRXyzDataset jRXyzDataset) throws IOException {
        this.writer.startElement("xyzDataset");
        this.writeElementDataset(jRXyzDataset);
        JRXyzSeries[] jRXyzSeriesArray = jRXyzDataset.getSeries();
        if (jRXyzSeriesArray != null && jRXyzSeriesArray.length > 0) {
            for (int i = 0; i < jRXyzSeriesArray.length; ++i) {
                this.writeXyzSeries(jRXyzSeriesArray[i]);
            }
        }
        this.writer.closeElement();
    }

    private void writeXyzSeries(JRXyzSeries jRXyzSeries) throws IOException {
        this.writer.startElement("xyzSeries");
        this.writer.writeExpression("seriesExpression", jRXyzSeries.getSeriesExpression(), false);
        this.writer.writeExpression("xValueExpression", jRXyzSeries.getXValueExpression(), false);
        this.writer.writeExpression("yValueExpression", jRXyzSeries.getYValueExpression(), false);
        this.writer.writeExpression("zValueExpression", jRXyzSeries.getZValueExpression(), false);
        this.writeHyperlink("itemHyperlink", jRXyzSeries.getItemHyperlink());
        this.writer.closeElement();
    }

    private void writeXySeries(JRXySeries jRXySeries) throws IOException {
        this.writer.startElement("xySeries");
        this.writer.writeExpression("seriesExpression", jRXySeries.getSeriesExpression(), false);
        this.writer.writeExpression("xValueExpression", jRXySeries.getXValueExpression(), false);
        this.writer.writeExpression("yValueExpression", jRXySeries.getYValueExpression(), false);
        this.writer.writeExpression("labelExpression", jRXySeries.getLabelExpression(), false);
        this.writeHyperlink("itemHyperlink", jRXySeries.getItemHyperlink());
        this.writer.closeElement();
    }

    private void writeXyDataset(JRXyDataset jRXyDataset) throws IOException {
        this.writer.startElement("xyDataset");
        this.writeElementDataset(jRXyDataset);
        JRXySeries[] jRXySeriesArray = jRXyDataset.getSeries();
        if (jRXySeriesArray != null && jRXySeriesArray.length > 0) {
            for (int i = 0; i < jRXySeriesArray.length; ++i) {
                this.writeXySeries(jRXySeriesArray[i]);
            }
        }
        this.writer.closeElement();
    }

    private void writeTimeSeries(JRTimeSeries jRTimeSeries) throws IOException {
        this.writer.startElement("timeSeries");
        this.writer.writeExpression("seriesExpression", jRTimeSeries.getSeriesExpression(), false);
        this.writer.writeExpression("timePeriodExpression", jRTimeSeries.getTimePeriodExpression(), false);
        this.writer.writeExpression("valueExpression", jRTimeSeries.getValueExpression(), false);
        this.writer.writeExpression("labelExpression", jRTimeSeries.getLabelExpression(), false);
        this.writeHyperlink("itemHyperlink", jRTimeSeries.getItemHyperlink());
        this.writer.closeElement();
    }

    private void writeTimePeriodSeries(JRTimePeriodSeries jRTimePeriodSeries) throws IOException {
        this.writer.startElement("timePeriodSeries");
        this.writer.writeExpression("seriesExpression", jRTimePeriodSeries.getSeriesExpression(), false);
        this.writer.writeExpression("startDateExpression", jRTimePeriodSeries.getStartDateExpression(), false);
        this.writer.writeExpression("endDateExpression", jRTimePeriodSeries.getEndDateExpression(), false);
        this.writer.writeExpression("valueExpression", jRTimePeriodSeries.getValueExpression(), false);
        this.writer.writeExpression("labelExpression", jRTimePeriodSeries.getLabelExpression(), false);
        this.writeHyperlink("itemHyperlink", jRTimePeriodSeries.getItemHyperlink());
        this.writer.closeElement();
    }

    public void writePieDataset(JRPieDataset jRPieDataset) throws IOException {
        this.writer.startElement("pieDataset");
        this.writeElementDataset(jRPieDataset);
        this.writer.writeExpression("keyExpression", jRPieDataset.getKeyExpression(), false);
        this.writer.writeExpression("valueExpression", jRPieDataset.getValueExpression(), false);
        this.writer.writeExpression("labelExpression", jRPieDataset.getLabelExpression(), false);
        this.writeHyperlink("sectionHyperlink", jRPieDataset.getSectionHyperlink());
        this.writer.closeElement();
    }

    public void writeValueDataset(JRValueDataset jRValueDataset) throws IOException {
        this.writer.startElement("valueDataset");
        this.writeElementDataset(jRValueDataset);
        this.writer.writeExpression("valueExpression", jRValueDataset.getValueExpression(), false);
        this.writer.closeElement();
    }

    public void writeValueDisplay(JRValueDisplay jRValueDisplay) throws IOException {
        this.writer.startElement("valueDisplay");
        this.writer.addAttribute("color", jRValueDisplay.getColor());
        this.writer.addAttribute("mask", jRValueDisplay.getMask());
        this.writeFont(jRValueDisplay.getFont());
        this.writer.closeElement();
    }

    public void writeDataRange(JRDataRange jRDataRange) throws IOException {
        this.writer.startElement("dataRange");
        this.writer.writeExpression("lowExpression", jRDataRange.getLowExpression(), false);
        this.writer.writeExpression("highExpression", jRDataRange.getHighExpression(), false);
        this.writer.closeElement();
    }

    private void writeMeterInterval(JRMeterInterval jRMeterInterval) throws IOException {
        this.writer.startElement("meterInterval");
        this.writer.addAttribute("label", jRMeterInterval.getLabel());
        this.writer.addAttribute("color", jRMeterInterval.getBackgroundColor());
        this.writer.addAttribute("alpha", jRMeterInterval.getAlpha());
        this.writeDataRange(jRMeterInterval.getDataRange());
        this.writer.closeElement();
    }

    private void writeSeriesColors(SortedSet sortedSet) throws IOException {
        if (sortedSet == null || sortedSet.size() == 0) {
            return;
        }
        JRChartPlot.JRSeriesColor[] jRSeriesColorArray = sortedSet.toArray(new JRChartPlot.JRSeriesColor[0]);
        for (int i = 0; i < jRSeriesColorArray.length; ++i) {
            this.writer.startElement("seriesColor");
            this.writer.addAttribute("seriesOrder", jRSeriesColorArray[i].getSeriesOrder());
            this.writer.addAttribute("color", jRSeriesColorArray[i].getColor());
            this.writer.closeElement();
        }
    }

    private void writeChartAxis(JRChartAxis jRChartAxis) throws IOException {
        this.writer.startElement("axis");
        this.writer.addAttribute("position", jRChartAxis.getPosition(), JRXmlConstants.getAxisPositionMap(), (byte)1);
        this.writeChartTag(jRChartAxis.getChart());
        this.writer.closeElement();
    }

    private void writePlot(JRChartPlot jRChartPlot) throws IOException {
        this.writer.startElement("plot");
        this.writer.addAttribute("backcolor", jRChartPlot.getBackcolor());
        this.writer.addAttribute("orientation", jRChartPlot.getOrientation(), JRXmlConstants.getPlotOrientationMap(), PlotOrientation.VERTICAL);
        this.writer.addAttribute("backgroundAlpha", jRChartPlot.getBackgroundAlpha(), 1.0f);
        this.writer.addAttribute("foregroundAlpha", jRChartPlot.getForegroundAlpha(), 1.0f);
        this.writer.addAttribute("labelRotation", jRChartPlot.getLabelRotation(), 0.0);
        this.writeSeriesColors(jRChartPlot.getSeriesColors());
        this.writer.closeElement();
    }

    public void writePieChart(JRChart jRChart) throws IOException {
        this.writer.startElement("pieChart");
        this.writeChart(jRChart);
        this.writePieDataset((JRPieDataset)jRChart.getDataset());
        this.writer.startElement("piePlot");
        this.writePlot(jRChart.getPlot());
        this.writer.closeElement();
        this.writer.closeElement();
    }

    public void writePie3DChart(JRChart jRChart) throws IOException {
        this.writer.startElement("pie3DChart");
        this.writeChart(jRChart);
        this.writePieDataset((JRPieDataset)jRChart.getDataset());
        JRPie3DPlot jRPie3DPlot = (JRPie3DPlot)jRChart.getPlot();
        this.writer.startElement("pie3DPlot");
        this.writer.addAttribute("depthFactor", jRPie3DPlot.getDepthFactor(), 0.2);
        this.writePlot(jRChart.getPlot());
        this.writer.closeElement();
        this.writer.closeElement();
    }

    public void writeAxisFormat(String string, JRFont jRFont, Color color, JRFont jRFont2, Color color2, String string2, Color color3) throws IOException {
        if (jRFont == null && color == null && jRFont2 == null && color2 == null && color3 == null) {
            return;
        }
        this.writer.startElement(string);
        this.writer.startElement("axisFormat");
        this.writer.addAttribute("labelColor", color);
        this.writer.addAttribute("tickLabelColor", color2);
        this.writer.addAttribute("tickLabelMask", string2);
        this.writer.addAttribute("axisLineColor", color3);
        if (jRFont != null) {
            this.writer.startElement("labelFont");
            this.writeFont(jRFont);
            this.writer.closeElement();
        }
        if (jRFont2 != null) {
            this.writer.startElement("tickLabelFont");
            this.writeFont(jRFont2);
            this.writer.closeElement();
        }
        this.writer.closeElement();
        this.writer.closeElement();
    }

    private void writeBarPlot(JRBarPlot jRBarPlot) throws IOException {
        this.writer.startElement("barPlot");
        this.writer.addAttribute("isShowLabels", jRBarPlot.isShowLabels(), false);
        this.writer.addAttribute("isShowTickLabels", jRBarPlot.isShowTickLabels(), true);
        this.writer.addAttribute("isShowTickMarks", jRBarPlot.isShowTickMarks(), true);
        this.writePlot(jRBarPlot);
        this.writer.writeExpression("categoryAxisLabelExpression", jRBarPlot.getCategoryAxisLabelExpression(), false);
        this.writeAxisFormat("categoryAxisFormat", jRBarPlot.getCategoryAxisLabelFont(), jRBarPlot.getCategoryAxisLabelColor(), jRBarPlot.getCategoryAxisTickLabelFont(), jRBarPlot.getCategoryAxisTickLabelColor(), jRBarPlot.getCategoryAxisTickLabelMask(), jRBarPlot.getCategoryAxisLineColor());
        this.writer.writeExpression("valueAxisLabelExpression", jRBarPlot.getValueAxisLabelExpression(), false);
        this.writeAxisFormat("valueAxisFormat", jRBarPlot.getValueAxisLabelFont(), jRBarPlot.getValueAxisLabelColor(), jRBarPlot.getValueAxisTickLabelFont(), jRBarPlot.getValueAxisTickLabelColor(), jRBarPlot.getValueAxisTickLabelMask(), jRBarPlot.getValueAxisLineColor());
        this.writer.closeElement();
    }

    private void writeBubblePlot(JRBubblePlot jRBubblePlot) throws IOException {
        this.writer.startElement("bubblePlot");
        this.writer.addAttribute("scaleType", jRBubblePlot.getScaleType(), JRXmlConstants.getScaleTypeMap());
        this.writePlot(jRBubblePlot);
        this.writer.writeExpression("xAxisLabelExpression", jRBubblePlot.getXAxisLabelExpression(), false);
        this.writeAxisFormat("xAxisFormat", jRBubblePlot.getXAxisLabelFont(), jRBubblePlot.getXAxisLabelColor(), jRBubblePlot.getXAxisTickLabelFont(), jRBubblePlot.getXAxisTickLabelColor(), jRBubblePlot.getXAxisTickLabelMask(), jRBubblePlot.getXAxisLineColor());
        this.writer.writeExpression("yAxisLabelExpression", jRBubblePlot.getYAxisLabelExpression(), false);
        this.writeAxisFormat("yAxisFormat", jRBubblePlot.getYAxisLabelFont(), jRBubblePlot.getYAxisLabelColor(), jRBubblePlot.getYAxisTickLabelFont(), jRBubblePlot.getYAxisTickLabelColor(), jRBubblePlot.getYAxisTickLabelMask(), jRBubblePlot.getYAxisLineColor());
        this.writer.closeElement();
    }

    private void writeLinePlot(JRLinePlot jRLinePlot) throws IOException {
        this.writer.startElement("linePlot");
        this.writer.addAttribute("isShowLines", jRLinePlot.isShowLines(), true);
        this.writer.addAttribute("isShowShapes", jRLinePlot.isShowShapes(), true);
        this.writePlot(jRLinePlot);
        this.writer.writeExpression("categoryAxisLabelExpression", jRLinePlot.getCategoryAxisLabelExpression(), false);
        this.writeAxisFormat("categoryAxisFormat", jRLinePlot.getCategoryAxisLabelFont(), jRLinePlot.getCategoryAxisLabelColor(), jRLinePlot.getCategoryAxisTickLabelFont(), jRLinePlot.getCategoryAxisTickLabelColor(), jRLinePlot.getCategoryAxisTickLabelMask(), jRLinePlot.getCategoryAxisLineColor());
        this.writer.writeExpression("valueAxisLabelExpression", jRLinePlot.getValueAxisLabelExpression(), false);
        this.writeAxisFormat("valueAxisFormat", jRLinePlot.getValueAxisLabelFont(), jRLinePlot.getValueAxisLabelColor(), jRLinePlot.getValueAxisTickLabelFont(), jRLinePlot.getValueAxisTickLabelColor(), jRLinePlot.getValueAxisTickLabelMask(), jRLinePlot.getValueAxisLineColor());
        this.writer.closeElement();
    }

    private void writeTimeSeriesPlot(JRTimeSeriesPlot jRTimeSeriesPlot) throws IOException {
        this.writer.startElement("timeSeriesPlot");
        this.writer.addAttribute("isShowLines", jRTimeSeriesPlot.isShowLines(), true);
        this.writer.addAttribute("isShowShapes", jRTimeSeriesPlot.isShowShapes(), true);
        this.writePlot(jRTimeSeriesPlot);
        this.writer.writeExpression("timeAxisLabelExpression", jRTimeSeriesPlot.getTimeAxisLabelExpression(), false);
        this.writeAxisFormat("timeAxisFormat", jRTimeSeriesPlot.getTimeAxisLabelFont(), jRTimeSeriesPlot.getTimeAxisLabelColor(), jRTimeSeriesPlot.getTimeAxisTickLabelFont(), jRTimeSeriesPlot.getTimeAxisTickLabelColor(), jRTimeSeriesPlot.getTimeAxisTickLabelMask(), jRTimeSeriesPlot.getTimeAxisLineColor());
        this.writer.writeExpression("valueAxisLabelExpression", jRTimeSeriesPlot.getValueAxisLabelExpression(), false);
        this.writeAxisFormat("valueAxisFormat", jRTimeSeriesPlot.getValueAxisLabelFont(), jRTimeSeriesPlot.getValueAxisLabelColor(), jRTimeSeriesPlot.getValueAxisTickLabelFont(), jRTimeSeriesPlot.getValueAxisTickLabelColor(), jRTimeSeriesPlot.getValueAxisTickLabelMask(), jRTimeSeriesPlot.getValueAxisLineColor());
        this.writer.closeElement();
    }

    public void writeBar3DPlot(JRBar3DPlot jRBar3DPlot) throws IOException {
        this.writer.startElement("bar3DPlot");
        this.writer.addAttribute("isShowLabels", jRBar3DPlot.isShowLabels(), false);
        this.writer.addAttribute("xOffset", jRBar3DPlot.getXOffset(), 12.0);
        this.writer.addAttribute("yOffset", jRBar3DPlot.getYOffset(), 8.0);
        this.writePlot(jRBar3DPlot);
        this.writer.writeExpression("categoryAxisLabelExpression", jRBar3DPlot.getCategoryAxisLabelExpression(), false);
        this.writeAxisFormat("categoryAxisFormat", jRBar3DPlot.getCategoryAxisLabelFont(), jRBar3DPlot.getCategoryAxisLabelColor(), jRBar3DPlot.getCategoryAxisTickLabelFont(), jRBar3DPlot.getCategoryAxisTickLabelColor(), jRBar3DPlot.getCategoryAxisTickLabelMask(), jRBar3DPlot.getCategoryAxisLineColor());
        this.writer.writeExpression("valueAxisLabelExpression", jRBar3DPlot.getValueAxisLabelExpression(), false);
        this.writeAxisFormat("valueAxisFormat", jRBar3DPlot.getValueAxisLabelFont(), jRBar3DPlot.getValueAxisLabelColor(), jRBar3DPlot.getValueAxisTickLabelFont(), jRBar3DPlot.getValueAxisTickLabelColor(), jRBar3DPlot.getValueAxisTickLabelMask(), jRBar3DPlot.getValueAxisLineColor());
        this.writer.closeElement();
    }

    public void writeBarChart(JRChart jRChart) throws IOException {
        this.writer.startElement("barChart");
        this.writeChart(jRChart);
        this.writeCategoryDataSet((JRCategoryDataset)jRChart.getDataset());
        this.writeBarPlot((JRBarPlot)jRChart.getPlot());
        this.writer.closeElement();
    }

    public void writeBar3DChart(JRChart jRChart) throws IOException {
        this.writer.startElement("bar3DChart");
        this.writeChart(jRChart);
        this.writeCategoryDataSet((JRCategoryDataset)jRChart.getDataset());
        this.writeBar3DPlot((JRBar3DPlot)jRChart.getPlot());
        this.writer.closeElement();
    }

    public void writeBubbleChart(JRChart jRChart) throws IOException {
        this.writer.startElement("bubbleChart");
        this.writeChart(jRChart);
        this.writeXyzDataset((JRXyzDataset)jRChart.getDataset());
        this.writeBubblePlot((JRBubblePlot)jRChart.getPlot());
        this.writer.closeElement();
    }

    public void writeStackedBarChart(JRChart jRChart) throws IOException {
        this.writer.startElement("stackedBarChart");
        this.writeChart(jRChart);
        this.writeCategoryDataSet((JRCategoryDataset)jRChart.getDataset());
        this.writeBarPlot((JRBarPlot)jRChart.getPlot());
        this.writer.closeElement();
    }

    public void writeStackedBar3DChart(JRChart jRChart) throws IOException {
        this.writer.startElement("stackedBar3DChart");
        this.writeChart(jRChart);
        this.writeCategoryDataSet((JRCategoryDataset)jRChart.getDataset());
        this.writeBar3DPlot((JRBar3DPlot)jRChart.getPlot());
        this.writer.closeElement();
    }

    public void writeLineChart(JRChart jRChart) throws IOException {
        this.writer.startElement("lineChart");
        this.writeChart(jRChart);
        this.writeCategoryDataSet((JRCategoryDataset)jRChart.getDataset());
        this.writeLinePlot((JRLinePlot)jRChart.getPlot());
        this.writer.closeElement();
    }

    public void writeTimeSeriesChart(JRChart jRChart) throws IOException {
        this.writer.startElement("timeSeriesChart");
        this.writeChart(jRChart);
        this.writeTimeSeriesDataset((JRTimeSeriesDataset)jRChart.getDataset());
        this.writeTimeSeriesPlot((JRTimeSeriesPlot)jRChart.getPlot());
        this.writer.closeElement();
    }

    public void writeHighLowDataset(JRHighLowDataset jRHighLowDataset) throws IOException {
        this.writer.startElement("highLowDataset");
        this.writeElementDataset(jRHighLowDataset);
        this.writer.writeExpression("seriesExpression", jRHighLowDataset.getSeriesExpression(), false);
        this.writer.writeExpression("dateExpression", jRHighLowDataset.getDateExpression(), false);
        this.writer.writeExpression("highExpression", jRHighLowDataset.getHighExpression(), false);
        this.writer.writeExpression("lowExpression", jRHighLowDataset.getLowExpression(), false);
        this.writer.writeExpression("openExpression", jRHighLowDataset.getOpenExpression(), false);
        this.writer.writeExpression("closeExpression", jRHighLowDataset.getCloseExpression(), false);
        this.writer.writeExpression("volumeExpression", jRHighLowDataset.getVolumeExpression(), false);
        this.writeHyperlink("itemHyperlink", jRHighLowDataset.getItemHyperlink());
        this.writer.closeElement();
    }

    public void writeHighLowChart(JRChart jRChart) throws IOException {
        this.writer.startElement("highLowChart");
        this.writeChart(jRChart);
        this.writeHighLowDataset((JRHighLowDataset)jRChart.getDataset());
        JRHighLowPlot jRHighLowPlot = (JRHighLowPlot)jRChart.getPlot();
        this.writer.startElement("highLowPlot");
        this.writer.addAttribute("isShowOpenTicks", jRHighLowPlot.isShowOpenTicks(), true);
        this.writer.addAttribute("isShowCloseTicks", jRHighLowPlot.isShowCloseTicks(), true);
        this.writePlot(jRHighLowPlot);
        this.writer.writeExpression("timeAxisLabelExpression", jRHighLowPlot.getTimeAxisLabelExpression(), false);
        this.writeAxisFormat("timeAxisFormat", jRHighLowPlot.getTimeAxisLabelFont(), jRHighLowPlot.getTimeAxisLabelColor(), jRHighLowPlot.getTimeAxisTickLabelFont(), jRHighLowPlot.getTimeAxisTickLabelColor(), jRHighLowPlot.getTimeAxisTickLabelMask(), jRHighLowPlot.getTimeAxisLineColor());
        this.writer.writeExpression("valueAxisLabelExpression", jRHighLowPlot.getValueAxisLabelExpression(), false);
        this.writeAxisFormat("valueAxisFormat", jRHighLowPlot.getValueAxisLabelFont(), jRHighLowPlot.getValueAxisLabelColor(), jRHighLowPlot.getValueAxisTickLabelFont(), jRHighLowPlot.getValueAxisTickLabelColor(), jRHighLowPlot.getValueAxisTickLabelMask(), jRHighLowPlot.getValueAxisLineColor());
        this.writer.closeElement();
        this.writer.closeElement();
    }

    public void writeCandlestickChart(JRChart jRChart) throws IOException {
        this.writer.startElement("candlestickChart");
        this.writeChart(jRChart);
        this.writeHighLowDataset((JRHighLowDataset)jRChart.getDataset());
        JRCandlestickPlot jRCandlestickPlot = (JRCandlestickPlot)jRChart.getPlot();
        this.writer.startElement("candlestickPlot");
        this.writer.addAttribute("isShowVolume", jRCandlestickPlot.isShowVolume(), true);
        this.writePlot(jRCandlestickPlot);
        this.writer.writeExpression("timeAxisLabelExpression", jRCandlestickPlot.getTimeAxisLabelExpression(), false);
        this.writeAxisFormat("timeAxisFormat", jRCandlestickPlot.getTimeAxisLabelFont(), jRCandlestickPlot.getTimeAxisLabelColor(), jRCandlestickPlot.getTimeAxisTickLabelFont(), jRCandlestickPlot.getTimeAxisTickLabelColor(), jRCandlestickPlot.getTimeAxisTickLabelMask(), jRCandlestickPlot.getTimeAxisLineColor());
        this.writer.writeExpression("valueAxisLabelExpression", jRCandlestickPlot.getValueAxisLabelExpression(), false);
        this.writeAxisFormat("valueAxisFormat", jRCandlestickPlot.getValueAxisLabelFont(), jRCandlestickPlot.getValueAxisLabelColor(), jRCandlestickPlot.getValueAxisTickLabelFont(), jRCandlestickPlot.getValueAxisTickLabelColor(), jRCandlestickPlot.getValueAxisTickLabelMask(), jRCandlestickPlot.getValueAxisLineColor());
        this.writer.closeElement();
        this.writer.closeElement();
    }

    private void writeAreaPlot(JRAreaPlot jRAreaPlot) throws IOException {
        this.writer.startElement("areaPlot");
        this.writePlot(jRAreaPlot);
        this.writer.writeExpression("categoryAxisLabelExpression", jRAreaPlot.getCategoryAxisLabelExpression(), false);
        this.writeAxisFormat("categoryAxisFormat", jRAreaPlot.getCategoryAxisLabelFont(), jRAreaPlot.getCategoryAxisLabelColor(), jRAreaPlot.getCategoryAxisTickLabelFont(), jRAreaPlot.getCategoryAxisTickLabelColor(), jRAreaPlot.getCategoryAxisTickLabelMask(), jRAreaPlot.getCategoryAxisLineColor());
        this.writer.writeExpression("valueAxisLabelExpression", jRAreaPlot.getValueAxisLabelExpression(), false);
        this.writeAxisFormat("valueAxisFormat", jRAreaPlot.getValueAxisLabelFont(), jRAreaPlot.getValueAxisLabelColor(), jRAreaPlot.getValueAxisTickLabelFont(), jRAreaPlot.getValueAxisTickLabelColor(), jRAreaPlot.getValueAxisTickLabelMask(), jRAreaPlot.getValueAxisLineColor());
        this.writer.closeElement();
    }

    public void writeAreaChart(JRChart jRChart) throws IOException {
        this.writer.startElement("areaChart");
        this.writeChart(jRChart);
        this.writeCategoryDataSet((JRCategoryDataset)jRChart.getDataset());
        this.writeAreaPlot((JRAreaPlot)jRChart.getPlot());
        this.writer.closeElement();
    }

    private void writeScatterPlot(JRScatterPlot jRScatterPlot) throws IOException {
        this.writer.startElement("scatterPlot");
        this.writer.addAttribute("isShowLines", jRScatterPlot.isShowLines(), true);
        this.writer.addAttribute("isShowShapes", jRScatterPlot.isShowShapes(), true);
        this.writePlot(jRScatterPlot);
        this.writer.writeExpression("xAxisLabelExpression", jRScatterPlot.getXAxisLabelExpression(), false);
        this.writeAxisFormat("xAxisFormat", jRScatterPlot.getXAxisLabelFont(), jRScatterPlot.getXAxisLabelColor(), jRScatterPlot.getXAxisTickLabelFont(), jRScatterPlot.getXAxisTickLabelColor(), jRScatterPlot.getXAxisTickLabelMask(), jRScatterPlot.getXAxisLineColor());
        this.writer.writeExpression("yAxisLabelExpression", jRScatterPlot.getYAxisLabelExpression(), false);
        this.writeAxisFormat("yAxisFormat", jRScatterPlot.getYAxisLabelFont(), jRScatterPlot.getYAxisLabelColor(), jRScatterPlot.getYAxisTickLabelFont(), jRScatterPlot.getYAxisTickLabelColor(), jRScatterPlot.getYAxisTickLabelMask(), jRScatterPlot.getYAxisLineColor());
        this.writer.closeElement();
    }

    public void writeScatterChart(JRChart jRChart) throws IOException {
        this.writer.startElement("scatterChart");
        this.writeChart(jRChart);
        this.writeXyDataset((JRXyDataset)jRChart.getDataset());
        this.writeScatterPlot((JRScatterPlot)jRChart.getPlot());
        this.writer.closeElement();
    }

    public void writeXyAreaChart(JRChart jRChart) throws IOException {
        this.writer.startElement("xyAreaChart");
        this.writeChart(jRChart);
        this.writeXyDataset((JRXyDataset)jRChart.getDataset());
        this.writeAreaPlot((JRAreaPlot)jRChart.getPlot());
        this.writer.closeElement();
    }

    public void writeXyBarChart(JRChart jRChart) throws IOException {
        this.writer.startElement("xyBarChart");
        this.writeChart(jRChart);
        JRChartDataset jRChartDataset = jRChart.getDataset();
        if (jRChartDataset.getDatasetType() == 6) {
            this.writeTimeSeriesDataset((JRTimeSeriesDataset)jRChartDataset);
        } else if (jRChartDataset.getDatasetType() == 5) {
            this.writeTimePeriodDataset((JRTimePeriodDataset)jRChartDataset);
        } else if (jRChartDataset.getDatasetType() == 3) {
            this.writeXyDataset((JRXyDataset)jRChartDataset);
        }
        this.writeBarPlot((JRBarPlot)jRChart.getPlot());
        this.writer.closeElement();
    }

    public void writeXyLineChart(JRChart jRChart) throws IOException {
        this.writer.startElement("xyLineChart");
        this.writeChart(jRChart);
        this.writeXyDataset((JRXyDataset)jRChart.getDataset());
        this.writeLinePlot((JRLinePlot)jRChart.getPlot());
        this.writer.closeElement();
    }

    public void writeMeterChart(JRChart jRChart) throws IOException {
        this.writer.startElement("meterChart");
        this.writeChart(jRChart);
        this.writeValueDataset((JRValueDataset)jRChart.getDataset());
        JRMeterPlot jRMeterPlot = (JRMeterPlot)jRChart.getPlot();
        this.writer.startElement("meterPlot");
        this.writer.addAttribute("shape", jRMeterPlot.getShape(), JRXmlConstants.getMeterShapeMap(), (byte)2);
        this.writer.addAttribute("angle", jRMeterPlot.getMeterAngle());
        this.writer.addAttribute("units", jRMeterPlot.getUnits());
        this.writer.addAttribute("tickInterval", jRMeterPlot.getTickInterval());
        this.writer.addAttribute("meterColor", jRMeterPlot.getMeterBackgroundColor());
        this.writer.addAttribute("needleColor", jRMeterPlot.getNeedleColor());
        this.writer.addAttribute("tickColor", jRMeterPlot.getTickColor());
        this.writePlot(jRChart.getPlot());
        this.writeValueDisplay(jRMeterPlot.getValueDisplay());
        this.writeDataRange(jRMeterPlot.getDataRange());
        List list = jRMeterPlot.getIntervals();
        if (list != null) {
            for (JRMeterInterval jRMeterInterval : list) {
                this.writeMeterInterval(jRMeterInterval);
            }
        }
        this.writer.closeElement();
        this.writer.closeElement();
    }

    public void writeThermometerChart(JRChart jRChart) throws IOException {
        this.writer.startElement("thermometerChart");
        this.writeChart(jRChart);
        this.writeValueDataset((JRValueDataset)jRChart.getDataset());
        JRThermometerPlot jRThermometerPlot = (JRThermometerPlot)jRChart.getPlot();
        this.writer.startElement("thermometerPlot");
        this.writer.addAttribute("valueLocation", jRThermometerPlot.getValueLocation(), JRXmlConstants.getThermometerValueLocationMap(), (byte)3);
        this.writer.addAttribute("isShowValueLines", jRThermometerPlot.isShowValueLines());
        this.writer.addAttribute("mercuryColor", jRThermometerPlot.getMercuryColor());
        this.writePlot(jRChart.getPlot());
        this.writeValueDisplay(jRThermometerPlot.getValueDisplay());
        this.writeDataRange(jRThermometerPlot.getDataRange());
        if (jRThermometerPlot.getLowRange() != null) {
            this.writer.startElement("lowRange");
            this.writeDataRange(jRThermometerPlot.getLowRange());
            this.writer.closeElement();
        }
        if (jRThermometerPlot.getMediumRange() != null) {
            this.writer.startElement("mediumRange");
            this.writeDataRange(jRThermometerPlot.getMediumRange());
            this.writer.closeElement();
        }
        if (jRThermometerPlot.getHighRange() != null) {
            this.writer.startElement("highRange");
            this.writeDataRange(jRThermometerPlot.getHighRange());
            this.writer.closeElement();
        }
        this.writer.closeElement();
        this.writer.closeElement();
    }

    public void writeMultiAxisChart(JRChart jRChart) throws IOException {
        this.writer.startElement("multiAxisChart");
        this.writeChart(jRChart);
        JRMultiAxisPlot jRMultiAxisPlot = (JRMultiAxisPlot)jRChart.getPlot();
        this.writer.startElement("multiAxisPlot");
        this.writePlot(jRChart.getPlot());
        List list = jRMultiAxisPlot.getAxes();
        if (list != null) {
            for (JRChartAxis jRChartAxis : list) {
                this.writeChartAxis(jRChartAxis);
            }
        }
        this.writer.closeElement();
        this.writer.closeElement();
    }

    public void writeChartTag(JRChart jRChart) throws IOException {
        switch (jRChart.getChartType()) {
            case 1: {
                this.writeAreaChart(jRChart);
                break;
            }
            case 3: {
                this.writeBarChart(jRChart);
                break;
            }
            case 2: {
                this.writeBar3DChart(jRChart);
                break;
            }
            case 4: {
                this.writeBubbleChart(jRChart);
                break;
            }
            case 5: {
                this.writeCandlestickChart(jRChart);
                break;
            }
            case 6: {
                this.writeHighLowChart(jRChart);
                break;
            }
            case 7: {
                this.writeLineChart(jRChart);
                break;
            }
            case 17: {
                this.writeMeterChart(jRChart);
                break;
            }
            case 19: {
                this.writeMultiAxisChart(jRChart);
                break;
            }
            case 9: {
                this.writePieChart(jRChart);
                break;
            }
            case 8: {
                this.writePie3DChart(jRChart);
                break;
            }
            case 10: {
                this.writeScatterChart(jRChart);
                break;
            }
            case 12: {
                this.writeStackedBarChart(jRChart);
                break;
            }
            case 11: {
                this.writeStackedBar3DChart(jRChart);
                break;
            }
            case 18: {
                this.writeThermometerChart(jRChart);
                break;
            }
            case 16: {
                this.writeTimeSeriesChart(jRChart);
                break;
            }
            case 13: {
                this.writeXyAreaChart(jRChart);
                break;
            }
            case 14: {
                this.writeXyBarChart(jRChart);
                break;
            }
            case 15: {
                this.writeXyLineChart(jRChart);
                break;
            }
            default: {
                throw new JRRuntimeException("Chart type not supported.");
            }
        }
    }

    private void writeSubreportReturnValue(JRSubreportReturnValue jRSubreportReturnValue) throws IOException {
        this.writer.startElement("returnValue");
        this.writer.addAttribute("subreportVariable", jRSubreportReturnValue.getSubreportVariable());
        this.writer.addAttribute("toVariable", jRSubreportReturnValue.getToVariable());
        this.writer.addAttribute("calculation", jRSubreportReturnValue.getCalculation(), JRXmlConstants.getCalculationMap(), (byte)0);
        this.writer.addAttribute("incrementerFactoryClass", jRSubreportReturnValue.getIncrementerFactoryClassName());
        this.writer.closeElement();
    }

    public void writeCrosstab(JRCrosstab jRCrosstab) throws IOException {
        this.writer.startElement("crosstab");
        this.writer.addAttribute("isRepeatColumnHeaders", jRCrosstab.isRepeatColumnHeaders(), true);
        this.writer.addAttribute("isRepeatRowHeaders", jRCrosstab.isRepeatRowHeaders(), true);
        this.writer.addAttribute("columnBreakOffset", jRCrosstab.getColumnBreakOffset(), 10);
        this.writeReportElement(jRCrosstab);
        JRCrosstabParameter[] jRCrosstabParameterArray = jRCrosstab.getParameters();
        if (jRCrosstabParameterArray != null) {
            for (int i = 0; i < jRCrosstabParameterArray.length; ++i) {
                if (jRCrosstabParameterArray[i].isSystemDefined()) continue;
                this.writeCrosstabParameter(jRCrosstabParameterArray[i]);
            }
        }
        this.writer.writeExpression("parametersMapExpression", jRCrosstab.getParametersMapExpression(), false);
        this.writeCrosstabDataset(jRCrosstab);
        this.writeCrosstabHeaderCell(jRCrosstab);
        JRCrosstabRowGroup[] jRCrosstabRowGroupArray = jRCrosstab.getRowGroups();
        for (int i = 0; i < jRCrosstabRowGroupArray.length; ++i) {
            this.writeCrosstabRowGroup(jRCrosstabRowGroupArray[i]);
        }
        JRCrosstabColumnGroup[] jRCrosstabColumnGroupArray = jRCrosstab.getColumnGroups();
        for (int i = 0; i < jRCrosstabColumnGroupArray.length; ++i) {
            this.writeCrosstabColumnGroup(jRCrosstabColumnGroupArray[i]);
        }
        JRCrosstabMeasure[] jRCrosstabMeasureArray = jRCrosstab.getMeasures();
        for (int i = 0; i < jRCrosstabMeasureArray.length; ++i) {
            this.writeCrosstabMeasure(jRCrosstabMeasureArray[i]);
        }
        if (jRCrosstab instanceof JRDesignCrosstab) {
            List list = ((JRDesignCrosstab)jRCrosstab).getCellsList();
            for (JRCrosstabCell jRCrosstabCell : list) {
                this.writeCrosstabCell(jRCrosstabCell);
            }
        } else {
            JRCrosstabCell[][] jRCrosstabCellArray = jRCrosstab.getCells();
            HashSet<JRCrosstabCell> hashSet = new HashSet<JRCrosstabCell>();
            for (int i = jRCrosstabCellArray.length - 1; i >= 0; --i) {
                for (int j = jRCrosstabCellArray[i].length - 1; j >= 0; --j) {
                    JRCrosstabCell jRCrosstabCell = jRCrosstabCellArray[i][j];
                    if (jRCrosstabCell == null || !hashSet.add(jRCrosstabCell)) continue;
                    this.writeCrosstabCell(jRCrosstabCell);
                }
            }
        }
        this.writeCrosstabWhenNoDataCell(jRCrosstab);
        this.writer.closeElement();
    }

    private void writeCrosstabDataset(JRCrosstab jRCrosstab) throws IOException {
        JRCrosstabDataset jRCrosstabDataset = jRCrosstab.getDataset();
        this.writer.startElement("crosstabDataset");
        this.writer.addAttribute("isDataPreSorted", jRCrosstabDataset.isDataPreSorted(), false);
        this.writeElementDataset(jRCrosstabDataset);
        this.writer.closeElement(true);
    }

    private void writeCrosstabWhenNoDataCell(JRCrosstab jRCrosstab) throws IOException {
        JRCellContents jRCellContents = jRCrosstab.getWhenNoDataCell();
        if (jRCellContents != null) {
            this.writer.startElement("whenNoDataCell");
            this.writeCellContents(jRCellContents);
            this.writer.closeElement();
        }
    }

    private void writeCrosstabHeaderCell(JRCrosstab jRCrosstab) throws IOException {
        JRCellContents jRCellContents = jRCrosstab.getHeaderCell();
        if (jRCellContents != null) {
            this.writer.startElement("crosstabHeaderCell");
            this.writeCellContents(jRCellContents);
            this.writer.closeElement();
        }
    }

    protected void writeCrosstabRowGroup(JRCrosstabRowGroup jRCrosstabRowGroup) throws IOException {
        this.writer.startElement("rowGroup");
        this.writer.addAttribute("name", jRCrosstabRowGroup.getName());
        this.writer.addAttribute("width", jRCrosstabRowGroup.getWidth());
        this.writer.addAttribute("totalPosition", jRCrosstabRowGroup.getTotalPosition(), JRXmlConstants.getCrosstabTotalPositionMap(), (byte)0);
        this.writer.addAttribute("headerPosition", jRCrosstabRowGroup.getPosition(), JRXmlConstants.getCrosstabRowPositionMap(), (byte)1);
        this.writeBucket(jRCrosstabRowGroup.getBucket());
        JRCellContents jRCellContents = jRCrosstabRowGroup.getHeader();
        this.writer.startElement("crosstabRowHeader");
        this.writeCellContents(jRCellContents);
        this.writer.closeElement();
        JRCellContents jRCellContents2 = jRCrosstabRowGroup.getTotalHeader();
        this.writer.startElement("crosstabTotalRowHeader");
        this.writeCellContents(jRCellContents2);
        this.writer.closeElement();
        this.writer.closeElement();
    }

    protected void writeCrosstabColumnGroup(JRCrosstabColumnGroup jRCrosstabColumnGroup) throws IOException {
        this.writer.startElement("columnGroup");
        this.writer.addAttribute("name", jRCrosstabColumnGroup.getName());
        this.writer.addAttribute("height", jRCrosstabColumnGroup.getHeight());
        this.writer.addAttribute("totalPosition", jRCrosstabColumnGroup.getTotalPosition(), JRXmlConstants.getCrosstabTotalPositionMap(), (byte)0);
        this.writer.addAttribute("headerPosition", jRCrosstabColumnGroup.getPosition(), JRXmlConstants.getCrosstabColumnPositionMap(), (byte)1);
        this.writeBucket(jRCrosstabColumnGroup.getBucket());
        JRCellContents jRCellContents = jRCrosstabColumnGroup.getHeader();
        this.writer.startElement("crosstabColumnHeader");
        this.writeCellContents(jRCellContents);
        this.writer.closeElement();
        JRCellContents jRCellContents2 = jRCrosstabColumnGroup.getTotalHeader();
        this.writer.startElement("crosstabTotalColumnHeader");
        this.writeCellContents(jRCellContents2);
        this.writer.closeElement();
        this.writer.closeElement();
    }

    protected void writeBucket(JRCrosstabBucket jRCrosstabBucket) throws IOException {
        this.writer.startElement("bucket");
        this.writer.addAttribute("order", jRCrosstabBucket.getOrder(), JRXmlConstants.getCrosstabBucketOrderMap(), (byte)1);
        this.writer.writeExpression("bucketExpression", jRCrosstabBucket.getExpression(), true);
        this.writer.writeExpression("comparatorExpression", jRCrosstabBucket.getComparatorExpression(), false);
        this.writer.closeElement();
    }

    protected void writeCrosstabMeasure(JRCrosstabMeasure jRCrosstabMeasure) throws IOException {
        this.writer.startElement("measure");
        this.writer.addAttribute("name", jRCrosstabMeasure.getName());
        this.writer.addAttribute("class", jRCrosstabMeasure.getValueClassName());
        this.writer.addAttribute("calculation", jRCrosstabMeasure.getCalculation(), JRXmlConstants.getCalculationMap(), (byte)0);
        this.writer.addAttribute("percentageOf", jRCrosstabMeasure.getPercentageOfType(), JRXmlConstants.getCrosstabPercentageMap(), (byte)0);
        this.writer.addAttribute("percentageCalculatorClass", jRCrosstabMeasure.getPercentageCalculatorClassName());
        this.writer.writeExpression("measureExpression", jRCrosstabMeasure.getValueExpression(), false);
        this.writer.closeElement();
    }

    protected void writeCrosstabCell(JRCrosstabCell jRCrosstabCell) throws IOException {
        this.writer.startElement("crosstabCell");
        this.writer.addAttribute("width", jRCrosstabCell.getWidth());
        this.writer.addAttribute("height", jRCrosstabCell.getHeight());
        this.writer.addAttribute("rowTotalGroup", jRCrosstabCell.getRowTotalGroup());
        this.writer.addAttribute("columnTotalGroup", jRCrosstabCell.getColumnTotalGroup());
        this.writeCellContents(jRCrosstabCell.getContents());
        this.writer.closeElement();
    }

    protected void writeCellContents(JRCellContents jRCellContents) throws IOException {
        if (jRCellContents != null) {
            this.writer.startElement("cellContents");
            this.writer.addAttribute("backcolor", jRCellContents.getBackcolor());
            this.writer.addAttribute("mode", jRCellContents.getMode(), JRXmlConstants.getModeMap());
            JRStyle jRStyle = jRCellContents.getStyle();
            if (jRStyle != null) {
                this.writer.addAttribute("style", jRStyle.getName());
            }
            this.writeBox(jRCellContents.getBox());
            List list = jRCellContents.getChildren();
            if (list != null) {
                for (JRChild jRChild : list) {
                    jRChild.writeXml(this);
                }
            }
            this.writer.closeElement();
        }
    }

    protected void writeCrosstabParameter(JRCrosstabParameter jRCrosstabParameter) throws IOException {
        this.writer.startElement("crosstabParameter");
        this.writer.addAttribute("name", jRCrosstabParameter.getName());
        this.writer.addAttribute("class", jRCrosstabParameter.getValueClassName(), "java.lang.String");
        this.writer.writeExpression("parameterValueExpression", jRCrosstabParameter.getExpression(), false);
        this.writer.closeElement();
    }

    public void writeDataset(JRDataset jRDataset) throws IOException {
        this.writer.startElement("subDataset");
        this.writer.addAttribute("name", jRDataset.getName());
        this.writer.addAttribute("scriptletClass", jRDataset.getScriptletClass());
        this.writer.addAttribute("resourceBundle", jRDataset.getResourceBundle());
        this.writer.addAttribute("whenResourceMissingType", jRDataset.getWhenResourceMissingType(), JRXmlConstants.getWhenResourceMissingTypeMap(), (byte)1);
        this.writeProperties(jRDataset.getPropertiesMap());
        this.writeDatasetContents(jRDataset);
        this.writer.closeElement();
    }

    protected void writeDatasetContents(JRDataset jRDataset) throws IOException {
        JRVariable[] jRVariableArray;
        JRSortField[] jRSortFieldArray;
        JRField[] jRFieldArray;
        JRParameter[] jRParameterArray = jRDataset.getParameters();
        if (jRParameterArray != null && jRParameterArray.length > 0) {
            for (int i = 0; i < jRParameterArray.length; ++i) {
                if (jRParameterArray[i].isSystemDefined()) continue;
                this.writeParameter(jRParameterArray[i]);
            }
        }
        if (jRDataset.getQuery() != null) {
            this.writeQuery(jRDataset.getQuery());
        }
        if ((jRFieldArray = jRDataset.getFields()) != null && jRFieldArray.length > 0) {
            for (int i = 0; i < jRFieldArray.length; ++i) {
                this.writeField(jRFieldArray[i]);
            }
        }
        if ((jRSortFieldArray = jRDataset.getSortFields()) != null && jRSortFieldArray.length > 0) {
            for (int i = 0; i < jRSortFieldArray.length; ++i) {
                this.writeSortField(jRSortFieldArray[i]);
            }
        }
        if ((jRVariableArray = jRDataset.getVariables()) != null && jRVariableArray.length > 0) {
            for (int i = 0; i < jRVariableArray.length; ++i) {
                if (jRVariableArray[i].isSystemDefined()) continue;
                this.writeVariable(jRVariableArray[i]);
            }
        }
        this.writer.writeExpression("filterExpression", jRDataset.getFilterExpression(), false);
        JRGroup[] jRGroupArray = jRDataset.getGroups();
        if (jRGroupArray != null && jRGroupArray.length > 0) {
            for (int i = 0; i < jRGroupArray.length; ++i) {
                this.writeGroup(jRGroupArray[i]);
            }
        }
    }

    protected void writeDatasetRun(JRDatasetRun jRDatasetRun) throws IOException {
        this.writer.startElement("datasetRun");
        this.writer.addAttribute("subDataset", jRDatasetRun.getDatasetName());
        this.writer.writeExpression("parametersMapExpression", jRDatasetRun.getParametersMapExpression(), false);
        JRDatasetParameter[] jRDatasetParameterArray = jRDatasetRun.getParameters();
        if (jRDatasetParameterArray != null && jRDatasetParameterArray.length > 0) {
            for (int i = 0; i < jRDatasetParameterArray.length; ++i) {
                this.writeDatasetParameter(jRDatasetParameterArray[i]);
            }
        }
        this.writer.writeExpression("connectionExpression", jRDatasetRun.getConnectionExpression(), false);
        this.writer.writeExpression("dataSourceExpression", jRDatasetRun.getDataSourceExpression(), false);
        this.writer.closeElement();
    }

    public void writeFrame(JRFrame jRFrame) throws IOException {
        this.writer.startElement("frame");
        this.writeReportElement(jRFrame);
        this.writeBox(jRFrame);
        List list = jRFrame.getChildren();
        if (list != null) {
            for (JRChild jRChild : list) {
                jRChild.writeXml(this);
            }
        }
        this.writer.closeElement();
    }

    protected void writeHyperlinkParameters(JRHyperlinkParameter[] jRHyperlinkParameterArray) throws IOException {
        if (jRHyperlinkParameterArray != null) {
            for (int i = 0; i < jRHyperlinkParameterArray.length; ++i) {
                JRHyperlinkParameter jRHyperlinkParameter = jRHyperlinkParameterArray[i];
                this.writeHyperlinkParameter(jRHyperlinkParameter);
            }
        }
    }

    protected void writeHyperlinkParameter(JRHyperlinkParameter jRHyperlinkParameter) throws IOException {
        if (jRHyperlinkParameter != null) {
            this.writer.startElement("hyperlinkParameter");
            this.writer.addAttribute("name", jRHyperlinkParameter.getName());
            this.writer.writeExpression("hyperlinkParameterExpression", jRHyperlinkParameter.getValueExpression(), true, String.class.getName());
            this.writer.closeElement();
        }
    }

    protected void writeHyperlink(String string, JRHyperlink jRHyperlink) throws IOException {
        if (jRHyperlink != null) {
            this.writer.startElement(string);
            this.writer.addAttribute("hyperlinkType", jRHyperlink.getLinkType());
            this.writer.addAttribute("hyperlinkTarget", jRHyperlink.getHyperlinkTarget(), JRXmlConstants.getHyperlinkTargetMap(), (byte)1);
            this.writer.writeExpression("hyperlinkReferenceExpression", jRHyperlink.getHyperlinkReferenceExpression(), false);
            this.writer.writeExpression("hyperlinkAnchorExpression", jRHyperlink.getHyperlinkAnchorExpression(), false);
            this.writer.writeExpression("hyperlinkPageExpression", jRHyperlink.getHyperlinkPageExpression(), false);
            this.writer.writeExpression("hyperlinkTooltipExpression", jRHyperlink.getHyperlinkTooltipExpression(), false);
            this.writeHyperlinkParameters(jRHyperlink.getHyperlinkParameters());
            this.writer.closeElement();
        }
    }
}

