/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.awt.Color;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import net.sf.jasperreports.engine.JRAbstractObjectFactory;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRHyperlinkParameter;
import net.sf.jasperreports.engine.JRImage;
import net.sf.jasperreports.engine.JRImageRenderer;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintHyperlinkParameters;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRCloneable;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillGraphicElement;
import net.sf.jasperreports.engine.fill.JRFillHyperlinkHelper;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRRecordedValuesPrintImage;
import net.sf.jasperreports.engine.fill.JRTemplateImage;
import net.sf.jasperreports.engine.fill.JRTemplatePrintImage;
import net.sf.jasperreports.engine.util.JRStyleResolver;
import net.sf.jasperreports.engine.xml.JRXmlWriter;

public class JRFillImage
extends JRFillGraphicElement
implements JRImage {
    private JRGroup evaluationGroup = null;
    private JRRenderable renderer = null;
    private String anchorName = null;
    private String hyperlinkReference = null;
    private String hyperlinkAnchor = null;
    private Integer hyperlinkPage = null;
    private String hyperlinkTooltip;
    private JRPrintHyperlinkParameters hyperlinkParameters;

    protected JRFillImage(JRBaseFiller jRBaseFiller, JRImage jRImage, JRFillObjectFactory jRFillObjectFactory) {
        super(jRBaseFiller, jRImage, jRFillObjectFactory);
        this.evaluationGroup = jRFillObjectFactory.getGroup(jRImage.getEvaluationGroup());
    }

    protected JRFillImage(JRFillImage jRFillImage, JRFillCloneFactory jRFillCloneFactory) {
        super(jRFillImage, jRFillCloneFactory);
        this.evaluationGroup = jRFillImage.evaluationGroup;
    }

    @Override
    public byte getMode() {
        return JRStyleResolver.getMode(this, (byte)2);
    }

    @Override
    public byte getPen() {
        return JRStyleResolver.getPen(this, (byte)0);
    }

    @Override
    public byte getScaleImage() {
        return JRStyleResolver.getScaleImage(this);
    }

    @Override
    public Byte getOwnScaleImage() {
        return ((JRImage)this.parent).getOwnScaleImage();
    }

    @Override
    public void setScaleImage(byte by) {
    }

    @Override
    public void setScaleImage(Byte by) {
    }

    @Override
    public byte getHorizontalAlignment() {
        return JRStyleResolver.getHorizontalAlignment(this);
    }

    @Override
    public Byte getOwnHorizontalAlignment() {
        return ((JRImage)this.parent).getOwnHorizontalAlignment();
    }

    @Override
    public void setHorizontalAlignment(byte by) {
    }

    @Override
    public void setHorizontalAlignment(Byte by) {
    }

    @Override
    public byte getVerticalAlignment() {
        return JRStyleResolver.getVerticalAlignment(this);
    }

    @Override
    public Byte getOwnVerticalAlignment() {
        return ((JRImage)this.parent).getOwnVerticalAlignment();
    }

    @Override
    public void setVerticalAlignment(byte by) {
    }

    @Override
    public void setVerticalAlignment(Byte by) {
    }

    @Override
    public boolean isUsingCache() {
        return ((JRImage)this.parent).isUsingCache();
    }

    @Override
    public Boolean isOwnUsingCache() {
        return ((JRImage)this.parent).isOwnUsingCache();
    }

    @Override
    public void setUsingCache(boolean bl) {
    }

    @Override
    public void setUsingCache(Boolean bl) {
    }

    @Override
    public boolean isLazy() {
        return ((JRImage)this.parent).isLazy();
    }

    @Override
    public void setLazy(boolean bl) {
    }

    @Override
    public byte getOnErrorType() {
        return ((JRImage)this.parent).getOnErrorType();
    }

    @Override
    public void setOnErrorType(byte by) {
    }

    @Override
    public byte getEvaluationTime() {
        return ((JRImage)this.parent).getEvaluationTime();
    }

    @Override
    public JRGroup getEvaluationGroup() {
        return this.evaluationGroup;
    }

    @Override
    public JRBox getBox() {
        return this;
    }

    @Override
    public byte getHyperlinkType() {
        return ((JRImage)this.parent).getHyperlinkType();
    }

    @Override
    public byte getHyperlinkTarget() {
        return ((JRImage)this.parent).getHyperlinkTarget();
    }

    @Override
    public JRExpression getExpression() {
        return ((JRImage)this.parent).getExpression();
    }

    @Override
    public JRExpression getAnchorNameExpression() {
        return ((JRImage)this.parent).getAnchorNameExpression();
    }

    @Override
    public JRExpression getHyperlinkReferenceExpression() {
        return ((JRImage)this.parent).getHyperlinkReferenceExpression();
    }

    @Override
    public JRExpression getHyperlinkAnchorExpression() {
        return ((JRImage)this.parent).getHyperlinkAnchorExpression();
    }

    @Override
    public JRExpression getHyperlinkPageExpression() {
        return ((JRImage)this.parent).getHyperlinkPageExpression();
    }

    protected JRRenderable getRenderer() {
        return this.renderer;
    }

    protected String getAnchorName() {
        return this.anchorName;
    }

    protected String getHyperlinkReference() {
        return this.hyperlinkReference;
    }

    protected String getHyperlinkAnchor() {
        return this.hyperlinkAnchor;
    }

    protected Integer getHyperlinkPage() {
        return this.hyperlinkPage;
    }

    protected String getHyperlinkTooltip() {
        return this.hyperlinkTooltip;
    }

    protected JRTemplateImage getJRTemplateImage() {
        JRStyle jRStyle = this.getStyle();
        JRTemplateImage jRTemplateImage = (JRTemplateImage)this.getTemplate(jRStyle);
        if (jRTemplateImage == null) {
            jRTemplateImage = new JRTemplateImage(this.filler.getJasperPrint().getDefaultStyleProvider(), this);
            this.registerTemplate(jRStyle, jRTemplateImage);
        }
        return jRTemplateImage;
    }

    @Override
    protected void evaluate(byte by) throws JRException {
        this.initDelayedEvaluations();
        this.reset();
        this.evaluatePrintWhenExpression(by);
        if ((this.isPrintWhenExpressionNull() || !this.isPrintWhenExpressionNull() && this.isPrintWhenTrue()) && this.isEvaluateNow()) {
            this.evaluateImage(by);
        }
    }

    protected void evaluateImage(byte by) throws JRException {
        JRExpression jRExpression = this.getExpression();
        JRRenderable jRRenderable = null;
        Object object = this.evaluateExpression(jRExpression, by);
        if (object != null) {
            if (this.isUsingCache() && this.filler.fillContext.hasLoadedImage(object)) {
                jRRenderable = this.filler.fillContext.getLoadedImage(object).getRenderer();
            } else {
                Object object2;
                Class clazz = jRExpression.getValueClass();
                if (Image.class.getName().equals(clazz.getName())) {
                    object2 = (Image)object;
                    jRRenderable = JRImageRenderer.getInstance((Image)object2, this.getOnErrorType());
                } else if (InputStream.class.getName().equals(clazz.getName())) {
                    object2 = (InputStream)object;
                    jRRenderable = JRImageRenderer.getInstance((InputStream)object2, this.getOnErrorType());
                } else if (URL.class.getName().equals(clazz.getName())) {
                    object2 = (URL)object;
                    jRRenderable = JRImageRenderer.getInstance((URL)object2, this.getOnErrorType());
                } else if (File.class.getName().equals(clazz.getName())) {
                    object2 = (File)object;
                    jRRenderable = JRImageRenderer.getInstance((File)object2, this.getOnErrorType());
                } else if (String.class.getName().equals(clazz.getName())) {
                    object2 = (String)object;
                    jRRenderable = JRImageRenderer.getInstance((String)object2, this.getOnErrorType(), this.isLazy(), this.filler.reportClassLoader, this.filler.urlHandlerFactory);
                } else if (JRRenderable.class.getName().equals(clazz.getName())) {
                    jRRenderable = (JRRenderable)object;
                }
                if (this.isUsingCache()) {
                    object2 = new JRTemplatePrintImage(this.getJRTemplateImage());
                    object2.setRenderer(jRRenderable);
                    this.filler.fillContext.registerLoadedImage(object, (JRPrintImage)object2);
                }
            }
        }
        this.setValueRepeating(this.renderer == jRRenderable);
        this.renderer = jRRenderable;
        this.anchorName = (String)this.evaluateExpression(this.getAnchorNameExpression(), by);
        this.hyperlinkReference = (String)this.evaluateExpression(this.getHyperlinkReferenceExpression(), by);
        this.hyperlinkAnchor = (String)this.evaluateExpression(this.getHyperlinkAnchorExpression(), by);
        this.hyperlinkPage = (Integer)this.evaluateExpression(this.getHyperlinkPageExpression(), by);
        this.hyperlinkTooltip = (String)this.evaluateExpression(this.getHyperlinkTooltipExpression(), by);
        this.hyperlinkParameters = JRFillHyperlinkHelper.evaluateHyperlinkParameters(this, this.expressionEvaluator, by);
    }

    @Override
    protected boolean prepare(int n, boolean bl) {
        boolean bl2 = false;
        if (this.isPrintWhenExpressionNull() || !this.isPrintWhenExpressionNull() && this.isPrintWhenTrue()) {
            this.setToPrint(true);
        } else {
            this.setToPrint(false);
        }
        if (!this.isToPrint()) {
            return bl2;
        }
        boolean bl3 = true;
        boolean bl4 = false;
        if (this.isEvaluateNow()) {
            if (bl && this.isAlreadyPrinted() && !this.isPrintWhenDetailOverflows()) {
                bl3 = false;
            }
            if (!(!bl3 || !this.isPrintWhenExpressionNull() || this.isPrintRepeatedValues() || !this.isValueRepeating() || this.isPrintInFirstWholeBand() && this.getBand().isFirstWholeOnPageColumn() || this.getPrintWhenGroupChanges() != null && this.getBand().isNewGroup(this.getPrintWhenGroupChanges()) || bl && this.isPrintWhenDetailOverflows())) {
                bl3 = false;
            }
            if (bl3 && n < this.getRelativeY() - this.getY() - this.getBandBottomY()) {
                bl3 = false;
                bl2 = true;
            }
            if (bl3 && bl && this.isPrintWhenDetailOverflows() && (this.isAlreadyPrinted() || !this.isAlreadyPrinted() && !this.isPrintRepeatedValues())) {
                bl4 = true;
            }
            if (bl3 && this.isRemoveLineWhenBlank() && this.getRenderer() == null) {
                bl3 = false;
            }
        } else {
            if (bl && this.isAlreadyPrinted() && !this.isPrintWhenDetailOverflows()) {
                bl3 = false;
            }
            if (bl3 && n < this.getRelativeY() - this.getY() - this.getBandBottomY()) {
                bl3 = false;
                bl2 = true;
            }
            if (bl3 && bl && this.isPrintWhenDetailOverflows() && (this.isAlreadyPrinted() || !this.isAlreadyPrinted() && !this.isPrintRepeatedValues())) {
                bl4 = true;
            }
        }
        this.setToPrint(bl3);
        this.setReprinted(bl4);
        return bl2;
    }

    @Override
    protected JRPrintElement fill() throws JRException {
        JRTemplatePrintImage jRTemplatePrintImage;
        JRRecordedValuesPrintImage jRRecordedValuesPrintImage;
        byte by = this.getEvaluationTime();
        if (this.isEvaluateAuto()) {
            jRRecordedValuesPrintImage = new JRRecordedValuesPrintImage(this.getJRTemplateImage());
            jRTemplatePrintImage = jRRecordedValuesPrintImage;
        } else {
            jRTemplatePrintImage = new JRTemplatePrintImage(this.getJRTemplateImage());
            jRRecordedValuesPrintImage = null;
        }
        jRTemplatePrintImage.setX(this.getX());
        jRTemplatePrintImage.setY(this.getRelativeY());
        jRTemplatePrintImage.setWidth(this.getWidth());
        jRTemplatePrintImage.setHeight(this.getStretchHeight());
        if (this.isEvaluateNow()) {
            this.copy(jRTemplatePrintImage);
        } else if (this.isEvaluateAuto()) {
            this.initDelayedEvaluationPrint(jRRecordedValuesPrintImage);
        } else {
            this.filler.addBoundElement(this, jRTemplatePrintImage, by, this.getEvaluationGroup(), this.band);
        }
        return jRTemplatePrintImage;
    }

    protected void copy(JRPrintImage jRPrintImage) {
        jRPrintImage.setRenderer(this.getRenderer());
        jRPrintImage.setAnchorName(this.getAnchorName());
        jRPrintImage.setHyperlinkReference(this.getHyperlinkReference());
        jRPrintImage.setHyperlinkAnchor(this.getHyperlinkAnchor());
        jRPrintImage.setHyperlinkPage(this.getHyperlinkPage());
        jRPrintImage.setHyperlinkTooltip(this.getHyperlinkTooltip());
        jRPrintImage.setBookmarkLevel(this.getBookmarkLevel());
        jRPrintImage.setHyperlinkParameters(this.hyperlinkParameters);
    }

    @Override
    public JRChild getCopy(JRAbstractObjectFactory jRAbstractObjectFactory) {
        return jRAbstractObjectFactory.getImage(this);
    }

    @Override
    public void collectExpressions(JRExpressionCollector jRExpressionCollector) {
        jRExpressionCollector.collect(this);
    }

    @Override
    public void writeXml(JRXmlWriter jRXmlWriter) throws IOException {
        jRXmlWriter.writeImage(this);
    }

    @Override
    protected void resolveElement(JRPrintElement jRPrintElement, byte by) throws JRException {
        this.evaluateImage(by);
        this.copy((JRPrintImage)jRPrintElement);
    }

    @Override
    public int getBookmarkLevel() {
        return ((JRImage)this.parent).getBookmarkLevel();
    }

    @Override
    public byte getBorder() {
        return JRStyleResolver.getBorder(this);
    }

    @Override
    public Byte getOwnBorder() {
        return ((JRBox)((Object)this.parent)).getOwnBorder();
    }

    @Override
    public void setBorder(byte by) {
    }

    @Override
    public Color getBorderColor() {
        return JRStyleResolver.getBorderColor(this, this.getForecolor());
    }

    @Override
    public Color getOwnBorderColor() {
        return ((JRBox)((Object)this.parent)).getOwnBorderColor();
    }

    @Override
    public void setBorderColor(Color color) {
    }

    @Override
    public int getPadding() {
        return JRStyleResolver.getPadding(this);
    }

    @Override
    public Integer getOwnPadding() {
        return ((JRBox)((Object)this.parent)).getOwnPadding();
    }

    @Override
    public void setPadding(int n) {
    }

    @Override
    public byte getTopBorder() {
        return JRStyleResolver.getTopBorder(this);
    }

    @Override
    public Byte getOwnTopBorder() {
        return ((JRBox)((Object)this.parent)).getOwnTopBorder();
    }

    @Override
    public void setTopBorder(byte by) {
    }

    @Override
    public Color getTopBorderColor() {
        return JRStyleResolver.getTopBorderColor(this, this.getForecolor());
    }

    @Override
    public Color getOwnTopBorderColor() {
        return ((JRBox)((Object)this.parent)).getOwnTopBorderColor();
    }

    @Override
    public void setTopBorderColor(Color color) {
    }

    @Override
    public int getTopPadding() {
        return JRStyleResolver.getTopPadding(this);
    }

    @Override
    public Integer getOwnTopPadding() {
        return ((JRBox)((Object)this.parent)).getOwnTopPadding();
    }

    @Override
    public void setTopPadding(int n) {
    }

    @Override
    public byte getLeftBorder() {
        return JRStyleResolver.getLeftBorder(this);
    }

    @Override
    public Byte getOwnLeftBorder() {
        return ((JRBox)((Object)this.parent)).getOwnLeftBorder();
    }

    @Override
    public void setLeftBorder(byte by) {
    }

    @Override
    public Color getLeftBorderColor() {
        return JRStyleResolver.getLeftBorderColor(this, this.getForecolor());
    }

    @Override
    public Color getOwnLeftBorderColor() {
        return ((JRBox)((Object)this.parent)).getOwnLeftBorderColor();
    }

    @Override
    public void setLeftBorderColor(Color color) {
    }

    @Override
    public int getLeftPadding() {
        return JRStyleResolver.getLeftPadding(this);
    }

    @Override
    public Integer getOwnLeftPadding() {
        return ((JRBox)((Object)this.parent)).getOwnLeftPadding();
    }

    @Override
    public void setLeftPadding(int n) {
    }

    @Override
    public byte getBottomBorder() {
        return JRStyleResolver.getBottomBorder(this);
    }

    @Override
    public Byte getOwnBottomBorder() {
        return ((JRBox)((Object)this.parent)).getOwnBottomBorder();
    }

    @Override
    public void setBottomBorder(byte by) {
    }

    @Override
    public Color getBottomBorderColor() {
        return JRStyleResolver.getBottomBorderColor(this, this.getForecolor());
    }

    @Override
    public Color getOwnBottomBorderColor() {
        return ((JRBox)((Object)this.parent)).getOwnBottomBorderColor();
    }

    @Override
    public void setBottomBorderColor(Color color) {
    }

    @Override
    public int getBottomPadding() {
        return JRStyleResolver.getBottomPadding(this);
    }

    @Override
    public Integer getOwnBottomPadding() {
        return ((JRBox)((Object)this.parent)).getOwnBottomPadding();
    }

    @Override
    public void setBottomPadding(int n) {
    }

    @Override
    public byte getRightBorder() {
        return JRStyleResolver.getRightBorder(this);
    }

    @Override
    public Byte getOwnRightBorder() {
        return ((JRBox)((Object)this.parent)).getOwnRightBorder();
    }

    @Override
    public void setRightBorder(byte by) {
    }

    @Override
    public Color getRightBorderColor() {
        return JRStyleResolver.getRightBorderColor(this, this.getForecolor());
    }

    @Override
    public Color getOwnRightBorderColor() {
        return ((JRBox)((Object)this.parent)).getOwnRightBorderColor();
    }

    @Override
    public void setRightBorderColor(Color color) {
    }

    @Override
    public int getRightPadding() {
        return JRStyleResolver.getRightPadding(this);
    }

    @Override
    public Integer getOwnRightPadding() {
        return ((JRBox)((Object)this.parent)).getOwnRightPadding();
    }

    @Override
    public void setRightPadding(int n) {
    }

    @Override
    public void setBorder(Byte by) {
    }

    @Override
    public void setPadding(Integer n) {
    }

    @Override
    public void setTopBorder(Byte by) {
    }

    @Override
    public void setTopPadding(Integer n) {
    }

    @Override
    public void setLeftBorder(Byte by) {
    }

    @Override
    public void setLeftPadding(Integer n) {
    }

    @Override
    public void setBottomBorder(Byte by) {
    }

    @Override
    public void setBottomPadding(Integer n) {
    }

    @Override
    public void setRightBorder(Byte by) {
    }

    @Override
    public void setRightPadding(Integer n) {
    }

    @Override
    public JRCloneable createClone(JRFillCloneFactory jRFillCloneFactory) {
        return new JRFillImage(this, jRFillCloneFactory);
    }

    @Override
    protected void collectDelayedEvaluations() {
        this.collectDelayedEvaluations(this.getExpression());
        this.collectDelayedEvaluations(this.getAnchorNameExpression());
        this.collectDelayedEvaluations(this.getHyperlinkReferenceExpression());
        this.collectDelayedEvaluations(this.getHyperlinkAnchorExpression());
        this.collectDelayedEvaluations(this.getHyperlinkPageExpression());
    }

    @Override
    public JRHyperlinkParameter[] getHyperlinkParameters() {
        return ((JRImage)this.parent).getHyperlinkParameters();
    }

    @Override
    public String getLinkType() {
        return ((JRImage)this.parent).getLinkType();
    }

    @Override
    public JRExpression getHyperlinkTooltipExpression() {
        return ((JRImage)this.parent).getHyperlinkTooltipExpression();
    }
}

