/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.jasperreports.engine.JRAbstractObjectFactory;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRHyperlinkHelper;
import net.sf.jasperreports.engine.JRHyperlinkParameter;
import net.sf.jasperreports.engine.JRTextField;
import net.sf.jasperreports.engine.design.JRDesignTextElement;
import net.sf.jasperreports.engine.util.JRStyleResolver;
import net.sf.jasperreports.engine.xml.JRXmlWriter;

public class JRDesignTextField
extends JRDesignTextElement
implements JRTextField {
    private static final long serialVersionUID = 10200L;
    protected boolean isStretchWithOverflow = false;
    protected byte evaluationTime = 1;
    protected String pattern = null;
    protected Boolean isBlankWhenNull = null;
    protected byte hyperlinkType = 0;
    protected String linkType;
    protected byte hyperlinkTarget = 1;
    private List hyperlinkParameters = new ArrayList();
    protected JRGroup evaluationGroup = null;
    protected JRExpression expression = null;
    protected JRExpression anchorNameExpression = null;
    protected JRExpression hyperlinkReferenceExpression = null;
    protected JRExpression hyperlinkAnchorExpression = null;
    protected JRExpression hyperlinkPageExpression = null;
    private JRExpression hyperlinkTooltipExpression;
    protected int bookmarkLevel = 0;

    public JRDesignTextField() {
        super(null);
    }

    public JRDesignTextField(JRDefaultStyleProvider jRDefaultStyleProvider) {
        super(jRDefaultStyleProvider);
    }

    @Override
    public boolean isStretchWithOverflow() {
        return this.isStretchWithOverflow;
    }

    @Override
    public byte getEvaluationTime() {
        return this.evaluationTime;
    }

    @Override
    public String getPattern() {
        return JRStyleResolver.getPattern(this);
    }

    @Override
    public String getOwnPattern() {
        return this.pattern;
    }

    @Override
    public boolean isBlankWhenNull() {
        return JRStyleResolver.isBlankWhenNull(this);
    }

    @Override
    public Boolean isOwnBlankWhenNull() {
        return this.isBlankWhenNull;
    }

    @Override
    public byte getHyperlinkType() {
        return JRHyperlinkHelper.getHyperlinkType(this);
    }

    @Override
    public byte getHyperlinkTarget() {
        return this.hyperlinkTarget;
    }

    @Override
    public JRGroup getEvaluationGroup() {
        return this.evaluationGroup;
    }

    @Override
    public JRExpression getExpression() {
        return this.expression;
    }

    @Override
    public JRExpression getAnchorNameExpression() {
        return this.anchorNameExpression;
    }

    @Override
    public JRExpression getHyperlinkReferenceExpression() {
        return this.hyperlinkReferenceExpression;
    }

    @Override
    public JRExpression getHyperlinkAnchorExpression() {
        return this.hyperlinkAnchorExpression;
    }

    @Override
    public JRExpression getHyperlinkPageExpression() {
        return this.hyperlinkPageExpression;
    }

    @Override
    public void setStretchWithOverflow(boolean bl) {
        this.isStretchWithOverflow = bl;
    }

    public void setEvaluationTime(byte by) {
        this.evaluationTime = by;
    }

    @Override
    public void setPattern(String string) {
        this.pattern = string;
    }

    @Override
    public void setBlankWhenNull(boolean bl) {
        this.isBlankWhenNull = bl ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public void setBlankWhenNull(Boolean bl) {
        this.isBlankWhenNull = bl;
    }

    public void setHyperlinkType(byte by) {
        this.setLinkType(JRHyperlinkHelper.getLinkType(by));
    }

    public void setHyperlinkTarget(byte by) {
        this.hyperlinkTarget = by;
    }

    public void setEvaluationGroup(JRGroup jRGroup) {
        this.evaluationGroup = jRGroup;
    }

    public void setExpression(JRExpression jRExpression) {
        this.expression = jRExpression;
    }

    public void setAnchorNameExpression(JRExpression jRExpression) {
        this.anchorNameExpression = jRExpression;
    }

    public void setHyperlinkReferenceExpression(JRExpression jRExpression) {
        this.hyperlinkReferenceExpression = jRExpression;
    }

    public void setHyperlinkAnchorExpression(JRExpression jRExpression) {
        this.hyperlinkAnchorExpression = jRExpression;
    }

    public void setHyperlinkPageExpression(JRExpression jRExpression) {
        this.hyperlinkPageExpression = jRExpression;
    }

    @Override
    public JRChild getCopy(JRAbstractObjectFactory jRAbstractObjectFactory) {
        return jRAbstractObjectFactory.getTextField(this);
    }

    @Override
    public void collectExpressions(JRExpressionCollector jRExpressionCollector) {
        jRExpressionCollector.collect(this);
    }

    @Override
    public void writeXml(JRXmlWriter jRXmlWriter) throws IOException {
        jRXmlWriter.writeTextField(this);
    }

    @Override
    public int getBookmarkLevel() {
        return this.bookmarkLevel;
    }

    public void setBookmarkLevel(int n) {
        this.bookmarkLevel = n;
    }

    @Override
    public String getLinkType() {
        return this.linkType;
    }

    public void setLinkType(String string) {
        this.linkType = string;
    }

    @Override
    public JRHyperlinkParameter[] getHyperlinkParameters() {
        JRHyperlinkParameter[] jRHyperlinkParameterArray;
        if (this.hyperlinkParameters.isEmpty()) {
            jRHyperlinkParameterArray = null;
        } else {
            jRHyperlinkParameterArray = new JRHyperlinkParameter[this.hyperlinkParameters.size()];
            this.hyperlinkParameters.toArray(jRHyperlinkParameterArray);
        }
        return jRHyperlinkParameterArray;
    }

    public List getHyperlinkParametersList() {
        return this.hyperlinkParameters;
    }

    public void addHyperlinkParameter(JRHyperlinkParameter jRHyperlinkParameter) {
        this.hyperlinkParameters.add(jRHyperlinkParameter);
    }

    public void removeHyperlinkParameter(JRHyperlinkParameter jRHyperlinkParameter) {
        this.hyperlinkParameters.remove(jRHyperlinkParameter);
    }

    public void removeHyperlinkParameter(String string) {
        Iterator iterator = this.hyperlinkParameters.iterator();
        while (iterator.hasNext()) {
            JRHyperlinkParameter jRHyperlinkParameter = (JRHyperlinkParameter)iterator.next();
            if (jRHyperlinkParameter.getName() == null || !jRHyperlinkParameter.getName().equals(string)) continue;
            iterator.remove();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.normalizeLinkType();
    }

    protected void normalizeLinkType() {
        if (this.linkType == null) {
            this.linkType = JRHyperlinkHelper.getLinkType(this.hyperlinkType);
        }
        this.hyperlinkType = 0;
    }

    @Override
    public JRExpression getHyperlinkTooltipExpression() {
        return this.hyperlinkTooltipExpression;
    }

    public void setHyperlinkTooltipExpression(JRExpression jRExpression) {
        this.hyperlinkTooltipExpression = jRExpression;
    }
}

