/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.jasperreports.charts.design.JRDesignAreaPlot;
import net.sf.jasperreports.charts.design.JRDesignBar3DPlot;
import net.sf.jasperreports.charts.design.JRDesignBarPlot;
import net.sf.jasperreports.charts.design.JRDesignBubblePlot;
import net.sf.jasperreports.charts.design.JRDesignCandlestickPlot;
import net.sf.jasperreports.charts.design.JRDesignCategoryDataset;
import net.sf.jasperreports.charts.design.JRDesignHighLowDataset;
import net.sf.jasperreports.charts.design.JRDesignHighLowPlot;
import net.sf.jasperreports.charts.design.JRDesignLinePlot;
import net.sf.jasperreports.charts.design.JRDesignMeterPlot;
import net.sf.jasperreports.charts.design.JRDesignMultiAxisPlot;
import net.sf.jasperreports.charts.design.JRDesignPie3DPlot;
import net.sf.jasperreports.charts.design.JRDesignPieDataset;
import net.sf.jasperreports.charts.design.JRDesignPiePlot;
import net.sf.jasperreports.charts.design.JRDesignScatterPlot;
import net.sf.jasperreports.charts.design.JRDesignThermometerPlot;
import net.sf.jasperreports.charts.design.JRDesignTimePeriodDataset;
import net.sf.jasperreports.charts.design.JRDesignTimeSeriesDataset;
import net.sf.jasperreports.charts.design.JRDesignTimeSeriesPlot;
import net.sf.jasperreports.charts.design.JRDesignValueDataset;
import net.sf.jasperreports.charts.design.JRDesignXyDataset;
import net.sf.jasperreports.charts.design.JRDesignXyzDataset;
import net.sf.jasperreports.engine.JRAbstractObjectFactory;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRChartDataset;
import net.sf.jasperreports.engine.JRChartPlot;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRHyperlinkHelper;
import net.sf.jasperreports.engine.JRHyperlinkParameter;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.util.JRStyleResolver;
import net.sf.jasperreports.engine.xml.JRXmlWriter;

public class JRDesignChart
extends JRDesignElement
implements JRChart {
    private static final long serialVersionUID = 10200L;
    protected byte chartType = 0;
    protected boolean isShowLegend = false;
    protected byte evaluationTime = 1;
    protected byte hyperlinkType = 0;
    protected String linkType;
    protected byte hyperlinkTarget = 1;
    protected byte titlePosition = 1;
    protected Color titleColor = Color.black;
    protected Color subtitleColor = Color.black;
    protected Color legendColor = null;
    protected Color legendBackgroundColor = null;
    protected JRFont titleFont = null;
    protected JRFont subtitleFont = null;
    protected JRFont legendFont = null;
    protected String customizerClass;
    protected JRGroup evaluationGroup = null;
    protected JRExpression titleExpression = null;
    protected JRExpression subtitleExpression = null;
    protected JRExpression anchorNameExpression = null;
    protected JRExpression hyperlinkReferenceExpression = null;
    protected JRExpression hyperlinkAnchorExpression = null;
    protected JRExpression hyperlinkPageExpression = null;
    private JRExpression hyperlinkTooltipExpression;
    private List hyperlinkParameters;
    protected JRChartDataset dataset = null;
    protected JRChartPlot plot = null;
    protected Byte border;
    protected Byte topBorder = null;
    protected Byte leftBorder = null;
    protected Byte bottomBorder = null;
    protected Byte rightBorder = null;
    protected Color borderColor = null;
    protected Color topBorderColor = null;
    protected Color leftBorderColor = null;
    protected Color bottomBorderColor = null;
    protected Color rightBorderColor = null;
    protected Integer padding;
    protected Integer topPadding = null;
    protected Integer leftPadding = null;
    protected Integer bottomPadding = null;
    protected Integer rightPadding = null;
    protected int bookmarkLevel = 0;

    public JRDesignChart(JRDefaultStyleProvider jRDefaultStyleProvider, byte by) {
        super(jRDefaultStyleProvider);
        this.setChartType(by);
        this.hyperlinkParameters = new ArrayList();
    }

    @Override
    public boolean isShowLegend() {
        return this.isShowLegend;
    }

    @Override
    public void setShowLegend(boolean bl) {
        this.isShowLegend = bl;
    }

    @Override
    public byte getEvaluationTime() {
        return this.evaluationTime;
    }

    public void setEvaluationTime(byte by) {
        this.evaluationTime = by;
    }

    @Override
    public JRGroup getEvaluationGroup() {
        return this.evaluationGroup;
    }

    public void setEvaluationGroup(JRGroup jRGroup) {
        this.evaluationGroup = jRGroup;
    }

    @Override
    public JRBox getBox() {
        return this;
    }

    public void setBox(JRBox jRBox) {
        this.border = jRBox.getOwnBorder();
        this.topBorder = jRBox.getOwnTopBorder();
        this.leftBorder = jRBox.getOwnLeftBorder();
        this.bottomBorder = jRBox.getOwnBottomBorder();
        this.rightBorder = jRBox.getOwnRightBorder();
        this.borderColor = jRBox.getOwnBorderColor();
        this.topBorderColor = jRBox.getOwnTopBorderColor();
        this.leftBorderColor = jRBox.getOwnLeftBorderColor();
        this.bottomBorderColor = jRBox.getOwnBottomBorderColor();
        this.rightBorderColor = jRBox.getOwnRightBorderColor();
        this.padding = jRBox.getOwnPadding();
        this.topPadding = jRBox.getOwnTopPadding();
        this.leftPadding = jRBox.getOwnLeftPadding();
        this.bottomPadding = jRBox.getOwnBottomPadding();
        this.rightPadding = jRBox.getOwnRightPadding();
    }

    @Override
    public JRFont getTitleFont() {
        return this.titleFont;
    }

    public void setTitleFont(JRFont jRFont) {
        this.titleFont = jRFont;
    }

    @Override
    public byte getTitlePosition() {
        return this.titlePosition;
    }

    @Override
    public void setTitlePosition(byte by) {
        this.titlePosition = by;
    }

    @Override
    public Color getTitleColor() {
        return this.titleColor;
    }

    @Override
    public void setTitleColor(Color color) {
        this.titleColor = color;
    }

    @Override
    public JRFont getSubtitleFont() {
        return this.subtitleFont;
    }

    public void setSubtitleFont(JRFont jRFont) {
        this.subtitleFont = jRFont;
    }

    @Override
    public Color getSubtitleColor() {
        return this.subtitleColor;
    }

    @Override
    public void setSubtitleColor(Color color) {
        this.subtitleColor = color;
    }

    @Override
    public Color getLegendColor() {
        return this.legendColor;
    }

    @Override
    public void setLegendColor(Color color) {
        this.legendColor = color;
    }

    @Override
    public Color getLegendBackgroundColor() {
        return this.legendBackgroundColor;
    }

    @Override
    public void setLegendBackgroundColor(Color color) {
        this.legendBackgroundColor = color;
    }

    @Override
    public JRFont getLegendFont() {
        return this.legendFont;
    }

    public void setLegendFont(JRFont jRFont) {
        this.legendFont = jRFont;
    }

    @Override
    public byte getHyperlinkType() {
        return JRHyperlinkHelper.getHyperlinkType(this);
    }

    public void setHyperlinkType(byte by) {
        this.setLinkType(JRHyperlinkHelper.getLinkType(by));
    }

    @Override
    public byte getHyperlinkTarget() {
        return this.hyperlinkTarget;
    }

    public void setHyperlinkTarget(byte by) {
        this.hyperlinkTarget = by;
    }

    @Override
    public JRExpression getTitleExpression() {
        return this.titleExpression;
    }

    public void setTitleExpression(JRExpression jRExpression) {
        this.titleExpression = jRExpression;
    }

    @Override
    public JRExpression getSubtitleExpression() {
        return this.subtitleExpression;
    }

    public void setSubtitleExpression(JRExpression jRExpression) {
        this.subtitleExpression = jRExpression;
    }

    @Override
    public JRExpression getAnchorNameExpression() {
        return this.anchorNameExpression;
    }

    public void setAnchorNameExpression(JRExpression jRExpression) {
        this.anchorNameExpression = jRExpression;
    }

    @Override
    public JRExpression getHyperlinkReferenceExpression() {
        return this.hyperlinkReferenceExpression;
    }

    public void setHyperlinkReferenceExpression(JRExpression jRExpression) {
        this.hyperlinkReferenceExpression = jRExpression;
    }

    @Override
    public JRExpression getHyperlinkAnchorExpression() {
        return this.hyperlinkAnchorExpression;
    }

    public void setHyperlinkAnchorExpression(JRExpression jRExpression) {
        this.hyperlinkAnchorExpression = jRExpression;
    }

    @Override
    public JRExpression getHyperlinkPageExpression() {
        return this.hyperlinkPageExpression;
    }

    public void setHyperlinkPageExpression(JRExpression jRExpression) {
        this.hyperlinkPageExpression = jRExpression;
    }

    @Override
    public JRChartDataset getDataset() {
        return this.dataset;
    }

    @Override
    public JRChartPlot getPlot() {
        return this.plot;
    }

    @Override
    public byte getChartType() {
        return this.chartType;
    }

    public void setChartType(byte by) {
        this.chartType = by;
        switch (by) {
            case 1: {
                this.dataset = new JRDesignCategoryDataset(this.dataset);
                this.plot = new JRDesignAreaPlot(this.plot);
                break;
            }
            case 3: {
                this.dataset = new JRDesignCategoryDataset(this.dataset);
                this.plot = new JRDesignBarPlot(this.plot);
                break;
            }
            case 2: {
                this.dataset = new JRDesignCategoryDataset(this.dataset);
                this.plot = new JRDesignBar3DPlot(this.plot);
                break;
            }
            case 4: {
                this.dataset = new JRDesignXyzDataset(this.dataset);
                this.plot = new JRDesignBubblePlot(this.plot);
                break;
            }
            case 5: {
                this.dataset = new JRDesignHighLowDataset(this.dataset);
                this.plot = new JRDesignCandlestickPlot(this.plot);
                break;
            }
            case 6: {
                this.dataset = new JRDesignHighLowDataset(this.dataset);
                this.plot = new JRDesignHighLowPlot(this.plot);
                break;
            }
            case 7: {
                this.dataset = new JRDesignCategoryDataset(this.dataset);
                this.plot = new JRDesignLinePlot(this.plot);
                break;
            }
            case 17: {
                this.dataset = new JRDesignValueDataset(this.dataset);
                this.plot = new JRDesignMeterPlot(this.plot);
                break;
            }
            case 19: {
                this.plot = new JRDesignMultiAxisPlot(this.plot);
                this.dataset = null;
                break;
            }
            case 9: {
                this.dataset = new JRDesignPieDataset(this.dataset);
                this.plot = new JRDesignPiePlot(this.plot);
                break;
            }
            case 8: {
                this.dataset = new JRDesignPieDataset(this.dataset);
                this.plot = new JRDesignPie3DPlot(this.plot);
                break;
            }
            case 10: {
                this.dataset = new JRDesignXyDataset(this.dataset);
                this.plot = new JRDesignScatterPlot(this.plot);
                break;
            }
            case 12: {
                this.dataset = new JRDesignCategoryDataset(this.dataset);
                this.plot = new JRDesignBarPlot(this.plot);
                break;
            }
            case 11: {
                this.dataset = new JRDesignCategoryDataset(this.dataset);
                this.plot = new JRDesignBar3DPlot(this.plot);
                break;
            }
            case 18: {
                this.dataset = new JRDesignValueDataset(this.dataset);
                this.plot = new JRDesignThermometerPlot(this.plot);
                break;
            }
            case 16: {
                this.dataset = new JRDesignTimeSeriesDataset(this.dataset);
                this.plot = new JRDesignTimeSeriesPlot(this.plot);
                break;
            }
            case 13: {
                this.dataset = new JRDesignXyDataset(this.dataset);
                this.plot = new JRDesignAreaPlot(this.plot);
                break;
            }
            case 14: {
                this.plot = new JRDesignBarPlot(this.plot);
                break;
            }
            case 15: {
                this.dataset = new JRDesignXyDataset(this.dataset);
                this.plot = new JRDesignLinePlot(this.plot);
                break;
            }
            default: {
                throw new JRRuntimeException("Chart type not supported.");
            }
        }
    }

    public void setDataset(JRChartDataset jRChartDataset) {
        switch (jRChartDataset.getDatasetType()) {
            case 2: {
                this.dataset = (JRDesignCategoryDataset)jRChartDataset;
                break;
            }
            case 7: {
                this.dataset = (JRDesignHighLowDataset)jRChartDataset;
                break;
            }
            case 1: {
                this.dataset = (JRDesignPieDataset)jRChartDataset;
                break;
            }
            case 5: {
                this.dataset = (JRDesignTimePeriodDataset)jRChartDataset;
                break;
            }
            case 6: {
                this.dataset = (JRDesignTimeSeriesDataset)jRChartDataset;
                break;
            }
            case 8: {
                this.dataset = (JRDesignValueDataset)jRChartDataset;
                break;
            }
            case 3: {
                this.dataset = (JRDesignXyDataset)jRChartDataset;
                break;
            }
            case 4: {
                this.dataset = (JRDesignXyzDataset)jRChartDataset;
            }
        }
    }

    @Override
    public JRChild getCopy(JRAbstractObjectFactory jRAbstractObjectFactory) {
        return jRAbstractObjectFactory.getChart(this);
    }

    @Override
    public void collectExpressions(JRExpressionCollector jRExpressionCollector) {
        jRExpressionCollector.collect(this);
    }

    @Override
    public void writeXml(JRXmlWriter jRXmlWriter) throws IOException {
        switch (this.chartType) {
            case 1: {
                jRXmlWriter.writeAreaChart(this);
                break;
            }
            case 3: {
                jRXmlWriter.writeBarChart(this);
                break;
            }
            case 2: {
                jRXmlWriter.writeBar3DChart(this);
                break;
            }
            case 4: {
                jRXmlWriter.writeBubbleChart(this);
                break;
            }
            case 5: {
                jRXmlWriter.writeCandlestickChart(this);
                break;
            }
            case 6: {
                jRXmlWriter.writeHighLowChart(this);
                break;
            }
            case 7: {
                jRXmlWriter.writeLineChart(this);
                break;
            }
            case 17: {
                jRXmlWriter.writeMeterChart(this);
                break;
            }
            case 19: {
                jRXmlWriter.writeMultiAxisChart(this);
                break;
            }
            case 9: {
                jRXmlWriter.writePieChart(this);
                break;
            }
            case 8: {
                jRXmlWriter.writePie3DChart(this);
                break;
            }
            case 10: {
                jRXmlWriter.writeScatterChart(this);
                break;
            }
            case 12: {
                jRXmlWriter.writeStackedBarChart(this);
                break;
            }
            case 11: {
                jRXmlWriter.writeStackedBar3DChart(this);
                break;
            }
            case 18: {
                jRXmlWriter.writeThermometerChart(this);
                break;
            }
            case 16: {
                jRXmlWriter.writeTimeSeriesChart(this);
                break;
            }
            case 13: {
                jRXmlWriter.writeXyAreaChart(this);
                break;
            }
            case 14: {
                jRXmlWriter.writeXyBarChart(this);
                break;
            }
            case 15: {
                jRXmlWriter.writeXyLineChart(this);
                break;
            }
            default: {
                throw new JRRuntimeException("Chart type not supported.");
            }
        }
    }

    @Override
    public int getBookmarkLevel() {
        return this.bookmarkLevel;
    }

    public void setBookmarkLevel(int n) {
        this.bookmarkLevel = n;
    }

    @Override
    public String getCustomizerClass() {
        return this.customizerClass;
    }

    public void setCustomizerClass(String string) {
        this.customizerClass = string;
    }

    @Override
    public byte getMode() {
        return JRStyleResolver.getMode(this, (byte)2);
    }

    @Override
    public byte getBorder() {
        return JRStyleResolver.getBorder(this);
    }

    @Override
    public Byte getOwnBorder() {
        return this.border;
    }

    @Override
    public void setBorder(byte by) {
        this.border = new Byte(by);
    }

    @Override
    public Color getBorderColor() {
        return JRStyleResolver.getBorderColor(this, this.getForecolor());
    }

    @Override
    public Color getOwnBorderColor() {
        return this.borderColor;
    }

    @Override
    public void setBorderColor(Color color) {
        this.borderColor = color;
    }

    @Override
    public int getPadding() {
        return JRStyleResolver.getPadding(this);
    }

    @Override
    public Integer getOwnPadding() {
        return this.padding;
    }

    @Override
    public void setPadding(int n) {
        this.padding = new Integer(n);
    }

    @Override
    public byte getTopBorder() {
        return JRStyleResolver.getTopBorder(this);
    }

    @Override
    public Byte getOwnTopBorder() {
        return this.topBorder;
    }

    @Override
    public void setTopBorder(byte by) {
        this.topBorder = new Byte(by);
    }

    @Override
    public Color getTopBorderColor() {
        return JRStyleResolver.getTopBorderColor(this, this.getForecolor());
    }

    @Override
    public Color getOwnTopBorderColor() {
        return this.topBorderColor;
    }

    @Override
    public void setTopBorderColor(Color color) {
        this.topBorderColor = color;
    }

    @Override
    public int getTopPadding() {
        return JRStyleResolver.getTopPadding(this);
    }

    @Override
    public Integer getOwnTopPadding() {
        return this.topPadding;
    }

    @Override
    public void setTopPadding(int n) {
        this.topPadding = new Integer(n);
    }

    @Override
    public byte getLeftBorder() {
        return JRStyleResolver.getLeftBorder(this);
    }

    @Override
    public Byte getOwnLeftBorder() {
        return this.leftBorder;
    }

    @Override
    public void setLeftBorder(byte by) {
        this.leftBorder = new Byte(by);
    }

    @Override
    public Color getLeftBorderColor() {
        return JRStyleResolver.getLeftBorderColor(this, this.getForecolor());
    }

    @Override
    public Color getOwnLeftBorderColor() {
        return this.leftBorderColor;
    }

    @Override
    public void setLeftBorderColor(Color color) {
        this.leftBorderColor = color;
    }

    @Override
    public int getLeftPadding() {
        return JRStyleResolver.getLeftPadding(this);
    }

    @Override
    public Integer getOwnLeftPadding() {
        return this.leftPadding;
    }

    @Override
    public void setLeftPadding(int n) {
        this.leftPadding = new Integer(n);
    }

    @Override
    public byte getBottomBorder() {
        return JRStyleResolver.getBottomBorder(this);
    }

    @Override
    public Byte getOwnBottomBorder() {
        return this.bottomBorder;
    }

    @Override
    public void setBottomBorder(byte by) {
        this.bottomBorder = new Byte(by);
    }

    @Override
    public Color getBottomBorderColor() {
        return JRStyleResolver.getBottomBorderColor(this, this.getForecolor());
    }

    @Override
    public Color getOwnBottomBorderColor() {
        return this.bottomBorderColor;
    }

    @Override
    public void setBottomBorderColor(Color color) {
        this.bottomBorderColor = color;
    }

    @Override
    public int getBottomPadding() {
        return JRStyleResolver.getBottomPadding(this);
    }

    @Override
    public Integer getOwnBottomPadding() {
        return this.bottomPadding;
    }

    @Override
    public void setBottomPadding(int n) {
        this.bottomPadding = new Integer(n);
    }

    @Override
    public byte getRightBorder() {
        return JRStyleResolver.getRightBorder(this);
    }

    @Override
    public Byte getOwnRightBorder() {
        return this.rightBorder;
    }

    @Override
    public void setRightBorder(byte by) {
        this.rightBorder = new Byte(by);
    }

    @Override
    public Color getRightBorderColor() {
        return JRStyleResolver.getRightBorderColor(this, this.getForecolor());
    }

    @Override
    public Color getOwnRightBorderColor() {
        return this.rightBorderColor;
    }

    @Override
    public void setRightBorderColor(Color color) {
        this.rightBorderColor = color;
    }

    @Override
    public int getRightPadding() {
        return JRStyleResolver.getRightPadding(this);
    }

    @Override
    public Integer getOwnRightPadding() {
        return this.rightPadding;
    }

    @Override
    public void setRightPadding(int n) {
        this.rightPadding = new Integer(n);
    }

    @Override
    public void setBorder(Byte by) {
        this.border = by;
    }

    @Override
    public void setPadding(Integer n) {
        this.padding = n;
    }

    @Override
    public void setTopBorder(Byte by) {
        this.topBorder = by;
    }

    @Override
    public void setTopPadding(Integer n) {
        this.topPadding = n;
    }

    @Override
    public void setLeftBorder(Byte by) {
        this.leftBorder = by;
    }

    @Override
    public void setLeftPadding(Integer n) {
        this.leftPadding = n;
    }

    @Override
    public void setBottomBorder(Byte by) {
        this.bottomBorder = by;
    }

    @Override
    public void setBottomPadding(Integer n) {
        this.bottomPadding = n;
    }

    @Override
    public void setRightBorder(Byte by) {
        this.rightBorder = by;
    }

    @Override
    public void setRightPadding(Integer n) {
        this.rightPadding = n;
    }

    @Override
    public String getLinkType() {
        return this.linkType;
    }

    public void setLinkType(String string) {
        this.linkType = string;
    }

    @Override
    public JRHyperlinkParameter[] getHyperlinkParameters() {
        JRHyperlinkParameter[] jRHyperlinkParameterArray;
        if (this.hyperlinkParameters.isEmpty()) {
            jRHyperlinkParameterArray = null;
        } else {
            jRHyperlinkParameterArray = new JRHyperlinkParameter[this.hyperlinkParameters.size()];
            this.hyperlinkParameters.toArray(jRHyperlinkParameterArray);
        }
        return jRHyperlinkParameterArray;
    }

    public List getHyperlinkParametersList() {
        return this.hyperlinkParameters;
    }

    public void addHyperlinkParameter(JRHyperlinkParameter jRHyperlinkParameter) {
        this.hyperlinkParameters.add(jRHyperlinkParameter);
    }

    public void removeHyperlinkParameter(JRHyperlinkParameter jRHyperlinkParameter) {
        this.hyperlinkParameters.remove(jRHyperlinkParameter);
    }

    public void removeHyperlinkParameter(String string) {
        Iterator iterator = this.hyperlinkParameters.iterator();
        while (iterator.hasNext()) {
            JRHyperlinkParameter jRHyperlinkParameter = (JRHyperlinkParameter)iterator.next();
            if (jRHyperlinkParameter.getName() == null || !jRHyperlinkParameter.getName().equals(string)) continue;
            iterator.remove();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.normalizeLinkType();
    }

    protected void normalizeLinkType() {
        if (this.linkType == null) {
            this.linkType = JRHyperlinkHelper.getLinkType(this.hyperlinkType);
        }
        this.hyperlinkType = 0;
    }

    @Override
    public JRExpression getHyperlinkTooltipExpression() {
        return this.hyperlinkTooltipExpression;
    }

    public void setHyperlinkTooltipExpression(JRExpression jRExpression) {
        this.hyperlinkTooltipExpression = jRExpression;
    }
}

