/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.io.Serializable;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.util.JRClassLoader;

public class JRBaseParameter
implements JRParameter,
Serializable {
    private static final long serialVersionUID = 10200L;
    protected String name = null;
    protected String description = null;
    protected String valueClassName = String.class.getName();
    protected boolean isSystemDefined = false;
    protected boolean isForPrompting = true;
    protected transient Class valueClass = null;
    protected JRExpression defaultValueExpression = null;

    protected JRBaseParameter() {
    }

    protected JRBaseParameter(JRParameter jRParameter, JRBaseObjectFactory jRBaseObjectFactory) {
        jRBaseObjectFactory.put(jRParameter, this);
        this.name = jRParameter.getName();
        this.description = jRParameter.getDescription();
        this.valueClassName = jRParameter.getValueClassName();
        this.isSystemDefined = jRParameter.isSystemDefined();
        this.isForPrompting = jRParameter.isForPrompting();
        this.defaultValueExpression = jRBaseObjectFactory.getExpression(jRParameter.getDefaultValueExpression());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String string) {
        this.description = string;
    }

    @Override
    public Class getValueClass() {
        if (this.valueClass == null && this.valueClassName != null) {
            try {
                this.valueClass = JRClassLoader.loadClassForName(this.valueClassName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new JRRuntimeException(classNotFoundException);
            }
        }
        return this.valueClass;
    }

    @Override
    public String getValueClassName() {
        return this.valueClassName;
    }

    @Override
    public boolean isSystemDefined() {
        return this.isSystemDefined;
    }

    @Override
    public boolean isForPrompting() {
        return this.isForPrompting;
    }

    @Override
    public JRExpression getDefaultValueExpression() {
        return this.defaultValueExpression;
    }
}

