/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.io.Serializable;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionChunk;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.util.JRClassLoader;

public class JRBaseExpression
implements JRExpression,
Serializable {
    private static final long serialVersionUID = 10200L;
    protected String valueClassName = null;
    protected int id = 0;
    protected transient Class valueClass = null;
    private JRExpressionChunk[] chunks = null;
    private static int lastId = 0;

    protected JRBaseExpression() {
    }

    protected JRBaseExpression(JRExpression jRExpression, JRBaseObjectFactory jRBaseObjectFactory, Integer n) {
        jRBaseObjectFactory.put(jRExpression, this);
        this.valueClassName = jRExpression.getValueClassName();
        this.id = n == null ? jRExpression.getId() : n.intValue();
        JRExpressionChunk[] jRExpressionChunkArray = jRExpression.getChunks();
        if (jRExpressionChunkArray != null && jRExpressionChunkArray.length > 0) {
            this.chunks = new JRExpressionChunk[jRExpressionChunkArray.length];
            for (int i = 0; i < this.chunks.length; ++i) {
                this.chunks[i] = jRBaseObjectFactory.getExpressionChunk(jRExpressionChunkArray[i]);
            }
        }
    }

    protected JRBaseExpression(JRExpression jRExpression, JRBaseObjectFactory jRBaseObjectFactory) {
        this(jRExpression, jRBaseObjectFactory, null);
    }

    private static synchronized int getNextId() {
        return lastId++;
    }

    public void regenerateId() {
        this.id = JRBaseExpression.getNextId();
    }

    @Override
    public Class getValueClass() {
        if (this.valueClass == null && this.valueClassName != null) {
            try {
                this.valueClass = JRClassLoader.loadClassForName(this.valueClassName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new JRRuntimeException(classNotFoundException);
            }
        }
        return this.valueClass;
    }

    @Override
    public String getValueClassName() {
        return this.valueClassName;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public JRExpressionChunk[] getChunks() {
        return this.chunks;
    }

    @Override
    public String getText() {
        String string = "";
        this.chunks = this.getChunks();
        if (this.chunks != null && this.chunks.length > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            block6: for (int i = 0; i < this.chunks.length; ++i) {
                switch (this.chunks[i].getType()) {
                    case 2: {
                        stringBuffer.append("$P{");
                        stringBuffer.append(this.chunks[i].getText());
                        stringBuffer.append("}");
                        continue block6;
                    }
                    case 3: {
                        stringBuffer.append("$F{");
                        stringBuffer.append(this.chunks[i].getText());
                        stringBuffer.append("}");
                        continue block6;
                    }
                    case 4: {
                        stringBuffer.append("$V{");
                        stringBuffer.append(this.chunks[i].getText());
                        stringBuffer.append("}");
                        continue block6;
                    }
                    case 5: {
                        stringBuffer.append("$R{");
                        stringBuffer.append(this.chunks[i].getText());
                        stringBuffer.append("}");
                        continue block6;
                    }
                    default: {
                        stringBuffer.append(this.chunks[i].getText());
                    }
                }
            }
            string = stringBuffer.toString();
        }
        return string;
    }
}

