/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.awt.Color;
import java.io.Serializable;
import java.util.SortedSet;
import java.util.TreeSet;
import net.sf.jasperreports.engine.JRChartPlot;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import org.jfree.chart.plot.PlotOrientation;

public abstract class JRBaseChartPlot
implements JRChartPlot,
Serializable {
    private static final long serialVersionUID = 10200L;
    protected Color backcolor = null;
    protected PlotOrientation orientation = PlotOrientation.VERTICAL;
    protected float backgroundAlpha = 1.0f;
    protected float foregroundAlpha = 1.0f;
    protected double labelRotation = 0.0;
    protected SortedSet seriesColors = null;

    protected JRBaseChartPlot(JRChartPlot jRChartPlot) {
        if (jRChartPlot != null) {
            this.backcolor = jRChartPlot.getBackcolor();
            this.orientation = jRChartPlot.getOrientation();
            this.backgroundAlpha = jRChartPlot.getBackgroundAlpha();
            this.foregroundAlpha = jRChartPlot.getForegroundAlpha();
            this.labelRotation = jRChartPlot.getLabelRotation();
            this.seriesColors = new TreeSet(jRChartPlot.getSeriesColors());
        } else {
            this.seriesColors = new TreeSet();
        }
    }

    protected JRBaseChartPlot(JRChartPlot jRChartPlot, JRBaseObjectFactory jRBaseObjectFactory) {
        jRBaseObjectFactory.put(jRChartPlot, this);
        this.backcolor = jRChartPlot.getBackcolor();
        this.orientation = jRChartPlot.getOrientation();
        this.backgroundAlpha = jRChartPlot.getBackgroundAlpha();
        this.foregroundAlpha = jRChartPlot.getForegroundAlpha();
        this.labelRotation = jRChartPlot.getLabelRotation();
        this.seriesColors = new TreeSet(jRChartPlot.getSeriesColors());
    }

    @Override
    public Color getBackcolor() {
        return this.backcolor;
    }

    @Override
    public void setBackcolor(Color color) {
        this.backcolor = color;
    }

    @Override
    public PlotOrientation getOrientation() {
        return this.orientation;
    }

    @Override
    public void setOrientation(PlotOrientation plotOrientation) {
        this.orientation = plotOrientation;
    }

    @Override
    public float getBackgroundAlpha() {
        return this.backgroundAlpha;
    }

    @Override
    public void setBackgroundAlpha(float f) {
        this.backgroundAlpha = f;
    }

    @Override
    public float getForegroundAlpha() {
        return this.foregroundAlpha;
    }

    @Override
    public void setForegroundAlpha(float f) {
        this.foregroundAlpha = f;
    }

    @Override
    public double getLabelRotation() {
        return this.labelRotation;
    }

    @Override
    public void setLabelRotation(double d) {
        this.labelRotation = d;
    }

    @Override
    public SortedSet getSeriesColors() {
        return this.seriesColors;
    }

    @Override
    public void clearSeriesColors() {
        this.seriesColors.clear();
    }

    @Override
    public void addSeriesColor(JRChartPlot.JRSeriesColor jRSeriesColor) {
        this.seriesColors.add(jRSeriesColor);
    }

    public static class JRBaseSeriesColor
    implements JRChartPlot.JRSeriesColor,
    Serializable,
    Comparable {
        private static final long serialVersionUID = 10200L;
        protected int seriesOrder = -1;
        protected Color color = null;

        public JRBaseSeriesColor(int n, Color color) {
            this.seriesOrder = n;
            this.color = color;
        }

        @Override
        public int getSeriesOrder() {
            return this.seriesOrder;
        }

        @Override
        public Color getColor() {
            return this.color;
        }

        public int compareTo(Object object) {
            if (object == null) {
                throw new NullPointerException();
            }
            return this.seriesOrder - ((JRBaseSeriesColor)object).getSeriesOrder();
        }
    }
}

