/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import net.sf.jasperreports.charts.JRAreaPlot;
import net.sf.jasperreports.charts.JRBar3DPlot;
import net.sf.jasperreports.charts.JRBarPlot;
import net.sf.jasperreports.charts.JRBubblePlot;
import net.sf.jasperreports.charts.JRCandlestickPlot;
import net.sf.jasperreports.charts.JRCategoryDataset;
import net.sf.jasperreports.charts.JRHighLowDataset;
import net.sf.jasperreports.charts.JRHighLowPlot;
import net.sf.jasperreports.charts.JRLinePlot;
import net.sf.jasperreports.charts.JRMeterPlot;
import net.sf.jasperreports.charts.JRMultiAxisPlot;
import net.sf.jasperreports.charts.JRPie3DPlot;
import net.sf.jasperreports.charts.JRPieDataset;
import net.sf.jasperreports.charts.JRPiePlot;
import net.sf.jasperreports.charts.JRScatterPlot;
import net.sf.jasperreports.charts.JRThermometerPlot;
import net.sf.jasperreports.charts.JRTimePeriodDataset;
import net.sf.jasperreports.charts.JRTimeSeriesDataset;
import net.sf.jasperreports.charts.JRTimeSeriesPlot;
import net.sf.jasperreports.charts.JRValueDataset;
import net.sf.jasperreports.charts.JRXyDataset;
import net.sf.jasperreports.charts.JRXyzDataset;
import net.sf.jasperreports.engine.JRAbstractObjectFactory;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRChartDataset;
import net.sf.jasperreports.engine.JRChartPlot;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRHyperlinkHelper;
import net.sf.jasperreports.engine.JRHyperlinkParameter;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.base.JRBaseElement;
import net.sf.jasperreports.engine.base.JRBaseHyperlink;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.util.JRStyleResolver;
import net.sf.jasperreports.engine.xml.JRXmlWriter;

public class JRBaseChart
extends JRBaseElement
implements JRChart {
    private static final long serialVersionUID = 10200L;
    protected byte chartType = 0;
    protected boolean isShowLegend = false;
    protected byte evaluationTime = 1;
    protected byte hyperlinkType = 0;
    protected String linkType;
    protected byte hyperlinkTarget = 1;
    private JRHyperlinkParameter[] hyperlinkParameters;
    protected byte titlePosition = 1;
    protected Color titleColor = Color.black;
    protected Color subtitleColor = Color.black;
    protected Color legendColor = null;
    protected Color legendBackgroundColor = null;
    protected JRBox box = null;
    protected JRFont titleFont = null;
    protected JRFont subtitleFont = null;
    protected JRFont legendFont = null;
    protected String customizerClass;
    protected JRGroup evaluationGroup = null;
    protected JRExpression titleExpression = null;
    protected JRExpression subtitleExpression = null;
    protected JRExpression anchorNameExpression = null;
    protected JRExpression hyperlinkReferenceExpression = null;
    protected JRExpression hyperlinkAnchorExpression = null;
    protected JRExpression hyperlinkPageExpression = null;
    private JRExpression hyperlinkTooltipExpression;
    protected JRChartDataset dataset = null;
    protected JRChartPlot plot = null;
    protected Byte border;
    protected Byte topBorder = null;
    protected Byte leftBorder = null;
    protected Byte bottomBorder = null;
    protected Byte rightBorder = null;
    protected Color borderColor = null;
    protected Color topBorderColor = null;
    protected Color leftBorderColor = null;
    protected Color bottomBorderColor = null;
    protected Color rightBorderColor = null;
    protected Integer padding;
    protected Integer topPadding = null;
    protected Integer leftPadding = null;
    protected Integer bottomPadding = null;
    protected Integer rightPadding = null;
    protected int bookmarkLevel = 0;

    protected JRBaseChart(JRChart jRChart, JRBaseObjectFactory jRBaseObjectFactory) {
        super(jRChart, jRBaseObjectFactory);
        this.chartType = jRChart.getChartType();
        switch (this.chartType) {
            case 1: {
                this.dataset = jRBaseObjectFactory.getCategoryDataset((JRCategoryDataset)jRChart.getDataset());
                this.plot = jRBaseObjectFactory.getAreaPlot((JRAreaPlot)jRChart.getPlot());
                break;
            }
            case 3: {
                this.dataset = jRBaseObjectFactory.getCategoryDataset((JRCategoryDataset)jRChart.getDataset());
                this.plot = jRBaseObjectFactory.getBarPlot((JRBarPlot)jRChart.getPlot());
                break;
            }
            case 2: {
                this.dataset = jRBaseObjectFactory.getCategoryDataset((JRCategoryDataset)jRChart.getDataset());
                this.plot = jRBaseObjectFactory.getBar3DPlot((JRBar3DPlot)jRChart.getPlot());
                break;
            }
            case 4: {
                this.dataset = jRBaseObjectFactory.getXyzDataset((JRXyzDataset)jRChart.getDataset());
                this.plot = jRBaseObjectFactory.getBubblePlot((JRBubblePlot)jRChart.getPlot());
                break;
            }
            case 5: {
                this.dataset = jRBaseObjectFactory.getHighLowDataset((JRHighLowDataset)jRChart.getDataset());
                this.plot = jRBaseObjectFactory.getCandlestickPlot((JRCandlestickPlot)jRChart.getPlot());
                break;
            }
            case 6: {
                this.dataset = jRBaseObjectFactory.getHighLowDataset((JRHighLowDataset)jRChart.getDataset());
                this.plot = jRBaseObjectFactory.getHighLowPlot((JRHighLowPlot)jRChart.getPlot());
                break;
            }
            case 7: {
                this.dataset = jRBaseObjectFactory.getCategoryDataset((JRCategoryDataset)jRChart.getDataset());
                this.plot = jRBaseObjectFactory.getLinePlot((JRLinePlot)jRChart.getPlot());
                break;
            }
            case 17: {
                this.dataset = jRBaseObjectFactory.getValueDataset((JRValueDataset)jRChart.getDataset());
                this.plot = jRBaseObjectFactory.getMeterPlot((JRMeterPlot)jRChart.getPlot());
                break;
            }
            case 19: {
                this.dataset = null;
                this.plot = jRBaseObjectFactory.getMultiAxisPlot((JRMultiAxisPlot)jRChart.getPlot());
                break;
            }
            case 9: {
                this.dataset = jRBaseObjectFactory.getPieDataset((JRPieDataset)jRChart.getDataset());
                this.plot = jRBaseObjectFactory.getPiePlot((JRPiePlot)jRChart.getPlot());
                break;
            }
            case 8: {
                this.dataset = jRBaseObjectFactory.getPieDataset((JRPieDataset)jRChart.getDataset());
                this.plot = jRBaseObjectFactory.getPie3DPlot((JRPie3DPlot)jRChart.getPlot());
                break;
            }
            case 10: {
                this.dataset = jRBaseObjectFactory.getXyDataset((JRXyDataset)jRChart.getDataset());
                this.plot = jRBaseObjectFactory.getScatterPlot((JRScatterPlot)jRChart.getPlot());
                break;
            }
            case 12: {
                this.dataset = jRBaseObjectFactory.getCategoryDataset((JRCategoryDataset)jRChart.getDataset());
                this.plot = jRBaseObjectFactory.getBarPlot((JRBarPlot)jRChart.getPlot());
                break;
            }
            case 11: {
                this.dataset = jRBaseObjectFactory.getCategoryDataset((JRCategoryDataset)jRChart.getDataset());
                this.plot = jRBaseObjectFactory.getBar3DPlot((JRBar3DPlot)jRChart.getPlot());
                break;
            }
            case 18: {
                this.dataset = jRBaseObjectFactory.getValueDataset((JRValueDataset)jRChart.getDataset());
                this.plot = jRBaseObjectFactory.getThermometerPlot((JRThermometerPlot)jRChart.getPlot());
                break;
            }
            case 16: {
                this.dataset = jRBaseObjectFactory.getTimeSeriesDataset((JRTimeSeriesDataset)jRChart.getDataset());
                this.plot = jRBaseObjectFactory.getTimeSeriesPlot((JRTimeSeriesPlot)jRChart.getPlot());
                break;
            }
            case 13: {
                this.dataset = jRBaseObjectFactory.getXyDataset((JRXyDataset)jRChart.getDataset());
                this.plot = jRBaseObjectFactory.getAreaPlot((JRAreaPlot)jRChart.getPlot());
                break;
            }
            case 14: {
                switch (jRChart.getDataset().getDatasetType()) {
                    case 6: {
                        this.dataset = jRBaseObjectFactory.getTimeSeriesDataset((JRTimeSeriesDataset)jRChart.getDataset());
                        break;
                    }
                    case 5: {
                        this.dataset = jRBaseObjectFactory.getTimePeriodDataset((JRTimePeriodDataset)jRChart.getDataset());
                        break;
                    }
                    case 3: {
                        this.dataset = jRBaseObjectFactory.getXyDataset((JRXyDataset)jRChart.getDataset());
                    }
                }
                this.plot = jRBaseObjectFactory.getBarPlot((JRBarPlot)jRChart.getPlot());
                break;
            }
            case 15: {
                this.dataset = jRBaseObjectFactory.getXyDataset((JRXyDataset)jRChart.getDataset());
                this.plot = jRBaseObjectFactory.getLinePlot((JRLinePlot)jRChart.getPlot());
                break;
            }
            default: {
                throw new JRRuntimeException("Chart type not supported.");
            }
        }
        this.isShowLegend = jRChart.isShowLegend();
        this.evaluationTime = jRChart.getEvaluationTime();
        this.linkType = jRChart.getLinkType();
        this.hyperlinkTarget = jRChart.getHyperlinkTarget();
        this.titlePosition = jRChart.getTitlePosition();
        this.titleColor = jRChart.getTitleColor();
        this.subtitleColor = jRChart.getSubtitleColor();
        this.legendColor = jRChart.getLegendColor();
        this.legendBackgroundColor = jRChart.getLegendBackgroundColor();
        this.titleFont = jRBaseObjectFactory.getFont(jRChart.getTitleFont());
        this.subtitleFont = jRBaseObjectFactory.getFont(jRChart.getSubtitleFont());
        this.legendFont = jRBaseObjectFactory.getFont(jRChart.getLegendFont());
        this.evaluationGroup = jRBaseObjectFactory.getGroup(jRChart.getEvaluationGroup());
        this.titleExpression = jRBaseObjectFactory.getExpression(jRChart.getTitleExpression());
        this.subtitleExpression = jRBaseObjectFactory.getExpression(jRChart.getSubtitleExpression());
        this.anchorNameExpression = jRBaseObjectFactory.getExpression(jRChart.getAnchorNameExpression());
        this.hyperlinkReferenceExpression = jRBaseObjectFactory.getExpression(jRChart.getHyperlinkReferenceExpression());
        this.hyperlinkAnchorExpression = jRBaseObjectFactory.getExpression(jRChart.getHyperlinkAnchorExpression());
        this.hyperlinkPageExpression = jRBaseObjectFactory.getExpression(jRChart.getHyperlinkPageExpression());
        this.hyperlinkTooltipExpression = jRBaseObjectFactory.getExpression(jRChart.getHyperlinkTooltipExpression());
        this.bookmarkLevel = jRChart.getBookmarkLevel();
        this.hyperlinkParameters = JRBaseHyperlink.copyHyperlinkParameters(jRChart, jRBaseObjectFactory);
        this.customizerClass = jRChart.getCustomizerClass();
        this.border = jRChart.getOwnBorder();
        this.topBorder = jRChart.getOwnTopBorder();
        this.leftBorder = jRChart.getOwnLeftBorder();
        this.bottomBorder = jRChart.getOwnBottomBorder();
        this.rightBorder = jRChart.getOwnRightBorder();
        this.borderColor = jRChart.getOwnBorderColor();
        this.topBorderColor = jRChart.getOwnTopBorderColor();
        this.leftBorderColor = jRChart.getOwnLeftBorderColor();
        this.bottomBorderColor = jRChart.getOwnBottomBorderColor();
        this.rightBorderColor = jRChart.getOwnRightBorderColor();
        this.padding = jRChart.getOwnPadding();
        this.topPadding = jRChart.getOwnTopPadding();
        this.leftPadding = jRChart.getOwnLeftPadding();
        this.bottomPadding = jRChart.getOwnBottomPadding();
        this.rightPadding = jRChart.getOwnRightPadding();
    }

    @Override
    public boolean isShowLegend() {
        return this.isShowLegend;
    }

    @Override
    public void setShowLegend(boolean bl) {
        this.isShowLegend = bl;
    }

    @Override
    public byte getEvaluationTime() {
        return this.evaluationTime;
    }

    @Override
    public JRGroup getEvaluationGroup() {
        return this.evaluationGroup;
    }

    @Override
    public JRBox getBox() {
        return this;
    }

    @Override
    public JRFont getTitleFont() {
        return this.titleFont;
    }

    @Override
    public byte getTitlePosition() {
        return this.titlePosition;
    }

    @Override
    public void setTitlePosition(byte by) {
        this.titlePosition = by;
    }

    @Override
    public Color getTitleColor() {
        return this.titleColor;
    }

    @Override
    public void setTitleColor(Color color) {
        this.titleColor = color;
    }

    @Override
    public JRFont getSubtitleFont() {
        return this.subtitleFont;
    }

    @Override
    public Color getSubtitleColor() {
        return this.subtitleColor;
    }

    @Override
    public void setSubtitleColor(Color color) {
        this.subtitleColor = color;
    }

    @Override
    public Color getLegendBackgroundColor() {
        return this.legendBackgroundColor;
    }

    @Override
    public Color getLegendColor() {
        return this.legendColor;
    }

    @Override
    public JRFont getLegendFont() {
        return this.legendFont;
    }

    @Override
    public void setLegendBackgroundColor(Color color) {
        this.legendBackgroundColor = color;
    }

    @Override
    public void setLegendColor(Color color) {
        this.legendColor = color;
    }

    @Override
    public byte getHyperlinkType() {
        return JRHyperlinkHelper.getHyperlinkType(this);
    }

    @Override
    public byte getHyperlinkTarget() {
        return this.hyperlinkTarget;
    }

    @Override
    public JRExpression getTitleExpression() {
        return this.titleExpression;
    }

    @Override
    public JRExpression getSubtitleExpression() {
        return this.subtitleExpression;
    }

    @Override
    public JRExpression getAnchorNameExpression() {
        return this.anchorNameExpression;
    }

    @Override
    public JRExpression getHyperlinkReferenceExpression() {
        return this.hyperlinkReferenceExpression;
    }

    @Override
    public JRExpression getHyperlinkAnchorExpression() {
        return this.hyperlinkAnchorExpression;
    }

    @Override
    public JRExpression getHyperlinkPageExpression() {
        return this.hyperlinkPageExpression;
    }

    @Override
    public JRChartDataset getDataset() {
        return this.dataset;
    }

    @Override
    public JRChartPlot getPlot() {
        return this.plot;
    }

    @Override
    public byte getChartType() {
        return this.chartType;
    }

    @Override
    public JRChild getCopy(JRAbstractObjectFactory jRAbstractObjectFactory) {
        return jRAbstractObjectFactory.getChart(this);
    }

    @Override
    public void collectExpressions(JRExpressionCollector jRExpressionCollector) {
        jRExpressionCollector.collect(this);
    }

    @Override
    public void writeXml(JRXmlWriter jRXmlWriter) throws IOException {
        jRXmlWriter.writeChartTag(this);
    }

    @Override
    public int getBookmarkLevel() {
        return this.bookmarkLevel;
    }

    @Override
    public String getCustomizerClass() {
        return this.customizerClass;
    }

    @Override
    public byte getMode() {
        return JRStyleResolver.getMode(this, (byte)2);
    }

    @Override
    public byte getBorder() {
        return JRStyleResolver.getBorder(this);
    }

    @Override
    public Byte getOwnBorder() {
        return this.border;
    }

    @Override
    public void setBorder(byte by) {
        this.border = new Byte(by);
    }

    @Override
    public void setBorder(Byte by) {
        this.border = by;
    }

    @Override
    public Color getBorderColor() {
        return JRStyleResolver.getBorderColor(this, this.getForecolor());
    }

    @Override
    public Color getOwnBorderColor() {
        return this.borderColor;
    }

    @Override
    public void setBorderColor(Color color) {
        this.borderColor = color;
    }

    @Override
    public int getPadding() {
        return JRStyleResolver.getPadding(this);
    }

    @Override
    public Integer getOwnPadding() {
        return this.padding;
    }

    @Override
    public void setPadding(int n) {
        this.padding = new Integer(n);
    }

    @Override
    public void setPadding(Integer n) {
        this.padding = n;
    }

    @Override
    public byte getTopBorder() {
        return JRStyleResolver.getTopBorder(this);
    }

    @Override
    public Byte getOwnTopBorder() {
        return this.topBorder;
    }

    @Override
    public void setTopBorder(byte by) {
        this.topBorder = new Byte(by);
    }

    @Override
    public void setTopBorder(Byte by) {
        this.topBorder = by;
    }

    @Override
    public Color getTopBorderColor() {
        return JRStyleResolver.getTopBorderColor(this, this.getForecolor());
    }

    @Override
    public Color getOwnTopBorderColor() {
        return this.topBorderColor;
    }

    @Override
    public void setTopBorderColor(Color color) {
        this.topBorderColor = color;
    }

    @Override
    public int getTopPadding() {
        return JRStyleResolver.getTopPadding(this);
    }

    @Override
    public Integer getOwnTopPadding() {
        return this.topPadding;
    }

    @Override
    public void setTopPadding(int n) {
        this.topPadding = new Integer(n);
    }

    @Override
    public void setTopPadding(Integer n) {
        this.topPadding = n;
    }

    @Override
    public byte getLeftBorder() {
        return JRStyleResolver.getLeftBorder(this);
    }

    @Override
    public Byte getOwnLeftBorder() {
        return this.leftBorder;
    }

    @Override
    public void setLeftBorder(byte by) {
        this.leftBorder = new Byte(by);
    }

    @Override
    public void setLeftBorder(Byte by) {
        this.leftBorder = by;
    }

    @Override
    public Color getLeftBorderColor() {
        return JRStyleResolver.getLeftBorderColor(this, this.getForecolor());
    }

    @Override
    public Color getOwnLeftBorderColor() {
        return this.leftBorderColor;
    }

    @Override
    public void setLeftBorderColor(Color color) {
        this.leftBorderColor = color;
    }

    @Override
    public int getLeftPadding() {
        return JRStyleResolver.getLeftPadding(this);
    }

    @Override
    public Integer getOwnLeftPadding() {
        return this.leftPadding;
    }

    @Override
    public void setLeftPadding(int n) {
        this.leftPadding = new Integer(n);
    }

    @Override
    public void setLeftPadding(Integer n) {
        this.leftPadding = n;
    }

    @Override
    public byte getBottomBorder() {
        return JRStyleResolver.getBottomBorder(this);
    }

    @Override
    public Byte getOwnBottomBorder() {
        return this.bottomBorder;
    }

    @Override
    public void setBottomBorder(byte by) {
        this.bottomBorder = new Byte(by);
    }

    @Override
    public void setBottomBorder(Byte by) {
        this.bottomBorder = by;
    }

    @Override
    public Color getBottomBorderColor() {
        return JRStyleResolver.getBottomBorderColor(this, this.getForecolor());
    }

    @Override
    public Color getOwnBottomBorderColor() {
        return this.bottomBorderColor;
    }

    @Override
    public void setBottomBorderColor(Color color) {
        this.bottomBorderColor = color;
    }

    @Override
    public int getBottomPadding() {
        return JRStyleResolver.getBottomPadding(this);
    }

    @Override
    public Integer getOwnBottomPadding() {
        return this.bottomPadding;
    }

    @Override
    public void setBottomPadding(int n) {
        this.bottomPadding = new Integer(n);
    }

    @Override
    public void setBottomPadding(Integer n) {
        this.bottomPadding = n;
    }

    @Override
    public byte getRightBorder() {
        return JRStyleResolver.getRightBorder(this);
    }

    @Override
    public Byte getOwnRightBorder() {
        return this.rightBorder;
    }

    @Override
    public void setRightBorder(byte by) {
        this.rightBorder = new Byte(by);
    }

    @Override
    public void setRightBorder(Byte by) {
        this.rightBorder = by;
    }

    @Override
    public Color getRightBorderColor() {
        return JRStyleResolver.getRightBorderColor(this, this.getForecolor());
    }

    @Override
    public Color getOwnRightBorderColor() {
        return this.rightBorderColor;
    }

    @Override
    public void setRightBorderColor(Color color) {
        this.rightBorderColor = color;
    }

    @Override
    public int getRightPadding() {
        return JRStyleResolver.getRightPadding(this);
    }

    @Override
    public Integer getOwnRightPadding() {
        return this.rightPadding;
    }

    @Override
    public void setRightPadding(int n) {
        this.rightPadding = new Integer(n);
    }

    @Override
    public void setRightPadding(Integer n) {
        this.rightPadding = n;
    }

    @Override
    public String getLinkType() {
        return this.linkType;
    }

    @Override
    public JRHyperlinkParameter[] getHyperlinkParameters() {
        return this.hyperlinkParameters;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.normalizeLinkType();
    }

    protected void normalizeLinkType() {
        if (this.linkType == null) {
            this.linkType = JRHyperlinkHelper.getLinkType(this.hyperlinkType);
        }
        this.hyperlinkType = 0;
    }

    @Override
    public JRExpression getHyperlinkTooltipExpression() {
        return this.hyperlinkTooltipExpression;
    }
}

