/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRDefaultFontProvider;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintAnchor;
import net.sf.jasperreports.engine.JRPrintAnchorIndex;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRReportFont;
import net.sf.jasperreports.engine.JRStyle;

public class JasperPrint
implements Serializable {
    private static final long serialVersionUID = 10200L;
    private String name = null;
    private int pageWidth = 0;
    private int pageHeight = 0;
    private byte orientation = 1;
    private Map fontsMap = new HashMap();
    private List fontsList = new ArrayList();
    private Map stylesMap = new HashMap();
    private List stylesList = new ArrayList();
    private List pages = new ArrayList();
    private transient Map anchorIndexes = null;
    private DefaultStyleProvider defaultStyleProvider = new DefaultStyleProvider(null, null);
    private String formatFactoryClass;
    private String localeCode;
    private String timeZoneId;

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public int getPageWidth() {
        return this.pageWidth;
    }

    public void setPageWidth(int n) {
        this.pageWidth = n;
    }

    public int getPageHeight() {
        return this.pageHeight;
    }

    public void setPageHeight(int n) {
        this.pageHeight = n;
    }

    public byte getOrientation() {
        return this.orientation;
    }

    public void setOrientation(byte by) {
        this.orientation = by;
    }

    public JRReportFont getDefaultFont() {
        return this.defaultStyleProvider.getDefaultFont();
    }

    public void setDefaultFont(JRReportFont jRReportFont) {
        this.defaultStyleProvider.setDefaultFont(jRReportFont);
    }

    public JRDefaultFontProvider getDefaultFontProvider() {
        return this.defaultStyleProvider;
    }

    public JRReportFont[] getFonts() {
        JRReportFont[] jRReportFontArray = new JRReportFont[this.fontsList.size()];
        this.fontsList.toArray(jRReportFontArray);
        return jRReportFontArray;
    }

    public List getFontsList() {
        return this.fontsList;
    }

    public Map getFontsMap() {
        return this.fontsMap;
    }

    public synchronized void addFont(JRReportFont jRReportFont) throws JRException {
        this.addFont(jRReportFont, false);
    }

    public synchronized void addFont(JRReportFont jRReportFont, boolean bl) throws JRException {
        if (this.fontsMap.containsKey(jRReportFont.getName())) {
            if (!bl) {
                throw new JRException("Duplicate declaration of report font : " + jRReportFont.getName());
            }
        } else {
            this.fontsList.add(jRReportFont);
            this.fontsMap.put(jRReportFont.getName(), jRReportFont);
            if (jRReportFont.isDefault()) {
                this.setDefaultFont(jRReportFont);
            }
        }
    }

    public synchronized JRReportFont removeFont(String string) {
        return this.removeFont((JRReportFont)this.fontsMap.get(string));
    }

    public synchronized JRReportFont removeFont(JRReportFont jRReportFont) {
        if (jRReportFont != null) {
            if (jRReportFont.isDefault()) {
                this.setDefaultFont(null);
            }
            this.fontsList.remove(jRReportFont);
            this.fontsMap.remove(jRReportFont.getName());
        }
        return jRReportFont;
    }

    public JRStyle getDefaultStyle() {
        return this.defaultStyleProvider.getDefaultStyle();
    }

    public synchronized void setDefaultStyle(JRStyle jRStyle) {
        this.defaultStyleProvider.setDefaultStyle(jRStyle);
    }

    public JRDefaultStyleProvider getDefaultStyleProvider() {
        return this.defaultStyleProvider;
    }

    public JRStyle[] getStyles() {
        JRStyle[] jRStyleArray = new JRStyle[this.stylesList.size()];
        this.stylesList.toArray(jRStyleArray);
        return jRStyleArray;
    }

    public List getStylesList() {
        return this.stylesList;
    }

    public Map getStylesMap() {
        return this.stylesMap;
    }

    public synchronized void addStyle(JRStyle jRStyle) throws JRException {
        this.addStyle(jRStyle, false);
    }

    public synchronized void addStyle(JRStyle jRStyle, boolean bl) throws JRException {
        if (this.stylesMap.containsKey(jRStyle.getName())) {
            if (!bl) {
                throw new JRException("Duplicate declaration of report style : " + jRStyle.getName());
            }
        } else {
            this.stylesList.add(jRStyle);
            this.stylesMap.put(jRStyle.getName(), jRStyle);
            if (jRStyle.isDefault()) {
                this.setDefaultStyle(jRStyle);
            }
        }
    }

    public synchronized JRStyle removeStyle(String string) {
        return this.removeStyle((JRStyle)this.stylesMap.get(string));
    }

    public synchronized JRStyle removeStyle(JRStyle jRStyle) {
        if (jRStyle != null) {
            if (jRStyle.isDefault()) {
                this.setDefaultStyle(null);
            }
            this.stylesList.remove(jRStyle);
            this.stylesMap.remove(jRStyle.getName());
        }
        return jRStyle;
    }

    public List getPages() {
        return this.pages;
    }

    public synchronized void addPage(JRPrintPage jRPrintPage) {
        this.anchorIndexes = null;
        this.pages.add(jRPrintPage);
    }

    public synchronized void addPage(int n, JRPrintPage jRPrintPage) {
        this.anchorIndexes = null;
        this.pages.add(n, jRPrintPage);
    }

    public synchronized JRPrintPage removePage(int n) {
        this.anchorIndexes = null;
        return (JRPrintPage)this.pages.remove(n);
    }

    public synchronized Map getAnchorIndexes() {
        if (this.anchorIndexes == null) {
            this.anchorIndexes = new HashMap();
            int n = 0;
            for (JRPrintPage jRPrintPage : this.pages) {
                List list = jRPrintPage.getElements();
                this.collectAnchors(list, n, 0, 0);
                ++n;
            }
        }
        return this.anchorIndexes;
    }

    protected void collectAnchors(Collection collection, int n, int n2, int n3) {
        if (collection != null && collection.size() > 0) {
            JRPrintElement jRPrintElement2 = null;
            for (JRPrintElement jRPrintElement2 : collection) {
                if (jRPrintElement2 instanceof JRPrintAnchor) {
                    this.anchorIndexes.put(((JRPrintAnchor)((Object)jRPrintElement2)).getAnchorName(), new JRPrintAnchorIndex(n, jRPrintElement2, n2, n3));
                }
                if (!(jRPrintElement2 instanceof JRPrintFrame)) continue;
                JRPrintFrame jRPrintFrame = (JRPrintFrame)jRPrintElement2;
                this.collectAnchors(jRPrintFrame.getElements(), n, n2 + jRPrintFrame.getX(), n3 + jRPrintFrame.getY());
            }
        }
    }

    public String getFormatFactoryClass() {
        return this.formatFactoryClass;
    }

    public void setFormatFactoryClass(String string) {
        this.formatFactoryClass = string;
    }

    public String getLocaleCode() {
        return this.localeCode;
    }

    public void setLocaleCode(String string) {
        this.localeCode = string;
    }

    public String getTimeZoneId() {
        return this.timeZoneId;
    }

    public void setTimeZoneId(String string) {
        this.timeZoneId = string;
    }

    private static class DefaultStyleProvider
    implements JRDefaultStyleProvider,
    Serializable {
        private static final long serialVersionUID = 10200L;
        private JRReportFont defaultFont;
        private JRStyle defaultStyle;

        DefaultStyleProvider(JRReportFont jRReportFont, JRStyle jRStyle) {
            this.defaultFont = jRReportFont;
            this.defaultStyle = jRStyle;
        }

        @Override
        public JRReportFont getDefaultFont() {
            return this.defaultFont;
        }

        void setDefaultFont(JRReportFont jRReportFont) {
            this.defaultFont = jRReportFont;
        }

        @Override
        public JRStyle getDefaultStyle() {
            return this.defaultStyle;
        }

        void setDefaultStyle(JRStyle jRStyle) {
            this.defaultStyle = jRStyle;
        }
    }
}

