/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import net.sf.jasperreports.engine.JRAbstractRenderer;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.util.JRImageLoader;

public abstract class JRAbstractSvgRenderer
extends JRAbstractRenderer {
    private static final long serialVersionUID = 10200L;

    @Override
    public byte getType() {
        return 1;
    }

    @Override
    public byte getImageType() {
        return 2;
    }

    @Override
    public Dimension2D getDimension() {
        return null;
    }

    public Color getBackcolor() {
        return null;
    }

    @Override
    public byte[] getImageData() throws JRException {
        Dimension2D dimension2D = this.getDimension();
        if (dimension2D != null) {
            BufferedImage bufferedImage = new BufferedImage((int)dimension2D.getWidth(), (int)dimension2D.getHeight(), 1);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            Color color = this.getBackcolor();
            if (color != null) {
                graphics2D.setColor(color);
                graphics2D.fillRect(0, 0, (int)dimension2D.getWidth(), (int)dimension2D.getHeight());
            }
            this.render(graphics2D, new Rectangle((int)dimension2D.getWidth(), (int)dimension2D.getHeight()));
            graphics2D.dispose();
            try {
                return JRImageLoader.loadImageDataFromAWTImage(bufferedImage);
            }
            catch (JRException jRException) {
                throw new JRRuntimeException(jRException);
            }
        }
        return null;
    }
}

