/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.fill;

import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.charts.JRXyzDataset;
import net.sf.jasperreports.charts.JRXyzSeries;
import net.sf.jasperreports.charts.fill.JRFillXyzSeries;
import net.sf.jasperreports.charts.util.DefaultXYZDataset;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.design.JRVerifier;
import net.sf.jasperreports.engine.fill.JRCalculator;
import net.sf.jasperreports.engine.fill.JRExpressionEvalException;
import net.sf.jasperreports.engine.fill.JRFillChartDataset;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.util.Pair;
import org.jfree.data.general.Dataset;

public class JRFillXyzDataset
extends JRFillChartDataset
implements JRXyzDataset {
    protected JRFillXyzSeries[] xyzSeries = null;
    private DefaultXYZDataset dataset = null;
    private Map itemHyperlinks;

    public JRFillXyzDataset(JRXyzDataset jRXyzDataset, JRFillObjectFactory jRFillObjectFactory) {
        super(jRXyzDataset, jRFillObjectFactory);
        JRXyzSeries[] jRXyzSeriesArray = jRXyzDataset.getSeries();
        if (jRXyzSeriesArray != null && jRXyzSeriesArray.length > 0) {
            this.xyzSeries = new JRFillXyzSeries[jRXyzSeriesArray.length];
            for (int i = 0; i < this.xyzSeries.length; ++i) {
                this.xyzSeries[i] = (JRFillXyzSeries)jRFillObjectFactory.getXyzSeries(jRXyzSeriesArray[i]);
            }
        }
    }

    @Override
    public JRXyzSeries[] getSeries() {
        return this.xyzSeries;
    }

    @Override
    protected void customInitialize() {
        this.dataset = new DefaultXYZDataset();
        this.itemHyperlinks = new HashMap();
    }

    @Override
    protected void customEvaluate(JRCalculator jRCalculator) throws JRExpressionEvalException {
        if (this.xyzSeries != null && this.xyzSeries.length > 0) {
            for (int i = 0; i < this.xyzSeries.length; ++i) {
                this.xyzSeries[i].evaluate(jRCalculator);
            }
        }
    }

    @Override
    protected void customIncrement() {
        if (this.xyzSeries != null && this.xyzSeries.length > 0) {
            for (int i = 0; i < this.xyzSeries.length; ++i) {
                JRFillXyzSeries jRFillXyzSeries = this.xyzSeries[i];
                this.dataset.addValue(jRFillXyzSeries.getSeries(), jRFillXyzSeries.getXValue(), jRFillXyzSeries.getYValue(), jRFillXyzSeries.getZValue());
                if (!jRFillXyzSeries.hasItemHyperlinks()) continue;
                HashMap<Pair, JRPrintHyperlink> hashMap = (HashMap<Pair, JRPrintHyperlink>)this.itemHyperlinks.get(jRFillXyzSeries.getSeries());
                if (hashMap == null) {
                    hashMap = new HashMap<Pair, JRPrintHyperlink>();
                    this.itemHyperlinks.put(jRFillXyzSeries.getSeries(), hashMap);
                }
                Pair pair = new Pair(jRFillXyzSeries.getXValue(), jRFillXyzSeries.getYValue());
                hashMap.put(pair, jRFillXyzSeries.getPrintItemHyperlink());
            }
        }
    }

    @Override
    public Dataset getCustomDataset() {
        return this.dataset;
    }

    @Override
    public byte getDatasetType() {
        return 4;
    }

    @Override
    public void collectExpressions(JRExpressionCollector jRExpressionCollector) {
        jRExpressionCollector.collect(this);
    }

    public boolean hasItemHyperlinks() {
        boolean bl = false;
        if (this.xyzSeries != null && this.xyzSeries.length > 0) {
            for (int i = 0; i < this.xyzSeries.length && !bl; ++i) {
                JRFillXyzSeries jRFillXyzSeries = this.xyzSeries[i];
                bl = jRFillXyzSeries.hasItemHyperlinks();
            }
        }
        return bl;
    }

    public Map getItemHyperlinks() {
        return this.itemHyperlinks;
    }

    @Override
    public void validate(JRVerifier jRVerifier) {
        jRVerifier.verify(this);
    }
}

