/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.List;
import com.lowagie.text.RomanList;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfString;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.TreeMap;

public class PdfPageLabels {
    public static final int DECIMAL_ARABIC_NUMERALS = 0;
    public static final int UPPERCASE_ROMAN_NUMERALS = 1;
    public static final int LOWERCASE_ROMAN_NUMERALS = 2;
    public static final int UPPERCASE_LETTERS = 3;
    public static final int LOWERCASE_LETTERS = 4;
    public static final int EMPTY = 5;
    static PdfName[] numberingStyle = new PdfName[]{PdfName.D, PdfName.R, new PdfName("r"), PdfName.A, new PdfName("a")};
    TreeMap map = new TreeMap();

    public PdfPageLabels() {
        this.addPageLabel(1, 0, null, 1);
    }

    public void addPageLabel(int n, int n2, String string, int n3) {
        if (n < 1 || n3 < 1) {
            throw new IllegalArgumentException("In a page label the page numbers must be greater or equal to 1.");
        }
        PdfName pdfName = null;
        if (n2 >= 0 && n2 < numberingStyle.length) {
            pdfName = numberingStyle[n2];
        }
        Integer n4 = new Integer(n);
        Object[] objectArray = new Object[]{n4, pdfName, string, new Integer(n3)};
        this.map.put(n4, objectArray);
    }

    public void addPageLabel(int n, int n2, String string) {
        this.addPageLabel(n, n2, string, 1);
    }

    public void addPageLabel(int n, int n2) {
        this.addPageLabel(n, n2, null, 1);
    }

    public void removePageLabel(int n) {
        if (n <= 1) {
            return;
        }
        this.map.remove(new Integer(n));
    }

    PdfDictionary getDictionary() {
        PdfDictionary pdfDictionary = new PdfDictionary();
        PdfArray pdfArray = new PdfArray();
        for (Object[] objectArray : this.map.values()) {
            int n;
            String string;
            PdfDictionary pdfDictionary2 = new PdfDictionary();
            PdfName pdfName = (PdfName)objectArray[1];
            if (pdfName != null) {
                pdfDictionary2.put(PdfName.S, pdfName);
            }
            if ((string = (String)objectArray[2]) != null) {
                pdfDictionary2.put(PdfName.P, new PdfString(string, "UnicodeBig"));
            }
            if ((n = ((Integer)objectArray[3]).intValue()) != 1) {
                pdfDictionary2.put(PdfName.ST, new PdfNumber(n));
            }
            pdfArray.add(new PdfNumber((Integer)objectArray[0] - 1));
            pdfArray.add(pdfDictionary2);
        }
        pdfDictionary.put(PdfName.NUMS, pdfArray);
        return pdfDictionary;
    }

    public static String[] getPageLabels(PdfReader pdfReader) {
        int n = pdfReader.getNumberOfPages();
        String[] stringArray = new String[n];
        PdfDictionary pdfDictionary = pdfReader.getCatalog();
        PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject(pdfDictionary.get(PdfName.PAGELABELS));
        PdfArray pdfArray = (PdfArray)PdfReader.getPdfObject(pdfDictionary2.get(PdfName.NUMS));
        HashMap<Integer, PdfDictionary> hashMap = new HashMap<Integer, PdfDictionary>();
        ListIterator listIterator = pdfArray.listIterator();
        while (listIterator.hasNext()) {
            PdfNumber pdfNumber = (PdfNumber)listIterator.next();
            PdfDictionary pdfDictionary3 = (PdfDictionary)PdfReader.getPdfObject((PdfObject)listIterator.next());
            hashMap.put(new Integer(pdfNumber.intValue()), pdfDictionary3);
        }
        int n2 = 1;
        String string = "";
        int n3 = 68;
        for (int i = 0; i < n; ++i) {
            Integer n4 = new Integer(i);
            if (hashMap.containsKey(n4)) {
                PdfDictionary pdfDictionary4 = (PdfDictionary)hashMap.get(n4);
                n2 = pdfDictionary4.contains(PdfName.ST) ? ((PdfNumber)pdfDictionary4.get(PdfName.ST)).intValue() : 1;
                if (pdfDictionary4.contains(PdfName.P)) {
                    string = ((PdfString)pdfDictionary4.get(PdfName.P)).toString();
                }
                if (pdfDictionary4.contains(PdfName.S)) {
                    n3 = ((PdfName)pdfDictionary4.get(PdfName.S)).toString().charAt(1);
                }
            }
            switch (n3) {
                default: {
                    stringArray[i] = string + n2;
                    break;
                }
                case 82: {
                    stringArray[i] = string + RomanList.toRomanUpperCase(n2);
                    break;
                }
                case 114: {
                    stringArray[i] = string + RomanList.toRomanLowerCase(n2);
                    break;
                }
                case 65: {
                    stringArray[i] = string + List.getUpperCaseLetter(n2);
                    break;
                }
                case 97: {
                    stringArray[i] = string + List.getLowerCaseLetter(n2);
                }
            }
            ++n2;
        }
        return stringArray;
    }
}

