/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import com.jgoodies.looks.plastic.PlasticComboBoxButton;
import com.jgoodies.looks.plastic.PlasticComboBoxEditor;
import com.jgoodies.looks.plastic.PlasticIconFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.ComboBoxEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TextUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.plaf.metal.MetalComboBoxUI;
import javax.swing.plaf.metal.MetalTextFieldUI;

public class PlasticComboBoxUI
extends MetalComboBoxUI {
    static final String CELL_EDITOR_KEY = "JComboBox.isTableCellEditor";
    private static final JTextField PHANTOM = new JTextField("Phantom");
    private static Class phantomLafClass;
    private boolean tableCellEditor;
    private PropertyChangeListener propertyChangeListener;

    public static ComponentUI createUI(JComponent jComponent) {
        PlasticComboBoxUI.ensurePhantomHasPlasticUI();
        return new PlasticComboBoxUI();
    }

    private static void ensurePhantomHasPlasticUI() {
        TextUI textUI = PHANTOM.getUI();
        Class<?> clazz = UIManager.getLookAndFeel().getClass();
        if (phantomLafClass != clazz || !(textUI instanceof MetalTextFieldUI)) {
            phantomLafClass = clazz;
            PHANTOM.updateUI();
        }
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.tableCellEditor = this.isTableCellEditor();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.propertyChangeListener = new TableCellEditorPropertyChangeHandler();
        this.comboBox.addPropertyChangeListener(CELL_EDITOR_KEY, this.propertyChangeListener);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.comboBox.removePropertyChangeListener(CELL_EDITOR_KEY, this.propertyChangeListener);
        this.propertyChangeListener = null;
    }

    @Override
    protected JButton createArrowButton() {
        return new PlasticComboBoxButton(this.comboBox, PlasticIconFactory.getComboBoxButtonIcon(), this.comboBox.isEditable(), this.currentValuePane, this.listBox);
    }

    @Override
    protected ComboBoxEditor createEditor() {
        return new PlasticComboBoxEditor.UIResource(this.tableCellEditor);
    }

    @Override
    protected LayoutManager createLayoutManager() {
        return new PlasticComboBoxLayoutManager();
    }

    @Override
    protected ComboPopup createPopup() {
        return new PlasticComboPopup(this.comboBox);
    }

    protected ListCellRenderer createRenderer() {
        if (this.tableCellEditor) {
            return super.createRenderer();
        }
        BasicComboBoxRenderer.UIResource uIResource = new BasicComboBoxRenderer.UIResource();
        uIResource.setBorder(UIManager.getBorder("ComboBox.rendererBorder"));
        return uIResource;
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        Serializable serializable;
        Insets insets;
        if (!this.isMinimumSizeDirty) {
            return new Dimension(this.cachedMinimumSize);
        }
        Dimension dimension = this.getDisplaySize();
        Insets insets2 = this.getInsets();
        dimension.height += insets2.top + insets2.bottom;
        if (this.comboBox.isEditable()) {
            insets = UIManager.getInsets("ComboBox.editorBorderInsets");
            dimension.width += insets.left + insets.right;
            ++dimension.width;
        } else if (this.arrowButton != null) {
            insets = this.arrowButton.getInsets();
            dimension.width += insets.left;
        }
        int n = PlasticComboBoxUI.getEditableButtonWidth();
        dimension.width += insets2.left + insets2.right + n;
        ListCellRenderer listCellRenderer = this.comboBox.getRenderer();
        if (listCellRenderer instanceof JComponent) {
            serializable = (JComponent)((Object)listCellRenderer);
            Insets insets3 = ((JComponent)serializable).getInsets();
            Insets insets4 = UIManager.getInsets("ComboBox.editorInsets");
            int n2 = Math.max(0, insets4.left - insets3.left);
            int n3 = Math.max(0, insets4.right - insets3.right);
            dimension.width += n2 + n3;
        }
        serializable = PHANTOM.getMinimumSize();
        dimension.height = Math.max(((Dimension)serializable).height, dimension.height);
        this.cachedMinimumSize.setSize(dimension.width, dimension.height);
        this.isMinimumSizeDirty = false;
        return new Dimension(dimension);
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        return this.getMinimumSize(jComponent);
    }

    @Override
    protected Rectangle rectangleForCurrentValue() {
        int n = this.comboBox.getWidth();
        int n2 = this.comboBox.getHeight();
        Insets insets = this.getInsets();
        int n3 = PlasticComboBoxUI.getEditableButtonWidth();
        if (this.arrowButton != null) {
            n3 = this.arrowButton.getWidth();
        }
        if (this.comboBox.getComponentOrientation().isLeftToRight()) {
            return new Rectangle(insets.left, insets.top, n - (insets.left + insets.right + n3), n2 - (insets.top + insets.bottom));
        }
        return new Rectangle(insets.left + n3, insets.top, n - (insets.left + insets.right + n3), n2 - (insets.top + insets.bottom));
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        if (jComponent.isOpaque()) {
            graphics.setColor(jComponent.getBackground());
            graphics.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
            if (this.isToolBarComboBox(jComponent)) {
                jComponent.setOpaque(false);
            }
        }
        this.paint(graphics, jComponent);
    }

    protected boolean isToolBarComboBox(JComponent jComponent) {
        Container container = jComponent.getParent();
        return container != null && (container instanceof JToolBar || container.getParent() instanceof JToolBar);
    }

    static int getEditableButtonWidth() {
        return UIManager.getInt("ScrollBar.width") - 1;
    }

    private boolean isTableCellEditor() {
        return Boolean.TRUE.equals(this.comboBox.getClientProperty(CELL_EDITOR_KEY));
    }

    @Override
    public PropertyChangeListener createPropertyChangeListener() {
        return new PlasticPropertyChangeListener();
    }

    private final class TableCellEditorPropertyChangeHandler
    implements PropertyChangeListener {
        private TableCellEditorPropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            PlasticComboBoxUI.this.tableCellEditor = PlasticComboBoxUI.this.isTableCellEditor();
            if (PlasticComboBoxUI.this.comboBox.getRenderer() == null || PlasticComboBoxUI.this.comboBox.getRenderer() instanceof UIResource) {
                PlasticComboBoxUI.this.comboBox.setRenderer(PlasticComboBoxUI.this.createRenderer());
            }
            if (PlasticComboBoxUI.this.comboBox.getEditor() == null || PlasticComboBoxUI.this.comboBox.getEditor() instanceof UIResource) {
                PlasticComboBoxUI.this.comboBox.setEditor(PlasticComboBoxUI.this.createEditor());
            }
        }
    }

    private static final class PlasticComboPopup
    extends BasicComboPopup {
        private PlasticComboPopup(JComboBox jComboBox) {
            super(jComboBox);
        }

        @Override
        protected void configureList() {
            super.configureList();
            this.list.setForeground(UIManager.getColor("MenuItem.foreground"));
            this.list.setBackground(UIManager.getColor("MenuItem.background"));
        }

        @Override
        protected void configureScroller() {
            super.configureScroller();
            this.scroller.getVerticalScrollBar().putClientProperty("JScrollBar.isFreeStanding", Boolean.FALSE);
        }

        @Override
        protected Rectangle computePopupBounds(int n, int n2, int n3, int n4) {
            Serializable serializable;
            boolean bl;
            Rectangle rectangle = super.computePopupBounds(n, n2, n3, n4);
            Object object = this.comboBox.getClientProperty("ComboBox.popupPrototypeDisplayValue");
            if (object == null) {
                return rectangle;
            }
            ListCellRenderer<Object> listCellRenderer = this.list.getCellRenderer();
            Component component = listCellRenderer.getListCellRendererComponent(this.list, object, -1, true, true);
            n3 = component.getPreferredSize().width;
            boolean bl2 = bl = this.comboBox.getItemCount() > this.comboBox.getMaximumRowCount();
            if (bl) {
                serializable = this.scroller.getVerticalScrollBar();
                n3 += serializable.getPreferredSize().width;
            }
            serializable = super.computePopupBounds(n, n2, n3, n4);
            return ((Rectangle)serializable).width > rectangle.width ? serializable : rectangle;
        }
    }

    private final class PlasticPropertyChangeListener
    extends BasicComboBoxUI.PropertyChangeHandler {
        private PlasticPropertyChangeListener() {
            super(PlasticComboBoxUI.this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            super.propertyChange(propertyChangeEvent);
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("editable")) {
                PlasticComboBoxButton plasticComboBoxButton = (PlasticComboBoxButton)PlasticComboBoxUI.this.arrowButton;
                plasticComboBoxButton.setIconOnly(PlasticComboBoxUI.this.comboBox.isEditable());
                PlasticComboBoxUI.this.comboBox.repaint();
            } else if (string.equals("background")) {
                Color color = (Color)propertyChangeEvent.getNewValue();
                PlasticComboBoxUI.this.arrowButton.setBackground(color);
                PlasticComboBoxUI.this.listBox.setBackground(color);
            } else if (string.equals("foreground")) {
                Color color = (Color)propertyChangeEvent.getNewValue();
                PlasticComboBoxUI.this.arrowButton.setForeground(color);
                PlasticComboBoxUI.this.listBox.setForeground(color);
            }
        }
    }

    private final class PlasticComboBoxLayoutManager
    extends MetalComboBoxUI.MetalComboBoxLayoutManager {
        private PlasticComboBoxLayoutManager() {
            super(PlasticComboBoxUI.this);
        }

        @Override
        public void layoutContainer(Container container) {
            JComboBox jComboBox = (JComboBox)container;
            if (!jComboBox.isEditable()) {
                super.layoutContainer(container);
                return;
            }
            int n = jComboBox.getWidth();
            int n2 = jComboBox.getHeight();
            Insets insets = PlasticComboBoxUI.this.getInsets();
            int n3 = PlasticComboBoxUI.getEditableButtonWidth();
            int n4 = n2 - (insets.top + insets.bottom);
            if (PlasticComboBoxUI.this.arrowButton != null) {
                if (jComboBox.getComponentOrientation().isLeftToRight()) {
                    PlasticComboBoxUI.this.arrowButton.setBounds(n - (insets.right + n3), insets.top, n3, n4);
                } else {
                    PlasticComboBoxUI.this.arrowButton.setBounds(insets.left, insets.top, n3, n4);
                }
            }
            if (PlasticComboBoxUI.this.editor != null) {
                PlasticComboBoxUI.this.editor.setBounds(PlasticComboBoxUI.this.rectangleForCurrentValue());
            }
        }
    }
}

