/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.txt.gravacaorestauracao;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.swing.JOptionPane;
import serpro.ppgd.formatosexternos.txt.excecao.GeracaoTxtException;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.txt.gravacaorestauracao.RepositorioDeclaracaoCentralTxt;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.util.TabelaMensagens;

public class ImportadorTxt {
    private RepositorioDeclaracaoCentralTxt repositorioTxt;

    public IdentificadorDeclaracao importarDeclaracaoAnoAnterior(File file, boolean bl) throws GeracaoTxtException, IOException {
        if (this.repositorioTxt == null) {
            this.repositorioTxt = new RepositorioDeclaracaoCentralTxt("ARQ_IRPFANOANTERIOR", file);
        }
        IdentificadorDeclaracao identificadorDeclaracao = this.repositorioTxt.recuperarIdDeclaracaoAnoAnterior();
        this.repositorioTxt.importarDeclaracaoAnoAnterior(identificadorDeclaracao);
        return identificadorDeclaracao;
    }

    public IdentificadorDeclaracao restaurarIdDeclaracaoNaoPersistidoAnoAnterior(File file) throws GeracaoTxtException, IOException {
        if (this.repositorioTxt == null) {
            this.repositorioTxt = new RepositorioDeclaracaoCentralTxt("ARQ_IRPFANOANTERIOR", file);
        }
        IdentificadorDeclaracao identificadorDeclaracao = this.repositorioTxt.recuperarIdDeclaracaoNaoPersistido();
        identificadorDeclaracao.getExercicio().setConteudo(ConstantesGlobais.EXERCICIO);
        return identificadorDeclaracao;
    }

    public void restaurarDeclaracao(File file) throws Exception {
        if (this.repositorioTxt == null) {
            this.repositorioTxt = new RepositorioDeclaracaoCentralTxt("ARQ_IRPF", file);
        }
        IdentificadorDeclaracao identificadorDeclaracao = this.repositorioTxt.recuperarIdDeclaracao();
        this.repositorioTxt.recuperarDeclaracao(identificadorDeclaracao);
        Iterator iterator = this.repositorioTxt.getArquivo().arquivo().iterator();
        while (iterator.hasNext()) {
            String string = ((String)iterator.next()).substring(0, 2);
            if (!string.equals("67") && !string.equals("78")) continue;
            JOptionPane.showMessageDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), TabelaMensagens.getTabelaMensagens().msg("recuperar_dados_windows"), "IRPF" + ConstantesGlobais.EXERCICIO, 1);
            break;
        }
        this.repositorioTxt = null;
    }

    public IdentificadorDeclaracao restaurarIdDeclaracao(File file) throws GeracaoTxtException, IOException {
        if (this.repositorioTxt == null) {
            this.repositorioTxt = new RepositorioDeclaracaoCentralTxt("ARQ_IRPF", file);
        }
        return this.repositorioTxt.recuperarIdDeclaracaoNaoPersistido();
    }

    public boolean existeDeclaracaoExercicioAtual(File file) throws GeracaoTxtException, IOException {
        if (this.repositorioTxt == null) {
            this.repositorioTxt = new RepositorioDeclaracaoCentralTxt("ARQ_IRPF", file);
        }
        IdentificadorDeclaracao identificadorDeclaracao = this.repositorioTxt.recuperarIdDeclaracaoNaoPersistido();
        identificadorDeclaracao.getExercicio().setConteudo(ConstantesGlobais.EXERCICIO);
        return IRPFFacade.existeDeclaracao(identificadorDeclaracao.getCpf().asString());
    }

    public RepositorioDeclaracaoCentralTxt getRepositorioTxt() {
        return this.repositorioTxt;
    }
}

