/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.txt.gravacaorestauracao;

import java.text.NumberFormat;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Logger;
import serpro.hash.Crc32;
import serpro.ppgd.formatosexternos.txt.RegistroTxt;
import serpro.ppgd.formatosexternos.txt.excecao.GeracaoTxtException;
import serpro.ppgd.irpf.ColecaoItemQuadroOutrosRendimentos;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.ItemQuadroOutrosRendimentos;
import serpro.ppgd.irpf.alimentandos.Alimentando;
import serpro.ppgd.irpf.alimentandos.Alimentandos;
import serpro.ppgd.irpf.atividaderural.AtividadeRural;
import serpro.ppgd.irpf.atividaderural.BemAR;
import serpro.ppgd.irpf.atividaderural.DividaAR;
import serpro.ppgd.irpf.atividaderural.ImovelAR;
import serpro.ppgd.irpf.atividaderural.ItemMovimentacaoRebanho;
import serpro.ppgd.irpf.atividaderural.MovimentacaoRebanho;
import serpro.ppgd.irpf.atividaderural.brasil.ARBrasil;
import serpro.ppgd.irpf.atividaderural.brasil.ApuracaoResultadoBrasil;
import serpro.ppgd.irpf.atividaderural.brasil.ImovelARBrasil;
import serpro.ppgd.irpf.atividaderural.brasil.MesReceitaDespesa;
import serpro.ppgd.irpf.atividaderural.brasil.ReceitasDespesas;
import serpro.ppgd.irpf.atividaderural.exterior.ARExterior;
import serpro.ppgd.irpf.atividaderural.exterior.ApuracaoResultadoExterior;
import serpro.ppgd.irpf.atividaderural.exterior.BemARExterior;
import serpro.ppgd.irpf.atividaderural.exterior.ReceitaDespesa;
import serpro.ppgd.irpf.bens.Bem;
import serpro.ppgd.irpf.bens.Bens;
import serpro.ppgd.irpf.calculos.CalculosPagamentos;
import serpro.ppgd.irpf.contribuinte.Contribuinte;
import serpro.ppgd.irpf.dependentes.Dependente;
import serpro.ppgd.irpf.dependentes.Dependentes;
import serpro.ppgd.irpf.dividas.Divida;
import serpro.ppgd.irpf.dividas.Dividas;
import serpro.ppgd.irpf.eleicoes.Doacao;
import serpro.ppgd.irpf.eleicoes.Doacoes;
import serpro.ppgd.irpf.espolio.Espolio;
import serpro.ppgd.irpf.pagamentos.Pagamento;
import serpro.ppgd.irpf.pagamentos.Pagamentos;
import serpro.ppgd.irpf.rendIsentos.RendIsentos;
import serpro.ppgd.irpf.rendTributacaoExclusiva.RendTributacaoExclusiva;
import serpro.ppgd.irpf.rendavariavel.FundosInvestimentos;
import serpro.ppgd.irpf.rendavariavel.GanhosLiquidosOuPerdas;
import serpro.ppgd.irpf.rendavariavel.MesFundosInvestimentos;
import serpro.ppgd.irpf.rendavariavel.Operacoes;
import serpro.ppgd.irpf.rendavariavel.RendaVariavel;
import serpro.ppgd.irpf.rendpf.MesRendPF;
import serpro.ppgd.irpf.rendpf.RendPF;
import serpro.ppgd.irpf.rendpf.RendPFDependente;
import serpro.ppgd.irpf.rendpj.ColecaoRendPJDependente;
import serpro.ppgd.irpf.rendpj.ColecaoRendPJTitular;
import serpro.ppgd.irpf.rendpj.RendPJDependente;
import serpro.ppgd.irpf.rendpj.RendPJTitular;
import serpro.ppgd.irpf.rendpjexigibilidade.ColecaoRendPJComExigibilidadeDependente;
import serpro.ppgd.irpf.rendpjexigibilidade.ColecaoRendPJComExigibilidadeTitular;
import serpro.ppgd.irpf.rendpjexigibilidade.RendPJComExigibilidadeDependente;
import serpro.ppgd.irpf.rendpjexigibilidade.RendPJComExigibilidadeTitular;
import serpro.ppgd.negocio.CPF;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Valor;
import serpro.ppgd.negocio.util.FabricaUtilitarios;
import serpro.util.PLong;

public class ConversorObjetosIRPF2Registros {
    private static final Logger logger;

    static {
        Class<ConversorObjetosIRPF2Registros> clazz = ConversorObjetosIRPF2Registros.class;
        logger = Logger.getLogger(clazz.getName());
    }

    public Vector montarRegistroHeader(DeclaracaoIRPF declaracaoIRPF) throws GeracaoTxtException {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        Vector<RegistroTxt> vector = new Vector<RegistroTxt>();
        RegistroTxt registroTxt = new RegistroTxt("ARQ_IRPF", "IR");
        registroTxt.fieldByName("SISTEMA").set("IRPF");
        registroTxt.fieldByName("EXERCICIO").set(ConstantesGlobais.EXERCICIO);
        registroTxt.fieldByName("ANO_BASE").set(ConstantesGlobais.ANO_BASE);
        registroTxt.fieldByName("CODIGO_RECNET").set(2900);
        if (declaracaoIRPF.getIdentificadorDeclaracao().isEspolio()) {
            registroTxt.fieldByName("DATA_TRANSITO_JULGADO").set("");
        }
        if (declaracaoIRPF.getIdentificadorDeclaracao().isRetificadora()) {
            registroTxt.fieldByName("IN_RETIFICADORA").set(1);
            string6 = declaracaoIRPF.getIdentificadorDeclaracao().getNumReciboDecRetif().asString();
            if (string6.length() >= 10) {
                registroTxt.fieldByName("NR_RECIBO_ULTIMA_DEC_EX_ATUAL").set(string6.substring(0, 10));
            } else if (string6.length() > 0) {
                registroTxt.fieldByName("NR_RECIBO_ULTIMA_DEC_EX_ATUAL").set(string6.substring(0, 9));
            }
        } else {
            registroTxt.fieldByName("IN_RETIFICADORA").set(0);
        }
        string6 = declaracaoIRPF.getContribuinte().getNumeroReciboDecAnterior().asString();
        if (string6.length() >= 10) {
            registroTxt.fieldByName("NR_RECIBO_ULTIMA_DEC_EX_ANTERIOR").set(string6.substring(0, 10));
        } else if (string6.length() > 0) {
            registroTxt.fieldByName("NR_RECIBO_ULTIMA_DEC_EX_ANTERIOR").set(string6.substring(0, 9));
        }
        registroTxt.fieldByName("NR_CPF").set(declaracaoIRPF.getIdentificadorDeclaracao().getCpf().asString());
        registroTxt.fieldByName("TIPO_NI").set(1);
        registroTxt.fieldByName("NR_VERSAO").set(FabricaUtilitarios.getProperties().getProperty("versao_txt"));
        registroTxt.fieldByName("NM_NOME").setLimitado(declaracaoIRPF.getIdentificadorDeclaracao().getNome().asString());
        if (declaracaoIRPF.getContribuinte().getExterior().asString().equals(Logico.NAO)) {
            registroTxt.fieldByName("SG_UF").set(declaracaoIRPF.getContribuinte().getUf().asString());
        } else {
            registroTxt.fieldByName("SG_UF").set("EX");
        }
        registroTxt.fieldByName("NR_HASH").set(0);
        registroTxt.fieldByName("IN_CERTIFICAVEL").set(1);
        registroTxt.fieldByName("DT_NASCIM").set(declaracaoIRPF.getContribuinte().getDataNascimento().asString());
        registroTxt.fieldByName("IN_COMPLETA").set(declaracaoIRPF.getIdentificadorDeclaracao().getTipoDeclaracao().asString().equals("0") ? "S" : "N");
        registroTxt.fieldByName("IN_GERADA").set(declaracaoIRPF.getIdentificadorDeclaracao().isDeclaracaoGerada() ? "S" : "N");
        registroTxt.fieldByName("NOME_SO").setLimitado(System.getProperty("os.name"));
        registroTxt.fieldByName("VERSAO_SO").setLimitado(System.getProperty("os.version"));
        registroTxt.fieldByName("VERSAO_JVM").setLimitado(System.getProperty("java.version"));
        if (declaracaoIRPF.getContribuinte().getPais().getConteudoAtual(0).equals("105")) {
            registroTxt.fieldByName("CD_MUNICIP").set(declaracaoIRPF.getContribuinte().getMunicipio().getConteudoAtual(0));
        } else {
            registroTxt.fieldByName("CD_MUNICIP").set(9707);
        }
        registroTxt.fieldByName("NR_CONJ").set(declaracaoIRPF.getContribuinte().getCpfConjuge().asString());
        String string7 = declaracaoIRPF.recuperarPrincipalFontePagadora().asString();
        if (string7 != null) {
            registroTxt.fieldByName("NR_BASE_FONTE_MAIOR").set(string7);
        }
        if ((string5 = declaracaoIRPF.recuperarSegundaMaiorFontePagadora().asString()) != null) {
            registroTxt.fieldByName("NR_BASE_FONTE_DOIS").set(string5);
        }
        if ((string4 = declaracaoIRPF.recuperarTerceiraMaiorFontePagadora().asString()) != null) {
            registroTxt.fieldByName("NR_BASE_FONTE_TRES").set(string4);
        }
        if ((string3 = declaracaoIRPF.recuperarQuartaMaiorFontePagadora().asString()) != null) {
            registroTxt.fieldByName("NR_BASE_FONTE_QUATRO").set(string3);
        }
        CPF cPF = declaracaoIRPF.recuperarMaiorDependente();
        Dependente dependente = declaracaoIRPF.getDependentes().getDependenteByCPF(cPF);
        if (dependente != null) {
            registroTxt.fieldByName("NR_CPF_DEPE_REND_MAIOR").set(cPF.asString());
            registroTxt.fieldByName("DT_NASC_DEPE_REND_MAIOR").set(dependente.getDataNascimento().asString());
        }
        cPF = declaracaoIRPF.recuperarSegundoMaiorDependente();
        dependente = declaracaoIRPF.getDependentes().getDependenteByCPF(cPF);
        if (dependente != null) {
            registroTxt.fieldByName("NR_CPF_DEPE_REND_DOIS").set(cPF.asString());
            registroTxt.fieldByName("DT_NASC_DEPE_REND_DOIS").set(dependente.getDataNascimento().asString());
        }
        cPF = declaracaoIRPF.recuperarTerceiroMaiorDependente();
        dependente = declaracaoIRPF.getDependentes().getDependenteByCPF(cPF);
        if (dependente != null) {
            registroTxt.fieldByName("NR_CPF_DEPE_REND_TRES").set(cPF.asString());
            registroTxt.fieldByName("DT_NASC_DEPE_REND_TRES").set(dependente.getDataNascimento().asString());
        }
        cPF = declaracaoIRPF.recuperarQuartoMaiorDependente();
        dependente = declaracaoIRPF.getDependentes().getDependenteByCPF(cPF);
        if (dependente != null) {
            registroTxt.fieldByName("NR_CPF_DEPE_REND_QUATRO").set(cPF.asString());
            registroTxt.fieldByName("DT_NASC_DEPE_REND_QUATRO").set(dependente.getDataNascimento().asString());
        }
        cPF = declaracaoIRPF.recuperarQuintoMaiorDependente();
        dependente = declaracaoIRPF.getDependentes().getDependenteByCPF(cPF);
        if (dependente != null) {
            registroTxt.fieldByName("NR_CPF_DEPE_REND_CINCO").set(cPF.asString());
            registroTxt.fieldByName("DT_NASC_DEPE_REND_CINCO").set(dependente.getDataNascimento().asString());
        }
        cPF = declaracaoIRPF.recuperarSextoMaiorDependente();
        dependente = declaracaoIRPF.getDependentes().getDependenteByCPF(cPF);
        if (dependente != null) {
            registroTxt.fieldByName("NR_CPF_DEPE_REND_SEIS").set(cPF.asString());
            registroTxt.fieldByName("DT_NASC_DEPE_REND_SEIS").set(dependente.getDataNascimento().asString());
        }
        if ((string2 = declaracaoIRPF.getPagamentos().recuperarNIMaiorDespMedicas().asString()) != null) {
            registroTxt.fieldByName("NR_BASE_BENEF_DESP_MED_MAIOR").set(string2);
        }
        if ((string = declaracaoIRPF.getPagamentos().recuperarNISegundoMaiorDespMedicas().asString()) != null) {
            registroTxt.fieldByName("NR_BASE_BENEF_DESP_MED_DOIS").set(string);
        }
        registroTxt.fieldByName("IN_OBRIGAT_ENTREGA").set(declaracaoIRPF.verificaObrigatoriedadeEntrega());
        Valor valor = null;
        if (declaracaoIRPF.getIdentificadorDeclaracao().getTipoDeclaracao().asString().equals("0")) {
            valor = declaracaoIRPF.getModelo().getImpostoDevidoII();
        } else if (declaracaoIRPF.getIdentificadorDeclaracao().getTipoDeclaracao().asString().equals("1")) {
            valor = declaracaoIRPF.getModelo().getImpostoDevido();
        }
        registroTxt.fieldByName("VR_IMPDEVIDO").set(valor);
        registroTxt.fieldByName("VR_DOACAO_ECA").set(CalculosPagamentos.totalizarPagamentosGlosado(declaracaoIRPF.getPagamentos(), new String[]{"39", "40"}, true));
        String string8 = declaracaoIRPF.getIdentificadorDeclaracao().getCpf().asString();
        PLong pLong = new PLong();
        Crc32 crc32 = new Crc32();
        pLong.setValue(0L);
        crc32.CalcCrc32(string8, string8.length(), pLong);
        registroTxt.fieldByName("FILLER3").set(crc32.getStrCrc32());
        registroTxt.fieldByName("ENDERECO_MAC").set(declaracaoIRPF.getIdentificadorDeclaracao().getEnderecoMAC().asString());
        if (!declaracaoIRPF.verificaObrigatoriedadeEntrega().equals("0")) {
            registroTxt.fieldByName("IN_CRIT_OBRIGAT").set(declaracaoIRPF.criteriosObrigatoriedadeEntrega());
        }
        registroTxt.fieldByName("VR_TOTAL_RENDTRIB_PFPJ_TITDEP").set(declaracaoIRPF.getIdentificadorDeclaracao().isCompleta() ? declaracaoIRPF.getModeloCompleta().getTotalRendimentos() : declaracaoIRPF.getModeloSimplificada().getTotalResultadosTributaveis());
        registroTxt.fieldByName("CNPJ_PREV_COMPLEMENTAR_1").set(declaracaoIRPF.getPagamentos().recuperarCNPJMaiorPrevComplementar());
        registroTxt.fieldByName("CNPJ_PREV_COMPLEMENTAR_2").set(declaracaoIRPF.getPagamentos().recuperarCNPJSegundaMaiorPrevComplementar());
        if (!declaracaoIRPF.getModelo().getSaldoImpostoPagar().isVazio() && declaracaoIRPF.getResumo().getCalculoImposto().getDebitoAutomatico().asString().equals("autorizado")) {
            registroTxt.fieldByName("IN_RESULTADO_IMPOSTO").set(3);
        } else if (!declaracaoIRPF.getModelo().getSaldoImpostoPagar().isVazio()) {
            registroTxt.fieldByName("IN_RESULTADO_IMPOSTO").set(1);
        } else if (!declaracaoIRPF.getModelo().getImpostoRestituir().isVazio()) {
            registroTxt.fieldByName("IN_RESULTADO_IMPOSTO").set(2);
        } else {
            registroTxt.fieldByName("IN_RESULTADO_IMPOSTO").set(0);
        }
        registroTxt.fieldByName("IN_IMPOSTO_PAGO").set(declaracaoIRPF.getModelo().recuperarCodInImpostoPago());
        registroTxt.fieldByName("IN_IMPOSTO_ANTECIPADO").set(declaracaoIRPF.getModelo().recuperarCodInImpostoAntecipado());
        registroTxt.fieldByName("IN_MUDA_ENDERECO").set(declaracaoIRPF.getContribuinte().getEnderecoDiferente().asString().equals(Logico.SIM) ? "1" : "0");
        registroTxt.fieldByName("NR_CPF_INVENTARIANTE").set(declaracaoIRPF.getEspolio().getCpfInventariante().asString());
        String string9 = declaracaoIRPF.getPagamentos().recuperarCpfMaiorPensaoAlimenticia();
        registroTxt.fieldByName("NR_CPF_DEST_PENSAO_ALIMENT_MAIOR").set(string9);
        boolean bl = declaracaoIRPF.getIdentificadorDeclaracao().isRetificadora();
        declaracaoIRPF.getContribuinte().getNumeroReciboDecAnterior().validar();
        if (bl) {
            registroTxt.fieldByName("IN_SEGURANCA").set(0);
        } else if (declaracaoIRPF.getContribuinte().getNumeroReciboDecAnterior().isVazio() || !declaracaoIRPF.getContribuinte().getNumeroReciboDecAnterior().isValido()) {
            registroTxt.fieldByName("IN_SEGURANCA").set(1);
        } else {
            registroTxt.fieldByName("IN_SEGURANCA").set(2);
        }
        registroTxt.fieldByName("IN_PLATAFORMAPGD").set(2);
        if (declaracaoIRPF.getContribuinte().getExterior().asString().equals(Logico.SIM)) {
            registroTxt.fieldByName("NR_CEP").set(declaracaoIRPF.getContribuinte().getCepExt().asString());
            registroTxt.fieldByName("NM_MUNICIP").set(declaracaoIRPF.getContribuinte().getCidade().getConteudoFormatado());
        } else {
            registroTxt.fieldByName("NR_CEP").set(declaracaoIRPF.getContribuinte().getCep().asString());
            registroTxt.fieldByName("NM_MUNICIPIO").set(declaracaoIRPF.getContribuinte().getMunicipio().getConteudoAtual(1));
        }
        registroTxt.fieldByName("IN_DEBITO_PRIMEIRA_QUOTA").set(declaracaoIRPF.getResumo().getCalculoImposto().getIndicadorPrimeiraQuota().asString().equals("1") ? "1" : "0");
        registroTxt.fieldByName("NR_BANCO").set(declaracaoIRPF.getResumo().getCalculoImposto().getBanco().getConteudoAtual(0));
        registroTxt.fieldByName("NR_AGENCIA").set(declaracaoIRPF.getResumo().getCalculoImposto().getAgencia().asString());
        registroTxt.fieldByName("NM_CONTRIBUINTE").setLimitado(declaracaoIRPF.getIdentificadorDeclaracao().getNome().asString());
        registroTxt.fieldByName("VR_TOTISENTOS").set(declaracaoIRPF.getRendIsentos().getTotal());
        registroTxt.fieldByName("VR_TOTEXCLUSIVO").set(declaracaoIRPF.getRendTributacaoExclusiva().getTotal());
        registroTxt.fieldByName("VR_TOTAL_PAGAMENTOS").set(CalculosPagamentos.totalizarPagamentos(declaracaoIRPF.getPagamentos()));
        registroTxt.fieldByName("NR_CONTA").set(declaracaoIRPF.getResumo().getCalculoImposto().getContaCredito().asString());
        registroTxt.fieldByName("NR_DV_CONTA").set(declaracaoIRPF.getResumo().getCalculoImposto().getDvContaCredito().asString());
        registroTxt.fieldByName("IN_DV_CONTA").set(0);
        registroTxt.fieldByName("CD_NATUR").set(declaracaoIRPF.getContribuinte().getNaturezaOcupacao().getConteudoAtual(0));
        registroTxt.fieldByName("NR_CPF_EMPREGADA_DOMESTICA_MAIOR").set(declaracaoIRPF.getPagamentos().recuperarCpfMaiorEmpregadaDomestica());
        registroTxt.fieldByName("NR_NIT_EMP_DOM_MAIOR").set(declaracaoIRPF.getPagamentos().recuperarNitMaiorEmpregadaDomestica());
        registroTxt.fieldByName("NR_CPF_EMPREGADA_DOMESTICA_DOIS").set(declaracaoIRPF.getPagamentos().recuperarCpfEmpregadaDomesticaDois());
        registroTxt.fieldByName("NR_NIT_EMP_DOM_DOIS").set(declaracaoIRPF.getPagamentos().recuperarNitEmpregadaDomesticaDois());
        registroTxt.fieldByName("NR_CPF_EMPREGADA_DOMESTICA_TRES").set(declaracaoIRPF.getPagamentos().recuperarCpfEmpregadaDomesticaTres());
        registroTxt.fieldByName("NR_NIT_EMP_DOM_TRES").set(declaracaoIRPF.getPagamentos().recuperarNitEmpregadaDomesticaTres());
        valor = declaracaoIRPF.getModelo().getSaldoImpostoPagar();
        RendaVariavel rendaVariavel = declaracaoIRPF.getRendaVariavel();
        int n = 1;
        while (n <= 12) {
            GanhosLiquidosOuPerdas ganhosLiquidosOuPerdas = rendaVariavel.getGanhosPorIndice(n - 1);
            if (!ganhosLiquidosOuPerdas.estaVazio()) {
                valor.append('+', ganhosLiquidosOuPerdas.getImpostoApagar());
            }
            ++n;
        }
        registroTxt.fieldByName("VR_SOMA_IMPOSTO_PAGAR").set(valor);
        registroTxt.fieldByName("TP_INICIADA").set(1);
        registroTxt.fieldByName("IN_UTILIZOU_PGD").set(1);
        registroTxt.fieldByName("IN_UTILIZOU_APP").set(0);
        registroTxt.fieldByName("IN_UTILIZOU_ONLINE").set(0);
        registroTxt.fieldByName("IN_UTILIZOU_RASCUNHO").set(0);
        registroTxt.fieldByName("IN_UTILIZOU_PREPREENCHIDA").set(0);
        registroTxt.fieldByName("IN_UTILIZOU_ASSISTIDA_FONTES_PAGADORAS").set(0);
        registroTxt.fieldByName("IN_UTILIZOU_ASSISTIDA_PLANO_SAUDE").set(0);
        registroTxt.fieldByName("IN_UTILIZOU_SALVAR_RECUPERAR_ONLINE").set(0);
        registroTxt.fieldByName("TP_TRANSMITIDA").set(1);
        String[] stringArray = declaracaoIRPF.getPagamentos().recuperarNiMaioresPagamentosDedutiveis(6);
        registroTxt.fieldByName("NR_PAGAMENTO_DEDUTIVEL_MAIOR_UM").set(stringArray[0] != null ? stringArray[0] : "");
        registroTxt.fieldByName("NR_PAGAMENTO_DEDUTIVEL_MAIOR_DOIS").set(stringArray[1] != null ? stringArray[1] : "");
        registroTxt.fieldByName("NR_PAGAMENTO_DEDUTIVEL_MAIOR_TRES").set(stringArray[2] != null ? stringArray[2] : "");
        registroTxt.fieldByName("NR_PAGAMENTO_DEDUTIVEL_MAIOR_QUATRO").set(stringArray[3] != null ? stringArray[3] : "");
        registroTxt.fieldByName("NR_PAGAMENTO_DEDUTIVEL_MAIOR_CINCO").set(stringArray[4] != null ? stringArray[4] : "");
        registroTxt.fieldByName("NR_PAGAMENTO_DEDUTIVEL_MAIOR_SEIS").set(stringArray[5] != null ? stringArray[5] : "");
        registroTxt.fieldByName("NR_PAGAMENTO_FUNPRESP").set(declaracaoIRPF.getPagamentos().recuperarCnpjMaiorPagamentoFunpresp());
        registroTxt.fieldByName("VERSAOTESTEPGD").set("   ");
        vector.add(registroTxt);
        return vector;
    }

    public Vector montarRegistroContribuinte(DeclaracaoIRPF declaracaoIRPF) throws GeracaoTxtException {
        Vector<RegistroTxt> vector = new Vector<RegistroTxt>();
        Contribuinte contribuinte = declaracaoIRPF.getContribuinte();
        RegistroTxt registroTxt = new RegistroTxt("ARQ_IRPF", "16");
        registroTxt.fieldByName("NR_REG").set("16");
        registroTxt.fieldByName("NR_CPF").set(declaracaoIRPF.getIdentificadorDeclaracao().getCpf().asString());
        registroTxt.fieldByName("NM_NOME").setLimitado(declaracaoIRPF.getIdentificadorDeclaracao().getNome().asString());
        registroTxt.fieldByName("NR_TITELEITOR").set(contribuinte.getTituloEleitor().asString());
        registroTxt.fieldByName("DT_NASCIM").set(contribuinte.getDataNascimento().asString());
        registroTxt.fieldByName("TIP_LOGRA").set(contribuinte.getTipoLogradouro().getConteudoAtual(0));
        registroTxt.fieldByName("CD_MUNICIP").set(contribuinte.getMunicipio().getConteudoAtual(0));
        registroTxt.fieldByName("NM_COMPLEM").setLimitado(contribuinte.getComplemento().asString());
        registroTxt.fieldByName("NR_CEP").set(contribuinte.getCep().asString());
        if (contribuinte.getExterior().asString().equals(Logico.SIM)) {
            registroTxt.fieldByName("SG_UF").set("EX");
            registroTxt.fieldByName("CD_EX").set(contribuinte.getCodigoExterior().getConteudoAtual(0));
            registroTxt.fieldByName("CD_PAIS").set(contribuinte.getPais().getConteudoAtual(0));
            registroTxt.fieldByName("NM_MUNICIP").setLimitado(contribuinte.getCidade().getConteudoFormatado());
            registroTxt.fieldByName("NM_LOGRA").setLimitado(contribuinte.getLogradouroExt().asString());
            registroTxt.fieldByName("NR_NUMERO").setLimitado(contribuinte.getNumeroExt().asString());
            registroTxt.fieldByName("NM_BAIRRO").setLimitado(contribuinte.getBairroExt().asString());
            registroTxt.fieldByName("NM_COMPLEM").setLimitado(contribuinte.getComplementoExt().asString());
            registroTxt.fieldByName("NR_NITPISPASEP").setLimitado(contribuinte.getNitPisPasep().asString());
        } else {
            registroTxt.fieldByName("NM_MUNICIP").setLimitado(contribuinte.getMunicipio().getConteudoAtual(1));
            registroTxt.fieldByName("SG_UF").set(contribuinte.getUf().getConteudoAtual(0));
            registroTxt.fieldByName("CD_PAIS").set(contribuinte.getPais().getConteudoAtual(0));
            registroTxt.fieldByName("NM_LOGRA").setLimitado(contribuinte.getLogradouro().asString());
            registroTxt.fieldByName("NR_NUMERO").setLimitado(contribuinte.getNumero().asString());
            registroTxt.fieldByName("NM_BAIRRO").setLimitado(contribuinte.getBairro().asString());
            registroTxt.fieldByName("NM_COMPLEM").setLimitado(contribuinte.getComplemento().asString());
        }
        String string = contribuinte.getCpfConjuge().asString();
        registroTxt.fieldByName("IN_CONJUGE").set(string.trim().equals("") ? "N" : "S");
        registroTxt.fieldByName("NR_CPF_CONJUGE").set(string);
        registroTxt.fieldByName("NR_REGISTRO_PROFISSIONAL").set(contribuinte.getRegistroProfissional().asString());
        registroTxt.fieldByName("NM_EMAIL").set(contribuinte.getEmail().asString());
        String string2 = contribuinte.getDdd().asString().trim();
        registroTxt.fieldByName("NR_DDD_TELEFONE").set(string2);
        registroTxt.fieldByName("NR_TELEFONE").set(contribuinte.getTelefone().asString());
        registroTxt.fieldByName("NR_DDD_CELULAR").set(contribuinte.getDddCelular().asString().trim());
        registroTxt.fieldByName("NR_CELULAR").set(contribuinte.getCelular().asString());
        registroTxt.fieldByName("CD_OCUP").set(contribuinte.getOcupacaoPrincipal().getConteudoAtual(0));
        registroTxt.fieldByName("CD_NATUR").set(contribuinte.getNaturezaOcupacao().getConteudoAtual(0));
        registroTxt.fieldByName("NR_QUOTAS").set(declaracaoIRPF.getResumo().getCalculoImposto().getNumQuotas().asInteger());
        registroTxt.fieldByName("NR_BANCO").set(declaracaoIRPF.getResumo().getCalculoImposto().getBanco().getConteudoAtual(0));
        registroTxt.fieldByName("NR_AGENCIA").set(declaracaoIRPF.getResumo().getCalculoImposto().getAgencia().asString());
        registroTxt.fieldByName("IN_DOENCA_DEFICIENCIA").set(contribuinte.getDoencaDeficiencia().asString().equals("S") ? "S" : "N");
        registroTxt.fieldByName("IN_PREPREENCHIDA").set("0");
        registroTxt.fieldByName("NR_CONTA").set(declaracaoIRPF.getResumo().getCalculoImposto().getContaCredito().asString());
        registroTxt.fieldByName("NR_DV_CONTA").set(declaracaoIRPF.getResumo().getCalculoImposto().getDvContaCredito().asString());
        String string3 = declaracaoIRPF.getResumo().getCalculoImposto().getDebitoAutomatico().asString().equals("autorizado") ? "S" : "N";
        registroTxt.fieldByName("IN_DEBITO_AUTOM").set(string3);
        registroTxt.fieldByName("IN_DEBITO_PRIMEIRA_QUOTA").set(declaracaoIRPF.getResumo().getCalculoImposto().getIndicadorPrimeiraQuota().asString().equals("1") ? "1" : "0");
        registroTxt.fieldByName("IN_COMPLETA").set(declaracaoIRPF.getIdentificadorDeclaracao().isCompleta() ? "S" : "N");
        registroTxt.fieldByName("IN_GERADO").set(declaracaoIRPF.getIdentificadorDeclaracao().isDeclaracaoGerada() ? "S" : "N");
        registroTxt.fieldByName("IN_RETIFICADORA").set(declaracaoIRPF.getIdentificadorDeclaracao().isRetificadora() ? "S" : "N");
        if (declaracaoIRPF.getIdentificadorDeclaracao().isRetificadora()) {
            registroTxt.fieldByName("NR_CONTROLE_ORIGINAL").set(declaracaoIRPF.getIdentificadorDeclaracao().getNumReciboDecRetif().asString());
        }
        registroTxt.fieldByName("IN_ENDERECO").set(declaracaoIRPF.getContribuinte().getEnderecoDiferente().asString().equals(Logico.SIM) ? "S" : "N");
        registroTxt.fieldByName("NR_FONTE_PRINCIPAL").set(declaracaoIRPF.recuperarPrincipalFontePagadora().asString());
        String string4 = declaracaoIRPF.getContribuinte().getNumeroReciboDecAnterior().asString();
        if (string4.length() >= 10) {
            registroTxt.fieldByName("NR_RECIBO_ULTIMA_DEC_ANO_ANTERIOR").set(string4.substring(0, 10));
        } else if (string4.length() > 0) {
            registroTxt.fieldByName("NR_RECIBO_ULTIMA_DEC_ANO_ANTERIOR").set(string4.substring(0, 9));
        }
        registroTxt.fieldByName("IN_TIPODECLARACAO").set(declaracaoIRPF.getIdentificadorDeclaracao().isEspolio() ? "E" : (declaracaoIRPF.getIdentificadorDeclaracao().isSaida() ? "S" : "A"));
        vector.add(registroTxt);
        return vector;
    }

    public Vector montarRegistroDeclaracaoCompleta(DeclaracaoIRPF declaracaoIRPF) throws GeracaoTxtException {
        Vector<RegistroTxt> vector = new Vector<RegistroTxt>();
        RegistroTxt registroTxt = new RegistroTxt("ARQ_IRPF", "19");
        registroTxt.fieldByName("NR_REG").set("19");
        registroTxt.fieldByName("NR_CPF").set(declaracaoIRPF.getIdentificadorDeclaracao().getCpf().asString());
        registroTxt.fieldByName("NR_FONTE").set(declaracaoIRPF.getColecaoRendPJTitular().getNiMaiorFontePagadora().asString());
        registroTxt.fieldByName("VR_IMPEXT").set(declaracaoIRPF.getModeloCompleta().getImpostoPagoExterior());
        registroTxt.fieldByName("VR_IMPCOMP").set(declaracaoIRPF.getModeloCompleta().getImpostoComplementar());
        registroTxt.fieldByName("VR_IRFONTELEI11033").set(declaracaoIRPF.getModeloCompleta().getImpostoRetidoFonteLei11033());
        registroTxt.fieldByName("VR_RECEX_TIT").set(declaracaoIRPF.getRendPFTitular().getTotalExterior());
        registroTxt.fieldByName("VR_LIVCAIX_TIT").set(declaracaoIRPF.getRendPFTitular().getTotalLivroCaixa());
        registroTxt.fieldByName("VR_CARNELEAO_TIT").set(declaracaoIRPF.getRendPFTitular().getTotalDarfPago());
        registroTxt.fieldByName("VR_RECEX_DEP").set(declaracaoIRPF.getRendPFDependente().getTotalExterior());
        registroTxt.fieldByName("VR_LIVCAIX_DEP").set(declaracaoIRPF.getRendPFDependente().getTotalLivroCaixa());
        registroTxt.fieldByName("VR_CARNELEAO_DEP").set(declaracaoIRPF.getRendPFDependente().getTotalDarfPago());
        registroTxt.fieldByName("VR_PREVPRIV").set(CalculosPagamentos.totalizarPagamentosGlosado(declaracaoIRPF.getPagamentos(), new String[]{"36"}, true));
        registroTxt.fieldByName("VR_FAPI").set(CalculosPagamentos.totalizarPagamentosGlosado(declaracaoIRPF.getPagamentos(), new String[]{"38"}, true));
        registroTxt.fieldByName("VR_PREVOFTITULAR").set(declaracaoIRPF.getColecaoRendPJTitular().getTotaisContribuicaoPrevOficial());
        registroTxt.fieldByName("VR_PREVOFDEPENDENTE").set(declaracaoIRPF.getColecaoRendPJDependente().getTotaisContribuicaoPrevOficial());
        registroTxt.fieldByName("VR_TOTAL13SALARIOTITULAR").set(declaracaoIRPF.getRendTributacaoExclusiva().getDecimoTerceiro());
        registroTxt.fieldByName("VR_TOTAL13SALARIODEPENDENTE").set(declaracaoIRPF.getRendTributacaoExclusiva().getDecimoTerceiroDependentes());
        registroTxt.fieldByName("NR_DEPENDENTE_DESP_INSTRUCAO").set(declaracaoIRPF.getPagamentos().obterTotalDependentesEnvolvidos());
        registroTxt.fieldByName("NR_ALIMENTANDO_DESP_INSTRUCAO").set(declaracaoIRPF.getPagamentos().obterTotalAlimentandosEnvolvidos());
        RendPF rendPF = declaracaoIRPF.getRendPFTitular();
        registroTxt.fieldByName("VR_RENDEXTTIT").set(rendPF.getTotalExterior());
        registroTxt.fieldByName("VR_RENDPFTIT").set(rendPF.getTotalPessoaFisica());
        RendPFDependente rendPFDependente = declaracaoIRPF.getRendPFDependente();
        registroTxt.fieldByName("VR_RENDEXTDEPEN").set(rendPFDependente.getTotalExterior());
        registroTxt.fieldByName("VR_RENDPFDEPEN").set(rendPFDependente.getTotalPessoaFisica());
        registroTxt.fieldByName("VR_IMPDEVIDO_SEM_REND_EXT").set(declaracaoIRPF.getImpostoPago().getImpostoDevidoSemRendExterior());
        registroTxt.fieldByName("VR_LIMITE_IMP_PAGO_EXT").set(declaracaoIRPF.getImpostoPago().getLimiteLegalImpPagoExterior());
        registroTxt.fieldByName("VR_ATE_LIMITE_FUNPRESP").set(0);
        registroTxt.fieldByName("VR_ACIMA_LIMITE_FUNPRESP").set(0);
        vector.add(registroTxt);
        return vector;
    }

    public Vector montarFichaResumoCompleta(DeclaracaoIRPF declaracaoIRPF) throws GeracaoTxtException {
        Vector<RegistroTxt> vector = new Vector<RegistroTxt>();
        RegistroTxt registroTxt = new RegistroTxt("ARQ_IRPF", "20");
        registroTxt.fieldByName("NR_REG").set("20");
        registroTxt.fieldByName("NR_CPF").set(declaracaoIRPF.getIdentificadorDeclaracao().getCpf().asString());
        registroTxt.fieldByName("VR_RENDJUR").set(declaracaoIRPF.getModeloCompleta().getRendRecebidoPJTitular());
        registroTxt.fieldByName("VR_RENDJURDEPENDENTE").set(declaracaoIRPF.getModeloCompleta().getRendRecebidoPJDependentes());
        registroTxt.fieldByName("VR_RENDFISICEXT_TIT").set(declaracaoIRPF.getModeloCompleta().getRendRecebidoPFEXTTitular());
        registroTxt.fieldByName("VR_RENDFISICEXT_DEP").set(declaracaoIRPF.getModeloCompleta().getRendRecebidoPFEXTDependentes());
        registroTxt.fieldByName("VR_RESAR").set(declaracaoIRPF.getModeloCompleta().getResultadoTributavelAR());
        registroTxt.fieldByName("VR_TOTTRIB").set(declaracaoIRPF.getModeloCompleta().getTotalRendimentos());
        registroTxt.fieldByName("VR_PREVOF").set(declaracaoIRPF.getModeloCompleta().getPrevidenciaOficial());
        registroTxt.fieldByName("VR_TOTPRIVADA").set(declaracaoIRPF.getModeloCompleta().getPrevidenciaFAPI());
        registroTxt.fieldByName("VR_DEPEN").set(declaracaoIRPF.getModeloCompleta().getDeducaoDependentes());
        registroTxt.fieldByName("VR_DESPINST").set(declaracaoIRPF.getModeloCompleta().getDespesasInstrucao());
        registroTxt.fieldByName("VR_DESPMEDIC").set(declaracaoIRPF.getModeloCompleta().getDespesasMedicas());
        registroTxt.fieldByName("VR_PENSAO").set(declaracaoIRPF.getModeloCompleta().getPensaoAlimenticia());
        registroTxt.fieldByName("VR_PENSAO_CARTORIO").set(declaracaoIRPF.getModeloCompleta().getPensaoCartoral());
        registroTxt.fieldByName("VR_LIVCAIX").set(declaracaoIRPF.getModeloCompleta().getLivroCaixa());
        registroTxt.fieldByName("VR_DEDUC").set(declaracaoIRPF.getModeloCompleta().getTotalDeducoes());
        registroTxt.fieldByName("VR_BASECALC").set(declaracaoIRPF.getModeloCompleta().getBaseCalculo());
        registroTxt.fieldByName("VR_IMPOSTO").set(declaracaoIRPF.getModeloCompleta().getImposto());
        registroTxt.fieldByName("VR_DEDIMPOSTO").set(declaracaoIRPF.getModeloCompleta().getDeducaoIncentivo());
        registroTxt.fieldByName("VR_IMPDEV").set(declaracaoIRPF.getModeloCompleta().getImpostoDevido());
        registroTxt.fieldByName("VR_CONTPATRONAL").set(declaracaoIRPF.getResumo().getCalculoImposto().getTotalContribEmpregadoDomestico());
        registroTxt.fieldByName("VR_IMPDEV2").set(declaracaoIRPF.getModeloCompleta().getImpostoDevidoII());
        registroTxt.fieldByName("VR_IMPDEV3").set(declaracaoIRPF.getModeloCompleta().getImpostoDevidoII());
        registroTxt.fieldByName("VR_IMPFONTE").set(declaracaoIRPF.getModeloCompleta().getImpostoRetidoFonteTitular());
        registroTxt.fieldByName("VR_IMPFONTEDEPENDENTE").set(declaracaoIRPF.getModeloCompleta().getImpostoRetidoFonteDependentes());
        registroTxt.fieldByName("VR_CARNELEAO").set(declaracaoIRPF.getModeloCompleta().getCarneLeao());
        registroTxt.fieldByName("VR_IMPCOMPL").set(declaracaoIRPF.getModeloCompleta().getImpostoComplementar());
        registroTxt.fieldByName("VR_IMPEXT").set(declaracaoIRPF.getModeloCompleta().getImpostoPagoExterior());
        registroTxt.fieldByName("VR_IRFONTELEI11033").set(declaracaoIRPF.getModeloCompleta().getImpostoRetidoFonteLei11033());
        registroTxt.fieldByName("VR_TOTIMPPAGO").set(declaracaoIRPF.getModeloCompleta().getTotalImpostoPago());
        if (declaracaoIRPF.getModelo().getImpostoRestituir().comparacao(">", "0,00")) {
            registroTxt.fieldByName("VR_IMPREST").set(declaracaoIRPF.getModeloCompleta().getImpostoRestituir());
            registroTxt.fieldByName("VR_IMPPAGAR").set(0);
        } else if (declaracaoIRPF.getModelo().getSaldoImpostoPagar().comparacao(">", "0,00")) {
            registroTxt.fieldByName("VR_IMPPAGAR").set(declaracaoIRPF.getModeloCompleta().getSaldoImpostoPagar());
            registroTxt.fieldByName("VR_IMPREST").set(0);
        } else {
            registroTxt.fieldByName("VR_IMPREST").set(0);
            registroTxt.fieldByName("VR_IMPPAGAR").set(0);
        }
        registroTxt.fieldByName("NR_QUOTAS").set(declaracaoIRPF.getResumo().getCalculoImposto().getNumQuotas().asInteger());
        registroTxt.fieldByName("VR_QUOTA").set(declaracaoIRPF.getResumo().getCalculoImposto().getValorQuota());
        registroTxt.fieldByName("VR_BENSANT").set(declaracaoIRPF.getModeloCompleta().getBensDireitosExercicioAnterior());
        registroTxt.fieldByName("VR_BENSATUAL").set(declaracaoIRPF.getModeloCompleta().getBensDireitosExercicioAtual());
        registroTxt.fieldByName("VR_DIVIDAANT").set(declaracaoIRPF.getModeloCompleta().getDividasExercicioAnterior());
        registroTxt.fieldByName("VR_DIVIDAATUAL").set(declaracaoIRPF.getModeloCompleta().getDividasExercicioAtual());
        registroTxt.fieldByName("VR_TOTISENTOS").set(declaracaoIRPF.getModeloCompleta().getRendIsentosNaoTributaveis());
        registroTxt.fieldByName("VR_TOTEXCLUS").set(declaracaoIRPF.getModeloCompleta().getRendSujeitoTribExclusiva());
        registroTxt.fieldByName("VR_IMPGC").set(declaracaoIRPF.getGanhosDeCapital().getTotalImpostoPagoSobreGanhosCapital());
        registroTxt.fieldByName("VR_TOTIRFONTELEI11033").set(declaracaoIRPF.getModeloCompleta().getTotalImpostoRetidoNaFonte());
        registroTxt.fieldByName("VR_IMPRV").set(declaracaoIRPF.getModeloCompleta().getImpostoPagoSobreRendaVariavel());
        registroTxt.fieldByName("VR_IMPPAGOVCBENS").set(declaracaoIRPF.getMoedaEstrangeira().getTotalImpostoPagoSobreGanhosCapital());
        registroTxt.fieldByName("VR_IMPPAGOVCESPECIE").set(declaracaoIRPF.getResumo().getCalculoImposto().getImpostoEspecie());
        registroTxt.fieldByName("VR_TOTRENDISENTOSTITULAR").set(declaracaoIRPF.getRendIsentos().getTotalTitular());
        registroTxt.fieldByName("VR_TOTRENDISENTOSDEPENDENTE").set(declaracaoIRPF.getRendIsentos().getTotalDependentes());
        registroTxt.fieldByName("VR_TOTRENDEXCLTITULAR").set(declaracaoIRPF.getRendTributacaoExclusiva().recuperarExclusivosTitular());
        registroTxt.fieldByName("VR_TOTRENDEXCLDEPENDENTE").set(declaracaoIRPF.getRendTributacaoExclusiva().recuperarExclusivosDependentes());
        registroTxt.fieldByName("VR_DOACOESCAMPANHA").set(declaracaoIRPF.getResumo().getOutrasInformacoes().getTotalDoacoesCampanhasEleitorais());
        registroTxt.fieldByName("VR_TOTRENDPJ_EXIB_SUSPTITULAR").set(declaracaoIRPF.getColecaoRendPJComExigibilidadeTitular().getTotaisRendRecebidoPJ());
        registroTxt.fieldByName("VR_TOTRENDPJ_EXIB_SUSPDEPENDEN").set(declaracaoIRPF.getColecaoRendPJComExigibilidadeDependente().getTotaisRendRecebidoPJ());
        registroTxt.fieldByName("VR_TOTDEPJUDIC_TITULAR").set(declaracaoIRPF.getColecaoRendPJComExigibilidadeTitular().getTotaisDepositoJudicial());
        registroTxt.fieldByName("VR_TOTDEPJUDIC_DEPENDEN").set(declaracaoIRPF.getColecaoRendPJComExigibilidadeDependente().getTotaisDepositoJudicial());
        registroTxt.fieldByName("VR_TOTREND_AC_TIT").set(0);
        registroTxt.fieldByName("VR_TOT_PREVOFC_AC_TIT").set(0);
        registroTxt.fieldByName("VR_TOT_PENSALI_AC_TIT").set(0);
        registroTxt.fieldByName("VR_TOT_IRF_AC_TIT").set(0);
        registroTxt.fieldByName("VR_TOT_IMPOSTO_RRA_TIT").set(0);
        registroTxt.fieldByName("VR_TOTREND_AC_DEP").set(0);
        registroTxt.fieldByName("VR_TOT_PREVOFC_AC_DEP").set(0);
        registroTxt.fieldByName("VR_TOT_PENSALI_AC_DEP").set(0);
        registroTxt.fieldByName("VR_TOT_IRF_AC_DEP").set(0);
        registroTxt.fieldByName("VR_TOT_IMPOSTO_RRA_DEP").set(0);
        registroTxt.fieldByName("VR_IMPOSTO_DIFERIDO_GCAP").set(0);
        registroTxt.fieldByName("VR_IMPOSTO_DEVIDO_GCAP").set(0);
        registroTxt.fieldByName("VR_IMPOSTO_GANHOLIQ_RVAR").set(0);
        registroTxt.fieldByName("VR_IMPOSTO_DEVIDO_GCME").set(0);
        registroTxt.fieldByName("VR_ALIQUOTA_EFETIVA").set(declaracaoIRPF.getModeloCompleta().getAliquotaEfetiva());
        vector.add(registroTxt);
        return vector;
    }

    public Vector montarFichaRendPJ(DeclaracaoIRPF declaracaoIRPF) throws GeracaoTxtException {
        Vector<RegistroTxt> vector = new Vector<RegistroTxt>();
        ColecaoRendPJTitular colecaoRendPJTitular = declaracaoIRPF.getColecaoRendPJTitular();
        int n = 0;
        while (n < colecaoRendPJTitular.recuperarLista().size()) {
            RendPJTitular rendPJTitular = (RendPJTitular)colecaoRendPJTitular.recuperarLista().get(n);
            RegistroTxt registroTxt = new RegistroTxt("ARQ_IRPF", "21");
            registroTxt.fieldByName("NR_REG").set("21");
            registroTxt.fieldByName("NR_CPF").set(declaracaoIRPF.getIdentificadorDeclaracao().getCpf().asString());
            registroTxt.fieldByName("NR_PAGADOR").set(rendPJTitular.getNIFontePagadora().asString());
            registroTxt.fieldByName("NM_PAGADOR").setLimitado(rendPJTitular.getNomeFontePagadora().asString());
            registroTxt.fieldByName("VR_RENDTO").set(rendPJTitular.getRendRecebidoPJ());
            registroTxt.fieldByName("VR_IMPOSTO").set(rendPJTitular.getImpostoRetidoFonte());
            registroTxt.fieldByName("VR_CONTRIB").set(rendPJTitular.getContribuicaoPrevOficial());
            registroTxt.fieldByName("VR_DECTERC").set(rendPJTitular.getDecimoTerceiro());
            registroTxt.fieldByName("VR_IRRF13SALARIO").set(rendPJTitular.getIRRFDecimoTerceiro());
            vector.add(registroTxt);
            ++n;
        }
        return vector;
    }

    public Vector montarFichaHerdeiros(DeclaracaoIRPF declaracaoIRPF) {
        return new Vector();
    }

    public Vector montarFichaPercentualBem(DeclaracaoIRPF declaracaoIRPF) {
        return new Vector();
    }

    public Vector montarFichaRendPJComExigibilidade(DeclaracaoIRPF declaracaoIRPF) throws GeracaoTxtException {
        Vector<RegistroTxt> vector = new Vector<RegistroTxt>();
        ColecaoRendPJComExigibilidadeTitular colecaoRendPJComExigibilidadeTitular = declaracaoIRPF.getColecaoRendPJComExigibilidadeTitular();
        int n = 0;
        while (n < colecaoRendPJComExigibilidadeTitular.recuperarLista().size()) {
            RendPJComExigibilidadeTitular rendPJComExigibilidadeTitular = (RendPJComExigibilidadeTitular)colecaoRendPJComExigibilidadeTitular.recuperarLista().get(n);
            RegistroTxt registroTxt = new RegistroTxt("ARQ_IRPF", "80");
            registroTxt.fieldByName("NR_REG").set("80");
            registroTxt.fieldByName("NR_CPF").set(declaracaoIRPF.getIdentificadorDeclaracao().getCpf().asString());
            registroTxt.fieldByName("NR_PAGADOR").set(rendPJComExigibilidadeTitular.getNIFontePagadora().asString());
            registroTxt.fieldByName("NM_PAGADOR").setLimitado(rendPJComExigibilidadeTitular.getNomeFontePagadora().asString());
            registroTxt.fieldByName("VR_RENDTO").set(rendPJComExigibilidadeTitular.getRendExigSuspensa());
            registroTxt.fieldByName("VR_DEP_JUDICIAL").set(rendPJComExigibilidadeTitular.getDepositoJudicial());
            vector.add(registroTxt);
            ++n;
        }
        return vector;
    }

    public Vector montarFichaRendPF(DeclaracaoIRPF declaracaoIRPF, boolean bl) throws GeracaoTxtException {
        Vector<RegistroTxt> vector = new Vector<RegistroTxt>();
        RendPF rendPF = bl ? declaracaoIRPF.getRendPFDependente() : declaracaoIRPF.getRendPFTitular();
        if (!rendPF.isVazio()) {
            int n = 1;
            while (n <= 12) {
                MesRendPF mesRendPF = rendPF.getMesRendPFPorIndice(n - 1);
                RegistroTxt registroTxt = new RegistroTxt("ARQ_IRPF", "22");
                registroTxt.fieldByName("NR_REG").set("22");
                registroTxt.fieldByName("NR_CPF").set(declaracaoIRPF.getIdentificadorDeclaracao().getCpf().asString());
                registroTxt.fieldByName("E_DEPENDENTE").set(bl);
                if (bl) {
                    registroTxt.fieldByName("NR_CPF_DEPEN").set(declaracaoIRPF.recuperarMaiorDependente().asString());
                } else {
                    registroTxt.fieldByName("NR_CPF_DEPEN").set(declaracaoIRPF.getIdentificadorDeclaracao().getCpf().asString());
                }
                registroTxt.fieldByName("NR_MES").set(n);
                registroTxt.fieldByName("VR_RENDTO").set(mesRendPF.getPessoaFisica());
                registroTxt.fieldByName("VR_ALUGUEIS").set(mesRendPF.getAlugueis());
                registroTxt.fieldByName("VR_OUTROS").set(mesRendPF.getOutros());
                registroTxt.fieldByName("VR_EXTER").set(mesRendPF.getExterior());
                registroTxt.fieldByName("VR_LIVCAIX").set(mesRendPF.getLivroCaixa());
                registroTxt.fieldByName("VR_ALIMENT").set(mesRendPF.getPensao());
                registroTxt.fieldByName("VR_DEDUC").set(mesRendPF.getDependentes());
                registroTxt.fieldByName("VR_PREVID").set(mesRendPF.getPrevidencia());
                Valor valor = new Valor();
                valor.append('+', mesRendPF.getPessoaFisica());
                valor.append('+', mesRendPF.getExterior());
                valor.append('-', mesRendPF.getPrevidencia());
                valor.append('-', mesRendPF.getDependentes());
                valor.append('-', mesRendPF.getPensao());
                valor.append('-', mesRendPF.getLivroCaixa());
                registroTxt.fieldByName("VR_BASECALCULO").set(valor);
                registroTxt.fieldByName("VR_IMPOSTO").set(mesRendPF.getDarfPago());
                vector.add(registroTxt);
                ++n;
            }
        }
        return vector;
    }

    private void linhaRendIsentoTotal(DeclaracaoIRPF declaracaoIRPF, Vector vector, String string, Valor valor) throws GeracaoTxtException {
        if (!valor.comparacao(">", "0,00")) {
            return;
        }
        RegistroTxt registroTxt = new RegistroTxt("ARQ_IRPF", "23");
        registroTxt.fieldByName("NR_REG").set("23");
        registroTxt.fieldByName("NR_CPF").set(declaracaoIRPF.getIdentificadorDeclaracao().getCpf().asString());
        registroTxt.fieldByName("CD_ISENTO").set(string);
        registroTxt.fieldByName("VR_VALOR").set(valor);
        vector.add(registroTxt);
    }

    public Vector montarFichaRendIsentos(DeclaracaoIRPF declaracaoIRPF) throws GeracaoTxtException {
        Vector vector = new Vector();
        RendIsentos rendIsentos = declaracaoIRPF.getRendIsentos();
        if (!rendIsentos.getTotal().comparacao(">", "0,00")) {
            return vector;
        }
        this.linhaRendIsentoTotal(declaracaoIRPF, vector, "01", rendIsentos.getBolsaEstudos());
        this.linhaRendIsentoTotal(declaracaoIRPF, vector, "02", rendIsentos.getResidenciaPronatec());
        this.linhaRendIsentoTotal(declaracaoIRPF, vector, "03", rendIsentos.getCapitalApolices());
        this.linhaRendIsentoTotal(declaracaoIRPF, vector, "04", rendIsentos.getIndenizacoes());
        this.linhaRendIsentoTotal(declaracaoIRPF, vector, "05", rendIsentos.getBensPequenoValorInformado().operacao('+', rendIsentos.getBensPequenoValorTransportado()));
        this.linhaRendIsentoTotal(declaracaoIRPF, vector, "06", rendIsentos.getUnicoImovelInformado().operacao('+', rendIsentos.getUnicoImovelTransportado()));
        this.linhaRendIsentoTotal(declaracaoIRPF, vector, "07", rendIsentos.getOutrosBensImoveisInformado().operacao('+', rendIsentos.getOutrosBensImoveisTransportado()));
        this.linhaRendIsentoTotal(declaracaoIRPF, vector, "08", rendIsentos.getMoedaEstrangeiraEspecieInformado());
        this.linhaRendIsentoTotal(declaracaoIRPF, vector, "09", rendIsentos.getLucroRecebido());
        this.linhaRendIsentoTotal(declaracaoIRPF, vector, "10", rendIsentos.getParcIsentaAposentadoria());
        this.linhaRendIsentoTotal(declaracaoIRPF, vector, "11", rendIsentos.getPensao());
        this.linhaRendIsentoTotal(declaracaoIRPF, vector, "12", rendIsentos.getPoupanca());
        this.linhaRendIsentoTotal(declaracaoIRPF, vector, "13", rendIsentos.getRendSocio());
        this.linhaRendIsentoTotal(declaracaoIRPF, vector, "14", rendIsentos.getTransferencias());
        this.linhaRendIsentoTotal(declaracaoIRPF, vector, "15", rendIsentos.getParcIsentaAtivRural());
        this.linhaRendIsentoTotal(declaracaoIRPF, vector, "16", rendIsentos.getIRPFAntCompJud());
        this.linhaRendIsentoTotal(declaracaoIRPF, vector, "17", rendIsentos.getRendAssalMoedaEstrang());
        this.linhaRendIsentoTotal(declaracaoIRPF, vector, "18", rendIsentos.getIncorpReservasCapital());
        this.linhaRendIsentoTotal(declaracaoIRPF, vector, "19", rendIsentos.getMeacaoDissolucao());
        this.linhaRendIsentoTotal(declaracaoIRPF, vector, "20", rendIsentos.getGanhosLiqAcoes());
        this.linhaRendIsentoTotal(declaracaoIRPF, vector, "21", rendIsentos.getGanhosCapOuro());
        this.linhaRendIsentoTotal(declaracaoIRPF, vector, "22", rendIsentos.getRecuperacaoPrejuizosBolsaValores());
        this.linhaRendIsentoTotal(declaracaoIRPF, vector, "23", rendIsentos.getTransporteCargas());
        this.linhaRendIsentoTotal(declaracaoIRPF, vector, "24", rendIsentos.getTransportePassageiros());
        this.linhaRendIsentoTotal(declaracaoIRPF, vector, "25", rendIsentos.getRestitIRPFAnt());
        this.linhaRendIsentoTotal(declaracaoIRPF, vector, "26", rendIsentos.getOutros());
        return vector;
    }

    private void linhaRendIsentoDetalhe2(DeclaracaoIRPF declaracaoIRPF, Vector vector, String string, ColecaoItemQuadroOutrosRendimentos colecaoItemQuadroOutrosRendimentos) throws GeracaoTxtException {
        for (ItemQuadroOutrosRendimentos itemQuadroOutrosRendimentos : colecaoItemQuadroOutrosRendimentos.recuperarLista()) {
            RegistroTxt registroTxt = new RegistroTxt("ARQ_IRPF", "83");
            registroTxt.fieldByName("NR_REG").set("83");
            registroTxt.fieldByName("NR_CPF").set(declaracaoIRPF.getIdentificadorDeclaracao().getCpf().asString());
            registroTxt.fieldByName("IN_TIPO").set(itemQuadroOutrosRendimentos.isTitular() ? "T" : "D");
            registroTxt.fieldByName("NR_CPF_BENEFIC").set(itemQuadroOutrosRendimentos.getCpfBenefic().asString());
            registroTxt.fieldByName("NR_COD").set(string);
            registroTxt.fieldByName("VR_VALOR").set(itemQuadroOutrosRendimentos.getValor());
            vector.add(registroTxt);
        }
    }

    private void linhaRendIsentoDetalhe3(DeclaracaoIRPF declaracaoIRPF, Vector vector, String string, ColecaoItemQuadroOutrosRendimentos colecaoItemQuadroOutrosRendimentos) throws GeracaoTxtException {
        for (ItemQuadroOutrosRendimentos itemQuadroOutrosRendimentos : colecaoItemQuadroOutrosRendimentos.recuperarLista()) {
            RegistroTxt registroTxt = new RegistroTxt("ARQ_IRPF", "84");
            registroTxt.fieldByName("NR_REG").set("84");
            registroTxt.fieldByName("NR_CPF").set(declaracaoIRPF.getIdentificadorDeclaracao().getCpf().asString());
            registroTxt.fieldByName("IN_TIPO").set(itemQuadroOutrosRendimentos.isTitular() ? "T" : "D");
            registroTxt.fieldByName("NR_CPF_BENEFIC").set(itemQuadroOutrosRendimentos.getCpfBenefic().asString());
            registroTxt.fieldByName("NR_COD").set(string);
            registroTxt.fieldByName("NR_PAGADORA").set(itemQuadroOutrosRendimentos.getCnpjEmpresa().asString());
            registroTxt.fieldByName("NM_NOME").set(itemQuadroOutrosRendimentos.getNomeFonte().asString());
            registroTxt.fieldByName("VR_VALOR").set(itemQuadroOutrosRendimentos.getValor());
            vector.add(registroTxt);
        }
    }

    private void linhaRendIsentoDetalhe4(DeclaracaoIRPF declaracaoIRPF, Vector vector, String string, ColecaoItemQuadroOutrosRendimentos colecaoItemQuadroOutrosRendimentos) throws GeracaoTxtException {
        for (ItemQuadroOutrosRendimentos itemQuadroOutrosRendimentos : colecaoItemQuadroOutrosRendimentos.recuperarLista()) {
            RegistroTxt registroTxt = new RegistroTxt("ARQ_IRPF", "85");
            registroTxt.fieldByName("NR_REG").set("85");
            registroTxt.fieldByName("NR_CPF").set(declaracaoIRPF.getIdentificadorDeclaracao().getCpf().asString());
            registroTxt.fieldByName("IN_TIPO").set(itemQuadroOutrosRendimentos.isTitular() ? "T" : "D");
            registroTxt.fieldByName("NR_CPF_BENEFIC").set(itemQuadroOutrosRendimentos.getCpfBenefic().asString());
            registroTxt.fieldByName("NR_COD").set(string);
            registroTxt.fieldByName("NR_PAGADORA").set(itemQuadroOutrosRendimentos.getCnpjEmpresa().asString());
            registroTxt.fieldByName("NM_NOME").set(itemQuadroOutrosRendimentos.getNomeFonte().asString());
            registroTxt.fieldByName("VR_RECEB").set(itemQuadroOutrosRendimentos.getValor());
            registroTxt.fieldByName("VR_13SALARIO").set("0");
            registroTxt.fieldByName("VR_IRRF").set("0");
            registroTxt.fieldByName("VR_IRRF13SALARIO").set("0");
            registroTxt.fieldByName("VR_PREVIDENCIA").set("0");
            vector.add(registroTxt);
        }
    }

    private void linhaRendIsentoDetalhe5(DeclaracaoIRPF declaracaoIRPF, Vector vector, String string, ColecaoItemQuadroOutrosRendimentos colecaoItemQuadroOutrosRendimentos) throws GeracaoTxtException {
        for (ItemQuadroOutrosRendimentos itemQuadroOutrosRendimentos : colecaoItemQuadroOutrosRendimentos.recuperarLista()) {
            RegistroTxt registroTxt = new RegistroTxt("ARQ_IRPF", "86");
            registroTxt.fieldByName("NR_REG").set("86");
            registroTxt.fieldByName("NR_CPF").set(declaracaoIRPF.getIdentificadorDeclaracao().getCpf().asString());
            registroTxt.fieldByName("IN_TIPO").set(itemQuadroOutrosRendimentos.isTitular() ? "T" : "D");
            registroTxt.fieldByName("NR_CPF_BENEFIC").set(itemQuadroOutrosRendimentos.getCpfBenefic().asString());
            registroTxt.fieldByName("NR_COD").set(string);
            registroTxt.fieldByName("NR_PAGADORA").set(itemQuadroOutrosRendimentos.getCnpjEmpresa().asString());
            registroTxt.fieldByName("NM_NOME").set(itemQuadroOutrosRendimentos.getNomeFonte().asString());
            registroTxt.fieldByName("VR_VALOR").set(itemQuadroOutrosRendimentos.getValor());
            registroTxt.fieldByName("NM_DESCRICAO").set(itemQuadroOutrosRendimentos.getEspecificacao().asString());
            vector.add(registroTxt);
        }
    }

    private void linhaRendIsentoDetalhe6(DeclaracaoIRPF declaracaoIRPF, Vector vector, String string, Valor valor, Valor valor2) throws GeracaoTxtException {
        if (valor.comparacao(">", "0,00") || valor2.comparacao(">", "0,00")) {
            RegistroTxt registroTxt = new RegistroTxt("ARQ_IRPF", "87");
            registroTxt.fieldByName("NR_REG").set("87");
            registroTxt.fieldByName("NR_CPF").set(declaracaoIRPF.getIdentificadorDeclaracao().getCpf().asString());
            registroTxt.fieldByName("NR_COD").set(string);
            registroTxt.fieldByName("VR_VALOR").set(valor);
            registroTxt.fieldByName("VR_VALORGCAP").set(valor2);
            vector.add(registroTxt);
        }
    }

    public Vector montarFichaDetalheRendIsentos(DeclaracaoIRPF declaracaoIRPF) throws GeracaoTxtException {
        Vector vector = new Vector();
        RendIsentos rendIsentos = declaracaoIRPF.getRendIsentos();
        this.linhaRendIsentoDetalhe2(declaracaoIRPF, vector, "19", rendIsentos.getMeacaoDissolucaoQuadroAuxiliar());
        this.linhaRendIsentoDetalhe2(declaracaoIRPF, vector, "20", rendIsentos.getGanhosLiqAcoesQuadroAuxiliar());
        this.linhaRendIsentoDetalhe2(declaracaoIRPF, vector, "21", rendIsentos.getGanhosCapOuroQuadroAuxiliar());
        this.linhaRendIsentoDetalhe3(declaracaoIRPF, vector, "01", rendIsentos.getBolsaEstudosQuadroAuxiliar());
        this.linhaRendIsentoDetalhe3(declaracaoIRPF, vector, "02", rendIsentos.getResidenciaPronatecQuadroAuxiliar());
        this.linhaRendIsentoDetalhe3(declaracaoIRPF, vector, "04", rendIsentos.getIndenizacoesQuadroAuxiliar());
        this.linhaRendIsentoDetalhe3(declaracaoIRPF, vector, "09", rendIsentos.getLucroRecebidoQuadroAuxiliar());
        this.linhaRendIsentoDetalhe3(declaracaoIRPF, vector, "10", rendIsentos.getParcIsentaAposentadoriaQuadroAuxiliar());
        this.linhaRendIsentoDetalhe3(declaracaoIRPF, vector, "12", rendIsentos.getPoupancaQuadroAuxiliar());
        this.linhaRendIsentoDetalhe3(declaracaoIRPF, vector, "13", rendIsentos.getRendSocioQuadroAuxiliar());
        this.linhaRendIsentoDetalhe3(declaracaoIRPF, vector, "14", rendIsentos.getTransferenciasQuadroAuxiliar());
        this.linhaRendIsentoDetalhe3(declaracaoIRPF, vector, "16", rendIsentos.getIRPFAntCompJudQuadroAuxiliar());
        this.linhaRendIsentoDetalhe3(declaracaoIRPF, vector, "17", rendIsentos.getRendAssalMoedaEstrangQuadroAuxiliar());
        this.linhaRendIsentoDetalhe3(declaracaoIRPF, vector, "18", rendIsentos.getIncorpReservasCapitalQuadroAuxiliar());
        this.linhaRendIsentoDetalhe4(declaracaoIRPF, vector, "11", rendIsentos.getPensaoQuadroAuxiliar());
        this.linhaRendIsentoDetalhe5(declaracaoIRPF, vector, "26", rendIsentos.getOutrosQuadroAuxiliar());
        this.linhaRendIsentoDetalhe6(declaracaoIRPF, vector, "05", rendIsentos.getBensPequenoValorInformado(), rendIsentos.getBensPequenoValorTransportado());
        this.linhaRendIsentoDetalhe6(declaracaoIRPF, vector, "06", rendIsentos.getUnicoImovelInformado(), rendIsentos.getUnicoImovelTransportado());
        this.linhaRendIsentoDetalhe6(declaracaoIRPF, vector, "07", rendIsentos.getOutrosBensImoveisInformado(), rendIsentos.getOutrosBensImoveisTransportado());
        return vector;
    }

    private void linhaRendExclusivosTotal(DeclaracaoIRPF declaracaoIRPF, Vector vector, String string, Valor valor) throws GeracaoTxtException {
        if (!valor.comparacao(">", "0,00")) {
            return;
        }
        RegistroTxt registroTxt = new RegistroTxt("ARQ_IRPF", "24");
        registroTxt.fieldByName("NR_REG").set("24");
        registroTxt.fieldByName("NR_CPF").set(declaracaoIRPF.getIdentificadorDeclaracao().getCpf().asString());
        registroTxt.fieldByName("CD_EXCLUSIVO").set(string);
        registroTxt.fieldByName("VR_VALOR").set(valor);
        vector.add(registroTxt);
    }

    public Vector montarFichaRendTribExcl(DeclaracaoIRPF declaracaoIRPF) throws GeracaoTxtException {
        Vector vector = new Vector();
        RendTributacaoExclusiva rendTributacaoExclusiva = declaracaoIRPF.getRendTributacaoExclusiva();
        if (!rendTributacaoExclusiva.getTotal().comparacao(">", "0,00")) {
            return vector;
        }
        this.linhaRendExclusivosTotal(declaracaoIRPF, vector, "01", rendTributacaoExclusiva.getDecimoTerceiro());
        this.linhaRendExclusivosTotal(declaracaoIRPF, vector, "02", rendTributacaoExclusiva.getGanhosCapital());
        this.linhaRendExclusivosTotal(declaracaoIRPF, vector, "03", rendTributacaoExclusiva.getGanhosCapitalEstrangeira());
        this.linhaRendExclusivosTotal(declaracaoIRPF, vector, "04", rendTributacaoExclusiva.getGanhosCapitalEmEspecie());
        this.linhaRendExclusivosTotal(declaracaoIRPF, vector, "05", rendTributacaoExclusiva.getGanhosRendaVariavel());
        this.linhaRendExclusivosTotal(declaracaoIRPF, vector, "06", rendTributacaoExclusiva.getRendAplicacoes());
        this.linhaRendExclusivosTotal(declaracaoIRPF, vector, "07", rendTributacaoExclusiva.getRRA());
        this.linhaRendExclusivosTotal(declaracaoIRPF, vector, "08", rendTributacaoExclusiva.getDecimoTerceiroDependentes());
        this.linhaRendExclusivosTotal(declaracaoIRPF, vector, "09", rendTributacaoExclusiva.getRRADep());
        this.linhaRendExclusivosTotal(declaracaoIRPF, vector, "10", rendTributacaoExclusiva.getJurosCapitalProprio());
        this.linhaRendExclusivosTotal(declaracaoIRPF, vector, "11", rendTributacaoExclusiva.getRendPLR());
        this.linhaRendExclusivosTotal(declaracaoIRPF, vector, "12", rendTributacaoExclusiva.getOutros());
        return vector;
    }

    private void linhaRendExclusivosDetalhe2(DeclaracaoIRPF declaracaoIRPF, Vector vector, String string, ColecaoItemQuadroOutrosRendimentos colecaoItemQuadroOutrosRendimentos) throws GeracaoTxtException {
        for (ItemQuadroOutrosRendimentos itemQuadroOutrosRendimentos : colecaoItemQuadroOutrosRendimentos.recuperarLista()) {
            RegistroTxt registroTxt = new RegistroTxt("ARQ_IRPF", "88");
            registroTxt.fieldByName("NR_REG").set("88");
            registroTxt.fieldByName("NR_CPF").set(declaracaoIRPF.getIdentificadorDeclaracao().getCpf().asString());
            registroTxt.fieldByName("IN_TIPO").set(itemQuadroOutrosRendimentos.isTitular() ? "T" : "D");
            registroTxt.fieldByName("NR_CPF_BENEFIC").set(itemQuadroOutrosRendimentos.getCpfBenefic().asString());
            registroTxt.fieldByName("NR_COD").set(string);
            registroTxt.fieldByName("NR_PAGADORA").set(itemQuadroOutrosRendimentos.getCnpjEmpresa().asString());
            registroTxt.fieldByName("NM_NOME").set(itemQuadroOutrosRendimentos.getNomeFonte().asString());
            registroTxt.fieldByName("VR_VALOR").set(itemQuadroOutrosRendimentos.getValor());
            vector.add(registroTxt);
        }
    }

    private void linhaRendExclusivosDetalhe3(DeclaracaoIRPF declaracaoIRPF, Vector vector, String string, ColecaoItemQuadroOutrosRendimentos colecaoItemQuadroOutrosRendimentos) throws GeracaoTxtException {
        for (ItemQuadroOutrosRendimentos itemQuadroOutrosRendimentos : colecaoItemQuadroOutrosRendimentos.recuperarLista()) {
            RegistroTxt registroTxt = new RegistroTxt("ARQ_IRPF", "89");
            registroTxt.fieldByName("NR_REG").set("89");
            registroTxt.fieldByName("NR_CPF").set(declaracaoIRPF.getIdentificadorDeclaracao().getCpf().asString());
            registroTxt.fieldByName("IN_TIPO").set(itemQuadroOutrosRendimentos.isTitular() ? "T" : "D");
            registroTxt.fieldByName("NR_CPF_BENEFIC").set(itemQuadroOutrosRendimentos.getCpfBenefic().asString());
            registroTxt.fieldByName("NR_COD").set(string);
            registroTxt.fieldByName("NR_PAGADORA").set(itemQuadroOutrosRendimentos.getCnpjEmpresa().asString());
            registroTxt.fieldByName("NM_NOME").set(itemQuadroOutrosRendimentos.getNomeFonte().asString());
            registroTxt.fieldByName("VR_VALOR").set(itemQuadroOutrosRendimentos.getValor());
            registroTxt.fieldByName("NM_DESCRICAO").set(itemQuadroOutrosRendimentos.getEspecificacao().asString());
            vector.add(registroTxt);
        }
    }

    public Vector montarFichaDetalheRendExclusivos(DeclaracaoIRPF declaracaoIRPF) throws GeracaoTxtException {
        Vector vector = new Vector();
        RendTributacaoExclusiva rendTributacaoExclusiva = declaracaoIRPF.getRendTributacaoExclusiva();
        this.linhaRendExclusivosDetalhe2(declaracaoIRPF, vector, "0006", rendTributacaoExclusiva.getRendAplicacoesQuadroAuxiliar());
        this.linhaRendExclusivosDetalhe2(declaracaoIRPF, vector, "0010", rendTributacaoExclusiva.getJurosCapitalProprioQuadroAuxiliar());
        this.linhaRendExclusivosDetalhe2(declaracaoIRPF, vector, "0011", rendTributacaoExclusiva.getRendPLRQuadroAuxiliar());
        this.linhaRendExclusivosDetalhe3(declaracaoIRPF, vector, "12", rendTributacaoExclusiva.getOutrosQuadroAuxiliar());
        return vector;
    }

    public Vector montarFichaDependentes(DeclaracaoIRPF declaracaoIRPF) throws GeracaoTxtException {
        Vector<RegistroTxt> vector = new Vector<RegistroTxt>();
        Dependentes dependentes = declaracaoIRPF.getDependentes();
        int n = 0;
        while (n < dependentes.recuperarLista().size()) {
            Dependente dependente = (Dependente)dependentes.recuperarLista().get(n);
            RegistroTxt registroTxt = new RegistroTxt("ARQ_IRPF", "25");
            registroTxt.fieldByName("NR_REG").set("25");
            registroTxt.fieldByName("NR_CPF").set(declaracaoIRPF.getIdentificadorDeclaracao().getCpf().asString());
            try {
                registroTxt.fieldByName("CD_DEPEND").set(dependente.getCodigo().getConteudoAtual(0));
            }
            catch (Exception exception) {}
            registroTxt.fieldByName("NR_CHAVE").set(n + 1);
            registroTxt.fieldByName("NM_DEPEND").setLimitado(dependente.getNome().asString());
            registroTxt.fieldByName("DT_NASCIM").set(dependente.getDataNascimento().asString());
            registroTxt.fieldByName("NI_DEPEND").set(dependente.getCpfDependente().asString());
            registroTxt.fieldByName("NR_NITPISPASEP").set(dependente.getNitPisPasep().asString());
            vector.add(registroTxt);
            ++n;
        }
        return vector;
    }

    public Vector montarFichaPagamentos(DeclaracaoIRPF declaracaoIRPF) throws GeracaoTxtException {
        Vector<RegistroTxt> vector = new Vector<RegistroTxt>();
        Pagamentos pagamentos = declaracaoIRPF.getPagamentos();
        int n = 0;
        while (n < pagamentos.recuperarLista().size()) {
            Pagamento pagamento = (Pagamento)pagamentos.recuperarLista().get(n);
            RegistroTxt registroTxt = new RegistroTxt("ARQ_IRPF", "26");
            registroTxt.fieldByName("NR_REG").set("26");
            registroTxt.fieldByName("NR_CPF").set(declaracaoIRPF.getIdentificadorDeclaracao().getCpf().asString());
            registroTxt.fieldByName("CD_PAGTO").set(pagamento.getCodigo().asString());
            registroTxt.fieldByName("NR_BENEF").set(pagamento.getNiBeneficiario().asString());
            registroTxt.fieldByName("NR_CHAVE_DEPEND").set(declaracaoIRPF.getChaveDependenteOuAlimentando(pagamento));
            registroTxt.fieldByName("NM_BENEF").setLimitado(pagamento.getNomeBeneficiario().asString());
            registroTxt.fieldByName("NR_NIT").setLimitado(pagamento.getNitEmpregadoDomestico().asString());
            registroTxt.fieldByName("VR_PAGTO").set(pagamento.getValorPago());
            registroTxt.fieldByName("VR_REDUC").set(pagamento.getParcelaNaoDedutivel());
            registroTxt.fieldByName("IN_TIPO_PGTO").set(pagamento.getTipo().asString());
            if (pagamento.getNiBeneficiario().asString().length() == 14) {
                registroTxt.fieldByName("IN_TIPO_CPF_CNPJ").set("2");
            } else if (pagamento.getNiBeneficiario().asString().length() == 11) {
                registroTxt.fieldByName("IN_TIPO_CPF_CNPJ").set("1");
            } else {
                registroTxt.fieldByName("IN_TIPO_CPF_CNPJ").set("0");
            }
            vector.add(registroTxt);
            ++n;
        }
        return vector;
    }

    public Vector montarFichaDoacoesCampanha(DeclaracaoIRPF declaracaoIRPF) throws GeracaoTxtException {
        Vector<RegistroTxt> vector = new Vector<RegistroTxt>();
        Doacoes doacoes = declaracaoIRPF.getDoacoes();
        for (Doacao doacao : doacoes.recuperarLista()) {
            RegistroTxt registroTxt = new RegistroTxt("ARQ_IRPF", "34");
            registroTxt.fieldByName("NR_REG").set("34");
            registroTxt.fieldByName("NR_CPF").set(declaracaoIRPF.getIdentificadorDeclaracao().getCpf().asString());
            registroTxt.fieldByName("NR_PARTIDO").set(doacao.getCNPJ().asString());
            registroTxt.fieldByName("NM_PARTIDO").set(doacao.getNome().asString());
            registroTxt.fieldByName("VR_DOACAO").set(doacao.getValor());
            vector.add(registroTxt);
        }
        return vector;
    }

    public Vector montarFichaAlimentandos(DeclaracaoIRPF declaracaoIRPF) throws GeracaoTxtException {
        Vector<RegistroTxt> vector = new Vector<RegistroTxt>();
        Alimentandos alimentandos = declaracaoIRPF.getAlimentandos();
        int n = 0;
        while (n < alimentandos.recuperarLista().size()) {
            Alimentando alimentando = (Alimentando)alimentandos.recuperarLista().get(n);
            RegistroTxt registroTxt = new RegistroTxt("ARQ_IRPF", "35");
            registroTxt.fieldByName("NR_REG").set("35");
            registroTxt.fieldByName("NR_CPF").set(declaracaoIRPF.getIdentificadorDeclaracao().getCpf().asString());
            registroTxt.fieldByName("INDICADOR_RESIDENC").set(alimentando.getExterior().asString());
            registroTxt.fieldByName("NR_CHAVE").set(n + 1);
            registroTxt.fieldByName("NM_NOME").setLimitado(alimentando.getNome().asString());
            registroTxt.fieldByName("DT_NASCIM").set(alimentando.getDataNascimento().asString());
            registroTxt.fieldByName("NI_ALIMENTANDO").set(alimentando.getCpf().asString());
            vector.add(registroTxt);
            ++n;
        }
        return vector;
    }

    public Vector montarFichaFinalEspolio(DeclaracaoIRPF declaracaoIRPF) {
        return new Vector();
    }

    public Vector montarFichaSaida(DeclaracaoIRPF declaracaoIRPF) {
        return new Vector();
    }

    public Vector montarFichaBem(DeclaracaoIRPF declaracaoIRPF) throws GeracaoTxtException {
        Vector<RegistroTxt> vector = new Vector<RegistroTxt>();
        declaracaoIRPF.getBens().excluirRegistrosEmBranco();
        Bens bens = declaracaoIRPF.getBens();
        int n = 0;
        while (n < bens.recuperarLista().size()) {
            Bem bem = (Bem)bens.recuperarLista().get(n);
            RegistroTxt registroTxt = new RegistroTxt("ARQ_IRPF", "27");
            registroTxt.fieldByName("NR_REG").set("27");
            registroTxt.fieldByName("NR_CPF").set(declaracaoIRPF.getIdentificadorDeclaracao().getCpf().asString());
            registroTxt.fieldByName("TX_BEM").setLimitado(bem.getDiscriminacao().asString());
            registroTxt.fieldByName("CD_BEM").set(bem.getCodigo().asString());
            registroTxt.fieldByName("VR_ANTER").set(bem.getValorExercicioAnterior());
            registroTxt.fieldByName("VR_ATUAL").set(bem.getValorExercicioAtual());
            if (bem.getPais().getConteudoAtual(0).equals("105")) {
                registroTxt.fieldByName("CD_PAIS").set("105");
                registroTxt.fieldByName("IN_EXTERIOR").set(0);
            } else {
                registroTxt.fieldByName("CD_PAIS").set(bem.getPais().getConteudoAtual(0));
                registroTxt.fieldByName("IN_EXTERIOR").set(1);
            }
            registroTxt.fieldByName("NM_LOGRA").set(bem.getLogradouro().asString());
            registroTxt.fieldByName("NR_NUMERO").set(bem.getNumero().asString());
            registroTxt.fieldByName("NM_COMPLEM").set(bem.getComplemento().asString());
            registroTxt.fieldByName("NM_BAIRRO").set(bem.getBairro().asString());
            registroTxt.fieldByName("NR_CEP").set(bem.getCep().asString());
            registroTxt.fieldByName("SG_UF").set(bem.getUf().asString());
            registroTxt.fieldByName("CD_MUNICIP").set(bem.getMunicipio().asString());
            registroTxt.fieldByName("NM_MUNICIP").set(bem.getNomeMunicipio().asString());
            String string = bem.getRegistrado().asString();
            if (string.equals("")) {
                string = "2";
            }
            registroTxt.fieldByName("NM_IND_REG_IMOV").set(string);
            registroTxt.fieldByName("MATRIC_IMOV").set(bem.getMatricula().asString());
            registroTxt.fieldByName("AREA").set(bem.getAreaTotal());
            string = bem.getUnidade().asString();
            if (string.equals("")) {
                string = "2";
            }
            registroTxt.fieldByName("NM_UNID").set(string);
            registroTxt.fieldByName("NM_CARTORIO").set(bem.getNomeCartorio().asString());
            registroTxt.fieldByName("NR_CHAVE_BEM").set(n + 1);
            registroTxt.fieldByName("DT_AQUISICAO").set(bem.getDataAquisicao().asString());
            registroTxt.fieldByName("NR_IPTU").set(bem.getIPTU().asString());
            registroTxt.fieldByName("NR_NIRF").set(bem.getNIRF().asString());
            registroTxt.fieldByName("NR_RENAVAN").set(bem.getRenavan().asString());
            registroTxt.fieldByName("NR_DEP_AVIACAO_CIVIL").set(bem.getRegAviaCivil().asString());
            registroTxt.fieldByName("NR_CAPITANIA_PORTOS").set(bem.getRegCapPortos().asString());
            registroTxt.fieldByName("NR_AGENCIA").set(bem.getAgencia().asString());
            registroTxt.fieldByName("NR_CONTA").set(bem.getConta().asString());
            registroTxt.fieldByName("NR_DV_CONTA").set(bem.getContaDV().asString());
            registroTxt.fieldByName("NM_CPFCNPJ").set(bem.getCPFCNPJ().asString());
            vector.add(registroTxt);
            ++n;
        }
        return vector;
    }

    public Vector montarFichaDividas(DeclaracaoIRPF declaracaoIRPF) throws GeracaoTxtException {
        Vector<RegistroTxt> vector = new Vector<RegistroTxt>();
        Dividas dividas = declaracaoIRPF.getDividas();
        int n = 0;
        while (n < dividas.recuperarLista().size()) {
            Divida divida = (Divida)dividas.recuperarLista().get(n);
            RegistroTxt registroTxt = new RegistroTxt("ARQ_IRPF", "28");
            registroTxt.fieldByName("NR_REG").set("28");
            registroTxt.fieldByName("NR_CPF").set(declaracaoIRPF.getIdentificadorDeclaracao().getCpf().asString());
            registroTxt.fieldByName("TX_DIV").setLimitado(divida.getDiscriminacao().asString());
            registroTxt.fieldByName("CD_DIV").set(divida.getCodigo().asString());
            registroTxt.fieldByName("VR_ANTER").set(divida.getValorExercicioAnterior());
            registroTxt.fieldByName("VR_ATUAL").set(divida.getValorExercicioAtual());
            registroTxt.fieldByName("VR_PGTO_ANUAL").set(divida.getPagamentoAnual());
            vector.add(registroTxt);
            ++n;
        }
        return vector;
    }

    public Vector montarFichaInventariante(DeclaracaoIRPF declaracaoIRPF) throws GeracaoTxtException {
        Vector<RegistroTxt> vector = new Vector<RegistroTxt>();
        Espolio espolio = declaracaoIRPF.getEspolio();
        if (!(espolio.getNomeInventariante().asString().equals("") || espolio.getEndInventariante().asString().equals("") || espolio.getCpfInventariante().asString().equals(""))) {
            RegistroTxt registroTxt = new RegistroTxt("ARQ_IRPF", "30");
            registroTxt.fieldByName("NR_REG").set("30");
            registroTxt.fieldByName("NR_CPF").set(declaracaoIRPF.getIdentificadorDeclaracao().getCpf().asString());
            registroTxt.fieldByName("NR_INVENT").set(espolio.getCpfInventariante().asString());
            registroTxt.fieldByName("NM_INVENT").setLimitado(espolio.getNomeInventariante().asString());
            registroTxt.fieldByName("NM_END_INVENT").setLimitado(espolio.getEndInventariante().asString());
            vector.add(registroTxt);
        }
        return vector;
    }

    public Vector montarFichaRendPJDependente(DeclaracaoIRPF declaracaoIRPF) throws GeracaoTxtException {
        Vector<RegistroTxt> vector = new Vector<RegistroTxt>();
        ColecaoRendPJDependente colecaoRendPJDependente = declaracaoIRPF.getColecaoRendPJDependente();
        int n = 0;
        while (n < colecaoRendPJDependente.recuperarLista().size()) {
            RendPJDependente rendPJDependente = (RendPJDependente)colecaoRendPJDependente.recuperarLista().get(n);
            RegistroTxt registroTxt = new RegistroTxt("ARQ_IRPF", "32");
            registroTxt.fieldByName("NR_REG").set("32");
            registroTxt.fieldByName("NR_CPF").set(declaracaoIRPF.getIdentificadorDeclaracao().getCpf().asString());
            registroTxt.fieldByName("CPF_BENEF").set(rendPJDependente.getCpfDependente().asString());
            registroTxt.fieldByName("NR_PAGADOR").set(rendPJDependente.getNIFontePagadora().asString());
            registroTxt.fieldByName("NM_PAGADOR").setLimitado(rendPJDependente.getNomeFontePagadora().asString());
            registroTxt.fieldByName("VR_RENDTO").set(rendPJDependente.getRendRecebidoPJ());
            registroTxt.fieldByName("VR_CONTRIB").set(rendPJDependente.getContribuicaoPrevOficial());
            registroTxt.fieldByName("VR_DECTERC").set(rendPJDependente.getDecimoTerceiro());
            registroTxt.fieldByName("VR_IMPOSTO").set(rendPJDependente.getImpostoRetidoFonte());
            registroTxt.fieldByName("VR_IRRF13SALARIO").set(rendPJDependente.getIRRFDecimoTerceiro());
            vector.add(registroTxt);
            ++n;
        }
        return vector;
    }

    public Vector montarFichaRendPJComExigibilidadeDependente(DeclaracaoIRPF declaracaoIRPF) throws GeracaoTxtException {
        Vector<RegistroTxt> vector = new Vector<RegistroTxt>();
        ColecaoRendPJComExigibilidadeDependente colecaoRendPJComExigibilidadeDependente = declaracaoIRPF.getColecaoRendPJComExigibilidadeDependente();
        int n = 0;
        while (n < colecaoRendPJComExigibilidadeDependente.recuperarLista().size()) {
            RendPJComExigibilidadeDependente rendPJComExigibilidadeDependente = (RendPJComExigibilidadeDependente)colecaoRendPJComExigibilidadeDependente.recuperarLista().get(n);
            RegistroTxt registroTxt = new RegistroTxt("ARQ_IRPF", "81");
            registroTxt.fieldByName("NR_REG").set("81");
            registroTxt.fieldByName("NR_CPF").set(declaracaoIRPF.getIdentificadorDeclaracao().getCpf().asString());
            registroTxt.fieldByName("CPF_BENEF").set(rendPJComExigibilidadeDependente.getCpfDependente().asString());
            registroTxt.fieldByName("NR_PAGADOR").set(rendPJComExigibilidadeDependente.getNIFontePagadora().asString());
            registroTxt.fieldByName("NM_PAGADOR").setLimitado(rendPJComExigibilidadeDependente.getNomeFontePagadora().asString());
            registroTxt.fieldByName("VR_RENDTO").set(rendPJComExigibilidadeDependente.getRendExigSuspensa());
            registroTxt.fieldByName("VR_DEP_JUDICIAL").set(rendPJComExigibilidadeDependente.getDepositoJudicial());
            vector.add(registroTxt);
            ++n;
        }
        return vector;
    }

    public Vector montarFichaSimplificada(DeclaracaoIRPF declaracaoIRPF) throws GeracaoTxtException {
        Vector<RegistroTxt> vector = new Vector<RegistroTxt>();
        RegistroTxt registroTxt = new RegistroTxt("ARQ_IRPF", "17");
        registroTxt.fieldByName("NR_REG").set("17");
        registroTxt.fieldByName("NR_CPF").set(declaracaoIRPF.getIdentificadorDeclaracao().getCpf().asString());
        registroTxt.fieldByName("VR_IMPCOMP").set(declaracaoIRPF.getModeloSimplificada().getImpostoComplementar());
        registroTxt.fieldByName("VR_LUCROSTIT").set(declaracaoIRPF.getRendIsentos().recuperarTotalLucrosDividendosTit());
        registroTxt.fieldByName("VR_ISENTOS").set(declaracaoIRPF.getRendIsentos().recuperarTotalTitularExcetoAtividadeRuraleGC());
        registroTxt.fieldByName("VR_EXCLUSIVOS").set(declaracaoIRPF.getRendTributacaoExclusiva().recuperarTotalTitularExceto13_RV_e_GC());
        registroTxt.fieldByName("VR_TOTAL13").set(declaracaoIRPF.getRendTributacaoExclusiva().getDecimoTerceiro());
        registroTxt.fieldByName("VR_TOTAL13DEPEND").set(declaracaoIRPF.getRendTributacaoExclusiva().getDecimoTerceiroDependentes());
        registroTxt.fieldByName("VR_LUCROSDEPEND").set(declaracaoIRPF.getRendIsentos().recuperarTotalLucrosDividendosDep());
        registroTxt.fieldByName("VR_ISENTOSDEPEND").set(declaracaoIRPF.getRendIsentos().getTotalDependentes().operacao('-', declaracaoIRPF.getRendIsentos().recuperarTotalLucrosDividendosDep()));
        registroTxt.fieldByName("VR_EXCLUSIVOSDEPEND").set(declaracaoIRPF.getRendTributacaoExclusiva().recuperarExclusivosDependentes());
        RendPF rendPF = declaracaoIRPF.getRendPFTitular();
        registroTxt.fieldByName("VR_RENDEXTTIT").set(rendPF.getTotalExterior());
        registroTxt.fieldByName("VR_RENDPFTIT").set(rendPF.getTotalPessoaFisica());
        RendPFDependente rendPFDependente = declaracaoIRPF.getRendPFDependente();
        registroTxt.fieldByName("VR_RENDEXTDEPEN").set(rendPFDependente.getTotalExterior());
        registroTxt.fieldByName("VR_RENDPFDEPEN").set(rendPFDependente.getTotalPessoaFisica());
        registroTxt.fieldByName("VR_CARNELEAOTIT").set(rendPF.getTotalDarfPago());
        registroTxt.fieldByName("VR_CARNELEAODEPEND").set(rendPFDependente.getTotalDarfPago());
        registroTxt.fieldByName("VR_DEPEN").set(declaracaoIRPF.getDependentes().getTotalDeducaoDependentes());
        registroTxt.fieldByName("VR_TOT_PREVOFC_AC_TIT").set(0);
        registroTxt.fieldByName("VR_TOT_PREVOFC_AC_DEP").set(0);
        registroTxt.fieldByName("VR_TOT_PENSALI_AC_TIT").set(0);
        registroTxt.fieldByName("VR_TOT_PENSALI_AC_DEP").set(0);
        vector.add(registroTxt);
        return vector;
    }

    public Vector montarFichaResumoSimplificada(DeclaracaoIRPF declaracaoIRPF) throws GeracaoTxtException {
        Vector<RegistroTxt> vector = new Vector<RegistroTxt>();
        RegistroTxt registroTxt = new RegistroTxt("ARQ_IRPF", "18");
        registroTxt.fieldByName("NR_REG").set("18");
        registroTxt.fieldByName("NR_CPF").set(declaracaoIRPF.getIdentificadorDeclaracao().getCpf().asString());
        registroTxt.fieldByName("VR_RENDTRIB").set(declaracaoIRPF.getModeloSimplificada().getTotalResultadosTributaveis());
        registroTxt.fieldByName("VR_DESCSIMP").set(declaracaoIRPF.getModeloSimplificada().getDescontoSimplificado());
        registroTxt.fieldByName("VR_BASECALC").set(declaracaoIRPF.getModeloSimplificada().getBaseCalculo());
        registroTxt.fieldByName("VR_IMPDEVIDO").set(declaracaoIRPF.getModeloSimplificada().getImpostoDevido());
        Valor valor = new Valor();
        valor.append('+', declaracaoIRPF.getModeloSimplificada().getImpostoRetidoFonteTitular());
        valor.append('+', declaracaoIRPF.getModeloSimplificada().getImpostoRetidoFonteDependentes());
        registroTxt.fieldByName("VR_IMPOSTO").set(valor);
        registroTxt.fieldByName("VR_IMPCOMP").set(declaracaoIRPF.getResumo().getCalculoImposto().getImpostoComplementar());
        registroTxt.fieldByName("VR_LEAO").set(declaracaoIRPF.getModeloSimplificada().getCarneLeao());
        registroTxt.fieldByName("VR_IRFONTELEI11033").set(declaracaoIRPF.getModeloSimplificada().getImpostoRetidoFonteLei11033());
        registroTxt.fieldByName("VR_RENDTRIBDEPENDENTE").set(declaracaoIRPF.getColecaoRendPJDependente().getTotaisRendRecebidoPJ());
        registroTxt.fieldByName("VR_IMPOSTODEPENDENTE").set(declaracaoIRPF.getModeloSimplificada().getImpostoRetidoFonteDependentes());
        registroTxt.fieldByName("VR_IMPPAGARESPECIE").set(declaracaoIRPF.getResumo().getCalculoImposto().getImpostoEspecie());
        if (declaracaoIRPF.getModeloSimplificada().getImpostoRestituir().comparacao(">", "0,00")) {
            registroTxt.fieldByName("VR_IMPRESTIT").set(declaracaoIRPF.getModeloSimplificada().getImpostoRestituir());
            registroTxt.fieldByName("VR_IMPPAGAR").set(ConstantesGlobais.ZERO);
        } else if (declaracaoIRPF.getModeloSimplificada().getSaldoImpostoPagar().comparacao(">", "0,00")) {
            registroTxt.fieldByName("VR_IMPRESTIT").set(ConstantesGlobais.ZERO);
            registroTxt.fieldByName("VR_IMPPAGAR").set(declaracaoIRPF.getModeloSimplificada().getSaldoImpostoPagar());
        } else {
            registroTxt.fieldByName("VR_IMPPAGAR").set(ConstantesGlobais.ZERO);
            registroTxt.fieldByName("VR_IMPRESTIT").set(ConstantesGlobais.ZERO);
        }
        registroTxt.fieldByName("NR_QUOTAS").set(declaracaoIRPF.getResumo().getCalculoImposto().getNumQuotas().asInteger());
        registroTxt.fieldByName("VR_QUOTA").set(declaracaoIRPF.getResumo().getCalculoImposto().getValorQuota());
        registroTxt.fieldByName("VR_TOTISENTO").set(declaracaoIRPF.getModeloSimplificada().getRendIsentosNaoTributaveis());
        registroTxt.fieldByName("VR_TOTEXCLUSIVO").set(declaracaoIRPF.getModeloSimplificada().getRendSujeitoTribExclusiva());
        registroTxt.fieldByName("VR_TOTRENDTRIBPJTITULAR").set(declaracaoIRPF.getModeloSimplificada().getRendRecebidoPJTitular());
        registroTxt.fieldByName("VR_RENDTRIBARURAL").set(declaracaoIRPF.getModeloSimplificada().getResultadoTributavelAR());
        registroTxt.fieldByName("VR_TOTFONTETITULAR").set(declaracaoIRPF.getModeloSimplificada().getImpostoRetidoFonteTitular());
        registroTxt.fieldByName("VR_TOTBENSANOBASEANTERIOR").set(declaracaoIRPF.getModeloSimplificada().getBensDireitosExercicioAnterior());
        registroTxt.fieldByName("VR_TOTBENSANOBASE").set(declaracaoIRPF.getModeloSimplificada().getBensDireitosExercicioAtual());
        registroTxt.fieldByName("VR_TOTDIVIDAANOBASEANTERIOR").set(declaracaoIRPF.getModeloSimplificada().getDividasExercicioAnterior());
        registroTxt.fieldByName("VR_TOTDIVIDAANOBASE").set(declaracaoIRPF.getModeloSimplificada().getDividasExercicioAtual());
        registroTxt.fieldByName("VR_TOTIRFONTELEI11033").set(declaracaoIRPF.getModeloSimplificada().calculaImpostoLei11033ComRendaVariavel());
        registroTxt.fieldByName("VR_RENDISENTOTITULAR").set(declaracaoIRPF.getRendIsentos().getTotalTitular());
        registroTxt.fieldByName("VR_RENDISENTODEPENDENTES").set(declaracaoIRPF.getRendIsentos().getTotalDependentes());
        registroTxt.fieldByName("VR_TOTRENDEXCLUSTITULAR").set(declaracaoIRPF.getRendTributacaoExclusiva().recuperarExclusivosTitular());
        registroTxt.fieldByName("VR_RENDEXCLUSDEPENDENTES").set(declaracaoIRPF.getRendTributacaoExclusiva().recuperarExclusivosDependentes());
        registroTxt.fieldByName("VR_RESNAOTRIB_AR").set(declaracaoIRPF.getRendIsentos().getParcIsentaAtivRural());
        registroTxt.fieldByName("VR_SUBTOTALISENTOTRANSPORTE").set(declaracaoIRPF.getRendIsentos().recuperarSubTotalRendIsentoTransportado());
        registroTxt.fieldByName("VR_SUBTOTALEXCLUSIVOTRANSPORTE").set(declaracaoIRPF.recuperarSubTotalExclusivoTransporteRendTribExclusiva());
        registroTxt.fieldByName("VR_GANHOLIQUIDORVTRANSPORTE").set(declaracaoIRPF.recuperarRendaVariavelTribtExclusiva());
        registroTxt.fieldByName("VR_RENDISENTOGCTRANSPORTE").set(declaracaoIRPF.getRendIsentos().getLucroAlienacao());
        registroTxt.fieldByName("VR_RENDPFEXT").set(declaracaoIRPF.getModeloSimplificada().getRendRecebidoPFEXTTitular());
        registroTxt.fieldByName("VR_RENDPFEXTDEPEN").set(declaracaoIRPF.getModeloSimplificada().getRendRecebidoPFEXTDependentes());
        registroTxt.fieldByName("VR_DOACOESCAMPANHA").set(declaracaoIRPF.getResumo().getOutrasInformacoes().getTotalDoacoesCampanhasEleitorais());
        registroTxt.fieldByName("VR_TOTRENDPJ_EXIB_SUSPTITULAR").set(declaracaoIRPF.getColecaoRendPJComExigibilidadeTitular().getTotaisRendRecebidoPJ());
        registroTxt.fieldByName("VR_TOTRENDPJ_EXIB_SUSPDEPEN").set(declaracaoIRPF.getColecaoRendPJComExigibilidadeDependente().getTotaisRendRecebidoPJ());
        registroTxt.fieldByName("VR_TOTDEPJUDIC_TITULAR").set(declaracaoIRPF.getColecaoRendPJComExigibilidadeTitular().getTotaisDepositoJudicial());
        registroTxt.fieldByName("VR_TOTDEPJUDIC_DEPENDEN").set(declaracaoIRPF.getColecaoRendPJComExigibilidadeDependente().getTotaisDepositoJudicial());
        registroTxt.fieldByName("VR_TOTREND_AC_TIT").set(0);
        registroTxt.fieldByName("VR_TOT_IRF_AC_TIT").set(0);
        registroTxt.fieldByName("VR_TOT_IMPOSTO_RRA_TIT").set(0);
        registroTxt.fieldByName("VR_TOTREND_AC_DEP").set(0);
        registroTxt.fieldByName("VR_TOT_IRF_AC_DEP").set(0);
        registroTxt.fieldByName("VR_TOT_IMPOSTO_RRA_DEP").set(0);
        registroTxt.fieldByName("VR_TOT_IMPOSTO_DEVIDO").set(declaracaoIRPF.getModeloSimplificada().getImpostoDevido());
        registroTxt.fieldByName("VR_IMPOSTO_DIFERIDO_GCAP").set(0);
        registroTxt.fieldByName("VR_IMPOSTO_DEVIDO_GCAP").set(0);
        registroTxt.fieldByName("VR_IMPOSTO_GANHOLIQ_RVAR").set(0);
        registroTxt.fieldByName("VR_IMPOSTO_DEVIDO_GCME").set(0);
        registroTxt.fieldByName("VR_IMPEXT").set(declaracaoIRPF.getImpostoPago().getImpostoPagoExterior());
        registroTxt.fieldByName("VR_ALIQUOTA_EFETIVA").set(declaracaoIRPF.getModeloSimplificada().getAliquotaEfetiva());
        vector.add(registroTxt);
        return vector;
    }

    public Vector montarRecibo(DeclaracaoIRPF declaracaoIRPF) throws GeracaoTxtException {
        Vector<RegistroTxt> vector = new Vector<RegistroTxt>();
        RegistroTxt registroTxt = new RegistroTxt("ARQ_IRPF", "HR");
        registroTxt.fieldByName("NR_REG").set("HR");
        registroTxt.fieldByName("NR_CPF").set(declaracaoIRPF.getIdentificadorDeclaracao().getCpf().asString());
        vector.add(registroTxt);
        Contribuinte contribuinte = declaracaoIRPF.getContribuinte();
        registroTxt = new RegistroTxt("ARQ_IRPF", "DR");
        registroTxt.fieldByName("NR_REG").set("DR");
        registroTxt.fieldByName("NR_CPF").set(declaracaoIRPF.getIdentificadorDeclaracao().getCpf().asString());
        registroTxt.fieldByName("IN_COMPLETA").set(declaracaoIRPF.getIdentificadorDeclaracao().isCompleta());
        registroTxt.fieldByName("NM_NOME").setLimitado(declaracaoIRPF.getIdentificadorDeclaracao().getNome().asString());
        if (contribuinte.getExterior().asString().equals(Logico.SIM)) {
            registroTxt.fieldByName("NM_LOGRA").setLimitado(contribuinte.getLogradouroExt().asString());
            registroTxt.fieldByName("NR_NUMERO").setLimitado(contribuinte.getNumeroExt().asString());
            registroTxt.fieldByName("NM_COMPLEM").setLimitado(contribuinte.getComplementoExt().asString());
            registroTxt.fieldByName("NM_BAIRRO").setLimitado(contribuinte.getBairroExt().asString());
            registroTxt.fieldByName("NR_CEP").set(contribuinte.getCepExt().asString());
            registroTxt.fieldByName("CD_MUNICIP").set("9701");
            registroTxt.fieldByName("NM_MUNICIP").set(contribuinte.getCidade().getConteudoFormatado());
            registroTxt.fieldByName("SG_UF").set("EX");
        } else {
            registroTxt.fieldByName("NR_NUMERO").setLimitado(contribuinte.getNumero().asString());
            registroTxt.fieldByName("NM_COMPLEM").setLimitado(contribuinte.getComplemento().asString());
            registroTxt.fieldByName("NM_BAIRRO").setLimitado(contribuinte.getBairro().asString());
            registroTxt.fieldByName("NR_CEP").set(contribuinte.getCep().asString());
            registroTxt.fieldByName("TIP_LOGRA").setLimitado(contribuinte.getTipoLogradouro().asString());
            registroTxt.fieldByName("NM_LOGRA").setLimitado(contribuinte.getLogradouro().asString());
            registroTxt.fieldByName("CD_MUNICIP").set(contribuinte.getMunicipio().getConteudoAtual(0));
            registroTxt.fieldByName("NM_MUNICIP").set(contribuinte.getMunicipio().getConteudoAtual(1));
            registroTxt.fieldByName("SG_UF").set(contribuinte.getUf().getConteudoAtual(0));
        }
        registroTxt.fieldByName("NR_DDD_TELEFONE").set(contribuinte.getDdd().asString());
        registroTxt.fieldByName("NR_TELEFONE").set(contribuinte.getTelefone().asString());
        registroTxt.fieldByName("IN_RETIFICADORA").set(declaracaoIRPF.getIdentificadorDeclaracao().isRetificadora() ? "S" : "N");
        registroTxt.fieldByName("VR_TOTTRIB").set(declaracaoIRPF.getModelo().recuperarTotalRendimentosTributaveis());
        if (declaracaoIRPF.getIdentificadorDeclaracao().isCompleta()) {
            registroTxt.fieldByName("VR_IMPDEV").set(declaracaoIRPF.getModelo().getImpostoDevidoII());
        } else {
            registroTxt.fieldByName("VR_IMPDEV").set(declaracaoIRPF.getModelo().getImpostoDevido());
        }
        if (declaracaoIRPF.getModelo().getSaldoImpostoPagar().comparacao(">", "0,00")) {
            registroTxt.fieldByName("VR_IMPPAGAR").set(declaracaoIRPF.getModelo().getSaldoImpostoPagar());
            registroTxt.fieldByName("VR_IMPREST").set(0);
        } else if (declaracaoIRPF.getModelo().getImpostoRestituir().comparacao(">", "0,00")) {
            registroTxt.fieldByName("VR_IMPPAGAR").set(0);
            registroTxt.fieldByName("VR_IMPREST").set(declaracaoIRPF.getModelo().getImpostoRestituir());
        }
        registroTxt.fieldByName("NR_QUOTAS").set(declaracaoIRPF.getResumo().getCalculoImposto().getNumQuotas().asInteger());
        registroTxt.fieldByName("VR_QUOTA").set(declaracaoIRPF.getResumo().getCalculoImposto().getValorQuota());
        registroTxt.fieldByName("NR_BANCO").set(declaracaoIRPF.getResumo().getCalculoImposto().getBanco().getConteudoAtual(0));
        registroTxt.fieldByName("NR_AGENCIA").set(declaracaoIRPF.getResumo().getCalculoImposto().getAgencia().getConteudoFormatado());
        registroTxt.fieldByName("IN_DEBITO_PRIMEIRA_QUOTA").set(declaracaoIRPF.getResumo().getCalculoImposto().getIndicadorPrimeiraQuota().getConteudoFormatado());
        registroTxt.fieldByName("VR_GCIMPOSTOPAGO").set(declaracaoIRPF.getGanhosDeCapital().getTotalImpostoPagoSobreGanhosCapital());
        registroTxt.fieldByName("NR_CONTA").set(declaracaoIRPF.getResumo().getCalculoImposto().getContaCredito().getConteudoFormatado());
        registroTxt.fieldByName("NR_DV_CONTA").set(declaracaoIRPF.getResumo().getCalculoImposto().getDvContaCredito().getConteudoFormatado());
        registroTxt.fieldByName("VR_VCMOEDAEST").set(declaracaoIRPF.getResumo().getCalculoImposto().getImpostoEspecie());
        vector.add(registroTxt);
        registroTxt = new RegistroTxt("ARQ_IRPF", "R9");
        registroTxt.fieldByName("NR_REG").set("R9");
        registroTxt.fieldByName("NR_CPF").set(declaracaoIRPF.getIdentificadorDeclaracao().getCpf().asString());
        vector.add(registroTxt);
        return vector;
    }

    public Vector montarFichaRendaVariavel(DeclaracaoIRPF declaracaoIRPF) throws GeracaoTxtException {
        Vector<RegistroTxt> vector = new Vector<RegistroTxt>();
        RendaVariavel rendaVariavel = declaracaoIRPF.getRendaVariavel();
        int n = 1;
        while (n <= 12) {
            GanhosLiquidosOuPerdas ganhosLiquidosOuPerdas = rendaVariavel.getGanhosPorIndice(n - 1);
            if (!ganhosLiquidosOuPerdas.estaVazio()) {
                RegistroTxt registroTxt = new RegistroTxt("ARQ_IRPF", "40");
                registroTxt.fieldByName("NR_REG").set("40");
                registroTxt.fieldByName("NR_CPF").set(declaracaoIRPF.getIdentificadorDeclaracao().getCpf().asString());
                registroTxt.fieldByName("NR_MES").set(rendaVariavel.obterMesFormatoNumerico(ganhosLiquidosOuPerdas));
                Operacoes operacoes = ganhosLiquidosOuPerdas.getOperacoesComuns();
                registroTxt.fieldByName("VR_COMUM_MVISTA_ACOES").set(operacoes.getMercadoVistaAcoes());
                registroTxt.fieldByName("VR_COMUM_MVISTA_OURO").set(operacoes.getMercadoVistaOuro());
                registroTxt.fieldByName("VR_COMUM_MVISTA_OUROFORA").set(operacoes.getMercadoVistaForaBolsa());
                registroTxt.fieldByName("VR_COMUM_MOPC_ACOES").set(operacoes.getMercadoOpcoesAcoes());
                registroTxt.fieldByName("VR_COMUM_MOPC_OURO").set(operacoes.getMercadoOpcoesOuro());
                registroTxt.fieldByName("VR_COMUM_MOPC_OUROFORA").set(operacoes.getMercadoOpcoesForaDeBolsa());
                registroTxt.fieldByName("VR_COMUM_MOPC_OUTROS").set(operacoes.getMercadoOpcoesOutros());
                registroTxt.fieldByName("VR_COMUM_MFUT_DOLAR").set(operacoes.getMercadoFuturoDolar());
                registroTxt.fieldByName("VR_COMUM_MFUT_INDICES").set(operacoes.getMercadoFuturoIndices());
                registroTxt.fieldByName("VR_COMUM_MFUT_JUROS").set(operacoes.getMercadoFuturoJuros());
                registroTxt.fieldByName("VR_COMUM_MFUT_OUTROS").set(operacoes.getMercadoFuturoOutros());
                registroTxt.fieldByName("VR_COMUM_MTERMO_ACOESOURO").set(operacoes.getMercadoTermoAcoes());
                registroTxt.fieldByName("VR_COMUM_MTERMO_OUTROS").set(operacoes.getMercadoTermoOutros());
                Operacoes operacoes2 = ganhosLiquidosOuPerdas.getOperacoesDayTrade();
                registroTxt.fieldByName("VR_DAYTR_MVISTA_ACOES").set(operacoes2.getMercadoVistaAcoes());
                registroTxt.fieldByName("VR_DAYTR_MVISTA_OURO").set(operacoes2.getMercadoVistaOuro());
                registroTxt.fieldByName("VR_DAYTR_MVISTA_OUROFORA").set(operacoes2.getMercadoVistaForaBolsa());
                registroTxt.fieldByName("VR_DAYTR_MOPC_ACOES").set(operacoes2.getMercadoOpcoesAcoes());
                registroTxt.fieldByName("VR_DAYTR_MOPC_OURO").set(operacoes2.getMercadoOpcoesOuro());
                registroTxt.fieldByName("VR_DAYTR_MOPC_OUROFORA").set(operacoes2.getMercadoOpcoesForaDeBolsa());
                registroTxt.fieldByName("VR_DAYTR_MOPC_OUTROS").set(operacoes2.getMercadoOpcoesOutros());
                registroTxt.fieldByName("VR_DAYTR_MFUT_DOLAR").set(operacoes2.getMercadoFuturoDolar());
                registroTxt.fieldByName("VR_DAYTR_MFUT_INDICES").set(operacoes2.getMercadoFuturoIndices());
                registroTxt.fieldByName("VR_DAYTR_MFUT_JUROS").set(operacoes2.getMercadoFuturoJuros());
                registroTxt.fieldByName("VR_DAYTR_MFUT_OUTROS").set(operacoes2.getMercadoFuturoOutros());
                registroTxt.fieldByName("VR_DAYTR_MTERMO_ACOESOURO").set(operacoes2.getMercadoTermoAcoes());
                registroTxt.fieldByName("VR_DAYTR_MTERMO_OUTROS").set(operacoes2.getMercadoTermoOutros());
                registroTxt.fieldByName("VR_FONTE_DAYTRADE").set(ganhosLiquidosOuPerdas.getIrFonteDayTradeMesAtual());
                registroTxt.fieldByName("VR_IMPOSTO_PAGO").set(ganhosLiquidosOuPerdas.getImpostoPago());
                registroTxt.fieldByName("VR_IMPRENDAFONTE").set(ganhosLiquidosOuPerdas.getImpostoRetidoFonteLei11033());
                registroTxt.fieldByName("VR_RESULTNEG_MESANT_COMUM").set(operacoes.getResultadoNegativoMesAnterior());
                registroTxt.fieldByName("VR_RESULTNEG_MESANT_DAYTR").set(operacoes2.getResultadoNegativoMesAnterior());
                registroTxt.fieldByName("VR_RESULTLIQ_MES_COMUM").set(operacoes.getResultadoLiquidoMes());
                registroTxt.fieldByName("VR_RESULTLIQ_MES_DAYTR").set(operacoes2.getResultadoLiquidoMes());
                registroTxt.fieldByName("VR_BASECALCULO_MES_COMUM").set(operacoes.getBaseCalculoImposto());
                registroTxt.fieldByName("VR_BASECALCULO_MES_DAYTR").set(operacoes2.getBaseCalculoImposto());
                registroTxt.fieldByName("VR_PREJACOMPENS_MES_COMUM").set(operacoes.getPrejuizoCompensar());
                registroTxt.fieldByName("VR_PREJACOMPENS_MES_DAYTR").set(operacoes2.getPrejuizoCompensar());
                registroTxt.fieldByName("VR_ALIQUOTA_IMPOSTO_COMUM").set(new Valor("15"));
                registroTxt.fieldByName("VR_ALIQUOTA_IMPOSTO_DAYTRADE").set(new Valor("20"));
                registroTxt.fieldByName("VR_IMPOSTODEVIDO_MES_COMUM").set(operacoes.getImpostoDevido());
                registroTxt.fieldByName("VR_IMPOSTODEVIDO_MES_DAYTR").set(operacoes2.getImpostoDevido());
                registroTxt.fieldByName("VR_TOTAL_IMPOSTODEVIDO").set(ganhosLiquidosOuPerdas.getTotalImpostoDevido());
                registroTxt.fieldByName("VR_IRFONTE_MESESANT_DAYTR").set(ganhosLiquidosOuPerdas.getIrFonteDayTradeMesesAnteriores());
                registroTxt.fieldByName("VR_IRFONTE_ACOMPENS_DAYTR").set(ganhosLiquidosOuPerdas.getIrFonteDayTradeAcompensar());
                registroTxt.fieldByName("VR_TOTAL_IMPOSTOAPAGAR").set(ganhosLiquidosOuPerdas.getImpostoApagar());
                vector.add(registroTxt);
            }
            ++n;
        }
        return vector;
    }

    public Vector montarFichaRendaVariavelAnual(DeclaracaoIRPF declaracaoIRPF) throws GeracaoTxtException {
        Vector<RegistroTxt> vector = new Vector<RegistroTxt>();
        RendaVariavel rendaVariavel = declaracaoIRPF.getRendaVariavel();
        Hashtable hashtable = rendaVariavel.obterTotalAnual();
        RegistroTxt registroTxt = new RegistroTxt("ARQ_IRPF", "41");
        registroTxt.fieldByName("NR_REG").set("41");
        registroTxt.fieldByName("NR_CPF").set(declaracaoIRPF.getIdentificadorDeclaracao().getCpf().asString());
        registroTxt.fieldByName("VR_RESULTLIQUIDO").set((Valor)hashtable.get("TotalResultadosLiquidos"));
        registroTxt.fieldByName("VR_RESULTNEGMESANTERIOR").set((Valor)hashtable.get("TotalResultadosNegativos"));
        registroTxt.fieldByName("VR_BASECALCULO").set((Valor)hashtable.get("BaseCalculoImposto"));
        registroTxt.fieldByName("VR_PREJUIZOCOMPENSAR").set((Valor)hashtable.get("PrejuizoCompensar"));
        registroTxt.fieldByName("VR_IMPOSTODEVIDO").set((Valor)hashtable.get("ImpostoDevido"));
        registroTxt.fieldByName("VR_CONSOL_IMPOSTOIMPOSTODEVIDO").set((Valor)hashtable.get("ImpostoDevidoConsolidacao"));
        registroTxt.fieldByName("VR_CONSOL_IRFONTEDAYTRMESANT").set((Valor)hashtable.get("IRDayTradeMesesAnteriores"));
        registroTxt.fieldByName("VR_CONSOL_IRFONTEDAYTRCOMPENSAR").set((Valor)hashtable.get("IRDayTradeCompensar"));
        registroTxt.fieldByName("VR_TOTALANUALIRFONTELEI11033").set(declaracaoIRPF.getRendaVariavel().getTotalImpostoRetidoFonteLei11033());
        registroTxt.fieldByName("VR_CONSOL_IMPOSTOAPAGAR").set((Valor)hashtable.get("TotalImpostoAPagar"));
        vector.add(registroTxt);
        return vector;
    }

    public Vector montarFichaRendaVariavelFII(DeclaracaoIRPF declaracaoIRPF) throws GeracaoTxtException {
        Vector<RegistroTxt> vector = new Vector<RegistroTxt>();
        NumberFormat numberFormat = null;
        RendaVariavel rendaVariavel = declaracaoIRPF.getRendaVariavel();
        int n = 1;
        while (n <= 12) {
            MesFundosInvestimentos mesFundosInvestimentos = rendaVariavel.getFundInvest().getMeses()[n - 1];
            if (!mesFundosInvestimentos.isVazio()) {
                RegistroTxt registroTxt = new RegistroTxt("ARQ_IRPF", "42");
                registroTxt.fieldByName("NR_REG").set("42");
                registroTxt.fieldByName("NR_CPF").set(declaracaoIRPF.getIdentificadorDeclaracao().getCpf().asString());
                numberFormat = NumberFormat.getInstance();
                numberFormat.setMaximumFractionDigits(0);
                numberFormat.setMinimumIntegerDigits(2);
                numberFormat.setGroupingUsed(false);
                registroTxt.fieldByName("NR_MES").set(numberFormat.format(n));
                registroTxt.fieldByName("VR_RESLIQUIDO_MES").set(mesFundosInvestimentos.getResultLiquidoMes());
                registroTxt.fieldByName("VR_RESULT_NEG_MESANT").set(mesFundosInvestimentos.getResultNegativoAnterior());
                registroTxt.fieldByName("VR_BASECALCULO_MES").set(mesFundosInvestimentos.getBaseCalcImposto());
                registroTxt.fieldByName("VR_PREJACOMPENSAR_MES_OPCOMUNS").set(mesFundosInvestimentos.getPrejuizoCompensar());
                registroTxt.fieldByName("VR_ALIQUOTA_IMPOSTO_OPCOMUNS").set(mesFundosInvestimentos.getAliquotaImposto());
                registroTxt.fieldByName("VR_IMPOSTODEVIDO_MES_OPCOMUNS").set(mesFundosInvestimentos.getImpostoDevido());
                registroTxt.fieldByName("VR_IMPOSTOPAGO").set(mesFundosInvestimentos.getImpostoPago());
                vector.add(registroTxt);
            }
            ++n;
        }
        return vector;
    }

    public Vector montarFichaRendaVariavelTotaisFII(DeclaracaoIRPF declaracaoIRPF) throws GeracaoTxtException {
        Vector<RegistroTxt> vector = new Vector<RegistroTxt>();
        FundosInvestimentos fundosInvestimentos = declaracaoIRPF.getRendaVariavel().getFundInvest();
        if (!fundosInvestimentos.isVazio()) {
            Hashtable hashtable = fundosInvestimentos.obterTotalAnual();
            RegistroTxt registroTxt = new RegistroTxt("ARQ_IRPF", "43");
            registroTxt.fieldByName("NR_REG").set("43");
            registroTxt.fieldByName("NR_CPF").set(declaracaoIRPF.getIdentificadorDeclaracao().getCpf().asString());
            registroTxt.fieldByName("VR_TOTALANUALRESULTADOLIQUIDOSRENDAVARIAVEL_FII").set((Valor)hashtable.get("VR_TOTALANUALRESULTADOLIQUIDOSRENDAVARIAVEL_FII"));
            registroTxt.fieldByName("VR_TOTALANUALRESULTADONEGATIVOMESANTERIOR_FII").set((Valor)hashtable.get("VR_TOTALANUALRESULTADONEGATIVOMESANTERIOR_FII"));
            registroTxt.fieldByName("VR_TOTALANUALBASECALCULOIMPOSTO_FII").set((Valor)hashtable.get("VR_TOTALANUALBASECALCULOIMPOSTO_FII"));
            registroTxt.fieldByName("VR_TOTALANUALPREJUIZOCOMPENSAR_FII").set((Valor)hashtable.get("VR_TOTALANUALPREJUIZOCOMPENSAR_FII"));
            registroTxt.fieldByName("VR_TOTALANUALIMPOSTODEVIDO_FII").set((Valor)hashtable.get("VR_TOTALANUALIMPOSTODEVIDO_FII"));
            registroTxt.fieldByName("VR_TOTALANUALIMPOSTOPAGAR_FII").set((Valor)hashtable.get("VR_TOTALANUALIMPOSTOPAGAR_FII"));
            registroTxt.fieldByName("VR_TOTALANUALIMPOSTORETIDONAFONTE_FII").set(0);
            vector.add(registroTxt);
        }
        return vector;
    }

    public Vector montarFichaRRATitular(DeclaracaoIRPF declaracaoIRPF) {
        return new Vector();
    }

    public Vector montarFichaRRATitularPensao(DeclaracaoIRPF declaracaoIRPF) {
        return new Vector();
    }

    public Vector montarFichaRRADependente(DeclaracaoIRPF declaracaoIRPF) {
        return new Vector();
    }

    public Vector montarFichaRRADependentePensao(DeclaracaoIRPF declaracaoIRPF) {
        return new Vector();
    }

    public Vector montarFichaRendPFouEX(DeclaracaoIRPF declaracaoIRPF) {
        return new Vector();
    }

    public Vector montarFichaAtividadeRuralIdentificacaoImovel(DeclaracaoIRPF declaracaoIRPF) throws GeracaoTxtException {
        ObjetoNegocio objetoNegocio2;
        Vector<Object> vector = new Vector<Object>();
        ARBrasil aRBrasil = declaracaoIRPF.getAtividadeRural().getBrasil();
        aRBrasil.getIdentificacaoImovel().excluirRegistrosEmBranco();
        for (ObjetoNegocio objetoNegocio2 : aRBrasil.getIdentificacaoImovel().recuperarLista()) {
            Object object = new RegistroTxt("ARQ_IRPF", "50");
            ((RegistroTxt)object).fieldByName("NR_REG").set("50");
            ((RegistroTxt)object).fieldByName("NR_CPF").set(declaracaoIRPF.getIdentificadorDeclaracao().getCpf().asString());
            ((RegistroTxt)object).fieldByName("IN_EXTERIOR").set(0);
            ((RegistroTxt)object).fieldByName("NR_INCRA").set(((ImovelARBrasil)objetoNegocio2).getNirf().asString());
            ((RegistroTxt)object).fieldByName("NM_IMOVEL").set(((ImovelAR)objetoNegocio2).getNome().asString());
            ((RegistroTxt)object).fieldByName("NM_LOCAL").set(((ImovelAR)objetoNegocio2).getLocalizacao().asString());
            ((RegistroTxt)object).fieldByName("QT_AREA").set(((ImovelAR)objetoNegocio2).getArea());
            ((RegistroTxt)object).fieldByName("PC_PARTIC").set(((ImovelAR)objetoNegocio2).getParticipacao());
            ((RegistroTxt)object).fieldByName("CD_EXPLOR").set(((ImovelAR)objetoNegocio2).getCondicaoExploracao().getConteudoAtual(0));
            ((RegistroTxt)object).fieldByName("CD_ATIV").set(((ImovelAR)objetoNegocio2).getCodigo().getConteudoAtual(0));
            vector.add(object);
        }
        objetoNegocio2 = declaracaoIRPF.getAtividadeRural().getExterior();
        ((ARExterior)objetoNegocio2).getIdentificacaoImovel().excluirRegistrosEmBranco();
        for (Object object : ((ARExterior)objetoNegocio2).getIdentificacaoImovel().recuperarLista()) {
            RegistroTxt registroTxt = new RegistroTxt("ARQ_IRPF", "50");
            registroTxt.fieldByName("NR_REG").set("50");
            registroTxt.fieldByName("NR_CPF").set(declaracaoIRPF.getIdentificadorDeclaracao().getCpf().asString());
            registroTxt.fieldByName("IN_EXTERIOR").set(1);
            registroTxt.fieldByName("NM_IMOVEL").set(((ImovelAR)object).getNome().asString());
            registroTxt.fieldByName("NM_LOCAL").set(((ImovelAR)object).getLocalizacao().asString());
            registroTxt.fieldByName("QT_AREA").set(((ImovelAR)object).getArea());
            registroTxt.fieldByName("PC_PARTIC").set(((ImovelAR)object).getParticipacao());
            registroTxt.fieldByName("CD_EXPLOR").set(((ImovelAR)object).getCondicaoExploracao().getConteudoAtual(0));
            registroTxt.fieldByName("CD_ATIV").set(((ImovelAR)object).getCodigo().asString());
            vector.add(registroTxt);
        }
        return vector;
    }

    public Vector montarFichaAtividadeRuralReceitasDespesasBrasil(DeclaracaoIRPF declaracaoIRPF) throws GeracaoTxtException {
        Vector<RegistroTxt> vector = new Vector<RegistroTxt>();
        ReceitasDespesas receitasDespesas = declaracaoIRPF.getAtividadeRural().getBrasil().getReceitasDespesas();
        int n = 0;
        while (n <= 11) {
            MesReceitaDespesa mesReceitaDespesa = receitasDespesas.getMesReceitaPorIndice(n);
            if (!mesReceitaDespesa.isVazio()) {
                RegistroTxt registroTxt = new RegistroTxt("ARQ_IRPF", "51");
                registroTxt.fieldByName("NR_REG").set("51");
                registroTxt.fieldByName("NR_CPF").set(declaracaoIRPF.getIdentificadorDeclaracao().getCpf().asString());
                registroTxt.fieldByName("IN_EXTERIOR").set(0);
                registroTxt.fieldByName("NR_MES").set(receitasDespesas.obterMesFormatoNumerico(mesReceitaDespesa));
                registroTxt.fieldByName("VR_DESP").set(mesReceitaDespesa.getDespesaCusteioInvestimento());
                registroTxt.fieldByName("VR_REC").set(mesReceitaDespesa.getReceitaBrutaMensal());
                vector.add(registroTxt);
            }
            ++n;
        }
        return vector;
    }

    public Vector montarFichaAtividadeRuralApuracaoResultado(DeclaracaoIRPF declaracaoIRPF) throws GeracaoTxtException {
        Object object;
        Vector<Object> vector = new Vector<Object>();
        AtividadeRural atividadeRural = declaracaoIRPF.getAtividadeRural();
        ApuracaoResultadoBrasil apuracaoResultadoBrasil = atividadeRural.getBrasil().getApuracaoResultado();
        if (!apuracaoResultadoBrasil.isVazio()) {
            object = new RegistroTxt("ARQ_IRPF", "52");
            ((RegistroTxt)object).fieldByName("NR_REG").set("52");
            ((RegistroTxt)object).fieldByName("IN_EXTERIOR").set(0);
            ((RegistroTxt)object).fieldByName("NR_CPF").set(declaracaoIRPF.getIdentificadorDeclaracao().getCpf().asString());
            ((RegistroTxt)object).fieldByName("VR_RECTOTAL").set(apuracaoResultadoBrasil.getReceitaBrutaTotal());
            ((RegistroTxt)object).fieldByName("VR_DESPTOTAL").set(apuracaoResultadoBrasil.getDespesaCusteio());
            ((RegistroTxt)object).fieldByName("VR_RES1REAL").set(apuracaoResultadoBrasil.getResultadoI());
            ((RegistroTxt)object).fieldByName("VR_PREJEXERCANT").set(apuracaoResultadoBrasil.getPrejuizoExercicioAnterior());
            ((RegistroTxt)object).fieldByName("VR_COMP_PREJ_EXERC_ANT").set(apuracaoResultadoBrasil.getResultadoAposCompensacaoPrejuizo());
            ((RegistroTxt)object).fieldByName("VR_OPCAO").set(apuracaoResultadoBrasil.getOpcaoArbitramento());
            ((RegistroTxt)object).fieldByName("VR_RESTRIB").set(apuracaoResultadoBrasil.getResultadoTributavel());
            ((RegistroTxt)object).fieldByName("VR_PREJUIZO").set(apuracaoResultadoBrasil.getPrejuizoCompensar());
            ((RegistroTxt)object).fieldByName("VR_RECVENDAFUTURA").set(apuracaoResultadoBrasil.getReceitaRecebidaContaVenda());
            ((RegistroTxt)object).fieldByName("VR_ADIANT").set(apuracaoResultadoBrasil.getValorAdiantamento());
            ((RegistroTxt)object).fieldByName("VR_RESNAOTRIBAR").set(apuracaoResultadoBrasil.getResultadoNaoTributavel());
            ((RegistroTxt)object).fieldByName("VR_RES1DOLAR").set(0);
            ((RegistroTxt)object).fieldByName("IN_OPC_APURRESTRIB").set(0);
            vector.add(object);
        }
        if (!((ObjetoNegocio)(object = atividadeRural.getExterior().getApuracaoResultado())).isVazio()) {
            RegistroTxt registroTxt = new RegistroTxt("ARQ_IRPF", "52");
            registroTxt.fieldByName("NR_REG").set("52");
            registroTxt.fieldByName("NR_CPF").set(declaracaoIRPF.getIdentificadorDeclaracao().getCpf().asString());
            registroTxt.fieldByName("IN_EXTERIOR").set(1);
            registroTxt.fieldByName("VR_RECTOTAL").set(0);
            registroTxt.fieldByName("VR_DESPTOTAL").set(0);
            registroTxt.fieldByName("VR_RES1REAL").set(((ApuracaoResultadoExterior)object).getResultadoI_EmReais());
            registroTxt.fieldByName("VR_PREJEXERCANT").set(((ApuracaoResultadoExterior)object).getPrejuizoExercicioAnterior());
            registroTxt.fieldByName("VR_RESAPOS").set(((ApuracaoResultadoExterior)object).getResultadoAposCompensacaoPrejuizo());
            registroTxt.fieldByName("VR_OPCAO").set(((ApuracaoResultadoExterior)object).getOpcaoArbitramento());
            registroTxt.fieldByName("VR_RESTRIB").set(((ApuracaoResultadoExterior)object).getResultadoTributavel());
            registroTxt.fieldByName("VR_PREJUIZO").set(((ApuracaoResultadoExterior)object).getPrejuizoCompensar());
            registroTxt.fieldByName("VR_RECVENDAFUTURA").set(((ApuracaoResultadoExterior)object).getReceitaRecebidaContaVenda());
            registroTxt.fieldByName("VR_ADIANT").set(((ApuracaoResultadoExterior)object).getValorAdiantamento());
            registroTxt.fieldByName("VR_RESNAOTRIBAR").set(((ApuracaoResultadoExterior)object).getResultadoNaoTributavel());
            registroTxt.fieldByName("VR_RES1DOLAR").set(((ApuracaoResultadoExterior)object).getResultadoI_EmDolar());
            vector.add(registroTxt);
        }
        return vector;
    }

    private void setarValoresTipoDadoMovimentacaoRebanho(ItemMovimentacaoRebanho itemMovimentacaoRebanho, RegistroTxt registroTxt) throws GeracaoTxtException {
        registroTxt.fieldByName("QT_INIC").set(itemMovimentacaoRebanho.getEstoqueInicial());
        registroTxt.fieldByName("QT_COMPRA").set(itemMovimentacaoRebanho.getAquisicoesAno());
        registroTxt.fieldByName("QT_NASCIM").set(itemMovimentacaoRebanho.getNascidosAno());
        registroTxt.fieldByName("QT_PERDA").set(itemMovimentacaoRebanho.getConsumo());
        registroTxt.fieldByName("QT_VENDA").set(itemMovimentacaoRebanho.getVendas());
        registroTxt.fieldByName("QT_ESTFINAL").set(itemMovimentacaoRebanho.getEstoqueFinal());
    }

    private void setarMovimentacaoRebanho(DeclaracaoIRPF declaracaoIRPF, RegistroTxt registroTxt, Vector vector, int n) throws GeracaoTxtException {
        AtividadeRural atividadeRural = declaracaoIRPF.getAtividadeRural();
        MovimentacaoRebanho movimentacaoRebanho = n == 0 ? atividadeRural.getBrasil().getMovimentacaoRebanho() : atividadeRural.getExterior().getMovimentacaoRebanho();
        if (!movimentacaoRebanho.getBovinos().isVazio()) {
            registroTxt = new RegistroTxt("ARQ_IRPF", "53");
            registroTxt.fieldByName("NR_REG").set("53");
            registroTxt.fieldByName("IN_EXTERIOR").set(n);
            registroTxt.fieldByName("NR_CPF").set(declaracaoIRPF.getIdentificadorDeclaracao().getCpf().asString());
            registroTxt.fieldByName("CD_ESPEC").set(1);
            this.setarValoresTipoDadoMovimentacaoRebanho(movimentacaoRebanho.getBovinos(), registroTxt);
            vector.add(registroTxt);
        }
        if (!movimentacaoRebanho.getSuinos().isVazio()) {
            registroTxt = new RegistroTxt("ARQ_IRPF", "53");
            registroTxt.fieldByName("NR_REG").set("53");
            registroTxt.fieldByName("IN_EXTERIOR").set(n);
            registroTxt.fieldByName("NR_CPF").set(declaracaoIRPF.getIdentificadorDeclaracao().getCpf().asString());
            registroTxt.fieldByName("CD_ESPEC").set(2);
            this.setarValoresTipoDadoMovimentacaoRebanho(movimentacaoRebanho.getSuinos(), registroTxt);
            vector.add(registroTxt);
        }
        if (!movimentacaoRebanho.getCaprinos().isVazio()) {
            registroTxt = new RegistroTxt("ARQ_IRPF", "53");
            registroTxt.fieldByName("NR_REG").set("53");
            registroTxt.fieldByName("IN_EXTERIOR").set(n);
            registroTxt.fieldByName("NR_CPF").set(declaracaoIRPF.getIdentificadorDeclaracao().getCpf().asString());
            registroTxt.fieldByName("CD_ESPEC").set(3);
            this.setarValoresTipoDadoMovimentacaoRebanho(movimentacaoRebanho.getCaprinos(), registroTxt);
            vector.add(registroTxt);
        }
        if (!movimentacaoRebanho.getAsininos().isVazio()) {
            registroTxt = new RegistroTxt("ARQ_IRPF", "53");
            registroTxt.fieldByName("NR_REG").set("53");
            registroTxt.fieldByName("IN_EXTERIOR").set(n);
            registroTxt.fieldByName("NR_CPF").set(declaracaoIRPF.getIdentificadorDeclaracao().getCpf().asString());
            registroTxt.fieldByName("CD_ESPEC").set(4);
            this.setarValoresTipoDadoMovimentacaoRebanho(movimentacaoRebanho.getAsininos(), registroTxt);
            vector.add(registroTxt);
        }
        if (!movimentacaoRebanho.getOutros().isVazio()) {
            registroTxt = new RegistroTxt("ARQ_IRPF", "53");
            registroTxt.fieldByName("NR_REG").set("53");
            registroTxt.fieldByName("IN_EXTERIOR").set(n);
            registroTxt.fieldByName("NR_CPF").set(declaracaoIRPF.getIdentificadorDeclaracao().getCpf().asString());
            registroTxt.fieldByName("CD_ESPEC").set(5);
            this.setarValoresTipoDadoMovimentacaoRebanho(movimentacaoRebanho.getOutros(), registroTxt);
            vector.add(registroTxt);
        }
    }

    public Vector montarFichaAtividadeRuralMovimentacaoRebanho(DeclaracaoIRPF declaracaoIRPF) throws GeracaoTxtException {
        Vector vector = new Vector();
        RegistroTxt registroTxt = null;
        if (!declaracaoIRPF.getAtividadeRural().getBrasil().getMovimentacaoRebanho().isVazio()) {
            this.setarMovimentacaoRebanho(declaracaoIRPF, registroTxt, vector, 0);
        }
        if (!declaracaoIRPF.getAtividadeRural().getExterior().getMovimentacaoRebanho().isVazio()) {
            this.setarMovimentacaoRebanho(declaracaoIRPF, registroTxt, vector, 1);
        }
        return vector;
    }

    public Vector montarFichaAtividadeRuralBens(DeclaracaoIRPF declaracaoIRPF) throws GeracaoTxtException {
        Vector vector = new Vector();
        this.setarBensAR(declaracaoIRPF, 0, vector);
        this.setarBensAR(declaracaoIRPF, 1, vector);
        return vector;
    }

    public void setarBensAR(DeclaracaoIRPF declaracaoIRPF, int n, Vector vector) throws GeracaoTxtException {
        AtividadeRural atividadeRural = declaracaoIRPF.getAtividadeRural();
        Iterator iterator = null;
        if (n == 0) {
            atividadeRural.getBrasil().getBens().excluirRegistrosEmBranco();
            iterator = atividadeRural.getBrasil().getBens().recuperarLista().iterator();
        } else {
            atividadeRural.getExterior().getBens().excluirRegistrosEmBranco();
            iterator = atividadeRural.getExterior().getBens().recuperarLista().iterator();
        }
        while (iterator.hasNext()) {
            BemAR bemAR = (BemAR)iterator.next();
            RegistroTxt registroTxt = new RegistroTxt("ARQ_IRPF", "54");
            registroTxt.fieldByName("NR_REG").set("54");
            registroTxt.fieldByName("IN_EXTERIOR").set(n);
            registroTxt.fieldByName("NR_CPF").set(declaracaoIRPF.getIdentificadorDeclaracao().getCpf().asString());
            if (n == 0) {
                registroTxt.fieldByName("CD_PAIS").set("000");
            } else {
                registroTxt.fieldByName("CD_PAIS").set(((BemARExterior)bemAR).getPais().getConteudoAtual(0));
            }
            registroTxt.fieldByName("CD_BEMAR").set(bemAR.getCodigo().getConteudoAtual(0));
            registroTxt.fieldByName("TX_BEM").set(bemAR.getDiscriminacao().getConteudoFormatado());
            registroTxt.fieldByName("VR_BEM").set(bemAR.getValor());
            vector.add(registroTxt);
        }
    }

    public Vector montarFichaAtividadeRuralDividas(DeclaracaoIRPF declaracaoIRPF) throws GeracaoTxtException {
        Vector vector = new Vector();
        this.setarDividasAR(declaracaoIRPF, 0, vector);
        this.setarDividasAR(declaracaoIRPF, 1, vector);
        return vector;
    }

    public void setarDividasAR(DeclaracaoIRPF declaracaoIRPF, int n, Vector vector) throws GeracaoTxtException {
        AtividadeRural atividadeRural = declaracaoIRPF.getAtividadeRural();
        Iterator iterator = null;
        if (n == 0) {
            atividadeRural.getBrasil().getDividas().excluirRegistrosEmBranco();
            iterator = atividadeRural.getBrasil().getDividas().recuperarLista().iterator();
        } else {
            atividadeRural.getExterior().getDividas().excluirRegistrosEmBranco();
            iterator = atividadeRural.getExterior().getDividas().recuperarLista().iterator();
        }
        while (iterator.hasNext()) {
            DividaAR dividaAR = (DividaAR)iterator.next();
            RegistroTxt registroTxt = new RegistroTxt("ARQ_IRPF", "55");
            registroTxt.fieldByName("NR_REG").set("55");
            registroTxt.fieldByName("IN_EXTERIOR").set(n);
            registroTxt.fieldByName("NR_CPF").set(declaracaoIRPF.getIdentificadorDeclaracao().getCpf().asString());
            registroTxt.fieldByName("TX_DIVIDA").set(dividaAR.getDiscriminacao().getConteudoFormatado());
            registroTxt.fieldByName("VR_DIVATE").set(dividaAR.getContraidasAteExercicioAnterior());
            registroTxt.fieldByName("VR_DIVATU").set(dividaAR.getContraidasAteExercicioAtual());
            vector.add(registroTxt);
        }
    }

    public Vector montarFichaAtividadeRuralReceitasDespesasExterior(DeclaracaoIRPF declaracaoIRPF) throws GeracaoTxtException {
        Vector<RegistroTxt> vector = new Vector<RegistroTxt>();
        AtividadeRural atividadeRural = declaracaoIRPF.getAtividadeRural();
        atividadeRural.getExterior().getReceitasDespesas().excluirRegistrosEmBranco();
        for (ReceitaDespesa receitaDespesa : atividadeRural.getExterior().getReceitasDespesas().recuperarLista()) {
            RegistroTxt registroTxt = new RegistroTxt("ARQ_IRPF", "56");
            registroTxt.fieldByName("NR_REG").set("56");
            registroTxt.fieldByName("NR_CPF").set(declaracaoIRPF.getIdentificadorDeclaracao().getCpf().asString());
            registroTxt.fieldByName("CD_PAIS").set(receitaDespesa.getPais().getConteudoAtual(0));
            registroTxt.fieldByName("DESPCUSTEIO").set(receitaDespesa.getDespesaCusteio());
            registroTxt.fieldByName("RECBRUTA").set(receitaDespesa.getReceitaBruta());
            registroTxt.fieldByName("RESDOLAR").set(receitaDespesa.getResultadoI_EmDolar());
            registroTxt.fieldByName("RESORIGINAL").set(receitaDespesa.getResultadoIMoedaOriginal());
            vector.add(registroTxt);
        }
        return vector;
    }
}

