/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.parser;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.Block;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ExplicitConstructorCall;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MemberValuePair;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.SuperReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.parser.RecoveredBlock;
import org.eclipse.jdt.internal.compiler.parser.RecoveredElement;
import org.eclipse.jdt.internal.compiler.parser.RecoveredType;
import org.eclipse.jdt.internal.compiler.parser.TerminalTokens;

public class RecoveredMethod
extends RecoveredElement
implements TerminalTokens {
    public AbstractMethodDeclaration methodDeclaration;
    public RecoveredType[] localTypes;
    public int localTypeCount;
    public RecoveredBlock methodBody;
    public boolean discardBody = true;

    public RecoveredMethod(AbstractMethodDeclaration abstractMethodDeclaration, RecoveredElement recoveredElement, int n, Parser parser) {
        super(recoveredElement, n, parser);
        this.methodDeclaration = abstractMethodDeclaration;
        boolean bl = this.foundOpeningBrace = !this.bodyStartsAtHeaderEnd();
        if (this.foundOpeningBrace) {
            ++this.bracketBalance;
        }
    }

    public RecoveredElement add(Block block, int n) {
        if (this.methodDeclaration.declarationSourceEnd > 0 && block.sourceStart > this.methodDeclaration.declarationSourceEnd) {
            if (this.parent == null) {
                return this;
            }
            return this.parent.add(block, n);
        }
        if (!this.foundOpeningBrace) {
            this.foundOpeningBrace = true;
            ++this.bracketBalance;
        }
        this.methodBody = new RecoveredBlock(block, (RecoveredElement)this, n);
        if (block.sourceEnd == 0) {
            return this.methodBody;
        }
        return this;
    }

    public RecoveredElement add(FieldDeclaration fieldDeclaration, int n) {
        char[][] cArray;
        if ((fieldDeclaration.modifiers & 0xFFFFFFEF) != 0 || fieldDeclaration.type == null || (cArray = fieldDeclaration.type.getTypeName()).length == 1 && CharOperation.equals(cArray[0], TypeBinding.VOID.sourceName())) {
            if (this.parent == null) {
                return this;
            }
            this.updateSourceEndIfNecessary(this.previousAvailableLineEnd(fieldDeclaration.declarationSourceStart - 1));
            return this.parent.add(fieldDeclaration, n);
        }
        if (this.methodDeclaration.declarationSourceEnd > 0 && fieldDeclaration.declarationSourceStart > this.methodDeclaration.declarationSourceEnd) {
            if (this.parent == null) {
                return this;
            }
            return this.parent.add(fieldDeclaration, n);
        }
        if (!this.foundOpeningBrace) {
            this.foundOpeningBrace = true;
            ++this.bracketBalance;
        }
        return this;
    }

    public RecoveredElement add(LocalDeclaration localDeclaration, int n) {
        if (this.methodDeclaration.declarationSourceEnd != 0 && localDeclaration.declarationSourceStart > this.methodDeclaration.declarationSourceEnd) {
            if (this.parent == null) {
                return this;
            }
            return this.parent.add(localDeclaration, n);
        }
        if (this.methodBody == null) {
            Block block = new Block(0);
            block.sourceStart = this.methodDeclaration.bodyStart;
            RecoveredElement recoveredElement = this.add(block, 1);
            if (this.bracketBalance > 0) {
                int n2 = 0;
                while (n2 < this.bracketBalance - 1) {
                    recoveredElement = recoveredElement.add(new Block(0), 1);
                    ++n2;
                }
                this.bracketBalance = 1;
            }
            return recoveredElement.add(localDeclaration, n);
        }
        return this.methodBody.add(localDeclaration, n, true);
    }

    public RecoveredElement add(Statement statement, int n) {
        if (this.methodDeclaration.declarationSourceEnd != 0 && statement.sourceStart > this.methodDeclaration.declarationSourceEnd) {
            if (this.parent == null) {
                return this;
            }
            return this.parent.add(statement, n);
        }
        if (this.methodBody == null) {
            Block block = new Block(0);
            block.sourceStart = this.methodDeclaration.bodyStart;
            RecoveredElement recoveredElement = this.add(block, 1);
            if (this.bracketBalance > 0) {
                int n2 = 0;
                while (n2 < this.bracketBalance - 1) {
                    recoveredElement = recoveredElement.add(new Block(0), 1);
                    ++n2;
                }
                this.bracketBalance = 1;
            }
            return recoveredElement.add(statement, n);
        }
        return this.methodBody.add(statement, n, true);
    }

    public RecoveredElement add(TypeDeclaration typeDeclaration, int n) {
        if (this.methodDeclaration.declarationSourceEnd != 0 && typeDeclaration.declarationSourceStart > this.methodDeclaration.declarationSourceEnd) {
            if (this.parent == null) {
                return this;
            }
            return this.parent.add(typeDeclaration, n);
        }
        if ((typeDeclaration.bits & 0x100) != 0 || this.parser().methodRecoveryActivated || this.parser().statementRecoveryActivated) {
            if (this.methodBody == null) {
                Block block = new Block(0);
                block.sourceStart = this.methodDeclaration.bodyStart;
                this.add(block, 1);
            }
            return this.methodBody.add(typeDeclaration, n, true);
        }
        switch (TypeDeclaration.kind(typeDeclaration.modifiers)) {
            case 2: 
            case 4: {
                this.updateSourceEndIfNecessary(this.previousAvailableLineEnd(typeDeclaration.declarationSourceStart - 1));
                if (this.parent == null) {
                    return this;
                }
                return this.parent.add(typeDeclaration, n);
            }
        }
        if (this.localTypes == null) {
            this.localTypes = new RecoveredType[5];
            this.localTypeCount = 0;
        } else if (this.localTypeCount == this.localTypes.length) {
            this.localTypes = new RecoveredType[2 * this.localTypeCount];
            System.arraycopy(this.localTypes, 0, this.localTypes, 0, this.localTypeCount);
        }
        RecoveredType recoveredType = new RecoveredType(typeDeclaration, (RecoveredElement)this, n);
        this.localTypes[this.localTypeCount++] = recoveredType;
        if (!this.foundOpeningBrace) {
            this.foundOpeningBrace = true;
            ++this.bracketBalance;
        }
        return recoveredType;
    }

    public boolean bodyStartsAtHeaderEnd() {
        return this.methodDeclaration.bodyStart == this.methodDeclaration.sourceEnd + 1;
    }

    public ASTNode parseTree() {
        return this.methodDeclaration;
    }

    public int sourceEnd() {
        return this.methodDeclaration.declarationSourceEnd;
    }

    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer(this.tabString(n));
        stringBuffer.append("Recovered method:\n");
        this.methodDeclaration.print(n + 1, stringBuffer);
        if (this.localTypes != null) {
            int n2 = 0;
            while (n2 < this.localTypeCount) {
                stringBuffer.append("\n");
                stringBuffer.append(this.localTypes[n2].toString(n + 1));
                ++n2;
            }
        }
        if (this.methodBody != null) {
            stringBuffer.append("\n");
            stringBuffer.append(this.methodBody.toString(n + 1));
        }
        return stringBuffer.toString();
    }

    public void updateBodyStart(int n) {
        this.foundOpeningBrace = true;
        this.methodDeclaration.bodyStart = n;
    }

    public AbstractMethodDeclaration updatedMethodDeclaration() {
        Block block;
        if (this.methodBody != null && (block = this.methodBody.updatedBlock()) != null) {
            this.methodDeclaration.statements = block.statements;
            if (this.methodDeclaration.isConstructor()) {
                ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)this.methodDeclaration;
                if (this.methodDeclaration.statements != null && this.methodDeclaration.statements[0] instanceof ExplicitConstructorCall) {
                    constructorDeclaration.constructorCall = (ExplicitConstructorCall)this.methodDeclaration.statements[0];
                    int n = this.methodDeclaration.statements.length;
                    this.methodDeclaration.statements = new Statement[n - 1];
                    System.arraycopy(this.methodDeclaration.statements, 1, this.methodDeclaration.statements, 0, n - 1);
                }
                if (constructorDeclaration.constructorCall == null) {
                    constructorDeclaration.constructorCall = SuperReference.implicitSuperConstructorCall();
                }
            }
        }
        if (this.localTypeCount > 0) {
            this.methodDeclaration.bits |= 2;
        }
        return this.methodDeclaration;
    }

    public void updateFromParserState() {
        if (this.bodyStartsAtHeaderEnd() && this.parent != null) {
            Parser parser = this.parser();
            if (parser.listLength > 0 && parser.astLengthPtr > 0) {
                if (this.methodDeclaration.sourceEnd == parser.rParenPos) {
                    boolean bl;
                    int n = parser.astLengthStack[parser.astLengthPtr];
                    int n2 = parser.astPtr - n;
                    boolean bl2 = bl = n2 >= 0;
                    if (bl) {
                        if (!(parser.astStack[n2] instanceof AbstractMethodDeclaration)) {
                            bl = false;
                        }
                        int n3 = 1;
                        int n4 = n + 1;
                        while (n3 < n4) {
                            if (!(parser.astStack[n2 + n3] instanceof TypeReference)) {
                                bl = false;
                            }
                            ++n3;
                        }
                    }
                    if (bl) {
                        parser.consumeMethodHeaderThrowsClause();
                    } else {
                        parser.listLength = 0;
                    }
                } else {
                    if (parser.currentToken == 28 || parser.currentToken == 27) {
                        int n = parser.astLengthPtr;
                        parser.astLengthStack[n] = parser.astLengthStack[n] - 1;
                        --parser.astPtr;
                        --parser.listLength;
                        parser.currentToken = 0;
                    }
                    int n = parser.astLengthStack[parser.astLengthPtr];
                    int n5 = parser.astPtr - n + 1;
                    boolean bl = parser.rParenPos < parser.lParenPos;
                    MemberValuePair[] memberValuePairArray = null;
                    if (n > 0 && parser.astStack[parser.astPtr] instanceof MemberValuePair) {
                        memberValuePairArray = new MemberValuePair[n];
                        System.arraycopy(parser.astStack, n5, memberValuePairArray, 0, n);
                        --parser.astLengthPtr;
                        parser.astPtr -= n;
                        n = parser.astLengthStack[parser.astLengthPtr];
                        n5 = parser.astPtr - n + 1;
                        bl = true;
                    }
                    int n6 = 0;
                    while (n6 < n) {
                        ASTNode aSTNode = parser.astStack[n5 + n6];
                        if (aSTNode instanceof Argument) {
                            Argument argument = (Argument)aSTNode;
                            char[][] cArray = argument.type.getTypeName();
                            if ((argument.modifiers & 0xFFFFFFEF) != 0 || cArray.length == 1 && CharOperation.equals(cArray[0], TypeBinding.VOID.sourceName())) {
                                parser.astLengthStack[parser.astLengthPtr] = n6;
                                parser.astPtr = n5 + n6 - 1;
                                parser.listLength = n6;
                                parser.currentToken = 0;
                                break;
                            }
                            if (bl) {
                                parser.rParenPos = argument.sourceEnd + 1;
                            }
                        } else {
                            parser.astLengthStack[parser.astLengthPtr] = n6;
                            parser.astPtr = n5 + n6 - 1;
                            parser.listLength = n6;
                            parser.currentToken = 0;
                            break;
                        }
                        ++n6;
                    }
                    if (parser.listLength > 0 && parser.astLengthPtr > 0) {
                        boolean bl3;
                        int n7 = parser.astLengthStack[parser.astLengthPtr];
                        int n8 = parser.astPtr - n7;
                        boolean bl4 = bl3 = n8 >= 0;
                        if (bl3) {
                            if (!(parser.astStack[n8] instanceof AbstractMethodDeclaration)) {
                                bl3 = false;
                            }
                            int n9 = 1;
                            int n10 = n7 + 1;
                            while (n9 < n10) {
                                if (!(parser.astStack[n8 + n9] instanceof Argument)) {
                                    bl3 = false;
                                }
                                ++n9;
                            }
                        }
                        if (bl3) {
                            parser.consumeMethodHeaderRightParen();
                            if (parser.currentElement == this) {
                                this.methodDeclaration.sourceEnd = this.methodDeclaration.arguments[this.methodDeclaration.arguments.length - 1].sourceEnd;
                                parser.lastCheckPoint = this.methodDeclaration.bodyStart = this.methodDeclaration.sourceEnd + 1;
                            }
                        }
                    }
                    if (memberValuePairArray != null) {
                        System.arraycopy(memberValuePairArray, 0, parser.astStack, parser.astPtr + 1, memberValuePairArray.length);
                        parser.astPtr += memberValuePairArray.length;
                        parser.astLengthStack[++parser.astLengthPtr] = memberValuePairArray.length;
                    }
                }
            }
        }
    }

    public RecoveredElement updateOnClosingBrace(int n, int n2) {
        if (this.methodDeclaration.isAnnotationMethod()) {
            this.updateSourceEndIfNecessary(n, n2);
            if (!this.foundOpeningBrace && this.parent != null) {
                return this.parent.updateOnClosingBrace(n, n2);
            }
            return this;
        }
        return super.updateOnClosingBrace(n, n2);
    }

    public RecoveredElement updateOnOpeningBrace(int n, int n2) {
        if (this.bracketBalance == 0) {
            switch (this.parser().lastIgnoredToken) {
                case -1: 
                case 105: {
                    break;
                }
                default: {
                    this.foundOpeningBrace = true;
                    this.bracketBalance = 1;
                }
            }
        }
        return super.updateOnOpeningBrace(n, n2);
    }

    public void updateParseTree() {
        this.updatedMethodDeclaration();
    }

    public void updateSourceEndIfNecessary(int n, int n2) {
        if (this.methodDeclaration.declarationSourceEnd == 0) {
            if (this.parser().rBraceSuccessorStart >= n2) {
                this.methodDeclaration.declarationSourceEnd = this.parser().rBraceEnd;
                this.methodDeclaration.bodyEnd = this.parser().rBraceStart;
            } else {
                this.methodDeclaration.declarationSourceEnd = n2;
                this.methodDeclaration.bodyEnd = n - 1;
            }
        }
    }

    void attach(TypeParameter[] typeParameterArray, int n) {
        if (this.methodDeclaration.modifiers != 0) {
            return;
        }
        int n2 = typeParameterArray[typeParameterArray.length - 1].sourceEnd;
        Parser parser = this.parser();
        if (parser.scanner.getLineNumber(this.methodDeclaration.declarationSourceStart) != parser.scanner.getLineNumber(n2)) {
            return;
        }
        if (parser.modifiersSourceStart > n2 && parser.modifiersSourceStart < this.methodDeclaration.declarationSourceStart) {
            return;
        }
        if (this.methodDeclaration instanceof MethodDeclaration) {
            ((MethodDeclaration)this.methodDeclaration).typeParameters = typeParameterArray;
            this.methodDeclaration.declarationSourceStart = n;
        } else if (this.methodDeclaration instanceof ConstructorDeclaration) {
            ((ConstructorDeclaration)this.methodDeclaration).typeParameters = typeParameterArray;
            this.methodDeclaration.declarationSourceStart = n;
        }
    }
}

